/*
 * Decompiled with CFR 0.152.
 */
package org.exist.http;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xmlrpc.Base64;
import org.exist.EXistException;
import org.exist.dom.DocumentImpl;
import org.exist.dom.NodeProxy;
import org.exist.dom.NodeSet;
import org.exist.http.BadRequestException;
import org.exist.http.HttpServer;
import org.exist.http.NotFoundException;
import org.exist.http.RESTServer;
import org.exist.http.Response;
import org.exist.security.PermissionDeniedException;
import org.exist.security.User;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.util.Configuration;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NodeList;

public class HttpServerConnection
extends RESTServer
implements Runnable {
    private static final int GET = 1;
    private static final int HEAD = 2;
    private static final int POST = 3;
    private static final int PUT = 4;
    private static final int DELETE = 5;
    private static final int OK = 0;
    private static final int WRONG_REQUEST = 1;
    private static final int PARSE_ERROR = 2;
    private static final int DOCUMENT_NOT_FOUND = 3;
    private static final int SYNTAX_ERROR = 4;
    private static final int OUTPUT_ERROR = 5;
    private static final int UNKNOWN_ERROR = 6;
    public static final int HTTP_OK = 200;
    public static final int HTTP_BAD_REQUEST = 400;
    public static final int HTTP_FORBIDDEN = 403;
    public static final int HTTP_NOT_FOUND = 404;
    public static final int HTTP_INTERNAL_ERROR = 500;
    private static final String stdHeaders = "Allow: POST GET PUT DELETE\nServer: eXist\nCache-control: no-cache\n";
    protected DBBroker broker = null;
    protected Configuration config;
    protected DocumentBuilder docBuilder = null;
    protected HttpServer.ConnectionPool pool;
    protected Socket sock = null;
    protected boolean terminate = false;
    protected String tmpDir = null;
    protected User user = null;
    protected String xslStyle = null;

    public HttpServerConnection(Configuration config, HttpServer.ConnectionPool pool) {
        this.config = config;
        this.pool = pool;
        this.tmpDir = (String)config.getProperty("tmpDir");
        if (this.tmpDir == null) {
            this.tmpDir = "/tmp";
        }
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        docFactory.setNamespaceAware(true);
        try {
            this.docBuilder = docFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            LOG.warn((Object)e);
        }
    }

    private User checkUser(BrokerPool pool, String username, String password) {
        this.user = pool.getSecurityManager().getUser(username);
        if (this.user == null) {
            return null;
        }
        if (!this.user.validate(password)) {
            return null;
        }
        return this.user;
    }

    protected void get(String name, int len) {
        Response response;
        HashMap parameters;
        if (name.indexOf("..") != -1) {
            this.errorReply(403);
            return;
        }
        int p = name.indexOf(63);
        if (p >= 0) {
            parameters = this.processParameters(name.substring(++p));
            name = name.substring(0, p - 1);
        } else {
            parameters = new HashMap();
        }
        try {
            response = this.doGet(this.broker, parameters, name);
        }
        catch (BadRequestException e) {
            response = new Response(400, e.getMessage());
        }
        catch (PermissionDeniedException e) {
            response = new Response(403, e.getMessage());
        }
        catch (NotFoundException e) {
            response = new Response(404, e.getMessage());
        }
        this.writeResponse(response);
    }

    protected void put(File tempFile, String contentType, String docPath) {
        Response response;
        try {
            response = this.doPut(this.broker, tempFile, contentType, docPath);
        }
        catch (BadRequestException e) {
            response = new Response(400, e.getMessage());
        }
        catch (PermissionDeniedException e) {
            response = new Response(403, e.getMessage());
        }
        this.writeResponse(response);
    }

    protected void delete(String path) {
        Response response;
        try {
            response = this.doDelete(this.broker, path);
        }
        catch (PermissionDeniedException e) {
            LOG.debug((Object)("permission denied to remove " + path));
            response = new Response(403, e.getMessage());
        }
        catch (NotFoundException e) {
            response = new Response(404, e.getMessage());
        }
        this.writeResponse(response);
    }

    protected void post(String content, String path, int len, String contentType) {
        Response response;
        try {
            response = this.doPost(this.broker, content, path);
        }
        catch (BadRequestException e) {
            response = new Response(400, e.getMessage());
        }
        catch (PermissionDeniedException e) {
            response = new Response(403, e.getMessage());
        }
        this.writeResponse(response);
    }

    protected void writeResponse(Response resp) {
        try {
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(this.sock.getOutputStream()));
            resp.write(out);
        }
        catch (IOException e) {
            LOG.warn((Object)"IO exception while writing response output", (Throwable)e);
        }
    }

    protected void errorReply(int code) {
        this.errorReply(code, null);
    }

    protected void errorReply(int code, String message) {
        StringBuffer content = new StringBuffer();
        content.append("<h1>HTTP/1.0 400 Bad Request</h1>\n");
        if (message != null) {
            content.append(message);
            content.append("<br />");
        }
        StringBuffer msg = new StringBuffer();
        msg.append("HTTP/1.0 400 ");
        msg.append(message);
        msg.append("\n");
        msg.append(stdHeaders);
        msg.append("Content-Type: text/html\n");
        msg.append("Content-Length: ");
        msg.append(content.length());
        msg.append("\n\n");
        msg.append(content.toString());
        try {
            LOG.warn((Object)"BAD_REQUEST");
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(this.sock.getOutputStream()));
            out.writeBytes(msg.toString());
            out.flush();
            out.close();
        }
        catch (IOException e) {
            LOG.warn((Object)e);
        }
    }

    protected Response statusReport(String message) {
        Response response = new Response(200, message);
        StringBuffer buf = new StringBuffer();
        buf.append("<exist:result xmlns:exist=\"");
        buf.append("http://exist.sourceforge.net/NS/exist");
        buf.append("\">");
        if (message != null) {
            buf.append("<exist:message>");
            buf.append(message);
            buf.append("</exist:message>");
            buf.append("</exist:result>");
        }
        response.setContent(buf.toString());
        return response;
    }

    protected String printSummary(NodeList resultSet, long queryTime) {
        NodeCount counter;
        if (resultSet.getLength() == 0) {
            return "nothing found";
        }
        HashMap<String, NodeCount> map = new HashMap<String, NodeCount>();
        HashMap<String, DoctypeCount> doctypes = new HashMap<String, DoctypeCount>();
        Iterator i = ((NodeSet)resultSet).iterator();
        while (i.hasNext()) {
            DoctypeCount doctypeCounter;
            NodeProxy p = (NodeProxy)i.next();
            String docName = p.getDocument().getFileName();
            DocumentType doctype = p.getDocument().getDoctype();
            if (map.containsKey(docName)) {
                counter = (NodeCount)map.get(docName);
                counter.inc();
            } else {
                counter = new NodeCount(p.getDocument());
                map.put(docName, counter);
            }
            if (doctype == null) continue;
            if (doctypes.containsKey(doctype.getName())) {
                doctypeCounter = (DoctypeCount)doctypes.get(doctype.getName());
                doctypeCounter.inc();
                continue;
            }
            doctypeCounter = new DoctypeCount(doctype);
            doctypes.put(doctype.getName(), doctypeCounter);
        }
        StringBuffer buf = new StringBuffer();
        buf.append("<exist:result xmlns:exist=\"http://exist.sourceforge.net/NS/exist\" ");
        buf.append("hitCount=\"");
        buf.append(resultSet.getLength());
        buf.append("\" queryTime=\"");
        buf.append(queryTime);
        buf.append("\">");
        Iterator i2 = map.values().iterator();
        while (i2.hasNext()) {
            counter = (NodeCount)i2.next();
            buf.append("<exist:document name=\"");
            buf.append(counter.doc.getFileName());
            buf.append("\" id=\"");
            buf.append(counter.doc.getDocId());
            buf.append("\" hitCount=\"");
            buf.append(counter.count);
            buf.append("\"/>");
        }
        Iterator i3 = doctypes.values().iterator();
        while (i3.hasNext()) {
            DoctypeCount docTemp = (DoctypeCount)i3.next();
            buf.append("<exist:doctype name=\"");
            buf.append(docTemp.doctype.getName());
            buf.append("\" hitCount=\"");
            buf.append(docTemp.count);
            buf.append("\"/>");
        }
        buf.append("</exist:result>");
        return buf.toString();
    }

    public synchronized void process(Socket sock) {
        this.sock = sock;
        this.notifyAll();
    }

    protected HashMap processParameters(String args) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        int start = 0;
        int end = 0;
        int l = args.length();
        while (start < l && end < l) {
            while (end < l && args.charAt(end++) != '=') {
            }
            if (end == l) break;
            String param = args.substring(start, end - 1);
            start = end;
            while (end < l && args.charAt(end++) != '&') {
            }
            String value = end == l ? args.substring(start) : args.substring(start, end - 1);
            start = end;
            param = URLDecoder.decode(param);
            value = URLDecoder.decode(value);
            LOG.debug((Object)("parameter: " + param + " = " + value));
            parameters.put(param, value);
        }
        return parameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        contentType = "text/xml";
        name = null;
        username = null;
        password = null;
        method = 400;
        len = 0;
        input = new StringBuffer();
        tempFile = null;
        brokerPool = null;
        try {
            brokerPool = BrokerPool.getInstance();
        }
        catch (EXistException e) {
            throw new RuntimeException(e.getMessage());
        }
        while (true) {
            if (this.sock == null && !this.terminate) {
                e = this;
                synchronized (e) {
                    try {
                        this.wait(500L);
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                    continue;
                }
            }
            if (this.terminate) {
                this.pool.release(this);
                return;
            }
            try {
                block39: {
                    is = new DataInputStream(new BufferedInputStream(this.sock.getInputStream()));
                    len = -1;
                    contentType = "text/xml";
                    while ((req = is.readLine()) != null && (tok = new StringTokenizer(req, " ")).hasMoreTokens()) {
                        first = tok.nextToken();
                        if (first.equals("GET")) {
                            method = 1;
                            name = tok.nextToken();
                            continue;
                        }
                        if (first.equals("POST")) {
                            method = 3;
                            name = tok.nextToken();
                            continue;
                        }
                        if (first.equals("HEAD")) {
                            method = 2;
                            name = tok.nextToken();
                            continue;
                        }
                        if (first.equals("PUT")) {
                            method = 4;
                            name = tok.nextToken();
                            continue;
                        }
                        if (first.equals("DELETE")) {
                            method = 5;
                            name = tok.nextToken();
                            continue;
                        }
                        if (req.toUpperCase().startsWith("CONTENT-LENGTH:")) {
                            try {
                                len = Integer.parseInt(tok.nextToken());
                                continue;
                            }
                            catch (NumberFormatException nf) {
                                HttpServerConnection.LOG.warn((Object)nf);
                                break;
                            }
                        }
                        if (req.toUpperCase().startsWith("CONTENT-TYPE:")) {
                            contentType = tok.nextToken();
                            continue;
                        }
                        if (!req.toUpperCase().startsWith("AUTHORIZATION:")) continue;
                        auth = req.substring("AUTHORIZATION:".length()).trim();
                        c = Base64.decode((byte[])auth.substring(6).getBytes());
                        s = new String(c);
                        p = s.indexOf(58);
                        username = s.substring(0, p);
                        password = s.substring(p + 1);
                        this.user = this.checkUser(brokerPool, username, password);
                        if (this.user != null) continue;
                        method = 403;
                    }
                    if (len > 0) {
                        buffer = new byte[2048];
                        l = 0;
                        if (method == 4) {
                            tempFile = File.createTempFile("exist", ".tmp");
                            os = new FileOutputStream(tempFile);
                            do {
                                if ((count = is.read(buffer)) <= 0) continue;
                                os.write(buffer, 0, count);
                            } while ((l += count) < len);
                            os.close();
                        } else {
                            do {
                                if ((count = is.read(buffer)) <= 0) continue;
                                input.append(new String(buffer, 0, count, "UTF-8"));
                            } while ((l += count) < len);
                        }
                    }
                    if (this.user == null) {
                        this.user = new User("guest", "guest", "guest");
                    }
                    try {
                        try {
                            this.broker = brokerPool.get();
                            this.broker.setUser(this.user);
                            switch (method) {
                                case 403: {
                                    this.errorReply(403, "Permission denied.");
                                    ** break;
                                }
                                case 400: {
                                    this.errorReply(400);
                                    ** break;
                                }
                                case 1: {
                                    this.get(name, len);
                                    ** break;
                                }
                                case 3: {
                                    this.post(input.toString(), name, len, contentType);
                                    ** break;
                                }
                                case 4: {
                                    this.put(tempFile, contentType, name);
                                    ** break;
                                }
                                case 5: {
                                    this.delete(name);
                                    ** break;
                                }
                            }
                            this.errorReply(400);
                        }
                        catch (EXistException e) {
                            HttpServerConnection.LOG.warn((Object)("Internal error: " + e.getMessage()), (Throwable)e);
                            var20_26 = null;
                            brokerPool.release(this.broker);
                            this.broker = null;
                            this.user = null;
                            break block39;
                        }
lbl127:
                        // 7 sources

                        var20_26 = null;
                        brokerPool.release(this.broker);
                        this.broker = null;
                        this.user = null;
                    }
                    catch (Throwable var19_27) {
                        var20_26 = null;
                        brokerPool.release(this.broker);
                        this.broker = null;
                        this.user = null;
                        throw var19_27;
                    }
                }
                is.close();
                input = new StringBuffer();
            }
            catch (IOException io) {
                HttpServerConnection.LOG.warn((Object)io);
            }
            this.sock = null;
            this.xslStyle = null;
            this.pool.release(this);
        }
    }

    public void terminate() {
        this.terminate = true;
    }

    class NodeCount {
        int count = 1;
        DocumentImpl doc;

        public NodeCount(DocumentImpl doc) {
            this.doc = doc;
        }

        public void inc() {
            ++this.count;
        }
    }

    class DoctypeCount {
        int count = 1;
        DocumentType doctype;

        public DoctypeCount(DocumentType doctype) {
            this.doctype = doctype;
        }

        public void inc() {
            ++this.count;
        }
    }
}

