/*
 * Decompiled with CFR 0.152.
 */
package org.exist.http;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Stack;
import org.apache.log4j.Category;
import org.exist.EXistException;
import org.exist.http.HttpServerConnection;
import org.exist.util.Configuration;
import org.exist.util.DatabaseConfigurationException;

public class HttpServer
extends Thread {
    protected static int port = 8080;
    protected static String basedir = null;
    protected Configuration config = null;
    protected ConnectionPool pool;
    protected static Category LOG = Category.getInstance((String)"exist.http");
    protected boolean stop = false;

    public HttpServer(Configuration conf) throws EXistException {
        this(conf, 8088);
    }

    public HttpServer(String confFile) throws EXistException, DatabaseConfigurationException {
        this(new Configuration(confFile), 8088);
    }

    public HttpServer(Configuration conf, int port) throws EXistException {
        this(conf, port, 1, 5);
    }

    public HttpServer(Configuration conf, int port, int min, int max) throws EXistException {
        this.config = conf;
        HttpServer.port = port;
        if (this.config.getProperty("port") != null) {
            port = (Integer)this.config.getProperty("port");
        }
        if ((basedir = (String)this.config.getProperty("basedir")) == null) {
            basedir = ".";
        }
        this.pool = new ConnectionPool(min, max, this.config);
    }

    public void run() {
        try {
            ServerSocket sock = new ServerSocket(port);
            sock.setSoTimeout(500);
            LOG.debug((Object)("listening at port " + port));
            while (!this.stop) {
                try {
                    Socket s = sock.accept();
                    LOG.info((Object)("connection from " + s.getInetAddress().getHostName()));
                    HttpServerConnection con = this.pool.get();
                    con.process(s);
                }
                catch (InterruptedIOException ie) {}
            }
            LOG.info((Object)"Shutting down ...");
            sock.close();
        }
        catch (IOException io) {
            LOG.error((Object)io);
        }
        catch (SecurityException sec) {
            LOG.error((Object)sec);
        }
    }

    public void shutdown() {
        this.stop = true;
        this.pool.shutdown();
    }

    private static void printNotice() {
        System.out.println("eXist version 1.0beta1, Copyright (C) 2001 Wolfgang M. Meier");
        System.out.println("eXist comes with ABSOLUTELY NO WARRANTY.");
        System.out.println("This is free software, and you are welcome to redistribute it\nunder certain conditions; for details read the license file.\n");
        System.out.println("\nType 'q[return]' to shutdown the server. Otherwise data may be lost.\n\n");
    }

    public static void main(String[] args) {
        HttpServer.printNotice();
        try {
            HttpServer http = new HttpServer("conf.xml");
            http.start();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    class ConnectionPool {
        protected Stack pool = new Stack();
        protected ArrayList threads = new ArrayList();
        protected int min = 0;
        protected int max = 1;
        protected int connections = 0;
        protected Configuration conf;

        public ConnectionPool(int min, int max, Configuration conf) {
            this.min = min;
            this.max = max;
            this.conf = conf;
            this.initialize();
        }

        protected void initialize() {
            for (int i = 0; i < this.min; ++i) {
                HttpServerConnection con = this.createConnection();
                this.pool.push(con);
            }
        }

        protected HttpServerConnection createConnection() {
            HttpServerConnection con = new HttpServerConnection(this.conf, this);
            Thread thread = new Thread(con);
            this.threads.add(con);
            thread.start();
            ++this.connections;
            return con;
        }

        public synchronized HttpServerConnection get() {
            if (this.pool.isEmpty()) {
                if (this.connections < this.max) {
                    return this.createConnection();
                }
                while (this.pool.isEmpty()) {
                    LOG.debug((Object)"waiting for connection to become available");
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {}
                }
            }
            HttpServerConnection con = (HttpServerConnection)this.pool.pop();
            this.notifyAll();
            return con;
        }

        public synchronized void release(HttpServerConnection con) {
            this.pool.push(con);
            this.notifyAll();
        }

        public synchronized void shutdown() {
            Iterator i = this.threads.iterator();
            while (i.hasNext()) {
                ((HttpServerConnection)i.next()).terminate();
            }
            while (this.pool.size() < this.connections) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

