/*
 * Decompiled with CFR 0.152.
 */
package org.exist.dom;

import java.util.Iterator;
import org.exist.dom.AbstractNodeSetBase;
import org.exist.dom.DocumentImpl;
import org.exist.dom.DocumentSet;
import org.exist.dom.ExtArrayNodeSet;
import org.exist.dom.NodeImpl;
import org.exist.dom.NodeProxy;
import org.exist.dom.NodeSet;
import org.exist.dom.XMLUtil;
import org.exist.xquery.NodeTest;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.SequenceIterator;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VirtualNodeSet
extends AbstractNodeSetBase {
    protected int axis = -1;
    protected NodeTest test;
    protected NodeSet context;
    protected NodeSet realSet = null;
    protected boolean realSetIsComplete = false;
    protected boolean inPredicate = false;
    protected boolean useSelfAsContext = false;

    public VirtualNodeSet(int axis, NodeTest test, NodeSet context) {
        this.axis = axis;
        this.test = test;
        this.context = context;
    }

    public boolean contains(DocumentImpl doc, long nodeId) {
        NodeProxy first = this.getFirstParent(new NodeProxy(doc, nodeId), null, this.axis == 12, 0);
        return first != null || this.context.get(doc, XMLUtil.getParentId(doc, nodeId)) != null;
    }

    public boolean contains(NodeProxy p) {
        NodeProxy first = this.getFirstParent(p, null, this.axis == 12, 0);
        return first != null || this.context.get(p.getDocument(), XMLUtil.getParentId(p.getDocument(), p.gid)) != null;
    }

    public void setInPredicate(boolean predicate) {
        this.inPredicate = predicate;
    }

    public DocumentSet getDocumentSet() {
        return this.context.getDocumentSet();
    }

    protected NodeProxy getFirstParent(NodeProxy node, long gid, boolean includeSelf) {
        return this.getFirstParent(node, null, includeSelf, true, 0);
    }

    protected NodeProxy getFirstParent(NodeProxy node, NodeProxy first, boolean includeSelf, int recursions) {
        return this.getFirstParent(node, first, includeSelf, true, recursions);
    }

    protected NodeProxy getFirstParent(NodeProxy node, NodeProxy first, boolean includeSelf, boolean directParent, int recursions) {
        NodeProxy parent;
        long pid = XMLUtil.getParentId(node.getDocument(), node.gid);
        if (recursions == 0 && includeSelf && this.test.matches(node)) {
            if (this.axis == 5) {
                parent = this.context.get(new NodeProxy(node.getDocument(), pid));
                if (parent != null) {
                    node.copyContext(parent);
                    if (this.useSelfAsContext && this.inPredicate) {
                        node.addContextNode(node);
                    } else if (this.inPredicate) {
                        node.addContextNode(parent);
                    }
                    return node;
                }
            } else {
                first = node;
            }
        }
        if (first == null) {
            if (pid < 0L) {
                return null;
            }
            first = new NodeProxy(node.getDocument(), pid, 1);
            return this.getFirstParent(first, first, false, directParent, recursions + 1);
        }
        parent = this.context.get(node.getDocument(), pid);
        if (parent != null && this.test.matches(first)) {
            if (this.axis != 5) {
                node = first;
            }
            node.copyContext(parent);
            if (this.useSelfAsContext && this.inPredicate) {
                node.addContextNode(node);
            } else if (this.inPredicate) {
                node.addContextNode(parent);
            }
            return node;
        }
        if (pid < 0L) {
            return null;
        }
        if (directParent && this.axis == 5 && recursions == 1) {
            return null;
        }
        parent = new NodeProxy(node.getDocument(), pid, 1);
        return this.getFirstParent(parent, first, false, directParent, recursions + 1);
    }

    public NodeProxy nodeHasParent(DocumentImpl doc, long gid, boolean directParent, boolean includeSelf, int level) {
        NodeProxy p = this.getFirstParent(new NodeProxy(doc, gid), null, includeSelf, directParent, 0);
        if (p != null) {
            this.addInternal(p);
        }
        return p;
    }

    public NodeProxy nodeHasParent(NodeProxy node, boolean directParent, boolean includeSelf, int level) {
        NodeProxy p = this.getFirstParent(node, null, includeSelf, directParent, 0);
        if (p != null) {
            this.addInternal(p);
        }
        return p;
    }

    private void addInternal(NodeProxy p) {
        if (this.realSet == null) {
            this.realSet = new ExtArrayNodeSet(256);
        }
        this.realSet.add(p);
        this.realSetIsComplete = false;
    }

    public NodeProxy parentWithChild(DocumentImpl doc, long gid, boolean directParent, boolean includeSelf, int level) {
        NodeProxy first = this.getFirstParent(new NodeProxy(doc, gid), null, includeSelf, directParent, 0);
        if (first != null) {
            this.addInternal(first);
        }
        return first;
    }

    public NodeProxy parentWithChild(NodeProxy proxy, boolean directParent, boolean includeSelf, int level) {
        NodeProxy first = this.getFirstParent(proxy, null, includeSelf, directParent, 0);
        if (first != null) {
            this.addInternal(first);
        }
        return first;
    }

    private final NodeSet getNodes() {
        ExtArrayNodeSet result = new ExtArrayNodeSet();
        Iterator i = this.context.iterator();
        while (i.hasNext()) {
            Iterator domIter;
            NodeProxy proxy = (NodeProxy)i.next();
            if (proxy.gid < 0L) {
                if (proxy.getDocument().getResourceType() == 1) continue;
                NodeProxy docElemProxy = new NodeProxy(proxy.getDoc(), 1L, 1);
                docElemProxy.setInternalAddress(proxy.getDocument().getFirstChildAddress());
                if (this.test.matches(docElemProxy)) {
                    result.add(docElemProxy);
                }
                if (this.axis != 7 && this.axis != 8 && this.axis != 13) continue;
                domIter = docElemProxy.getDocument().getBroker().getNodeIterator(docElemProxy);
                NodeImpl node = (NodeImpl)domIter.next();
                node.setOwnerDocument(docElemProxy.getDocument());
                node.setGID(docElemProxy.gid);
                docElemProxy.setMatches(proxy.getMatches());
                this.addChildren(docElemProxy, result, node, domIter, 0);
                continue;
            }
            if (this.axis == 12 && this.test.matches(proxy)) {
                if (this.inPredicate) {
                    proxy.addContextNode(proxy);
                }
                result.add(proxy);
                continue;
            }
            domIter = proxy.getDocument().getBroker().getNodeIterator(proxy);
            NodeImpl node = (NodeImpl)domIter.next();
            node.setOwnerDocument(proxy.getDocument());
            node.setGID(proxy.gid);
            this.addChildren(proxy, result, node, domIter, 0);
        }
        return result;
    }

    private final void addChildren(NodeProxy contextNode, NodeSet result, NodeImpl node, Iterator iter, int recursions) {
        if (node.hasChildNodes()) {
            for (int i = 0; i < node.getChildCount(); ++i) {
                NodeImpl child = (NodeImpl)iter.next();
                if (child == null) {
                    LOG.debug((Object)("CHILD == NULL; doc = " + ((DocumentImpl)node.getOwnerDocument()).getName()));
                }
                if (node.getOwnerDocument() == null) {
                    LOG.debug((Object)"DOC == NULL");
                }
                child.setOwnerDocument(node.getOwnerDocument());
                child.setGID(node.firstChildID() + (long)i);
                NodeProxy p = new NodeProxy(child.ownerDocument, child.gid, child.getNodeType());
                p.setInternalAddress(child.internalAddress);
                p.setMatches(contextNode.getMatches());
                if (this.test.matches(child) && ((this.axis == 5 || this.axis == 6) && recursions == 0 || this.axis == 7 || this.axis == 8 || this.axis == 13)) {
                    result.add(p);
                    p.copyContext(contextNode);
                    if (this.useSelfAsContext && this.inPredicate) {
                        p.addContextNode(p);
                    } else if (this.inPredicate) {
                        p.addContextNode(contextNode);
                    }
                }
                this.addChildren(contextNode, result, child, iter, recursions + 1);
            }
        } else if (this.test.matches(node)) {
            if ((this.axis == 5 || this.axis == 6) && recursions > 0) {
                return;
            }
            NodeProxy p = new NodeProxy(node.ownerDocument, node.gid, node.getNodeType());
            p.setInternalAddress(node.internalAddress);
            p.setMatches(contextNode.getMatches());
            result.add(p);
            p.copyContext(contextNode);
            if (this.useSelfAsContext && this.inPredicate) {
                p.addContextNode(p);
            } else if (this.inPredicate) {
                p.addContextNode(contextNode);
            }
        }
    }

    private final void realize() {
        if (this.realSet != null && this.realSetIsComplete) {
            return;
        }
        this.realSet = this.getNodes();
        this.realSetIsComplete = true;
    }

    public void setSelfIsContext() {
        this.useSelfAsContext = true;
    }

    public boolean hasIndex() {
        return false;
    }

    public void add(DocumentImpl doc, long nodeId) {
    }

    public void add(Node node) {
    }

    public void add(NodeProxy proxy) {
    }

    public void addAll(NodeList other) {
    }

    public void addAll(NodeSet other) {
    }

    public void set(int position, DocumentImpl doc, long nodeId) {
    }

    public void remove(NodeProxy node) {
    }

    public int getLength() {
        this.realize();
        return this.realSet.getLength();
    }

    public Node item(int pos) {
        this.realize();
        return this.realSet.item(pos);
    }

    public NodeProxy get(int pos) {
        this.realize();
        return this.realSet.get(pos);
    }

    public Item itemAt(int pos) {
        this.realize();
        return this.realSet.itemAt(pos);
    }

    public NodeProxy get(DocumentImpl doc, long gid) {
        this.realize();
        return this.realSet.get(doc, gid);
    }

    public NodeProxy get(NodeProxy proxy) {
        this.realize();
        return this.realSet.get(proxy);
    }

    public Iterator iterator() {
        this.realize();
        return this.realSet.iterator();
    }

    public SequenceIterator iterate() {
        this.realize();
        return this.realSet.iterate();
    }

    public SequenceIterator unorderedIterator() {
        this.realize();
        return this.realSet.unorderedIterator();
    }

    public NodeSet intersection(NodeSet other) {
        this.realize();
        return this.realSet.intersection(other);
    }

    public NodeSet union(NodeSet other) {
        this.realize();
        return this.realSet.union(other);
    }
}

