/*
 * Decompiled with CFR 0.152.
 */
package org.exist.dom;

import org.exist.dom.CharacterDataImpl;
import org.exist.dom.NodeImpl;
import org.exist.dom.NodeObjectPool;
import org.exist.util.ByteArrayPool;
import org.exist.util.UTF8;
import org.w3c.dom.DOMException;
import org.w3c.dom.Text;

public class TextImpl
extends CharacterDataImpl
implements Text {
    public TextImpl() {
        super((short)3);
    }

    public TextImpl(long gid) {
        super((short)3, gid);
    }

    public TextImpl(String data) {
        super((short)3, data);
    }

    public TextImpl(long gid, String data) {
        super((short)3, gid, data);
    }

    public TextImpl(char[] data, int start, int howmany) {
        super((short)3, data, start, howmany);
    }

    public static NodeImpl deserialize(byte[] data, int start, int len, boolean pooled) {
        TextImpl text = pooled ? (TextImpl)NodeObjectPool.getInstance().borrowNode(TextImpl.class) : new TextImpl();
        text.cdata = UTF8.decode(data, start + 1, len - 1);
        return text;
    }

    public void appendData(String arg) throws DOMException {
        super.appendData(arg);
    }

    public void appendData(char[] data, int start, int howmany) throws DOMException {
        super.appendData(data, start, howmany);
    }

    public void deleteData(int offset, int count) throws DOMException {
        super.deleteData(offset, count);
    }

    public int getLength() {
        return super.getLength();
    }

    public String getNodeValue() {
        return super.getNodeValue();
    }

    public void insertData(int offset, String arg) throws DOMException {
        super.insertData(offset, arg);
    }

    public void replaceData(int offset, int count, String arg) throws DOMException {
        super.replaceData(offset, count, arg);
    }

    public byte[] serialize() {
        byte[] data = ByteArrayPool.getByteArray(this.cdata.UTF8Size() + 1);
        data[0] = 0;
        this.cdata.UTF8Encode(data, 1);
        return data;
    }

    public void setNodeValue(String value) throws DOMException {
        super.setNodeValue(value);
    }

    public Text splitText(int offset) throws DOMException {
        return null;
    }

    public String substringData(int offset, int count) throws DOMException {
        return super.substringData(offset, count);
    }

    public String toString(boolean top) {
        if (top) {
            StringBuffer result = new StringBuffer();
            result.append("<exist:text ");
            result.append("xmlns:exist=\"http://exist.sourceforge.net/NS/exist\" ");
            result.append("exist:id=\"");
            result.append(this.gid);
            result.append("\" exist:source=\"");
            result.append(this.ownerDocument.getFileName());
            result.append("\">");
            result.append(this.getData());
            result.append("</exist:text>");
            return result.toString();
        }
        return this.toString();
    }

    public String toString() {
        return super.toString();
    }
}

