/*
 * Decompiled with CFR 0.152.
 */
package org.exist.dom;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import antlr.collections.AST;
import java.io.StringReader;
import java.util.Iterator;
import org.exist.EXistException;
import org.exist.dom.AbstractNodeSetBase;
import org.exist.dom.DocumentImpl;
import org.exist.dom.DocumentSet;
import org.exist.dom.NodeProxy;
import org.exist.dom.NodeSet;
import org.exist.security.User;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.util.OrderedLinkedList;
import org.exist.xquery.PathExpr;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.parser.XQueryLexer;
import org.exist.xquery.parser.XQueryParser;
import org.exist.xquery.parser.XQueryTreeParser;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SortedNodeSet
extends AbstractNodeSetBase {
    private PathExpr expr;
    private OrderedLinkedList list = new OrderedLinkedList();
    private DocumentSet ndocs;
    private String sortExpr;
    private BrokerPool pool;
    private User user = null;

    public SortedNodeSet(BrokerPool pool, User user, String sortExpr) {
        this.sortExpr = sortExpr;
        this.pool = pool;
        this.user = user;
    }

    public void addAll(Sequence other) throws XPathException {
        this.addAll(other.toNodeSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(NodeSet other) {
        NodeProxy p;
        long start = System.currentTimeMillis();
        DocumentSet docs = new DocumentSet();
        Iterator i = other.iterator();
        while (i.hasNext()) {
            p = (NodeProxy)i.next();
            docs.add(p.getDocument());
        }
        DBBroker broker = null;
        try {
            broker = this.pool.get(this.user);
            XQueryContext context = new XQueryContext(broker);
            XQueryLexer lexer = new XQueryLexer(context, new StringReader(this.sortExpr));
            XQueryParser parser = new XQueryParser(lexer);
            XQueryTreeParser treeParser = new XQueryTreeParser(context);
            parser.xpath();
            if (parser.foundErrors()) {
                LOG.debug((Object)parser.getErrorMessage());
            }
            AST ast = parser.getAST();
            LOG.debug((Object)("generated AST: " + ast.toStringTree()));
            this.expr = new PathExpr(context);
            treeParser.xpath(ast, this.expr);
            if (treeParser.foundErrors()) {
                LOG.debug((Object)treeParser.getErrorMessage());
            }
            SequenceIterator i2 = other.iterate();
            while (i2.hasNext()) {
                p = (NodeProxy)i2.nextItem();
                IteratorItem item = new IteratorItem(broker, p, this.expr, docs, context);
                this.list.add(item);
            }
        }
        catch (RecognitionException re) {
            LOG.debug((Object)re);
        }
        catch (TokenStreamException tse) {
            LOG.debug((Object)tse);
        }
        catch (EXistException e) {
            LOG.debug((Object)"Exception during sort", (Throwable)e);
        }
        catch (XPathException e) {
            LOG.debug((Object)"Exception during sort", (Throwable)e);
        }
        finally {
            this.pool.release(broker);
        }
        LOG.debug((Object)("sort-expression found " + this.list.size() + " in " + (System.currentTimeMillis() - start) + "ms."));
    }

    public void addAll(NodeList other) {
        if (!(other instanceof NodeSet)) {
            throw new RuntimeException("not implemented!");
        }
        this.addAll((NodeSet)other);
    }

    public boolean contains(DocumentImpl doc, long nodeId) {
        return this.contains(new NodeProxy(doc, nodeId));
    }

    public boolean contains(NodeProxy proxy) {
        Iterator i = this.list.iterator();
        while (i.hasNext()) {
            NodeProxy p = ((IteratorItem)i.next()).proxy;
            if (p.compareTo(proxy) != 0) continue;
            return true;
        }
        return false;
    }

    public NodeProxy get(int pos) {
        IteratorItem item = (IteratorItem)this.list.get(pos);
        return item == null ? null : item.proxy;
    }

    public NodeProxy get(DocumentImpl doc, long nodeId) {
        NodeProxy proxy = new NodeProxy(doc, nodeId);
        Iterator i = this.list.iterator();
        while (i.hasNext()) {
            NodeProxy p = ((IteratorItem)i.next()).proxy;
            if (p.compareTo(proxy) != 0) continue;
            return p;
        }
        return null;
    }

    public NodeProxy get(NodeProxy proxy) {
        Iterator i = this.list.iterator();
        while (i.hasNext()) {
            NodeProxy p = ((IteratorItem)i.next()).proxy;
            if (p.compareTo(proxy) != 0) continue;
            return p;
        }
        return null;
    }

    public int getLength() {
        return this.list.size();
    }

    public Node item(int pos) {
        NodeProxy p = ((IteratorItem)this.list.get((int)pos)).proxy;
        return p == null ? null : p.getDocument().getNode(p);
    }

    public Item itemAt(int pos) {
        NodeProxy p = ((IteratorItem)this.list.get((int)pos)).proxy;
        return p == null ? null : p;
    }

    public Iterator iterator() {
        return new SortedNodeSetIterator(this.list.iterator());
    }

    public SequenceIterator iterate() {
        return new SortedNodeSetIterator(this.list.iterator());
    }

    public SequenceIterator unorderedIterator() {
        return new SortedNodeSetIterator(this.list.iterator());
    }

    public void add(NodeProxy proxy) {
    }

    private static final class IteratorItem
    extends OrderedLinkedList.Node {
        NodeProxy proxy;
        String value = null;

        public IteratorItem(DBBroker broker, NodeProxy proxy, PathExpr expr, DocumentSet ndocs, XQueryContext context) {
            this.proxy = proxy;
            try {
                Sequence seq = expr.eval(proxy);
                StringBuffer buf = new StringBuffer();
                OrderedLinkedList strings = new OrderedLinkedList();
                SequenceIterator i = seq.iterate();
                while (i.hasNext()) {
                    Item item = i.nextItem();
                    strings.add(new OrderedLinkedList.SimpleNode((Comparable)((Object)item.getStringValue().toUpperCase())));
                }
                Iterator j = strings.iterator();
                while (j.hasNext()) {
                    buf.append(((OrderedLinkedList.SimpleNode)j.next()).getData());
                }
                this.value = buf.toString();
            }
            catch (XPathException e) {
                AbstractNodeSetBase.LOG.warn((Object)e.getMessage(), (Throwable)e);
            }
        }

        public int compareTo(OrderedLinkedList.Node other) {
            IteratorItem o = (IteratorItem)other;
            if (this.value == null) {
                return o.value == null ? 0 : 1;
            }
            if (o.value == null) {
                return this.value == null ? 0 : -1;
            }
            return this.value.compareTo(o.value);
        }

        public boolean equals(OrderedLinkedList.Node other) {
            IteratorItem o = (IteratorItem)other;
            return this.value.equals(o.value);
        }
    }

    private static final class SortedNodeSetIterator
    implements Iterator,
    SequenceIterator {
        Iterator pi;

        public SortedNodeSetIterator(Iterator i) {
            this.pi = i;
        }

        public boolean hasNext() {
            return this.pi.hasNext();
        }

        public Object next() {
            if (!this.pi.hasNext()) {
                return null;
            }
            return ((IteratorItem)this.pi.next()).proxy;
        }

        public Item nextItem() {
            if (!this.pi.hasNext()) {
                return null;
            }
            return ((IteratorItem)this.pi.next()).proxy;
        }

        public void remove() {
        }
    }
}

