/*
 * Decompiled with CFR 0.152.
 */
package org.exist.dom;

import java.util.Iterator;
import org.exist.dom.QName;
import org.exist.util.hashtable.AbstractHashtable;

public class QNamePool
extends AbstractHashtable {
    private QName[] values;
    private QName temp = new QName("", "");

    public QNamePool() {
        super(512);
        this.values = new QName[this.tabSize];
    }

    public QNamePool(int iSize) {
        super(iSize);
        this.values = new QName[this.tabSize];
    }

    public QName add(String namespaceURI, String localName, String prefix) {
        this.temp.setLocalName(localName);
        this.temp.setNamespaceURI(namespaceURI);
        this.temp.setPrefix(prefix);
        try {
            return this.insert(this.temp);
        }
        catch (AbstractHashtable.HashtableOverflowException e) {
            this.values = new QName[this.tabSize];
            this.items = 0;
            try {
                return this.insert(this.temp);
            }
            catch (AbstractHashtable.HashtableOverflowException e1) {
                return new QName(this.temp);
            }
        }
    }

    protected QName insert(QName value) throws AbstractHashtable.HashtableOverflowException {
        if (value == null) {
            throw new IllegalArgumentException("Illegal value: null");
        }
        int idx = value.hashCode() % this.tabSize;
        if (idx < 0) {
            idx *= -1;
        }
        int bucket = -1;
        if (this.values[idx] == null) {
            this.values[idx] = new QName(value);
            ++this.items;
            return this.values[idx];
        }
        if (this.values[idx] == REMOVED) {
            bucket = idx;
        } else if (this.values[idx].equals(value)) {
            return this.values[idx];
        }
        int rehashVal = this.rehash(idx);
        int rehashCnt = 1;
        for (int i = 0; i < this.tabSize; ++i) {
            if (this.values[idx = (idx + rehashVal) % this.tabSize] == REMOVED) {
                bucket = idx;
            } else {
                if (this.values[idx] == null) {
                    if (bucket > -1) {
                        idx = bucket;
                    }
                    this.values[idx] = new QName(value);
                    ++this.items;
                    return this.values[idx];
                }
                if (this.values[idx].equals(value)) {
                    return this.values[idx];
                }
            }
            ++rehashCnt;
        }
        if (bucket > -1) {
            this.values[bucket] = new QName(value);
            ++this.items;
            return this.values[bucket];
        }
        throw new AbstractHashtable.HashtableOverflowException();
    }

    protected int rehash(int iVal) {
        int retVal = (iVal + iVal / 2) % this.tabSize;
        if (retVal == 0) {
            retVal = 1;
        }
        return retVal;
    }

    public Iterator iterator() {
        return null;
    }

    public Iterator valueIterator() {
        return null;
    }
}

