/*
 * Decompiled with CFR 0.152.
 */
package org.exist.dom;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.exist.EXistException;
import org.exist.dom.AttrImpl;
import org.exist.dom.CommentImpl;
import org.exist.dom.DocumentImpl;
import org.exist.dom.NamedNode;
import org.exist.dom.NamedNodeMapImpl;
import org.exist.dom.NodeImpl;
import org.exist.dom.NodeListImpl;
import org.exist.dom.NodeObjectPool;
import org.exist.dom.NodeSet;
import org.exist.dom.ProcessingInstructionImpl;
import org.exist.dom.QName;
import org.exist.dom.TextImpl;
import org.exist.dom.XMLUtil;
import org.exist.security.PermissionDeniedException;
import org.exist.storage.DBBroker;
import org.exist.storage.NodePath;
import org.exist.storage.Signatures;
import org.exist.util.ByteArrayPool;
import org.exist.util.ByteConversion;
import org.exist.util.UTF8;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;

public class ElementImpl
extends NamedNode
implements Element {
    protected short attributes = 0;
    protected int children = 0;
    protected long firstChild = -1L;
    protected Map namespaceMappings = null;

    public ElementImpl() {
        super((short)1);
    }

    public ElementImpl(long gid) {
        super((short)1, gid, null);
    }

    public ElementImpl(QName nodeName) {
        super((short)1, nodeName);
        this.nodeName = nodeName;
    }

    public ElementImpl(long gid, QName nodeName) {
        super((short)1, gid, nodeName);
    }

    public void clear() {
        super.clear();
        this.firstChild = -1L;
        this.gid = 0L;
        this.children = 0;
        this.attributes = 0;
        if (this.namespaceMappings != null) {
            this.namespaceMappings = null;
        }
    }

    public static NodeImpl deserialize(byte[] data, int start, int len, DocumentImpl doc, boolean pooled) {
        String namespace;
        byte attrSizeType = (byte)((data[start] & 0xC) >> 2);
        byte idSizeType = (byte)(data[start] & 3);
        boolean hasNamespace = (data[start] & 0x10) == 16;
        int children = ByteConversion.byteToInt(data, start + 1);
        short attributes = (short)Signatures.read(attrSizeType, data, start + 5);
        int next = start + 5 + Signatures.getLength(attrSizeType);
        int end = start + len;
        short id = (short)Signatures.read(idSizeType, data, next);
        next += Signatures.getLength(idSizeType);
        short nsId = 0;
        String prefix = null;
        if (hasNamespace) {
            nsId = ByteConversion.byteToShort(data, next);
            short prefixLen = ByteConversion.byteToShort(data, next += 2);
            next += 2;
            if (prefixLen > 0) {
                prefix = UTF8.decode(data, next, prefixLen).toString();
            }
            next += prefixLen;
        }
        String name = doc.getSymbols().getName(id);
        String string = namespace = nsId == 0 ? "" : doc.getSymbols().getNamespace(nsId);
        ElementImpl node = pooled ? (ElementImpl)NodeObjectPool.getInstance().borrowNode(ElementImpl.class) : new ElementImpl();
        node.nodeName = doc.getSymbols().getQName(namespace, name, prefix);
        node.children = children;
        node.attributes = attributes;
        node.ownerDocument = doc;
        if (end > next) {
            byte[] pfxData = new byte[end - next];
            System.arraycopy(data, next, pfxData, 0, end - next);
            ByteArrayInputStream bin = new ByteArrayInputStream(pfxData);
            DataInputStream in = new DataInputStream(bin);
            try {
                int prefixCount = in.readShort();
                for (int i = 0; i < prefixCount; ++i) {
                    prefix = in.readUTF();
                    nsId = in.readShort();
                    node.addNamespaceMapping(prefix, doc.getSymbols().getNamespace(nsId));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return node;
    }

    public void addNamespaceMapping(String prefix, String ns) {
        if (prefix == null) {
            return;
        }
        if (this.namespaceMappings == null) {
            this.namespaceMappings = new HashMap(1);
        } else if (this.namespaceMappings.containsKey(prefix)) {
            return;
        }
        this.namespaceMappings.put(prefix, ns);
        this.ownerDocument.getSymbols().getNSSymbol(ns);
    }

    public void appendChildInternal(NodeImpl child) throws DOMException {
        if (this.gid > 0L) {
            child.setGID(this.firstChildID() + (long)this.children);
            if (child.getGID() < 0L) {
                int level = this.ownerDocument.getTreeLevel(this.gid);
                int order = this.ownerDocument.getTreeLevelOrder(level);
                throw new DOMException(11, "internal error: node " + this.gid + "; first-child: " + this.firstChildID() + "; level: " + level + "; maxDepth: " + this.ownerDocument.maxDepth + "; order(level+1): " + order + "; start0: " + this.ownerDocument.getLevelStartPoint(level) + "; start1: " + this.ownerDocument.getLevelStartPoint(level + 1));
            }
        } else {
            child.setGID(0L);
        }
        ++this.children;
    }

    public Node appendChild(Node child) throws DOMException {
        NodeImpl lastNode;
        long childGid;
        DocumentImpl prevDoc = new DocumentImpl(this.ownerDocument);
        if (this.children == 0) {
            childGid = this.firstChildID();
            lastNode = this;
        } else {
            childGid = this.lastChildID() + 1L;
            lastNode = this.getLastNode((NodeImpl)this.ownerDocument.getNode(childGid - 1L));
        }
        try {
            this.checkTree(1);
        }
        catch (EXistException e) {
            throw new DOMException(13, "max. document size exceeded");
        }
        ++this.children;
        Node node = this.appendChild(childGid, lastNode, this.getPath(), child, true);
        this.ownerDocument.broker.update(this);
        this.ownerDocument.broker.reindex(prevDoc, this.ownerDocument, null);
        try {
            this.ownerDocument.broker.saveCollection(this.ownerDocument.getCollection());
        }
        catch (PermissionDeniedException e) {
            throw new DOMException(15, e.getMessage());
        }
        return child;
    }

    private void checkTree(int size) throws EXistException {
        int level = this.ownerDocument.getTreeLevel(this.gid);
        if (this.ownerDocument.getMaxDepth() == level + 1) {
            this.ownerDocument.incMaxDepth();
            LOG.debug((Object)("setting maxDepth = " + this.ownerDocument.getMaxDepth()));
        }
        if (this.ownerDocument.getTreeLevelOrder(level + 1) < this.children + size) {
            this.ownerDocument.setTreeLevelOrder(level + 1, this.children + size + this.ownerDocument.broker.getXUpdateGrowthFactor());
            this.ownerDocument.calculateTreeLevelStartPoints(false);
            if (this.ownerDocument.reindex < 0 || this.ownerDocument.reindex > level + 1) {
                this.ownerDocument.reindex = level + 1;
            }
        }
    }

    public Node appendAttributes(NodeList attribs) throws DOMException {
        NodeList duplicateAttrs = this.findDupAttributes(attribs);
        if (duplicateAttrs != null) {
            this.removeAppendAttributes(duplicateAttrs, attribs);
            return null;
        }
        DocumentImpl prevDoc = new DocumentImpl(this.ownerDocument);
        Node node = null;
        AttrImpl lastAttrib = this.getLastAttribute();
        node = this.children == 0 ? this.appendChildren(this.firstChildID(), this, this.getPath(), attribs, true) : (lastAttrib != null && lastAttrib.gid == this.lastChildID() ? this.appendChildren(this.lastChildID() + 1L, lastAttrib, this.getPath(), attribs, true) : this.appendChildren(this.firstChildID() + 1L, this, this.getPath(), attribs, true));
        this.ownerDocument.broker.update(this);
        this.ownerDocument.broker.reindex(prevDoc, this.ownerDocument, null);
        return node;
    }

    private NodeList checkForAttributes(NodeList nodes) throws DOMException {
        NodeListImpl attribs = null;
        NodeListImpl rest = null;
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node next = nodes.item(i);
            if (next.getNodeType() == 2) {
                if (attribs == null) {
                    attribs = new NodeListImpl();
                }
                attribs.add(next);
                continue;
            }
            if (attribs == null) continue;
            if (rest == null) {
                rest = new NodeListImpl();
            }
            rest.add(next);
        }
        if (attribs != null) {
            this.appendAttributes(attribs);
            return rest;
        }
        return nodes;
    }

    public Node appendChildren(NodeList nodes, int child) throws DOMException {
        if ((nodes = this.checkForAttributes(nodes)) == null || nodes.getLength() == 0) {
            return null;
        }
        DocumentImpl prevDoc = new DocumentImpl(this.ownerDocument);
        Node node = null;
        if (this.children == 0) {
            node = this.appendChildren(this.firstChildID(), this, this.getPath(), nodes, true);
        } else if (child == 1) {
            Node firstChild = this.getFirstChild();
            this.insertBefore(nodes, firstChild);
        } else {
            long pos = this.firstChildID();
            if (0 < child && child <= this.children) {
                pos = this.firstChildID() + (long)child - 2L;
                NodeImpl prevNode = this.getLastNode((NodeImpl)this.ownerDocument.getNode(pos));
                node = this.insertAfter(nodes, (Node)prevNode);
            } else {
                NodeImpl prevNode = this.getLastNode((NodeImpl)this.ownerDocument.getNode(this.lastChildID()));
                node = this.appendChildren(this.lastChildID() + 1L, prevNode, this.getPath(), nodes, true);
            }
        }
        this.ownerDocument.broker.update(this);
        this.ownerDocument.broker.reindex(prevDoc, this.ownerDocument, null);
        return node;
    }

    protected Node appendChildren(long gid, NodeImpl last, NodePath lastPath, NodeList nodes, boolean index) throws DOMException {
        if (last == null || last.ownerDocument == null) {
            throw new DOMException(13, "invalid node");
        }
        try {
            this.checkTree(nodes.getLength());
        }
        catch (EXistException e) {
            throw new DOMException(13, "max. document size exceeded");
        }
        this.children += nodes.getLength();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node child = nodes.item(i);
            if (last == null) {
                throw new DOMException(13, "invalid node: null");
            }
            last = (NodeImpl)this.appendChild(gid + (long)i, last, lastPath, child, index);
        }
        return last;
    }

    private Node appendChild(long gid, NodeImpl last, NodePath lastPath, Node child, boolean index) throws DOMException {
        if (last == null) {
            throw new DOMException(13, "invalid node");
        }
        switch (child.getNodeType()) {
            case 1: {
                Element childElem = (Element)child;
                ElementImpl elem = new ElementImpl(new QName(child.getLocalName(), child.getNamespaceURI(), child.getPrefix()));
                elem.setGID(gid);
                elem.setOwnerDocument(this.ownerDocument);
                NodeListImpl ch = new NodeListImpl();
                NamedNodeMap attribs = child.getAttributes();
                for (int i = 0; i < attribs.getLength(); ++i) {
                    Attr attr = (Attr)attribs.item(i);
                    ch.add(attr);
                }
                ch.addAll(child.getChildNodes());
                elem.setChildCount(ch.getLength());
                elem.setAttributes((short)(elem.getAttributesCount() + attribs.getLength()));
                lastPath.addComponent(elem.getNodeName());
                this.ownerDocument.broker.insertAfter(last, elem);
                if ((this.ownerDocument.reindex < 0 || this.ownerDocument.reindex > this.ownerDocument.getTreeLevel(gid)) && index) {
                    this.ownerDocument.broker.index(elem, lastPath);
                }
                elem.setChildCount(0);
                try {
                    elem.checkTree(ch.getLength());
                }
                catch (EXistException e) {
                    throw new DOMException(13, "max. document size exceeded");
                }
                last = (NodeImpl)elem.appendChildren(elem.firstChildID(), elem, lastPath, ch, index);
                lastPath.removeLastComponent();
                return last;
            }
            case 3: {
                TextImpl text = new TextImpl(((Text)child).getData());
                text.setGID(gid);
                text.setOwnerDocument(this.ownerDocument);
                this.ownerDocument.broker.insertAfter(last, text);
                if ((this.ownerDocument.reindex < 0 || this.ownerDocument.reindex > this.ownerDocument.getTreeLevel(gid)) && index) {
                    this.ownerDocument.broker.index(text, lastPath);
                }
                return text;
            }
            case 2: {
                Attr attr = (Attr)child;
                String ns = attr.getNamespaceURI();
                String prefix = ns != null && ns.equals("http://www.w3.org/XML/1998/namespace") ? "xml" : attr.getPrefix();
                String name = attr.getLocalName();
                if (name == null) {
                    name = attr.getName();
                }
                QName attrName = new QName(name, ns, prefix);
                AttrImpl attrib = new AttrImpl(attrName, attr.getValue());
                attrib.setGID(gid);
                attrib.setOwnerDocument(this.ownerDocument);
                this.ownerDocument.broker.insertAfter(last, attrib);
                if ((this.ownerDocument.reindex < 0 || this.ownerDocument.reindex > this.ownerDocument.getTreeLevel(gid)) && index) {
                    this.ownerDocument.broker.index(attrib, lastPath);
                }
                return attrib;
            }
            case 8: {
                CommentImpl comment = new CommentImpl(((Comment)child).getData());
                comment.setGID(gid);
                comment.setOwnerDocument(this.ownerDocument);
                this.ownerDocument.broker.insertAfter(last, comment);
                if ((this.ownerDocument.reindex < 0 || this.ownerDocument.reindex > this.ownerDocument.getTreeLevel(gid)) && index) {
                    this.ownerDocument.broker.index(comment, lastPath);
                }
                return comment;
            }
            case 7: {
                ProcessingInstructionImpl pi = new ProcessingInstructionImpl(gid, ((ProcessingInstruction)child).getTarget(), ((ProcessingInstruction)child).getData());
                pi.setOwnerDocument(this.ownerDocument);
                this.ownerDocument.broker.insertAfter(last, pi);
                if ((this.ownerDocument.reindex < 0 || this.ownerDocument.reindex > this.ownerDocument.getTreeLevel(gid)) && index) {
                    this.ownerDocument.broker.index(pi, lastPath);
                }
                return pi;
            }
        }
        throw new DOMException(13, "unknown node type: " + child.getNodeType() + " " + child.getNodeName());
    }

    public boolean declaresNamespacePrefixes() {
        return this.namespaceMappings != null && this.namespaceMappings.size() > 0;
    }

    public long firstChildID() {
        if (this.gid == 0L) {
            return 0L;
        }
        if (this.firstChild > -1L) {
            return this.firstChild;
        }
        this.firstChild = XMLUtil.getFirstChildId(this.ownerDocument, this.gid);
        return this.firstChild;
    }

    public short getAttributesCount() {
        return this.attributes;
    }

    public void setAttributes(short attribNum) {
        this.attributes = attribNum;
    }

    public String getAttribute(String name) {
        long start;
        for (long i = start = this.firstChildID(); i < start + (long)this.children; ++i) {
            Node child = this.ownerDocument.getNode(i);
            if (child == null || child.getNodeType() != 2 || !child.getNodeName().equals(name)) continue;
            return ((AttrImpl)child).getValue();
        }
        return null;
    }

    public String getAttributeNS(String namespaceURI, String localName) {
        long start;
        for (long i = start = this.firstChildID(); i < start + (long)this.children; ++i) {
            Node child = this.ownerDocument.getNode(i);
            if (child == null || child.getNodeType() != 2 || child.getNamespaceURI() != null && !child.getNamespaceURI().equals(namespaceURI) || !child.getLocalName().equals(localName)) continue;
            return ((AttrImpl)child).getValue();
        }
        return "";
    }

    public Attr getAttributeNode(String name) {
        long start;
        for (long i = start = this.firstChildID(); i < start + (long)this.children; ++i) {
            Node child = this.ownerDocument.getNode(i);
            if (child == null || child.getNodeType() != 2 || !child.getNodeName().equals(name)) continue;
            return (Attr)child;
        }
        return null;
    }

    private AttrImpl getLastAttribute() throws DOMException {
        Node child;
        long start = this.firstChildID();
        AttrImpl attr = null;
        for (long i = start; i < start + (long)this.children && (child = this.ownerDocument.getNode(i)) != null; ++i) {
            if (child.getNodeType() != 2) continue;
            attr = (AttrImpl)child;
        }
        return attr;
    }

    private NodeList findDupAttributes(NodeList attrs) throws DOMException {
        Node child;
        long start;
        NodeListImpl dupList = null;
        for (long i = start = this.firstChildID(); i < start + (long)this.children && (child = this.ownerDocument.getNode(i)).getNodeType() == 2; ++i) {
            Node duplicate = ElementImpl.findAttribute(child, attrs);
            if (duplicate == null) continue;
            LOG.debug((Object)("Found a duplicate attribute: " + child.getLocalName()));
            if (dupList == null) {
                dupList = new NodeListImpl();
            }
            dupList.add(child);
        }
        return dupList;
    }

    private static Node findAttribute(Node child, NodeList attrs) throws DOMException {
        String childNS = child.getNamespaceURI();
        if (childNS == null) {
            childNS = "";
        }
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node current = attrs.item(i);
            if (current == null || current.getNodeType() != 2) continue;
            String currentNS = current.getNamespaceURI();
            if (currentNS == null) {
                currentNS = "";
            }
            if (!child.getLocalName().equals(current.getLocalName()) || !childNS.equals(currentNS)) continue;
            return current;
        }
        return null;
    }

    public Attr getAttributeNodeNS(String namespaceURI, String localName) {
        long start;
        for (long i = start = this.firstChildID(); i < start + (long)this.children; ++i) {
            Node child = this.ownerDocument.getNode(i);
            if (child == null || child.getNodeType() != 2 || child.getNamespaceURI() != null && !child.getNamespaceURI().equals(namespaceURI) || !child.getLocalName().equals(localName)) continue;
            return (Attr)child;
        }
        return null;
    }

    public NamedNodeMap getAttributes() {
        NamedNodeMapImpl map = new NamedNodeMapImpl();
        long start = this.firstChildID();
        if (this.getAttributesCount() == 0) {
            return map;
        }
        for (long i = start; i < start + (long)this.children; ++i) {
            Node child = this.ownerDocument.getNode(i);
            if (child == null || child.getNodeType() != 2) continue;
            map.setNamedItem(child);
        }
        return map;
    }

    public int getChildCount() {
        return this.children;
    }

    public NodeList getChildNodes() {
        if (this.children == 0) {
            return new NodeListImpl();
        }
        long first = this.firstChildID();
        if (this.children == 1) {
            NodeListImpl childList = new NodeListImpl(1);
            childList.add(this.ownerDocument.getNode(first));
            return childList;
        }
        NodeList result = this.ownerDocument.getRange(first, first + (long)this.children - 1L);
        return result;
    }

    public NodeList getElementsByTagName(String tagName) {
        QName qname = new QName(tagName, "", null);
        return (NodeSet)this.ownerDocument.findElementsByTagName(this, qname);
    }

    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        QName qname = new QName(localName, namespaceURI, null);
        return (NodeSet)this.ownerDocument.findElementsByTagName(this, qname);
    }

    public Node getFirstChild() {
        if (!this.hasChildNodes() || this.getChildCount() == this.getAttributesCount()) {
            return null;
        }
        long first = this.firstChildID() + (long)this.getAttributesCount();
        return this.ownerDocument.getNode(first);
    }

    public Node getLastChild() {
        if (!this.hasChildNodes()) {
            return null;
        }
        return this.ownerDocument.getNode(this.lastChildID());
    }

    public String getNodeValue() throws DOMException {
        return null;
    }

    public String getTagName() {
        return this.nodeName.toString();
    }

    public boolean hasAttribute(String name) {
        long first = this.firstChildID();
        for (int i = 0; i < this.children; ++i) {
            Node n = this.ownerDocument.getNode(first + (long)i);
            if (n.getNodeType() != 2 || !n.getNodeName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAttributeNS(String namespaceURI, String localName) {
        long first = this.firstChildID();
        for (int i = 0; i < this.children; ++i) {
            Node n = this.ownerDocument.getNode(first + (long)i);
            if (n.getNodeType() != 2 || n.getNamespaceURI() != null && !n.getNamespaceURI().equals(namespaceURI) || !n.getLocalName().equals(localName)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAttributes() {
        return this.getAttributesCount() > 0;
    }

    public boolean hasChildNodes() {
        return this.children > 0;
    }

    public long lastChildID() {
        if (!this.hasChildNodes()) {
            return -1L;
        }
        return this.firstChildID() + (long)this.children - 1L;
    }

    public void removeAttribute(String name) throws DOMException {
    }

    public void removeAttributeNS(String namespaceURI, String name) throws DOMException {
    }

    public Attr removeAttributeNode(Attr oldAttr) throws DOMException {
        return null;
    }

    public byte[] serialize() {
        try {
            byte[] prefixData = null;
            if (this.namespaceMappings != null && this.namespaceMappings.size() > 0) {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                DataOutputStream out = new DataOutputStream(bout);
                out.writeShort(this.namespaceMappings.size());
                Iterator i = this.namespaceMappings.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry entry = i.next();
                    out.writeUTF((String)entry.getKey());
                    short nsId = this.ownerDocument.getSymbols().getNSSymbol((String)entry.getValue());
                    out.writeShort(nsId);
                }
                prefixData = bout.toByteArray();
            }
            short id = this.ownerDocument.getSymbols().getSymbol(this);
            boolean hasNamespace = this.nodeName.needsNamespaceDecl();
            short nsId = hasNamespace ? this.ownerDocument.getSymbols().getNSSymbol(this.nodeName.getNamespaceURI()) : (short)0;
            byte attrSizeType = Signatures.getSizeType(this.attributes);
            byte idSizeType = Signatures.getSizeType(id);
            byte signature = (byte)(0x20 | attrSizeType << 2 | idSizeType);
            int prefixLen = 0;
            if (hasNamespace) {
                prefixLen = this.nodeName.getPrefix() != null && this.nodeName.getPrefix().length() > 0 ? UTF8.encoded(this.nodeName.getPrefix()) : 0;
                signature = (byte)(signature | 0x10);
            }
            byte[] data = ByteArrayPool.getByteArray(5 + Signatures.getLength(attrSizeType) + Signatures.getLength(idSizeType) + (hasNamespace ? prefixLen + 4 : 0) + (prefixData != null ? prefixData.length : 0));
            int next = 0;
            data[next++] = signature;
            ByteConversion.intToByte(this.children, data, next);
            Signatures.write(attrSizeType, this.attributes, data, next += 4);
            Signatures.write(idSizeType, id, data, next += Signatures.getLength(attrSizeType));
            next += Signatures.getLength(idSizeType);
            if (hasNamespace) {
                ByteConversion.shortToByte(nsId, data, next);
                ByteConversion.shortToByte((short)prefixLen, data, next += 2);
                next += 2;
                if (this.nodeName.getPrefix() != null && this.nodeName.getPrefix().length() > 0) {
                    UTF8.encode(this.nodeName.getPrefix(), data, next);
                }
                next += prefixLen;
            }
            if (prefixData != null) {
                System.arraycopy(prefixData, 0, data, next, prefixData.length);
            }
            return data;
        }
        catch (IOException e) {
            return null;
        }
    }

    public void setAttribute(String name, String value) throws DOMException {
    }

    public void setAttributeNS(String namespaceURI, String qualifiedName, String value) throws DOMException {
    }

    public Attr setAttributeNode(Attr newAttr) throws DOMException {
        return null;
    }

    public Attr setAttributeNodeNS(Attr newAttr) {
        return null;
    }

    public void setChildCount(int count) {
        this.children = count;
    }

    public void setNamespaceMappings(Map map) {
        this.namespaceMappings = new HashMap(map);
        Iterator i = this.namespaceMappings.values().iterator();
        while (i.hasNext()) {
            String ns = (String)i.next();
            this.ownerDocument.getSymbols().getNSSymbol(ns);
        }
    }

    public Iterator getPrefixes() {
        return this.namespaceMappings.keySet().iterator();
    }

    public String getNamespaceForPrefix(String prefix) {
        return (String)this.namespaceMappings.get(prefix);
    }

    public int getPrefixCount() {
        return this.namespaceMappings.size();
    }

    public void toSAX(ContentHandler contentHandler, LexicalHandler lexicalHandler, boolean first, Set namespaces) throws SAXException {
        int i;
        NodeList childNodes = this.getChildNodes();
        NodeImpl child = null;
        DBBroker broker = this.ownerDocument.getBroker();
        AttributesImpl attributes = new AttributesImpl();
        Object myPrefixes = null;
        String defaultNS = null;
        if (this.declaresNamespacePrefixes()) {
            Iterator i2 = this.namespaceMappings.entrySet().iterator();
            while (i2.hasNext()) {
                Map.Entry entry = i2.next();
                contentHandler.startPrefixMapping((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (this.nodeName.needsNamespaceDecl() && !namespaces.contains(this.nodeName.getNamespaceURI())) {
            contentHandler.startPrefixMapping(this.nodeName.getPrefix(), this.nodeName.getNamespaceURI());
        }
        if (first) {
            attributes.addAttribute("http://exist.sourceforge.net/NS/exist", "id", "exist:id", "CDATA", Long.toString(this.gid));
            attributes.addAttribute("http://exist.sourceforge.net/NS/exist", "source", "exist:source", "CDATA", this.ownerDocument.getFileName());
        }
        for (i = 0; i < childNodes.getLength() && (child = (NodeImpl)childNodes.item(i)).getNodeType() == 2; ++i) {
            attributes.addAttribute(child.getNamespaceURI(), child.getLocalName(), child.getNodeName(), "CDATA", ((AttrImpl)child).getValue());
        }
        String ns = defaultNS == null ? this.getNamespaceURI() : defaultNS;
        contentHandler.startElement(ns, this.getLocalName(), this.getNodeName(), attributes);
        while (i < childNodes.getLength()) {
            child.toSAX(contentHandler, lexicalHandler, false, namespaces);
            if (++i >= childNodes.getLength()) break;
            child = (NodeImpl)childNodes.item(i);
        }
        contentHandler.endElement(ns, this.getLocalName(), this.getNodeName());
        if (this.declaresNamespacePrefixes() && myPrefixes != null) {
            Iterator j = this.namespaceMappings.keySet().iterator();
            while (j.hasNext()) {
                String prefix = (String)j.next();
                contentHandler.endPrefixMapping(prefix);
            }
        }
        if (this.nodeName.needsNamespaceDecl() && !namespaces.contains(this.nodeName.getNamespaceURI())) {
            contentHandler.endPrefixMapping(this.nodeName.getPrefix());
        }
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean top) {
        return this.toString(top, new TreeSet());
    }

    public String toString(boolean top, TreeSet namespaces) {
        DBBroker broker = this.ownerDocument.getBroker();
        StringBuffer buf = new StringBuffer();
        StringBuffer attributes = new StringBuffer();
        StringBuffer children = new StringBuffer();
        buf.append('<');
        buf.append(this.nodeName);
        if (top) {
            buf.append(" xmlns:exist=\"http://exist.sourceforge.net/NS/exist\"");
            buf.append(" exist:id=\"");
            buf.append(this.gid);
            buf.append("\" exist:document=\"");
            buf.append(this.ownerDocument.getFileName());
            buf.append("\"");
        }
        Object myPrefixes = null;
        if (this.declaresNamespacePrefixes()) {
            Iterator i = this.namespaceMappings.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                String prefix = (String)entry.getKey();
                String namespace = (String)entry.getValue();
                if (prefix.length() == 0) {
                    buf.append(" xmlns=\"");
                    buf.append(namespace);
                } else {
                    buf.append(" xmlns:");
                    buf.append(prefix);
                    buf.append("=\"");
                    buf.append(namespace);
                }
                buf.append("\" ");
                namespaces.add(namespace);
            }
        }
        if (this.nodeName.getNamespaceURI().length() > 0 && !namespaces.contains(this.nodeName.getNamespaceURI())) {
            buf.append(" xmlns:").append(this.nodeName.getPrefix()).append("=\"");
            buf.append(this.nodeName.getNamespaceURI());
            buf.append("\" ");
        }
        NodeList childNodes = this.getChildNodes();
        block5: for (int i = 0; i < childNodes.getLength(); ++i) {
            Node child = childNodes.item(i);
            switch (child.getNodeType()) {
                case 2: {
                    attributes.append(' ');
                    attributes.append(((Attr)child).getName());
                    attributes.append("=\"");
                    attributes.append(this.escapeXml(child));
                    attributes.append("\"");
                    continue block5;
                }
                case 1: {
                    children.append(((ElementImpl)child).toString(false, namespaces));
                    continue block5;
                }
                default: {
                    children.append(child.toString());
                }
            }
        }
        if (attributes.length() > 0) {
            buf.append(attributes.toString());
        }
        if (childNodes.getLength() > 0) {
            buf.append(">");
            buf.append(children.toString());
            buf.append("</");
            buf.append(this.nodeName);
            buf.append(">");
        } else {
            buf.append("/>");
        }
        return buf.toString();
    }

    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        Node result;
        if (!(refChild instanceof NodeImpl)) {
            throw new DOMException(4, "wrong node type");
        }
        DocumentImpl prevDoc = new DocumentImpl(this.ownerDocument);
        if (refChild == null) {
            return this.appendChild(newChild);
        }
        NodeImpl ref = (NodeImpl)refChild;
        long first = this.firstChildID();
        if (ref.gid < first || ref.gid > ref.gid + (long)this.children - 1L) {
            throw new DOMException(3, "reference node is not a child of the selected node");
        }
        if (ref.gid == first) {
            result = this.appendChild(first, this, this.getPath(), newChild, false);
        } else {
            NodeImpl prev = (NodeImpl)ref.getPreviousSibling();
            result = this.appendChild(ref.gid, this.getLastNode(prev), this.getPath(), newChild, false);
        }
        this.ownerDocument.broker.update(this);
        this.ownerDocument.broker.reindex(prevDoc, this.ownerDocument, null);
        try {
            this.ownerDocument.broker.saveCollection(this.ownerDocument.getCollection());
        }
        catch (PermissionDeniedException e) {
            // empty catch block
        }
        return result;
    }

    public Node insertBefore(NodeList nodes, Node refChild) throws DOMException {
        Node result;
        if (!(refChild instanceof NodeImpl)) {
            throw new DOMException(4, "wrong node type");
        }
        DocumentImpl prevDoc = new DocumentImpl(this.ownerDocument);
        if (refChild == null) {
            return this.appendChildren(nodes, -1);
        }
        NodeImpl ref = (NodeImpl)refChild;
        long first = this.firstChildID();
        if (ref.gid < first || ref.gid > ref.gid + (long)this.children - 1L) {
            throw new DOMException(3, "reference node is not a child of the selected node");
        }
        int level = this.ownerDocument.getTreeLevel(this.gid);
        if (ref.gid == first) {
            result = this.appendChildren(first, this, this.getPath(), nodes, false);
        } else {
            NodeImpl prev = (NodeImpl)ref.getPreviousSibling();
            result = this.appendChildren(ref.gid, this.getLastNode(prev), this.getPath(), nodes, false);
        }
        this.ownerDocument.broker.update(this);
        if (this.ownerDocument.reindex > -1) {
            this.ownerDocument.reindex = level + 1;
            this.ownerDocument.broker.reindex(prevDoc, this.ownerDocument, null);
        } else {
            this.ownerDocument.reindex = level + 1;
            this.ownerDocument.broker.reindex(prevDoc, this.ownerDocument, this);
        }
        return result;
    }

    public Node insertAfter(NodeList nodes, Node refChild) throws DOMException {
        if (refChild == null) {
            return this.appendChildren(nodes, -1);
        }
        if (!(refChild instanceof NodeImpl)) {
            throw new DOMException(4, "wrong node type: ");
        }
        DocumentImpl prevDoc = new DocumentImpl(this.ownerDocument);
        NodeImpl ref = (NodeImpl)refChild;
        long first = this.firstChildID();
        if (ref.gid < first || ref.gid > ref.gid + (long)this.children - 1L) {
            throw new DOMException(3, "reference node is not a child of the selected node");
        }
        int level = this.ownerDocument.getTreeLevel(this.gid);
        Node result = this.appendChildren(ref.gid + 1L, this.getLastNode(ref), this.getPath(), nodes, false);
        this.ownerDocument.broker.update(this);
        if (this.ownerDocument.reindex > -1) {
            this.ownerDocument.reindex = level + 1;
            this.ownerDocument.broker.reindex(prevDoc, this.ownerDocument, null);
        } else {
            this.ownerDocument.reindex = level + 1;
            this.ownerDocument.broker.reindex(prevDoc, this.ownerDocument, this);
        }
        return result;
    }

    public void update(NodeList newContent) throws DOMException {
        int i;
        NodePath path = this.getPath();
        DocumentImpl prevDoc = new DocumentImpl(this.ownerDocument);
        NodeList nodes = this.getChildNodes();
        NodeImpl last = this;
        long firstChildId = this.firstChildID();
        for (i = nodes.getLength(); i > 0; --i) {
            NodeImpl child = (NodeImpl)nodes.item(i - 1);
            if (child.getNodeType() == 2) {
                firstChildId = child.gid + 1L;
                last = child;
                break;
            }
            if (child.getNodeType() == 1) {
                path.addComponent(child.getNodeName());
            }
            this.removeAll(child, path);
            if (child.getNodeType() != 1) continue;
            path.removeLastComponent();
        }
        this.ownerDocument.broker.endRemove();
        this.children = i;
        this.appendChildren(firstChildId, last, this.getPath(), newContent, true);
        this.ownerDocument.broker.update(this);
        this.ownerDocument.broker.reindex(prevDoc, this.ownerDocument, null);
    }

    public void updateChild(Node oldChild, Node newChild) throws DOMException {
        if (!(oldChild instanceof NodeImpl)) {
            throw new DOMException(4, "wrong node type");
        }
        NodeImpl old = (NodeImpl)oldChild;
        NodeImpl newNode = (NodeImpl)newChild;
        if (old.getParentGID() != this.gid) {
            throw new DOMException(8, "node is not a child of this element");
        }
        NodeImpl previous = (NodeImpl)old.getPreviousSibling();
        previous = previous == null ? this : this.getLastNode(previous);
        this.ownerDocument.broker.removeNode(old, old.getPath());
        this.ownerDocument.broker.endRemove();
        newNode.gid = old.gid;
        this.ownerDocument.broker.insertAfter(previous, newNode);
        this.ownerDocument.broker.index(newNode);
        this.ownerDocument.broker.flush();
    }

    public Node removeChild(Node oldChild) throws DOMException {
        if (!(oldChild instanceof NodeImpl)) {
            throw new DOMException(4, "wrong node type");
        }
        NodeImpl old = (NodeImpl)oldChild;
        if (old.getParentGID() != this.gid) {
            throw new DOMException(8, "node is not a child of this element");
        }
        int level = this.ownerDocument.getTreeLevel(this.gid);
        DocumentImpl prevDoc = new DocumentImpl(this.ownerDocument);
        long lastChild = this.lastChildID();
        this.removeAll(old, old.getPath());
        --this.children;
        this.ownerDocument.broker.endRemove();
        this.ownerDocument.broker.update(this);
        if (old.gid < lastChild) {
            this.ownerDocument.reindex = level + 1;
            this.ownerDocument.broker.reindex(prevDoc, this.ownerDocument, this);
        }
        return old;
    }

    private void removeAll(NodeImpl node, NodePath currentPath) {
        switch (node.getNodeType()) {
            case 1: {
                NodeList children = node.getChildNodes();
                for (int i = children.getLength() - 1; i > -1; --i) {
                    NodeImpl child = (NodeImpl)children.item(i);
                    if (child.nodeType == 1) {
                        currentPath.addComponent(((ElementImpl)child).getNodeName());
                        this.removeAll(child, currentPath);
                        currentPath.removeLastComponent();
                        continue;
                    }
                    this.removeAll(child, currentPath);
                }
                this.ownerDocument.broker.removeNode(node, currentPath);
                break;
            }
            default: {
                this.ownerDocument.broker.removeNode(node, currentPath);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAppendAttributes(NodeList removeList, NodeList appendList) {
        int level = this.ownerDocument.getTreeLevel(this.gid);
        DocumentImpl prevDoc = new DocumentImpl(this.ownerDocument);
        long lastChild = this.lastChildID();
        try {
            try {
                for (int i = 0; i < removeList.getLength(); ++i) {
                    Node oldChild = removeList.item(i);
                    if (!(oldChild instanceof NodeImpl)) {
                        throw new DOMException(4, "wrong node type");
                    }
                    NodeImpl old = (NodeImpl)oldChild;
                    if (old.getParentGID() != this.gid) {
                        throw new DOMException(8, "node is not a child of this element");
                    }
                    this.ownerDocument.broker.removeNode(old, old.getPath());
                    if (old.gid < lastChild) {
                        this.ownerDocument.reindex = level + 1;
                    }
                    --this.children;
                }
            }
            finally {
                this.ownerDocument.broker.endRemove();
            }
            if (this.children == 0) {
                this.appendChildren(this.firstChildID(), this, this.getPath(), appendList, true);
            } else {
                AttrImpl lastAttrib = this.getLastAttribute();
                if (lastAttrib != null && lastAttrib.gid == this.lastChildID()) {
                    this.appendChildren(this.lastChildID() + 1L, lastAttrib, this.getPath(), appendList, true);
                } else {
                    this.appendChildren(this.firstChildID() + 1L, this, this.getPath(), appendList, true);
                }
            }
            Object var12_11 = null;
            this.ownerDocument.broker.update(this);
            this.ownerDocument.broker.reindex(prevDoc, this.ownerDocument, null);
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            this.ownerDocument.broker.update(this);
            this.ownerDocument.broker.reindex(prevDoc, this.ownerDocument, null);
            throw throwable;
        }
    }

    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        if (!(oldChild instanceof NodeImpl)) {
            throw new DOMException(4, "wrong node type");
        }
        NodeImpl old = (NodeImpl)oldChild;
        if (old.getParentGID() != this.gid) {
            throw new DOMException(8, "node is not a child of this element");
        }
        DocumentImpl prevDoc = new DocumentImpl(this.ownerDocument);
        NodeImpl previous = (NodeImpl)old.getPreviousSibling();
        previous = previous == null ? this : this.getLastNode(previous);
        this.removeAll(old, old.getPath());
        this.ownerDocument.broker.endRemove();
        this.appendChild(old.gid, previous, this.getPath(), newChild, true);
        this.ownerDocument.broker.reindex(prevDoc, this.ownerDocument, null);
        try {
            this.ownerDocument.broker.saveCollection(this.ownerDocument.getCollection());
        }
        catch (PermissionDeniedException e) {
            throw new DOMException(15, e.getMessage());
        }
        return newChild;
    }

    private String escapeXml(Node child) {
        String str = ((Attr)child).getValue();
        StringBuffer buffer = null;
        String entity = null;
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            switch (ch) {
                case '\"': {
                    entity = "&quot;";
                    break;
                }
                case '<': {
                    entity = "&lt;";
                    break;
                }
                case '>': {
                    entity = "&gt;";
                    break;
                }
                case '\'': {
                    entity = "&apos;";
                    break;
                }
                default: {
                    entity = null;
                }
            }
            if (buffer == null) {
                if (entity == null) continue;
                buffer = new StringBuffer(str.length() + 20);
                buffer.append(str.substring(0, i));
                buffer.append(entity);
                continue;
            }
            if (entity == null) {
                buffer.append(ch);
                continue;
            }
            buffer.append(entity);
        }
        return buffer == null ? str : buffer.toString();
    }
}

