/*
 * Decompiled with CFR 0.152.
 */
package org.exist.dom;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.exist.dom.DocumentImpl;
import org.exist.storage.DBBroker;
import org.exist.util.Lock;
import org.exist.util.LockException;
import org.exist.util.hashtable.Int2ObjectHashMap;
import org.exist.xquery.XQueryContext;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DocumentSet
extends Int2ObjectHashMap
implements NodeList {
    public static final DocumentSet EMPTY_DOCUMENT_SET = new DocumentSet(9);
    private static final Logger LOG = Logger.getLogger((String)DocumentSet.class.getName());
    private ArrayList list = null;
    private TreeSet collections = new TreeSet();

    public DocumentSet() {
        super(29);
    }

    public DocumentSet(int initialSize) {
        super(initialSize);
    }

    public void clear() {
        super.clear();
        this.collections = new TreeSet();
        this.list = null;
    }

    public void add(DocumentImpl doc) {
        this.add(doc, true);
    }

    public void add(DocumentImpl doc, boolean checkDuplicates) {
        int docId = doc.getDocId();
        if (checkDuplicates && this.containsKey(docId)) {
            return;
        }
        this.put(docId, doc);
        if (this.list != null) {
            this.list.add(doc);
        }
        if (doc.getCollection() != null && !this.collections.contains(doc.getCollection())) {
            this.collections.add(doc.getCollection());
        }
    }

    public void add(Node node) {
        if (!(node instanceof DocumentImpl)) {
            throw new RuntimeException("wrong implementation");
        }
        this.add((DocumentImpl)node);
    }

    public void addAll(NodeList other) {
        for (int i = 0; i < other.getLength(); ++i) {
            this.add(other.item(i));
        }
    }

    public void addAll(DBBroker broker, Collection docs, boolean checkPermissions) {
        Iterator i = docs.iterator();
        while (i.hasNext()) {
            DocumentImpl doc = (DocumentImpl)i.next();
            if (broker != null && checkPermissions && !doc.getPermissions().validate(broker.getUser(), 4)) continue;
            this.put(doc.getDocId(), doc);
        }
    }

    public void addCollection(org.exist.collections.Collection collection) {
        this.collections.add(collection);
    }

    public Iterator iterator() {
        return this.valueIterator();
    }

    public Iterator getCollectionIterator() {
        return this.collections.iterator();
    }

    public int getLength() {
        return this.size();
    }

    public int getCollectionCount() {
        return this.collections.size();
    }

    public Node item(int pos) {
        if (this.list == null) {
            this.list = new ArrayList();
            Iterator i = this.valueIterator();
            while (i.hasNext()) {
                this.list.add(i.next());
            }
        }
        return (Node)this.list.get(pos);
    }

    public DocumentImpl getDoc(int docId) {
        return (DocumentImpl)this.get(docId);
    }

    public String[] getNames() {
        Object[] result = new String[this.size()];
        int j = 0;
        Iterator i = this.iterator();
        while (i.hasNext()) {
            DocumentImpl d = (DocumentImpl)i.next();
            result[j] = d.getFileName();
            ++j;
        }
        Arrays.sort(result);
        return result;
    }

    public DocumentSet intersection(DocumentSet other) {
        DocumentImpl d;
        DocumentSet r = new DocumentSet();
        Iterator i = this.iterator();
        while (i.hasNext()) {
            d = (DocumentImpl)i.next();
            if (!other.containsKey(d.docId)) continue;
            r.add(d);
        }
        i = other.iterator();
        while (i.hasNext()) {
            d = (DocumentImpl)i.next();
            if (!this.containsKey(d.docId) || r.containsKey(d.docId)) continue;
            r.add(d);
        }
        return r;
    }

    public DocumentSet union(DocumentSet other) {
        DocumentSet result = new DocumentSet();
        result.addAll(other);
        Iterator i = this.iterator();
        while (i.hasNext()) {
            DocumentImpl d = (DocumentImpl)i.next();
            if (result.containsKey(d.docId)) continue;
            result.add(d);
        }
        return result;
    }

    public boolean contains(DocumentSet other) {
        if (other.size() > this.size()) {
            return false;
        }
        boolean equal = false;
        Iterator i = other.iterator();
        while (i.hasNext()) {
            DocumentImpl d = (DocumentImpl)i.next();
            if (this.containsKey(d.docId)) {
                equal = true;
                continue;
            }
            equal = false;
        }
        return equal;
    }

    public boolean contains(int id) {
        return this.containsKey(id);
    }

    public int getMinDocId() {
        int min = -1;
        Iterator i = this.iterator();
        while (i.hasNext()) {
            DocumentImpl d = (DocumentImpl)i.next();
            if (min < 0) {
                min = d.getDocId();
                continue;
            }
            if (d.getDocId() >= min) continue;
            min = d.getDocId();
        }
        return min;
    }

    public int getMaxDocId() {
        int max = -1;
        Iterator i = this.iterator();
        while (i.hasNext()) {
            DocumentImpl d = (DocumentImpl)i.next();
            if (d.getDocId() <= max) continue;
            max = d.getDocId();
        }
        return max;
    }

    public boolean equals(Object other) {
        DocumentSet o = (DocumentSet)other;
        if (this.size() != o.size()) {
            return false;
        }
        return this.hasEqualKeys(o);
    }

    public void lock(XQueryContext context) throws LockException {
        this.lock(context.inExclusiveMode());
    }

    public void lock(boolean exclusive) throws LockException {
        for (int idx = 0; idx < this.tabSize; ++idx) {
            if (this.values[idx] == null || this.values[idx] == REMOVED) continue;
            DocumentImpl d = (DocumentImpl)this.values[idx];
            Lock dlock = d.getUpdateLock();
            if (exclusive) {
                dlock.acquire(1);
                continue;
            }
            dlock.acquire(0);
        }
    }

    public void unlock(XQueryContext context) {
        this.unlock(context.inExclusiveMode());
    }

    public void unlock(boolean exclusive) {
        for (int idx = 0; idx < this.tabSize; ++idx) {
            if (this.values[idx] == null || this.values[idx] == REMOVED) continue;
            DocumentImpl d = (DocumentImpl)this.values[idx];
            Lock dlock = d.getUpdateLock();
            if (exclusive) {
                dlock.release(1);
                continue;
            }
            dlock.release(0);
        }
    }
}

