/*
 * Decompiled with CFR 0.152.
 */
package org.exist.dom;

import java.util.Comparator;
import org.exist.dom.DocumentImpl;
import org.exist.dom.NodeProxy;
import org.exist.dom.XMLUtil;

public class DocumentOrderComparator
implements Comparator {
    public int compare(Object o1, Object o2) {
        int lb;
        NodeProxy p1 = (NodeProxy)o1;
        NodeProxy p2 = (NodeProxy)o2;
        DocumentImpl doc = p1.getDocument();
        if (doc.docId > p2.getDocument().docId) {
            return 1;
        }
        if (doc.docId < p2.getDocument().docId) {
            return -1;
        }
        if (p1.gid == p2.gid) {
            return 0;
        }
        int la = doc.getTreeLevel(p1.gid);
        if (la == (lb = doc.getTreeLevel(p2.gid))) {
            return p1.gid < p2.gid ? -1 : 1;
        }
        long pa = p1.gid;
        long pb = p2.gid;
        if (la > lb) {
            while (la > lb) {
                pa = XMLUtil.getParentId(doc, pa, la);
                --la;
            }
            if (pa == pb) {
                return 1;
            }
            return pa < pb ? -1 : 1;
        }
        while (lb > la) {
            pb = XMLUtil.getParentId(doc, pb, lb);
            --lb;
        }
        if (pb == pa) {
            return -1;
        }
        return pa < pb ? -1 : 1;
    }
}

