/*
 * Decompiled with CFR 0.152.
 */
package org.exist.dom;

import java.io.UnsupportedEncodingException;
import java.util.Set;
import org.exist.dom.CharacterDataImpl;
import org.exist.dom.NodeImpl;
import org.exist.dom.NodeObjectPool;
import org.w3c.dom.Comment;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class CommentImpl
extends CharacterDataImpl
implements Comment {
    public CommentImpl() {
        super((short)8);
    }

    public CommentImpl(long gid) {
        super((short)8, gid);
    }

    public CommentImpl(long gid, String data) {
        super((short)8, gid, data);
    }

    public CommentImpl(String data) {
        super((short)8, data);
    }

    public CommentImpl(char[] data, int start, int howmany) {
        super((short)8, data, start, howmany);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("<!-- ");
        buf.append((Object)this.cdata);
        buf.append(" -->");
        return buf.toString();
    }

    public void toSAX(ContentHandler contentHandler, LexicalHandler lexicalHandler, boolean first, Set namespaces) throws SAXException {
        if (lexicalHandler != null) {
            char[] data = this.cdata.toString().toCharArray();
            lexicalHandler.comment(data, 0, data.length);
        }
    }

    public byte[] serialize() {
        byte[] cd;
        try {
            cd = this.cdata.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            cd = this.cdata.toString().getBytes();
        }
        byte[] data = new byte[cd.length + 1];
        data[0] = 96;
        System.arraycopy(cd, 0, data, 1, cd.length);
        return data;
    }

    public static NodeImpl deserialize(byte[] data, int start, int len, boolean pooled) {
        String cdata;
        try {
            cdata = new String(data, start + 1, len - 1, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            cdata = new String(data, start + 1, len - 1);
        }
        CommentImpl comment = pooled ? (CommentImpl)NodeObjectPool.getInstance().borrowNode(CommentImpl.class) : new CommentImpl();
        comment.appendData(cdata);
        return comment;
    }
}

