/*
 * Decompiled with CFR 0.152.
 */
package org.exist.dom;

import java.io.EOFException;
import java.io.IOException;
import org.exist.collections.Collection;
import org.exist.dom.DocumentImpl;
import org.exist.security.Group;
import org.exist.security.SecurityManager;
import org.exist.security.User;
import org.exist.storage.DBBroker;
import org.exist.storage.io.VariableByteArrayInput;
import org.exist.storage.io.VariableByteInput;
import org.exist.storage.io.VariableByteOutputStream;

public class BinaryDocument
extends DocumentImpl {
    public static final byte DATA = -1;
    private long pageNr = -1L;
    private byte signature = (byte)-1;

    public BinaryDocument(DBBroker broker, Collection collection) {
        super(broker, collection);
    }

    public BinaryDocument(DBBroker broker, String docName, Collection collection) {
        super(broker, docName, collection);
    }

    public void setSignature(byte signature) {
        this.signature = signature;
    }

    public byte getResourceType() {
        return 1;
    }

    public void setPage(long page) {
        this.pageNr = page;
    }

    public long getPage() {
        return this.pageNr;
    }

    public void write(VariableByteOutputStream ostream) throws IOException {
        ostream.writeByte(this.getResourceType());
        ostream.writeInt(this.docId);
        ostream.writeUTF(this.fileName);
        ostream.writeLong(this.internalAddress);
        ostream.writeLong(this.pageNr);
        SecurityManager secman = this.broker.getBrokerPool().getSecurityManager();
        if (secman == null) {
            ostream.writeInt(1);
            ostream.writeInt(1);
        } else {
            User user = secman.getUser(this.permissions.getOwner());
            Group group = secman.getGroup(this.permissions.getOwnerGroup());
            ostream.writeInt(user.getUID());
            ostream.writeInt(group.getId());
        }
        ostream.writeByte((byte)this.permissions.getPermissions());
    }

    public void read(VariableByteInput istream) throws IOException, EOFException {
        this.docId = istream.readInt();
        this.fileName = istream.readUTF();
        this.internalAddress = istream.readLong();
        this.pageNr = istream.readLong();
        SecurityManager secman = this.broker.getBrokerPool().getSecurityManager();
        int uid = istream.readInt();
        int gid = istream.readInt();
        int perm = istream.readByte() & 0x1FF;
        if (secman == null) {
            this.permissions.setOwner("admin");
            this.permissions.setGroup("dba");
        } else {
            this.permissions.setOwner(secman.getUser(uid));
            this.permissions.setGroup(secman.getGroup(gid).getName());
        }
        this.permissions.setPermissions(perm);
    }

    public byte[] serialize() {
        VariableByteOutputStream ostream = new VariableByteOutputStream(17);
        try {
            ostream.writeLong(this.created);
            ostream.writeLong(this.lastModified);
            ostream.writeByte(this.signature);
            byte[] data = ostream.toByteArray();
            ostream.close();
            return data;
        }
        catch (IOException e) {
            LOG.warn((Object)"io error while writing document data", (Throwable)e);
            return null;
        }
    }

    public void deserialize(byte[] data) {
        VariableByteArrayInput istream = new VariableByteArrayInput(data);
        try {
            this.created = istream.readLong();
            this.lastModified = istream.readLong();
            this.signature = istream.readByte();
        }
        catch (IOException e) {
            LOG.warn((Object)"IO error while reading document metadata", (Throwable)e);
        }
    }
}

