/*
 * Decompiled with CFR 0.152.
 */
package org.exist.dom;

import java.io.UnsupportedEncodingException;
import java.util.Set;
import org.exist.dom.DocumentImpl;
import org.exist.dom.ElementImpl;
import org.exist.dom.NamedNode;
import org.exist.dom.NodeImpl;
import org.exist.dom.NodeObjectPool;
import org.exist.dom.QName;
import org.exist.storage.Signatures;
import org.exist.util.ByteArrayPool;
import org.exist.util.ByteConversion;
import org.exist.util.UTF8;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;

public class AttrImpl
extends NamedNode
implements Attr {
    public static final int CDATA = 0;
    public static final int ID = 1;
    protected int attributeType = 0;
    protected ElementImpl ownerElement = null;
    protected String value = null;

    public AttrImpl() {
        super((short)2);
    }

    public AttrImpl(long gid) {
        super((short)2, gid, null);
    }

    public AttrImpl(QName name, String value) {
        super((short)2, name);
        this.value = value;
    }

    public static NodeImpl deserialize(byte[] data, int start, int len, DocumentImpl doc, boolean pooled) {
        String value;
        int next = start;
        byte idSizeType = (byte)(data[next] & 3);
        boolean hasNamespace = (data[next] & 0x10) == 16;
        int attrType = (data[next] & 4) >> 2;
        short id = (short)Signatures.read(idSizeType, data, ++next);
        next += Signatures.getLength(idSizeType);
        String name = doc.getSymbols().getName(id);
        if (name == null) {
            throw new RuntimeException("no symbol for id " + id);
        }
        short nsId = 0;
        String prefix = null;
        if (hasNamespace) {
            nsId = ByteConversion.byteToShort(data, next);
            short prefixLen = ByteConversion.byteToShort(data, next += 2);
            next += 2;
            if (prefixLen > 0) {
                prefix = UTF8.decode(data, next, prefixLen).toString();
            }
            next += prefixLen;
        }
        String namespace = nsId == 0 ? "" : doc.getSymbols().getNamespace(nsId);
        try {
            value = new String(data, next, len - (next - start), "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            value = new String(data, next, len - (next - start));
        }
        AttrImpl attr = pooled ? (AttrImpl)NodeObjectPool.getInstance().borrowNode(AttrImpl.class) : new AttrImpl();
        attr.nodeName = doc.getSymbols().getQName(namespace, name, prefix);
        attr.value = value;
        attr.setType(attrType);
        return attr;
    }

    public String getName() {
        return this.nodeName.toString();
    }

    public int getType() {
        return this.attributeType;
    }

    public void setType(int type) {
        this.attributeType = type;
    }

    public String getNodeValue() {
        return this.value;
    }

    public Element getOwnerElement() {
        return (Element)this.ownerDocument.getNode(this.getParentGID());
    }

    public boolean getSpecified() {
        return true;
    }

    public String getValue() {
        return this.value;
    }

    public byte[] serialize() {
        if (this.nodeName.getLocalName() == null) {
            throw new RuntimeException("Local name is null");
        }
        short id = this.ownerDocument.getSymbols().getSymbol(this);
        byte idSizeType = Signatures.getSizeType(id);
        int prefixLen = 0;
        if (this.nodeName.needsNamespaceDecl()) {
            prefixLen = this.nodeName.getPrefix() != null && this.nodeName.getPrefix().length() > 0 ? UTF8.encoded(this.nodeName.getPrefix()) : 0;
        }
        byte[] data = ByteArrayPool.getByteArray(UTF8.encoded(this.value) + Signatures.getLength(idSizeType) + (this.nodeName.needsNamespaceDecl() ? prefixLen + 4 : 0) + 1);
        int pos = 0;
        data[pos] = -128;
        int n = pos;
        data[n] = (byte)(data[n] | idSizeType);
        int n2 = pos;
        data[n2] = (byte)(data[n2] | (byte)(this.attributeType << 2));
        if (this.nodeName.needsNamespaceDecl()) {
            int n3 = pos;
            data[n3] = (byte)(data[n3] | 0x10);
        }
        Signatures.write(idSizeType, id, data, ++pos);
        pos += Signatures.getLength(idSizeType);
        if (this.nodeName.needsNamespaceDecl()) {
            short nsId = this.ownerDocument.getSymbols().getNSSymbol(this.nodeName.getNamespaceURI());
            ByteConversion.shortToByte(nsId, data, pos);
            ByteConversion.shortToByte((short)prefixLen, data, pos += 2);
            pos += 2;
            if (this.nodeName.getPrefix() != null && this.nodeName.getPrefix().length() > 0) {
                UTF8.encode(this.nodeName.getPrefix(), data, pos);
            }
            pos += prefixLen;
        }
        UTF8.encode(this.value, data, pos);
        return data;
    }

    public void setValue(String value) throws DOMException {
        this.value = value;
    }

    public void toSAX(ContentHandler contentHandler, LexicalHandler lexicalHandler, boolean first, Set namespaces) throws SAXException {
        if (first) {
            AttributesImpl attribs = new AttributesImpl();
            attribs.addAttribute("http://exist.sourceforge.net/NS/exist", "id", "exist:id", "CDATA", Long.toString(this.gid));
            attribs.addAttribute("http://exist.sourceforge.net/NS/exist", "source", "exist:source", "CDATA", this.ownerDocument.getFileName());
            attribs.addAttribute(this.getNamespaceURI(), this.getLocalName(), this.getNodeName(), "CDATA", this.getValue());
            contentHandler.startElement("http://exist.sourceforge.net/NS/exist", "attribute", "exist:attribute", attribs);
            contentHandler.endElement("http://exist.sourceforge.net/NS/exist", "attribute", "exist:attribute");
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(' ');
        buf.append(this.nodeName);
        buf.append("=\"");
        buf.append(this.value);
        buf.append('\"');
        return buf.toString();
    }

    public String toString(boolean top) {
        if (top) {
            StringBuffer result = new StringBuffer();
            result.append("<exist:attribute ");
            result.append("xmlns:exist=\"http://exist.sourceforge.net/NS/exist\" ");
            result.append("exist:id=\"");
            result.append(this.gid);
            result.append("\" exist:source=\"");
            result.append(this.ownerDocument.getFileName());
            result.append("\" ");
            result.append(this.getNodeName());
            result.append("=\"");
            result.append(this.getValue());
            result.append("\"/>");
            return result.toString();
        }
        return this.toString();
    }

    public void clear() {
        super.clear();
        this.attributeType = 0;
    }
}

