/*
 * Decompiled with CFR 0.152.
 */
package org.exist.dom;

import java.util.Iterator;
import org.exist.dom.AbstractNodeSetBase;
import org.exist.dom.DocumentImpl;
import org.exist.dom.DocumentOrderComparator;
import org.exist.dom.DocumentSet;
import org.exist.dom.NodeImpl;
import org.exist.dom.NodeProxy;
import org.exist.dom.NodeSet;
import org.exist.dom.XMLUtil;
import org.exist.util.FastQSort;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.SequenceIterator;
import org.w3c.dom.Node;

public class ArraySet
extends AbstractNodeSetBase {
    protected int counter = 0;
    protected int length;
    protected NodeProxy[] nodes;
    protected boolean sorted = false;
    private DocumentOrderComparator docOrderComparator = new DocumentOrderComparator();

    public ArraySet(int initialCapacity) {
        this.nodes = new NodeProxy[initialCapacity];
        this.length = initialCapacity;
    }

    private static final boolean getParentSet(NodeProxy[] nl, int len) {
        boolean foundValid = false;
        for (int i = 0; i < len; ++i) {
            long pid;
            NodeProxy node = nl[i];
            if (node == null) continue;
            if (node.gid < 0L) {
                nl[i] = null;
                continue;
            }
            node.gid = pid = XMLUtil.getParentId(node);
            foundValid = true;
        }
        return foundValid;
    }

    private static final int search(NodeProxy[] items, int low, int high, NodeProxy cmpItem) {
        while (low <= high) {
            int mid = (low + high) / 2;
            int cmp = items[mid].compareTo(cmpItem);
            if (cmp == 0) {
                return mid;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            low = mid + 1;
        }
        return -1;
    }

    private static final int search(NodeProxy[] items, int low, int high, DocumentImpl cmpDoc, long gid) {
        while (low <= high) {
            int mid = (low + high) / 2;
            if (items[mid].getDocument().docId == cmpDoc.docId) {
                if (items[mid].gid == gid) {
                    return mid;
                }
                if (items[mid].gid > gid) {
                    high = mid - 1;
                    continue;
                }
                low = mid + 1;
                continue;
            }
            if (items[mid].getDocument().docId > cmpDoc.docId) {
                high = mid - 1;
                continue;
            }
            low = mid + 1;
        }
        return -1;
    }

    private static final NodeSet searchRange(NodeProxy[] items, int low, int high, NodeProxy lower, NodeProxy upper) {
        ArraySet result = new ArraySet(100);
        return ArraySet.searchRange(result, items, low, high, lower, upper);
    }

    private static final NodeSet searchRange(ArraySet result, NodeProxy[] items, int low, int high, NodeProxy lower, NodeProxy upper) {
        int cmp;
        int mid = 0;
        int max = high;
        while (low <= high && (cmp = items[mid = (low + high) / 2].compareTo(lower)) != 0) {
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            low = mid + 1;
        }
        while (mid > 0 && items[mid].compareTo(lower) > 0) {
            --mid;
        }
        if (items[mid].compareTo(lower) < 0) {
            ++mid;
        }
        while (mid <= max && items[mid].compareTo(upper) <= 0) {
            result.add(items[mid++]);
        }
        result.setIsSorted(true);
        return result;
    }

    public void add(NodeProxy proxy) {
        if (proxy == null) {
            return;
        }
        if (this.counter < this.length) {
            this.nodes[this.counter++] = proxy;
        } else {
            int grow = this.length < 10 ? 50 : this.length >> 1;
            NodeProxy[] temp = new NodeProxy[this.length + grow];
            System.arraycopy(this.nodes, 0, temp, 0, this.length);
            this.length += grow;
            this.nodes = temp;
            this.nodes[this.counter++] = proxy;
        }
        this.sorted = false;
    }

    public void addAll(NodeSet other) {
        Iterator i = other.iterator();
        while (i.hasNext()) {
            this.add((NodeProxy)i.next());
        }
    }

    public boolean hasIndex() {
        for (int i = 0; i < this.counter; ++i) {
            if (this.nodes[i].hasIndex()) continue;
            return false;
        }
        return true;
    }

    public boolean contains(DocumentImpl doc, long nodeId) {
        this.sort();
        NodeProxy p = new NodeProxy(doc, nodeId);
        return this.contains(p);
    }

    public boolean contains(NodeProxy proxy) {
        this.sort();
        return -1 < ArraySet.search(this.nodes, 0, this.counter - 1, proxy);
    }

    public NodeProxy get(DocumentImpl doc, long nodeId) {
        this.sort();
        int pos = ArraySet.search(this.nodes, 0, this.counter - 1, doc, nodeId);
        if (pos < 0) {
            return null;
        }
        return this.nodes[pos];
    }

    public NodeProxy get(NodeProxy p) {
        this.sort();
        int pos = ArraySet.search(this.nodes, 0, this.counter - 1, p);
        if (pos < 0) {
            return null;
        }
        return this.nodes[pos];
    }

    public NodeProxy get(int pos) {
        if (pos >= this.counter || pos < 0) {
            return null;
        }
        this.sort();
        return this.nodes[pos];
    }

    public Item itemAt(int pos) {
        return this.get(pos);
    }

    public NodeSet getChildrenX(NodeSet ancestors, int mode, boolean rememberContext) {
        if (!(ancestors instanceof ArraySet)) {
            return super.selectParentChild(ancestors, mode, rememberContext);
        }
        ArraySet al = (ArraySet)ancestors;
        if (al.counter == 0 || this.counter == 0) {
            return new ArraySet(1);
        }
        long start = System.currentTimeMillis();
        this.sort();
        al.sort();
        ArraySet result = new ArraySet(al.counter);
        NodeProxy[] dl = null;
        if (mode == 1) {
            dl = ArraySet.copyNodeSet(al, this);
            result.sorted = true;
        } else {
            dl = this.nodes;
        }
        int ax = 0;
        int dx = 0;
        int dlen = dl.length;
        ArraySet.getParentSet(dl, dlen);
        while (dx < dlen) {
            while (dl[dx] == null && ++dx < dlen) {
            }
            if (dx == dlen) break;
            int cmp = dl[dx].compareTo(al.nodes[ax]);
            if (cmp > 0) {
                if (ax >= al.counter - 1) break;
                ++ax;
                continue;
            }
            if (cmp < 0) {
                ++dx;
                continue;
            }
            switch (mode) {
                case 0: {
                    al.nodes[ax].addMatches(dl[dx]);
                    if (rememberContext) {
                        al.nodes[ax].addContextNode(dl[dx]);
                    } else {
                        al.nodes[ax].copyContext(dl[dx]);
                    }
                    result.add(al.nodes[ax]);
                    break;
                }
                case 1: {
                    this.nodes[dx].addMatches(al.nodes[ax]);
                    if (rememberContext) {
                        this.nodes[dx].addContextNode(al.nodes[ax]);
                    } else {
                        this.nodes[dx].copyContext(al.nodes[ax]);
                    }
                    result.add(this.nodes[dx]);
                }
            }
            ++dx;
        }
        LOG.debug((Object)("getChildren found " + result.getLength() + " in " + (System.currentTimeMillis() - start) + "ms."));
        return result;
    }

    public NodeSet selectAncestorDescendant(NodeSet other, int mode) {
        return this.selectAncestorDescendant(other, mode, false);
    }

    public NodeSet selectAncestorDescendant(NodeSet other, int mode, boolean includeSelf) {
        return this.selectAncestorDescendant(other, mode, includeSelf, false);
    }

    public NodeSet getDescendantsX(NodeSet other, int mode, boolean includeSelf, boolean rememberContext) {
        boolean more;
        if (!(other instanceof ArraySet)) {
            return super.selectAncestorDescendant(other, mode, includeSelf, rememberContext);
        }
        ArraySet al = (ArraySet)other;
        if (al.counter == 0 || this.counter == 0) {
            return NodeSet.EMPTY_SET;
        }
        long start = System.currentTimeMillis();
        al.sort();
        this.sort();
        NodeProxy[] dl = null;
        dl = mode == 1 ? ArraySet.copyNodeSet(al, this) : this.nodes;
        ArraySet result = new ArraySet(dl.length);
        int dlen = dl.length;
        boolean bl = more = includeSelf ? true : ArraySet.getParentSet(dl, dlen);
        while (more) {
            int ax = 0;
            int dx = 0;
            while (dx < dlen) {
                if (dl[dx] == null) {
                    ++dx;
                    continue;
                }
                int cmp = dl[dx].compareTo(al.nodes[ax]);
                if (cmp > 0) {
                    if (ax >= al.counter - 1) break;
                    ++ax;
                    continue;
                }
                if (cmp < 0) {
                    ++dx;
                    continue;
                }
                switch (mode) {
                    case 0: {
                        al.nodes[ax].addMatches(dl[dx]);
                        if (rememberContext) {
                            al.nodes[ax].addContextNode(this.nodes[dx]);
                        } else {
                            al.nodes[ax].copyContext(this.nodes[dx]);
                        }
                        result.add(al.nodes[ax]);
                        break;
                    }
                    case 1: {
                        this.nodes[dx].addMatches(al.nodes[ax]);
                        if (rememberContext) {
                            this.nodes[dx].addContextNode(al.nodes[ax]);
                        } else {
                            this.nodes[dx].copyContext(al.nodes[ax]);
                        }
                        result.add(this.nodes[dx]);
                    }
                }
                ++dx;
            }
            more = ArraySet.getParentSet(dl, dlen);
        }
        LOG.debug((Object)("getDescendants found " + result.getLength() + " in " + (System.currentTimeMillis() - start) + "ms."));
        return result;
    }

    public NodeSet selectAncestors(NodeSet other, boolean includeSelf, boolean rememberContext) {
        boolean more;
        if (!(other instanceof ArraySet)) {
            return super.selectAncestors(other, includeSelf, rememberContext);
        }
        ArraySet al = (ArraySet)other;
        if (al.counter == 0 || this.counter == 0) {
            return new ArraySet(1);
        }
        long start = System.currentTimeMillis();
        al.sort();
        this.sort();
        NodeProxy[] dl = ArraySet.copyNodeSet(al, this);
        ArraySet result = new ArraySet(this.getLength());
        int dlen = dl.length;
        boolean bl = more = includeSelf ? true : ArraySet.getParentSet(dl, dlen);
        while (more) {
            int ax = 0;
            int dx = 0;
            while (dx < dlen) {
                if (dl[dx] == null) {
                    System.out.println("skipping " + ++dx);
                    continue;
                }
                int cmp = dl[dx].compareTo(al.nodes[ax]);
                if (cmp > 0) {
                    if (ax >= al.counter - 1) break;
                    ++ax;
                    continue;
                }
                if (cmp < 0) {
                    ++dx;
                    continue;
                }
                NodeProxy temp = result.get(al.nodes[ax]);
                if (temp == null) {
                    al.nodes[ax].addMatches(this.nodes[dx]);
                    if (rememberContext) {
                        al.nodes[ax].addContextNode(this.nodes[dx]);
                    } else {
                        al.nodes[ax].copyContext(this.nodes[dx]);
                    }
                    result.add(al.nodes[ax]);
                } else if (rememberContext) {
                    temp.addContextNode(this.nodes[dx]);
                }
                ++dx;
            }
            more = ArraySet.getParentSet(dl, dlen);
        }
        LOG.debug((Object)("getAncestors found " + result.getLength() + " in " + (System.currentTimeMillis() - start) + "ms."));
        return result;
    }

    public int getLength() {
        return this.counter;
    }

    public NodeSet getRange(NodeProxy lower, NodeProxy upper) {
        this.sort();
        return ArraySet.searchRange(this.nodes, 0, this.counter - 1, lower, upper);
    }

    public NodeSet getRange(DocumentImpl doc, long lower, long upper) {
        return this.getRange(new NodeProxy(doc, lower), new NodeProxy(doc, upper));
    }

    protected boolean isSorted() {
        return this.sorted;
    }

    public Node item(int pos) {
        if (pos >= this.counter || pos < 0) {
            return null;
        }
        this.sort();
        NodeProxy p = this.nodes[pos];
        return p.getNode();
    }

    public Iterator iterator() {
        this.sort();
        return new ArraySetIterator();
    }

    public SequenceIterator iterate() {
        this.sortInDocumentOrder();
        return new ArraySequenceIterator();
    }

    public SequenceIterator unorderedIterator() {
        this.sort();
        return new ArraySequenceIterator();
    }

    public int position(NodeImpl test) {
        this.sort();
        NodeProxy p = new NodeProxy(test.ownerDocument, test.getGID());
        return ArraySet.search(this.nodes, 0, this.counter - 1, p);
    }

    public int position(NodeProxy proxy) {
        this.sort();
        return ArraySet.search(this.nodes, 0, this.counter - 1, proxy);
    }

    public void remove(NodeProxy node) {
        long start = System.currentTimeMillis();
        int pos = ArraySet.search(this.nodes, 0, this.counter - 1, node);
        if (pos < 0) {
            return;
        }
        NodeProxy[] temp = new NodeProxy[this.counter];
        System.arraycopy(this.nodes, 0, temp, 0, pos - 2);
        System.arraycopy(this.nodes, pos + 1, temp, pos + 1, temp.length - pos - 1);
        this.nodes = temp;
        --this.counter;
        LOG.debug((Object)("removal of node took " + (System.currentTimeMillis() - start)));
    }

    public DocumentSet getDocumentSet() {
        DocumentSet docs = new DocumentSet();
        DocumentImpl lastDoc = null;
        for (int i = 0; i < this.counter; ++i) {
            if (lastDoc == null || lastDoc.getDocId() != this.nodes[i].getDocument().getDocId()) {
                docs.add(this.nodes[i].getDocument(), false);
            }
            lastDoc = this.nodes[i].getDocument();
        }
        return docs;
    }

    public void setIsSorted(boolean sorted) {
    }

    public void sort() {
        if (this.sorted || this.counter < 2) {
            return;
        }
        FastQSort.sort(this.nodes, 0, this.counter - 1);
        this.removeDuplicateNodes();
        this.sorted = true;
    }

    public void sortInDocumentOrder() {
        if (this.counter < 2) {
            return;
        }
        FastQSort.sort(this.nodes, this.docOrderComparator, 0, this.counter - 1);
        this.removeDuplicateNodes();
        this.sorted = false;
    }

    private final void removeDuplicateNodes() {
        int j = 0;
        for (int i = 1; i < this.counter; ++i) {
            if (this.nodes[i].compareTo(this.nodes[j]) == 0 || i == ++j) continue;
            this.nodes[j] = this.nodes[i];
        }
        this.counter = ++j;
    }

    private static final NodeProxy[] copyNodeSet(ArraySet al, ArraySet dl) {
        int ax = 0;
        int dx = 0;
        int ad = al.nodes[ax].getDocument().docId;
        int dd = dl.nodes[dx].getDocument().docId;
        int alen = al.counter - 1;
        int dlen = dl.counter - 1;
        NodeProxy[] ol = new NodeProxy[dl.counter];
        while (true) {
            if (ad < dd) {
                if (ax >= alen) break;
                ad = al.nodes[++ax].getDocument().docId;
                continue;
            }
            if (ad > dd) {
                if (dx >= dlen) break;
                ol[dx] = null;
                dd = dl.nodes[++dx].getDocument().docId;
                continue;
            }
            ol[dx] = new NodeProxy(dl.nodes[dx]);
            if (dx >= dlen) break;
            dd = dl.nodes[++dx].getDocument().docId;
        }
        return ol;
    }

    private static final void trimNodeSet(ArraySet al, ArraySet dl) {
        int ax = 0;
        int dx = 0;
        int ad = al.nodes[ax].getDocument().docId;
        int dd = dl.nodes[dx].getDocument().docId;
        int count = 0;
        int alen = al.counter - 1;
        int dlen = dl.counter - 1;
        while (true) {
            if (ad < dd) {
                if (ax >= alen) break;
                ad = al.nodes[++ax].getDocument().docId;
                continue;
            }
            if (ad > dd) {
                if (dx >= dlen) break;
                dd = dl.nodes[++dx].getDocument().docId;
                continue;
            }
            if (dx >= dlen) break;
            ++count;
            dd = dl.nodes[++dx].getDocument().docId;
        }
        System.out.println("dl = " + dlen + "; copy = " + count);
    }

    public int compare(int a, int b) {
        NodeProxy anode = this.nodes[a];
        NodeProxy bnode = this.nodes[b];
        if (anode.getDocument().docId == bnode.getDocument().docId) {
            return anode.gid == bnode.gid ? 0 : (anode.gid < bnode.gid ? -1 : 1);
        }
        return anode.getDocument().docId < bnode.getDocument().docId ? -1 : 1;
    }

    public void swap(int a, int b) {
        NodeProxy t = this.nodes[a];
        this.nodes[a] = this.nodes[b];
        this.nodes[b] = this.nodes[a];
    }

    public Comparable[] array() {
        return this.nodes;
    }

    private class ArraySequenceIterator
    implements SequenceIterator {
        private int pos = 0;

        private ArraySequenceIterator() {
        }

        public boolean hasNext() {
            return this.pos < ArraySet.this.counter;
        }

        public Item nextItem() {
            return this.pos < ArraySet.this.counter ? ArraySet.this.nodes[this.pos++] : null;
        }
    }

    private class ArraySetIterator
    implements Iterator {
        private int pos = 0;

        private ArraySetIterator() {
        }

        public boolean hasNext() {
            return this.pos < ArraySet.this.counter;
        }

        public Object next() {
            return this.hasNext() ? ArraySet.this.nodes[this.pos++] : null;
        }

        public void remove() {
        }
    }
}

