/*
 * Decompiled with CFR 0.152.
 */
package org.exist.dom;

import java.util.Iterator;
import org.exist.dom.AVLTreeNodeSet;
import org.exist.dom.ArraySet;
import org.exist.dom.ContextItem;
import org.exist.dom.DocumentImpl;
import org.exist.dom.DocumentSet;
import org.exist.dom.ExtArrayNodeSet;
import org.exist.dom.NodeProxy;
import org.exist.dom.NodeSet;
import org.exist.dom.VirtualNodeSet;
import org.exist.dom.XMLUtil;
import org.exist.util.Range;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.AbstractSequence;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.Type;
import org.w3c.dom.Node;

public abstract class AbstractNodeSet
extends AbstractSequence
implements NodeSet {
    protected AbstractNodeSet() {
    }

    public abstract Iterator iterator();

    public abstract SequenceIterator iterate();

    public abstract SequenceIterator unorderedIterator();

    public int getItemType() {
        return -1;
    }

    public abstract boolean contains(DocumentImpl var1, long var2);

    public abstract boolean contains(NodeProxy var1);

    public boolean containsDoc(DocumentImpl doc) {
        return true;
    }

    public abstract void add(NodeProxy var1);

    public void add(NodeProxy proxy, int sizeHint) {
        this.add(proxy);
    }

    public void add(Item item) throws XPathException {
        if (!Type.subTypeOf(item.getType(), -1)) {
            throw new XPathException("item has wrong type");
        }
        this.add((NodeProxy)item);
    }

    public void addAll(Sequence other) throws XPathException {
        if (!Type.subTypeOf(other.getItemType(), -1)) {
            throw new XPathException("sequence argument is not a node sequence");
        }
        SequenceIterator i = other.iterate();
        while (i.hasNext()) {
            this.add(i.nextItem());
        }
    }

    public abstract void addAll(NodeSet var1);

    public void remove(NodeProxy node) {
        throw new RuntimeException("remove not implemented for class " + this.getClass().getName());
    }

    public abstract int getLength();

    public void removeDuplicates() {
    }

    public abstract Node item(int var1);

    public abstract NodeProxy get(int var1);

    public abstract NodeProxy get(NodeProxy var1);

    public abstract NodeProxy get(DocumentImpl var1, long var2);

    public DocumentSet getDocumentSet() {
        DocumentSet ds = new DocumentSet();
        Iterator i = this.iterator();
        while (i.hasNext()) {
            NodeProxy p = (NodeProxy)i.next();
            ds.add(p.getDocument());
        }
        return ds;
    }

    public NodeSet hasChildrenInSet(NodeProxy parent, int mode, boolean rememberContext) {
        Range range = XMLUtil.getChildRange(parent.getDocument(), parent.gid);
        return this.getRange(parent.getDocument(), range.getStart(), range.getEnd());
    }

    public NodeSet selectParentChild(NodeSet al, int mode) {
        return this.selectParentChild(al, mode, false);
    }

    public NodeSet selectParentChild(NodeSet al, int mode, boolean rememberContext) {
        if (!(al instanceof VirtualNodeSet)) {
            if (al.getLength() == 1) {
                return this.hasChildrenInSet(al.get(0), mode, rememberContext);
            }
            return this.quickSelectParentChild(al, mode, rememberContext);
        }
        ExtArrayNodeSet result = new ExtArrayNodeSet();
        DocumentImpl lastDoc = null;
        int sizeHint = -1;
        switch (mode) {
            case 1: {
                Iterator i = this.iterator();
                while (i.hasNext()) {
                    NodeProxy p;
                    NodeProxy n = (NodeProxy)i.next();
                    if (lastDoc == null || n.getDocument() != lastDoc) {
                        lastDoc = n.getDocument();
                        sizeHint = this.getSizeHint(lastDoc);
                    }
                    if ((p = al.parentWithChild(n, true, false, -1)) == null) continue;
                    if (rememberContext) {
                        n.addContextNode(p);
                    } else {
                        n.copyContext(p);
                    }
                    result.add(n, sizeHint);
                }
                break;
            }
            case 0: {
                Iterator i = this.iterator();
                while (i.hasNext()) {
                    NodeProxy p;
                    NodeProxy n = (NodeProxy)i.next();
                    if (lastDoc == null || n.getDocument() != lastDoc) {
                        lastDoc = n.getDocument();
                        sizeHint = al.getSizeHint(lastDoc);
                    }
                    if ((p = al.parentWithChild(n, true, false, -1)) == null) continue;
                    if (rememberContext) {
                        p.addContextNode(n);
                    } else {
                        p.copyContext(n);
                    }
                    result.add(p, sizeHint);
                }
                break;
            }
        }
        result.sort();
        return result;
    }

    public NodeSet selectAncestorDescendant(NodeSet al, int mode) {
        return this.selectAncestorDescendant(al, mode, false);
    }

    public NodeSet selectAncestorDescendant(NodeSet al, int mode, boolean includeSelf) {
        return this.selectAncestorDescendant(al, mode, includeSelf, false);
    }

    public NodeSet selectAncestorDescendant(NodeSet al, int mode, boolean includeSelf, boolean rememberContext) {
        DocumentImpl lastDoc = null;
        int sizeHint = -1;
        ExtArrayNodeSet result = new ExtArrayNodeSet();
        switch (mode) {
            case 1: {
                Iterator i = this.iterator();
                while (i.hasNext()) {
                    NodeProxy p;
                    NodeProxy n = (NodeProxy)i.next();
                    if (lastDoc == null || n.getDocument() != lastDoc) {
                        lastDoc = n.getDocument();
                        sizeHint = this.getSizeHint(lastDoc);
                    }
                    if ((p = al.parentWithChild(n.getDocument(), n.gid, false, includeSelf, -1)) == null) continue;
                    if (rememberContext) {
                        n.addContextNode(p);
                    } else {
                        n.copyContext(p);
                    }
                    result.add(n, sizeHint);
                }
                break;
            }
            case 0: {
                Iterator i = this.iterator();
                while (i.hasNext()) {
                    NodeProxy p;
                    NodeProxy n = (NodeProxy)i.next();
                    if (lastDoc == null || n.getDocument() != lastDoc) {
                        lastDoc = n.getDocument();
                        sizeHint = al.getSizeHint(lastDoc);
                    }
                    if ((p = al.parentWithChild(n.getDocument(), n.gid, false, includeSelf, -1)) == null) continue;
                    if (rememberContext) {
                        p.addContextNode(n);
                    } else {
                        p.copyContext(n);
                    }
                    result.add(p, sizeHint);
                }
                break;
            }
        }
        return result;
    }

    private NodeSet quickSelectParentChild(NodeSet al, int mode, boolean rememberContext) {
        ExtArrayNodeSet result = new ExtArrayNodeSet();
        Iterator ia = al.iterator();
        Iterator ib = this.iterator();
        NodeProxy na = (NodeProxy)ia.next();
        NodeProxy nb = (NodeProxy)ib.next();
        if (na == null || nb == null) {
            return result;
        }
        while (true) {
            if (na.getDocument().getDocId() < nb.getDocument().getDocId()) {
                if (!ia.hasNext()) break;
                na = (NodeProxy)ia.next();
                continue;
            }
            if (na.getDocument().getDocId() > nb.getDocument().getDocId()) {
                if (!ib.hasNext()) break;
                nb = (NodeProxy)ib.next();
                continue;
            }
            long pa = na.gid;
            long pb = nb.gid;
            pb = XMLUtil.getParentId(nb.getDocument(), pb, nb.getDocument().getTreeLevel(pb));
            if (pa == pb) {
                if (mode == 1) {
                    if (rememberContext) {
                        nb.addContextNode(na);
                    } else {
                        nb.copyContext(na);
                    }
                    result.add(nb);
                } else {
                    if (rememberContext) {
                        na.addContextNode(nb);
                    } else {
                        na.copyContext(nb);
                    }
                    result.add(na);
                }
                if (!ib.hasNext()) break;
                nb = (NodeProxy)ib.next();
                continue;
            }
            if (pa < pb) {
                if (!ia.hasNext()) break;
                na = (NodeProxy)ia.next();
                continue;
            }
            if (!ib.hasNext()) break;
            nb = (NodeProxy)ib.next();
        }
        return result;
    }

    public NodeSet selectAncestors(NodeSet dl, boolean includeSelf, boolean rememberContext) {
        ExtArrayNodeSet result = new ExtArrayNodeSet();
        Iterator i = dl.iterator();
        while (i.hasNext()) {
            NodeProxy n = (NodeProxy)i.next();
            NodeSet ancestors = this.ancestorsForChild(n.getDocument(), n.gid, false, includeSelf, -1);
            Iterator j = ancestors.iterator();
            while (j.hasNext()) {
                NodeProxy p = (NodeProxy)j.next();
                if (p == null) continue;
                NodeProxy temp = result.get(p);
                if (temp == null) {
                    if (rememberContext) {
                        p.addContextNode(n);
                    } else {
                        p.copyContext(n);
                    }
                    result.add(p);
                    continue;
                }
                if (!rememberContext) continue;
                temp.addContextNode(n);
            }
        }
        return result;
    }

    public NodeSet selectFollowing(NodeSet following) throws XPathException {
        if (following.getLength() == 0 || this.getLength() == 0) {
            return EMPTY_SET;
        }
        ExtArrayNodeSet result = new ExtArrayNodeSet();
        Iterator ia = this.iterator();
        Iterator ib = following.iterator();
        NodeProxy na = (NodeProxy)ia.next();
        NodeProxy nb = (NodeProxy)ib.next();
        while (true) {
            if (na.getDocument().getDocId() < nb.getDocument().getDocId()) {
                if (!ia.hasNext()) break;
                na = (NodeProxy)ia.next();
                continue;
            }
            if (na.getDocument().getDocId() > nb.getDocument().getDocId()) {
                if (!ib.hasNext()) break;
                nb = (NodeProxy)ib.next();
                continue;
            }
            if (nb.after(na, false)) {
                nb.addContextNode(na);
                result.add(nb);
                continue;
            }
            if (!ib.hasNext()) break;
            nb = (NodeProxy)ib.next();
        }
        return result;
    }

    public NodeSet selectSiblings(NodeSet siblings, int mode) {
        if (siblings.getLength() == 0 || this.getLength() == 0) {
            return EMPTY_SET;
        }
        ExtArrayNodeSet result = new ExtArrayNodeSet();
        Iterator ia = siblings.iterator();
        Iterator ib = this.iterator();
        NodeProxy na = (NodeProxy)ia.next();
        NodeProxy nb = (NodeProxy)ib.next();
        while (true) {
            long pb;
            if (na.getDocument().getDocId() < nb.getDocument().getDocId()) {
                if (!ia.hasNext()) break;
                na = (NodeProxy)ia.next();
                continue;
            }
            if (na.getDocument().getDocId() > nb.getDocument().getDocId()) {
                if (!ib.hasNext()) break;
                nb = (NodeProxy)ib.next();
                continue;
            }
            long pa = XMLUtil.getParentId(na.getDocument(), na.gid);
            if (pa < (pb = XMLUtil.getParentId(nb.getDocument(), nb.gid))) {
                if (!ia.hasNext()) break;
                na = (NodeProxy)ia.next();
                continue;
            }
            if (pa > pb) {
                if (!ib.hasNext()) break;
                nb = (NodeProxy)ib.next();
                continue;
            }
            if (nb.gid < na.gid) {
                if (mode == 2) {
                    nb.addContextNode(na);
                    result.add(nb);
                }
                if (!ib.hasNext()) break;
                nb = (NodeProxy)ib.next();
                continue;
            }
            if (nb.gid > na.gid) {
                if (mode == 3) {
                    nb.addContextNode(na);
                    result.add(nb);
                }
                if (!ib.hasNext()) break;
                nb = (NodeProxy)ib.next();
                continue;
            }
            if (!ib.hasNext()) break;
            nb = (NodeProxy)ib.next();
        }
        return result;
    }

    public NodeSet getSiblings(DocumentImpl doc, long gid) {
        int level = doc.getTreeLevel(gid);
        long pid = (gid - doc.getLevelStartPoint(level)) / (long)doc.getTreeLevelOrder(level) + doc.getLevelStartPoint(level - 1);
        long f_gid = (pid - doc.getLevelStartPoint(level - 1)) * (long)doc.getTreeLevelOrder(level) + doc.getLevelStartPoint(level);
        long e_gid = f_gid + (long)doc.getTreeLevelOrder(level);
        NodeSet set = this.getRange(doc, f_gid, e_gid);
        return set;
    }

    public NodeProxy parentWithChild(DocumentImpl doc, long gid, boolean directParent) {
        return this.parentWithChild(doc, gid, directParent, false, -1);
    }

    public NodeProxy parentWithChild(DocumentImpl doc, long gid, boolean directParent, boolean includeSelf) {
        return this.parentWithChild(doc, gid, directParent, includeSelf, -1);
    }

    public NodeProxy parentWithChild(DocumentImpl doc, long gid, boolean directParent, boolean includeSelf, int level) {
        NodeProxy temp;
        if (includeSelf && (temp = this.get(doc, gid)) != null) {
            return temp;
        }
        if (level < 0) {
            level = doc.getTreeLevel(gid);
        }
        while (gid > 0L) {
            temp = this.get(doc, gid = XMLUtil.getParentId(doc, gid, level));
            if (temp != null) {
                return temp;
            }
            if (directParent) {
                return null;
            }
            --level;
        }
        return null;
    }

    public NodeProxy parentWithChild(NodeProxy proxy, boolean directParent, boolean includeSelf, int level) {
        return this.parentWithChild(proxy.getDocument(), proxy.gid, directParent, includeSelf, level);
    }

    public NodeSet ancestorsForChild(DocumentImpl doc, long gid, boolean directParent, boolean includeSelf, int level) {
        NodeProxy temp;
        ArraySet result = new ArraySet(5);
        if (includeSelf && (temp = this.get(doc, gid)) != null) {
            result.add(temp);
        }
        if (level < 0) {
            level = doc.getTreeLevel(gid);
        }
        while (gid > 0L) {
            temp = this.get(doc, gid = XMLUtil.getParentId(doc, gid, level));
            if (temp != null) {
                result.add(temp);
            } else if (directParent) {
                return result;
            }
            --level;
        }
        return result;
    }

    public NodeSet getParents(boolean rememberContext) {
        ExtArrayNodeSet parents = new ExtArrayNodeSet();
        Iterator i = this.iterator();
        while (i.hasNext()) {
            NodeProxy p = (NodeProxy)i.next();
            long pid = XMLUtil.getParentId(p.getDocument(), p.gid);
            if (pid <= -1L) continue;
            NodeProxy parent = new NodeProxy(p.getDocument(), pid, 1);
            if (rememberContext) {
                parent.addContextNode(p);
            } else {
                parent.copyContext(p);
            }
            parents.add(parent);
        }
        return parents;
    }

    public NodeSet getRange(DocumentImpl doc, long lower, long upper) {
        throw new RuntimeException("getRange is not valid for class " + this.getClass().getName());
    }

    public int getSizeHint(DocumentImpl doc) {
        return -1;
    }

    public NodeSet intersection(NodeSet other) {
        NodeProxy l;
        AVLTreeNodeSet r = new AVLTreeNodeSet();
        Iterator i = this.iterator();
        while (i.hasNext()) {
            l = (NodeProxy)i.next();
            if (!other.contains(l)) continue;
            r.add(l);
        }
        i = other.iterator();
        while (i.hasNext()) {
            l = (NodeProxy)i.next();
            if (!this.contains(l)) continue;
            NodeProxy p = r.get(l);
            if (p != null) {
                p.addMatches(l);
                continue;
            }
            r.add(l);
        }
        return r;
    }

    public NodeSet deepIntersection(NodeSet other) {
        NodeProxy p;
        NodeProxy l;
        AVLTreeNodeSet r = new AVLTreeNodeSet();
        Iterator i = this.iterator();
        while (i.hasNext()) {
            l = (NodeProxy)i.next();
            p = other.parentWithChild(l, false, true, -1);
            if (p == null) continue;
            if (p.gid != l.gid) {
                p.addMatches(l);
            }
            r.add(p);
        }
        i = other.iterator();
        while (i.hasNext()) {
            l = (NodeProxy)i.next();
            NodeProxy q = this.parentWithChild(l, false, true, -1);
            if (q == null) continue;
            p = r.get(q);
            if (p != null) {
                p.addMatches(l);
                continue;
            }
            r.add(l);
        }
        return r;
    }

    public NodeSet except(NodeSet other) {
        AVLTreeNodeSet r = new AVLTreeNodeSet();
        Iterator i = this.iterator();
        while (i.hasNext()) {
            NodeProxy l = (NodeProxy)i.next();
            if (other.contains(l)) continue;
            r.add(l);
        }
        return r;
    }

    public NodeSet union(NodeSet other) {
        ArraySet result = new ArraySet(this.getLength() + other.getLength());
        result.addAll(other);
        Iterator i = this.iterator();
        while (i.hasNext()) {
            NodeProxy p = (NodeProxy)i.next();
            if (other.contains(p)) {
                NodeProxy c = other.get(p);
                if (c == null) continue;
                c.addMatches(p);
                continue;
            }
            result.add(p);
        }
        return result;
    }

    public NodeSet getContextNodes(NodeSet contextNodes, boolean rememberContext) {
        ArraySet result = new ArraySet(this.getLength());
        Iterator i = this.iterator();
        while (i.hasNext()) {
            NodeProxy current = (NodeProxy)i.next();
            for (ContextItem contextNode = current.getContext(); contextNode != null; contextNode = contextNode.getNextItem()) {
                NodeProxy item = contextNode.getNode();
                NodeProxy context = contextNodes.get(item);
                if (context == null) continue;
                if (!result.contains(context)) {
                    if (rememberContext) {
                        context.addContextNode(context);
                    }
                    result.add(context);
                }
                context.addMatches(current);
            }
        }
        return result;
    }

    public NodeSet getContextNodes(boolean rememberContext) {
        ExtArrayNodeSet result = new ExtArrayNodeSet();
        DocumentImpl lastDoc = null;
        Iterator i = this.iterator();
        while (i.hasNext()) {
            NodeProxy current = (NodeProxy)i.next();
            for (ContextItem contextNode = current.getContext(); contextNode != null; contextNode = contextNode.getNextItem()) {
                NodeProxy context = contextNode.getNode();
                context.addMatches(current);
                if (result.contains(context)) continue;
                if (rememberContext) {
                    context.addContextNode(context);
                }
                if (lastDoc != null && lastDoc.getDocId() != context.getDocument().getDocId()) {
                    lastDoc = context.getDocument();
                    result.add(context, this.getSizeHint(lastDoc));
                    continue;
                }
                result.add(context);
            }
        }
        return result;
    }

    public NodeSet toNodeSet() throws XPathException {
        return this;
    }

    public int getState() {
        return 1;
    }

    public boolean hasChanged(int previousState) {
        return false;
    }

    public String pprint() {
        StringBuffer buf = new StringBuffer();
        buf.append('[');
        buf.append(this.getClass().getName());
        buf.append(' ');
        Iterator i = this.iterator();
        while (i.hasNext()) {
            NodeProxy p = (NodeProxy)i.next();
            buf.append(p.pprint());
            buf.append(' ');
        }
        buf.append(']');
        return buf.toString();
    }
}

