/*
 * Decompiled with CFR 0.152.
 */
package org.exist.collections;

import org.exist.collections.Collection;
import org.exist.storage.cache.Cacheable;
import org.exist.storage.cache.LRDCache;
import org.exist.util.Lock;
import org.exist.util.hashtable.Object2LongHashMap;

public class CollectionCache
extends LRDCache {
    private Object2LongHashMap names;

    public CollectionCache(int blockBuffers) {
        super(blockBuffers);
        this.names = new Object2LongHashMap(blockBuffers);
    }

    public void add(Collection collection) {
        this.add(collection, 1);
    }

    public void add(Collection collection, int initialRefCount) {
        super.add(collection, initialRefCount);
        this.names.put(collection.getName(), collection.getKey());
    }

    public Collection get(Collection collection) {
        return (Collection)this.get(collection.getKey());
    }

    public Collection get(String name) {
        long key = this.names.get(name);
        if (key < 0L) {
            return null;
        }
        return (Collection)this.get(key);
    }

    protected Cacheable removeOne(Cacheable item) {
        Collection old;
        double rd = 0.0;
        double minRd = -1.0;
        int bucket = -1;
        for (int i = 0; i < this.items.length; ++i) {
            old = (Collection)this.items[i];
            if (old == null) {
                bucket = i;
                break;
            }
            Lock lock = old.getLock();
            rd = (double)old.getReferenceCount() / (double)(this.totalReferences - old.getTimestamp());
            if (!lock.attempt(0)) continue;
            if ((minRd < 0.0 || rd < minRd) && old.allowUnload()) {
                minRd = rd;
                bucket = i;
            }
            lock.release();
        }
        if ((old = (Collection)this.items[bucket]) != null) {
            this.map.remove(old.getKey());
            this.names.remove(old.getName());
            old.sync();
        }
        this.items[bucket] = item;
        this.map.put(item.getKey(), item);
        return old;
    }

    public void remove(Cacheable item) {
        super.remove(item);
        this.names.remove(((Collection)item).getName());
    }
}

