/*
 * Decompiled with CFR 0.152.
 */
package org.exist.client;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.exist.storage.ElementIndex;
import org.exist.storage.TextSearchEngine;
import org.exist.util.ProgressIndicator;

class UploadDialog
extends JFrame {
    JTextField currentFile;
    JTextField currentDir;
    JLabel currentSize;
    JTextArea messages;
    JProgressBar progress;
    JProgressBar byDirProgress;

    public UploadDialog() {
        super("Storing files ...");
        GridBagLayout grid = new GridBagLayout();
        this.getContentPane().setLayout(grid);
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(5, 5, 5, 5);
        JLabel label = new JLabel("Stored:");
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.fill = 0;
        grid.setConstraints(label, c);
        this.getContentPane().add(label);
        this.byDirProgress = new JProgressBar();
        this.byDirProgress.setStringPainted(true);
        this.byDirProgress.setString("Calculating file sizes ...");
        this.byDirProgress.setIndeterminate(true);
        c.gridx = 1;
        c.gridy = 0;
        c.anchor = 13;
        c.fill = 2;
        grid.setConstraints(this.byDirProgress, c);
        this.getContentPane().add(this.byDirProgress);
        label = new JLabel("Directory:");
        c.gridx = 0;
        c.gridy = 1;
        c.anchor = 17;
        c.fill = 0;
        grid.setConstraints(label, c);
        this.getContentPane().add(label);
        this.currentDir = new JTextField(30);
        this.currentDir.setEditable(false);
        c.gridx = 1;
        c.gridy = 1;
        c.anchor = 13;
        c.fill = 2;
        grid.setConstraints(this.currentDir, c);
        this.getContentPane().add(this.currentDir);
        label = new JLabel("Uploading file:");
        c.gridx = 0;
        c.gridy = 2;
        c.anchor = 17;
        c.fill = 0;
        grid.setConstraints(label, c);
        this.getContentPane().add(label);
        this.currentFile = new JTextField(30);
        this.currentFile.setEditable(false);
        c.gridx = 1;
        c.gridy = 2;
        c.anchor = 13;
        c.fill = 2;
        grid.setConstraints(this.currentFile, c);
        this.getContentPane().add(this.currentFile);
        label = new JLabel("Size:");
        c.gridx = 0;
        c.gridy = 3;
        c.anchor = 17;
        c.fill = 0;
        grid.setConstraints(label, c);
        this.getContentPane().add(label);
        this.currentSize = new JLabel("0K");
        c.gridx = 1;
        c.gridy = 3;
        c.anchor = 13;
        c.fill = 2;
        grid.setConstraints(this.currentSize, c);
        this.getContentPane().add(this.currentSize);
        JLabel status = new JLabel("Progress:");
        c.gridx = 0;
        c.gridy = 4;
        c.anchor = 17;
        c.fill = 0;
        grid.setConstraints(status, c);
        this.getContentPane().add(status);
        this.progress = new JProgressBar();
        this.progress.setIndeterminate(true);
        this.progress.setStringPainted(true);
        c.gridx = 1;
        c.gridy = 4;
        c.anchor = 13;
        c.fill = 2;
        grid.setConstraints(this.progress, c);
        this.getContentPane().add(this.progress);
        this.messages = new JTextArea(5, 50);
        this.messages.setEditable(false);
        this.messages.setLineWrap(true);
        JScrollPane scroll = new JScrollPane(this.messages, 22, 30);
        scroll.setBorder(BorderFactory.createTitledBorder("Messages"));
        c.gridx = 0;
        c.gridy = 5;
        c.gridwidth = 2;
        c.anchor = 17;
        c.fill = 2;
        grid.setConstraints(scroll, c);
        this.getContentPane().add(scroll);
        this.pack();
    }

    public Observer getObserver() {
        return new UploadProgressObserver();
    }

    public void setCurrent(String label) {
        this.currentFile.setText(label);
    }

    public void setCurrentDir(String dir) {
        this.currentDir.setText(dir);
    }

    public void setCurrentSize(long size) {
        if (size >= 1024L) {
            this.currentSize.setText(String.valueOf(size / 1024L) + "K");
        } else {
            this.currentSize.setText(String.valueOf(size));
        }
    }

    public void setTotalSize(long size) {
        this.byDirProgress.setIndeterminate(false);
        this.byDirProgress.setString(null);
        this.byDirProgress.setMinimum(0);
        this.byDirProgress.setValue(0);
        this.byDirProgress.setMaximum((int)(size / 1024L));
    }

    public void setStoredSize(long count) {
        this.byDirProgress.setValue((int)(count / 1024L));
    }

    public void showMessage(String msg) {
        this.messages.append(msg + "\n");
        this.messages.setCaretPosition(this.messages.getDocument().getLength());
    }

    public void reset() {
        this.progress.setString("Storing ...");
        this.progress.setIndeterminate(true);
    }

    class UploadProgressObserver
    implements Observer {
        int mode = 0;

        UploadProgressObserver() {
        }

        public void update(Observable o, Object arg) {
            UploadDialog.this.progress.setIndeterminate(false);
            ProgressIndicator ind = (ProgressIndicator)arg;
            UploadDialog.this.progress.setValue(ind.getPercentage());
            if (o instanceof TextSearchEngine) {
                UploadDialog.this.progress.setString("Storing words");
            } else if (o instanceof ElementIndex) {
                UploadDialog.this.progress.setString("Storing elements");
            } else {
                UploadDialog.this.progress.setString("Storing nodes");
            }
        }
    }
}

