/*
 * Decompiled with CFR 0.152.
 */
package org.exist.client;

import java.awt.Cursor;
import java.awt.Dimension;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PushbackInputStream;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Properties;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.avalon.excalibur.cli.CLArgsParser;
import org.apache.avalon.excalibur.cli.CLOption;
import org.apache.avalon.excalibur.cli.CLOptionDescriptor;
import org.apache.avalon.excalibur.cli.CLUtil;
import org.apache.oro.io.GlobFilenameFilter;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.exist.client.ClientFrame;
import org.exist.client.DocumentView;
import org.exist.client.QueryDialog;
import org.exist.client.UploadDialog;
import org.exist.dom.XMLUtil;
import org.exist.schema.SchemaService;
import org.exist.security.Permission;
import org.exist.security.User;
import org.exist.storage.ElementIndex;
import org.exist.storage.TextSearchEngine;
import org.exist.util.CollectionScanner;
import org.exist.util.DirectoryScanner;
import org.exist.util.Occurrences;
import org.exist.util.ProgressBar;
import org.exist.util.ProgressIndicator;
import org.exist.util.XMLFilenameFilter;
import org.exist.util.serializer.SAXSerializer;
import org.exist.util.serializer.SAXSerializerPool;
import org.exist.xmldb.CollectionManagementServiceImpl;
import org.exist.xmldb.DatabaseInstanceManager;
import org.exist.xmldb.IndexQueryService;
import org.exist.xmldb.UserManagementService;
import org.exist.xmldb.XPathQueryServiceImpl;
import org.gnu.readline.Readline;
import org.gnu.readline.ReadlineCompleter;
import org.gnu.readline.ReadlineLibrary;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Database;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.ResourceSet;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.BinaryResource;
import org.xmldb.api.modules.CollectionManagementService;
import org.xmldb.api.modules.XPathQueryService;
import org.xmldb.api.modules.XUpdateQueryService;

public class InteractiveClient {
    private static final int HELP_OPT = 104;
    private static final int QUIET_OPT = 113;
    private static final int USER_OPT = 117;
    private static final int PASS_OPT = 80;
    private static final int LOCAL_OPT = 108;
    private static final int CONFIG_OPT = 67;
    private static final int PARSE_OPT = 112;
    private static final int COLLECTION_OPT = 99;
    private static final int RESOURCE_OPT = 102;
    private static final int REMOVE_OPT = 114;
    private static final int GET_OPT = 103;
    private static final int MKCOL_OPT = 109;
    private static final int RMCOL_OPT = 82;
    private static final int OPTION_OPT = 111;
    private static final int FIND_OPT = 120;
    private static final int RESULTS_OPT = 110;
    private static final int VERBOSE_OPT = 118;
    private static final int QUERY_FILE_OPT = 70;
    private static final int XUPDATE_OPT = 88;
    private static final int THREADS_OPT = 116;
    private static final int RECURSE_DIRS_OPT = 100;
    private static final int NO_GUI_OPT = 115;
    private static final int TRACE_QUERIES_OPT = 84;
    private static final int OUTPUT_FILE_OPT = 79;
    private static final int REINDEX_OPT = 105;
    private static final int QUERY_GUI_OPT = 81;
    private static final CLOptionDescriptor[] OPTIONS = new CLOptionDescriptor[]{new CLOptionDescriptor("help", 8, 104, "print help on command line options and exit."), new CLOptionDescriptor("quiet", 8, 113, "be quiet. Just print errors."), new CLOptionDescriptor("verbose", 8, 118, "be verbose. Display progress information on put."), new CLOptionDescriptor("user", 2, 117, "set username."), new CLOptionDescriptor("password", 2, 80, "specify password."), new CLOptionDescriptor("local", 8, 108, "launch a local database instance. Otherwise client will connect to URI specified in client.properties."), new CLOptionDescriptor("config", 2, 67, "specify alternate configuration file. Implies -l."), new CLOptionDescriptor("parse", 4, 112, "store files or directories given as extra args on command line."), new CLOptionDescriptor("remove", 2, 114, "remove a document."), new CLOptionDescriptor("collection", 2, 99, "set target collection."), new CLOptionDescriptor("resource", 2, 102, "specify a resource contained in the current collection. Use in conjunction with -u to specify the resource to update."), new CLOptionDescriptor("get", 2, 103, "retrieve a document."), new CLOptionDescriptor("mkcol", 2, 109, "create a collection (and any missing parent collection). Implies -c."), new CLOptionDescriptor("rmcol", 2, 82, "remove entire collection"), new CLOptionDescriptor("xpath", 4, 120, "execute XPath query given as argument. Without argument reads query from stdin."), new CLOptionDescriptor("howmany", 2, 110, "max. number of query results to be displayed."), new CLOptionDescriptor("output", 2, 79, "write output of command into given file (use with -x, -g)."), new CLOptionDescriptor("option", 48, 111, "specify extra options: property=value. For available properties see client.properties."), new CLOptionDescriptor("file", 2, 70, "load queries from file and execute in random order."), new CLOptionDescriptor("threads", 2, 116, "number of parallel threads to test with (use with -f)."), new CLOptionDescriptor("recurse-dirs", 8, 100, "recurse into subdirectories during index?"), new CLOptionDescriptor("xupdate", 2, 88, "process xupdate commands. Commands are read from the file specified in the argument."), new CLOptionDescriptor("no-gui", 8, 115, "don't start client with GUI. Just use the shell."), new CLOptionDescriptor("trace", 2, 84, "log queries to the file specified by the argument (for debugging)."), new CLOptionDescriptor("reindex", 8, 105, "reindex the collection specified in the collection argument -c"), new CLOptionDescriptor("query", 8, 81, "directly open the query gui")};
    private static final String ANSI_BLUE = "\u001b[0;34m";
    private static final String ANSI_CYAN = "\u001b[0;36m";
    private static final String ANSI_WHITE = "\u001b[0;37m";
    protected static String EDIT_CMD = "xemacs $file";
    protected static String ENCODING = "ISO-8859-1";
    protected static String PASS = null;
    protected static String URI = "xmldb:exist://localhost:8080/exist/xmlrpc";
    protected static String USER = "admin";
    protected static int PARALLEL_THREADS = 5;
    protected static Properties defaultProps = new Properties();
    protected static final int[] colSizes = new int[]{10, 10, 10, -1};
    protected static String driver = "org.exist.xmldb.DatabaseImpl";
    protected static String configuration = null;
    protected TreeSet completitions;
    protected LinkedList queryHistory;
    protected File queryHistoryFile;
    protected File historyFile;
    protected Collection current;
    protected int nextInSet;
    protected int maxResults;
    protected String path;
    protected Properties properties;
    protected String[] xmlSuffixes;
    protected String[] binarySuffixes;
    protected String[] resources;
    protected ResourceSet result;
    protected HashMap namespaceMappings;
    protected int filesCount;
    protected boolean quiet;
    protected boolean verbose;
    protected boolean recurseDirs;
    protected boolean startGUI;
    protected Writer traceWriter;
    protected ClientFrame frame;

    public InteractiveClient() {
        defaultProps.setProperty("driver", driver);
        defaultProps.setProperty("uri", URI);
        defaultProps.setProperty("editor", EDIT_CMD);
        defaultProps.setProperty("indent", "true");
        defaultProps.setProperty("encoding", ENCODING);
        defaultProps.setProperty("user", USER);
        defaultProps.setProperty("colors", "false");
        defaultProps.setProperty("permissions", "false");
        defaultProps.setProperty("expand-xincludes", "true");
        this.completitions = new TreeSet();
        this.queryHistory = new LinkedList();
        this.current = null;
        this.nextInSet = 1;
        this.maxResults = 10;
        this.path = "/db";
        this.resources = null;
        this.result = null;
        this.namespaceMappings = new HashMap();
        this.filesCount = 0;
        this.quiet = false;
        this.verbose = false;
        this.recurseDirs = false;
        this.startGUI = true;
        this.traceWriter = null;
    }

    protected void displayHelp() {
        this.messageln("--- general commands ---");
        this.messageln("ls                   list collection contents");
        this.messageln("cd [collection|..]   change current collection");
        this.messageln("put [file pattern] upload file or directory to the database");
        this.messageln("edit [resource] open the resource for editing");
        this.messageln("mkcol collection     create new sub-collection in current collection");
        this.messageln("rm document          remove document from current collection");
        this.messageln("rmcol collection     remove collection");
        this.messageln("set [key=value]      set property. Calling set without ");
        this.messageln("                     argument shows current settings.");
        this.messageln("\n--- search commands ---");
        this.messageln("find xpath-expr      execute the given XPath expression.");
        this.messageln("show [position]      display query result value at position.");
        this.messageln("\n--- user management (may require dba rights) ---");
        this.messageln("users                list existing users.");
        this.messageln("adduser username     create a new user.");
        this.messageln("passwd username      change password for user. ");
        this.messageln("chown user group [resource]");
        this.messageln("                     change resource ownership. chown without");
        this.messageln("                     resource changes ownership of the current");
        this.messageln("                     collection.");
        this.messageln("chmod [resource] permissions");
        this.messageln("                     change resource permissions. Format:");
        this.messageln("                     [user|group|other]=[+|-][read|write|update].");
        this.messageln("                     chmod without resource changes permissions for");
        this.messageln("                     the current collection.");
        this.messageln("lock resource        put a write lock on the specified resource.");
        this.messageln("unlock resource      remove a write lock from the specified resource.");
        this.messageln("quit                 quit the program");
    }

    public static void main(String[] args) {
        try {
            InteractiveClient client = new InteractiveClient();
            client.run(args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void connect() throws Exception {
        if (this.startGUI && this.frame != null) {
            this.frame.setStatus("connecting to " + this.properties.getProperty("uri"));
        }
        Class<?> cl = Class.forName(this.properties.getProperty("driver"));
        Database database = (Database)cl.newInstance();
        database.setProperty("create-database", "true");
        if (this.properties.containsKey("configuration")) {
            database.setProperty("configuration", this.properties.getProperty("configuration"));
        }
        DatabaseManager.registerDatabase((Database)database);
        this.current = DatabaseManager.getCollection((String)(this.properties.getProperty("uri") + this.path), (String)this.properties.getProperty("user"), (String)this.properties.getProperty("password"));
        if (this.startGUI && this.frame != null) {
            this.frame.setStatus("connected to " + this.properties.getProperty("uri") + " as user " + this.properties.getProperty("user"));
        }
    }

    protected Collection getCollection() {
        return this.current;
    }

    protected void reloadCollection() throws XMLDBException {
        this.current = DatabaseManager.getCollection((String)(this.properties.getProperty("uri") + this.path), (String)this.properties.getProperty("user"), (String)this.properties.getProperty("password"));
        this.getResources();
    }

    protected void setProperties() throws XMLDBException {
        Iterator<Object> i = this.properties.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            this.current.setProperty(key, this.properties.getProperty(key));
        }
    }

    protected void getResources() throws XMLDBException {
        Permission perm;
        int i;
        if (this.current == null) {
            return;
        }
        this.setProperties();
        UserManagementService mgtService = (UserManagementService)this.current.getService("UserManagementService", "1.0");
        String[] childCollections = this.current.listChildCollections();
        String[] childResources = this.current.listResources();
        this.resources = new String[childCollections.length + childResources.length];
        Object[][] tableData = new Object[this.resources.length][4];
        String[] cols = new String[4];
        for (i = 0; i < childCollections.length; ++i) {
            Collection child = this.current.getChildCollection(childCollections[i]);
            perm = mgtService.getPermissions(child);
            if (this.properties.getProperty("permissions").equals("true")) {
                cols[0] = perm.toString();
                cols[1] = perm.getOwner();
                cols[2] = perm.getOwnerGroup();
                cols[3] = childCollections[i];
                this.resources[i] = 'd' + InteractiveClient.formatString(cols, colSizes);
            } else {
                this.resources[i] = childCollections[i];
            }
            if (this.startGUI) {
                tableData[i][0] = perm.toString();
                tableData[i][1] = perm.getOwner();
                tableData[i][2] = perm.getOwnerGroup();
                tableData[i][3] = new CollectionName(childCollections[i]);
            }
            this.completitions.add(childCollections[i]);
        }
        for (int j = 0; j < childResources.length; ++j) {
            Resource res = this.current.getResource(childResources[j]);
            perm = mgtService.getPermissions(res);
            if (perm == null) {
                System.out.println("null");
            }
            this.resources[i] = this.properties.getProperty("permissions").equals("true") ? '-' + perm.toString() + '\t' + perm.getOwner() + '\t' + perm.getOwnerGroup() + '\t' + childResources[j] : childResources[j];
            if (this.startGUI) {
                tableData[i][0] = perm.toString();
                tableData[i][1] = perm.getOwner();
                tableData[i][2] = perm.getOwnerGroup();
                tableData[i][3] = childResources[j];
            }
            this.completitions.add(childResources[j]);
            ++i;
        }
        if (this.startGUI) {
            this.frame.setResources(tableData);
        }
    }

    protected void more(String str) {
        LineNumberReader reader = new LineNumberReader(new StringReader(str));
        boolean count = false;
        try {
            String line;
            while (System.in.available() > 0) {
                System.in.read();
            }
            while ((line = reader.readLine()) != null) {
                if (reader.getLineNumber() % 24 == 0) {
                    System.out.print("line: " + reader.getLineNumber() + "; press [return] for more or [q] for quit.");
                    int ch = System.in.read();
                    if (ch == 113 || ch == 81) {
                        return;
                    }
                }
                System.out.println(line);
            }
        }
        catch (IOException ioe) {
            System.err.println("IOException: " + ioe);
        }
    }

    protected boolean process(String line) {
        int i;
        String[] args;
        if (this.startGUI) {
            this.frame.setPath(this.path);
        }
        if (line.startsWith("find")) {
            args = new String[]{"find", line.substring(5)};
        } else {
            StreamTokenizer tok = new StreamTokenizer(new StringReader(line));
            tok.resetSyntax();
            tok.wordChars(33, Short.MAX_VALUE);
            tok.quoteChar(34);
            tok.whitespaceChars(32, 32);
            ArrayList<String> argList = new ArrayList<String>(3);
            i = 0;
            try {
                int token;
                while ((token = tok.nextToken()) != -1) {
                    if (token != -3 && token != 34) continue;
                    argList.add(tok.sval);
                }
            }
            catch (IOException e) {
                System.err.println("Could not parse command line.");
                return true;
            }
            args = new String[argList.size()];
            argList.toArray(args);
        }
        String newPath = this.path;
        try {
            if (args[0].equalsIgnoreCase("ls")) {
                this.getResources();
                if (this.properties.getProperty("permissions").equals("true")) {
                    for (int i2 = 0; i2 < this.resources.length; ++i2) {
                        this.messageln(this.resources[i2]);
                    }
                } else {
                    for (i = 0; i < this.resources.length; ++i) {
                        StringBuffer buf = new StringBuffer();
                        int k = 0;
                        int j = 0;
                        while (i < this.resources.length && j < 5) {
                            buf.append(this.resources[i] + '\t');
                            k = j++;
                            ++i;
                        }
                        if (k == 4 && i < this.resources.length) {
                            --i;
                        }
                        this.messageln(buf.toString());
                    }
                }
            } else if (args[0].equalsIgnoreCase("cd")) {
                Collection temp;
                this.completitions.clear();
                String tempPath = newPath;
                if (args.length < 2 || args[1] == null) {
                    tempPath = "/db";
                    temp = DatabaseManager.getCollection((String)(this.properties.getProperty("uri") + "/db"), (String)this.properties.getProperty("user"), (String)this.properties.getProperty("password"));
                } else {
                    if (args[1].equals("..")) {
                        String string = tempPath = newPath.equals("/db") ? "/db" : tempPath.substring(0, newPath.lastIndexOf("/"));
                        if (tempPath.length() == 0) {
                            tempPath = "/db";
                        }
                    } else {
                        tempPath = args[1].startsWith("/") ? args[1] : tempPath + '/' + args[1];
                    }
                    temp = DatabaseManager.getCollection((String)(this.properties.getProperty("uri") + tempPath), (String)this.properties.getProperty("user"), (String)this.properties.getProperty("password"));
                }
                if (temp != null) {
                    this.current = temp;
                    newPath = tempPath;
                    if (this.startGUI) {
                        this.frame.setPath(newPath);
                    }
                } else {
                    this.messageln("no such collection.");
                }
                this.getResources();
            } else if (args[0].equalsIgnoreCase("cp")) {
                if (args.length != 3) {
                    this.messageln("cp requires two arguments.");
                    return true;
                }
                this.copy(args[1], args[2]);
                this.getResources();
            } else if (args[0].equalsIgnoreCase("edit")) {
                if (args.length == 2) {
                    this.editResource(args[1]);
                } else {
                    this.messageln("Please specify a resource.");
                }
            } else {
                Resource res;
                if (args[0].equalsIgnoreCase("get")) {
                    if (args.length < 2) {
                        System.err.println("wrong number of arguments.");
                        return true;
                    }
                    res = this.retrieve(args[1]);
                    if (res != null) {
                        String data = res.getResourceType().equals("XMLResource") ? (String)res.getContent() : new String((byte[])res.getContent());
                        if (this.startGUI) {
                            this.frame.setEditable(false);
                            this.frame.display(data);
                            this.frame.setEditable(true);
                        } else {
                            String content = data;
                            this.more(content);
                        }
                    }
                    return true;
                }
                if (args[0].equalsIgnoreCase("find")) {
                    if (args.length < 2) {
                        this.messageln("no query argument found.");
                        return true;
                    }
                    this.messageln(args[1]);
                    long start = System.currentTimeMillis();
                    this.result = this.find(args[1]);
                    if (this.result == null) {
                        this.messageln("nothing found");
                    } else {
                        this.messageln("found " + this.result.getSize() + " hits in " + (System.currentTimeMillis() - start) + "ms.");
                    }
                    this.nextInSet = 1;
                } else if (args[0].equalsIgnoreCase("run")) {
                    if (args.length < 2) {
                        this.messageln("please specify a query file.");
                        return true;
                    }
                    try {
                        String nextLine;
                        BufferedReader reader = new BufferedReader(new FileReader(args[1]));
                        StringBuffer buf = new StringBuffer();
                        while ((nextLine = reader.readLine()) != null) {
                            buf.append(nextLine);
                            buf.append('\n');
                        }
                        args[1] = buf.toString();
                        long start = System.currentTimeMillis();
                        this.result = this.find(args[1]);
                        if (this.result == null) {
                            this.messageln("nothing found");
                        } else {
                            this.messageln("found " + this.result.getSize() + " hits in " + (System.currentTimeMillis() - start) + "ms.");
                        }
                        this.nextInSet = 1;
                    }
                    catch (Exception e) {
                        this.messageln("An error occurred: " + e.getMessage());
                    }
                } else {
                    Object mgtService;
                    if (args[0].equalsIgnoreCase("show")) {
                        if (this.result == null) {
                            this.messageln("no result set.");
                            return true;
                        }
                        try {
                            int start = this.nextInSet;
                            int count = 1;
                            if (args.length > 1) {
                                start = Integer.parseInt(args[1]);
                            }
                            if (args.length > 2) {
                                count = Integer.parseInt(args[2]);
                            }
                            int s = (int)this.result.getSize();
                            if (start < 1 || start > s) {
                                this.messageln("start offset out of range");
                                return true;
                            }
                            if (--start + count > s) {
                                count = s - start;
                            }
                            this.nextInSet = start + count + 1;
                            for (int i3 = start; i3 < start + count; ++i3) {
                                Resource r = this.result.getResource((long)i3);
                                if (this.startGUI) {
                                    this.frame.display((String)r.getContent());
                                    continue;
                                }
                                this.more((String)r.getContent());
                            }
                            this.messageln("displayed items " + (start + 1) + " to " + (start + count) + " of " + this.result.getSize());
                        }
                        catch (NumberFormatException nfe) {
                            this.messageln("wrong argument");
                            return true;
                        }
                    }
                    if (args[0].equalsIgnoreCase("mkcol")) {
                        if (args.length < 2) {
                            this.messageln("missing argument.");
                            return true;
                        }
                        mgtService = (CollectionManagementService)this.current.getService("CollectionManagementService", "1.0");
                        Collection newCollection = mgtService.createCollection(args[1]);
                        if (newCollection == null) {
                            this.messageln("could not create collection.");
                        } else {
                            this.messageln("created collection.");
                        }
                        this.current = DatabaseManager.getCollection((String)(this.properties.getProperty("uri") + this.path), (String)this.properties.getProperty("user"), (String)this.properties.getProperty("password"));
                        this.getResources();
                    } else {
                        Collection temp;
                        int i4;
                        if (args[0].equalsIgnoreCase("put")) {
                            if (args.length < 2) {
                                this.messageln("missing argument.");
                                return true;
                            }
                            boolean r = this.parse(args[1]);
                            this.getResources();
                            return r;
                        }
                        if (args[0].equalsIgnoreCase("blob")) {
                            if (args.length < 2) {
                                this.messageln("missing argument.");
                                return true;
                            }
                            this.storeBinary(args[1]);
                            this.getResources();
                        } else if (args[0].equalsIgnoreCase("rm")) {
                            if (args.length < 2) {
                                this.messageln("missing argument.");
                                return true;
                            }
                            this.remove(args[1]);
                            this.current = DatabaseManager.getCollection((String)(this.properties.getProperty("uri") + this.path), (String)this.properties.getProperty("user"), (String)this.properties.getProperty("password"));
                            this.getResources();
                        } else if (args[0].equalsIgnoreCase("rmcol")) {
                            if (args.length < 2) {
                                this.messageln("wrong argument count.");
                                return true;
                            }
                            this.rmcol(args[1]);
                            this.current = DatabaseManager.getCollection((String)(this.properties.getProperty("uri") + this.path), (String)this.properties.getProperty("user"), (String)this.properties.getProperty("password"));
                            this.getResources();
                        } else if (args[0].equalsIgnoreCase("adduser")) {
                            if (args.length < 2) {
                                System.err.println("Usage: adduser name");
                                return true;
                            }
                            if (this.startGUI) {
                                this.messageln("command not supported in GUI mode. Please use the \"Edit users\" menu option.");
                                return true;
                            }
                            try {
                                String p2;
                                String p1;
                                mgtService = (UserManagementService)this.current.getService("UserManagementService", "1.0");
                                while (!(p1 = Readline.readline((String)"password: ")).equals(p2 = Readline.readline((String)"re-enter password: "))) {
                                    System.out.println("\nentered passwords differ. Try again...");
                                }
                                String home = Readline.readline((String)"home collection [none]: ");
                                User user = new User(args[1], p1);
                                if (home != null && home.length() > 0) {
                                    user.setHome(home);
                                }
                                String groups = Readline.readline((String)"enter groups: ");
                                StringTokenizer tok = new StringTokenizer(groups, " ,");
                                while (tok.hasMoreTokens()) {
                                    String group = tok.nextToken();
                                    if (group.length() <= 0) continue;
                                    user.addGroup(group);
                                }
                                mgtService.addUser(user);
                                System.out.println("user " + user + " created.");
                            }
                            catch (Exception e) {
                                System.out.println("ERROR: " + e.getMessage());
                                e.printStackTrace();
                            }
                        } else if (args[0].equalsIgnoreCase("users")) {
                            mgtService = (UserManagementService)this.current.getService("UserManagementService", "1.0");
                            User[] users = mgtService.getUsers();
                            System.out.println("User\t\tGroups");
                            System.out.println("-----------------------------------------");
                            for (i4 = 0; i4 < users.length; ++i4) {
                                System.out.print(users[i4].getName() + "\t\t");
                                Iterator j = users[i4].getGroups();
                                while (j.hasNext()) {
                                    System.out.print(j.next());
                                    if (!j.hasNext()) continue;
                                    System.out.print(", ");
                                }
                                System.out.println();
                            }
                        } else if (args[0].equalsIgnoreCase("passwd")) {
                            if (this.startGUI) {
                                this.messageln("command not supported in GUI mode. Please use the \"Edit users\" menu option.");
                                return true;
                            }
                            if (args.length < 2) {
                                System.out.println("Usage: passwd username");
                                return true;
                            }
                            try {
                                String p2;
                                String p1;
                                mgtService = (UserManagementService)this.current.getService("UserManagementService", "1.0");
                                User user = mgtService.getUser(args[1]);
                                if (user == null) {
                                    System.out.println("no such user.");
                                    return true;
                                }
                                while (!(p1 = Readline.readline((String)"password: ")).equals(p2 = Readline.readline((String)"re-enter password: "))) {
                                    System.out.println("\nentered passwords differ. Try again...");
                                }
                                user.setPassword(p1);
                                mgtService.updateUser(user);
                                this.properties.setProperty("password", p1);
                            }
                            catch (Exception e) {
                                System.err.println("ERROR: " + e.getMessage());
                            }
                        } else if (args[0].equalsIgnoreCase("chmod")) {
                            if (args.length < 2) {
                                System.out.println("Usage: chmod [resource] mode");
                                return true;
                            }
                            temp = null;
                            if (args.length == 3) {
                                System.out.println("trying collection: " + args[1]);
                                temp = this.current.getChildCollection(args[1]);
                                if (temp == null) {
                                    System.out.println("\ntrying resource: " + args[1]);
                                    Resource r = this.current.getResource(args[1]);
                                    if (r != null) {
                                        UserManagementService mgtService2 = (UserManagementService)this.current.getService("UserManagementService", "1.0");
                                        mgtService2.chmod(r, args[2]);
                                    } else {
                                        System.err.println("Resource " + args[1] + " not found.");
                                    }
                                } else {
                                    UserManagementService mgtService3 = (UserManagementService)temp.getService("UserManagementService", "1.0");
                                    mgtService3.chmod(args[2]);
                                }
                            } else {
                                UserManagementService mgtService4 = (UserManagementService)this.current.getService("UserManagementService", "1.0");
                                mgtService4.chmod(args[1]);
                            }
                            this.current = DatabaseManager.getCollection((String)(this.properties.getProperty("uri") + this.path), (String)this.properties.getProperty("user"), (String)this.properties.getProperty("password"));
                            this.getResources();
                        } else if (args[0].equalsIgnoreCase("chown")) {
                            if (args.length < 3) {
                                System.out.println("Usage: chown username group [resource]");
                                return true;
                            }
                            temp = args.length == 4 ? this.current.getChildCollection(args[3]) : this.current;
                            if (temp != null) {
                                UserManagementService mgtService5 = (UserManagementService)temp.getService("UserManagementService", "1.0");
                                User u = mgtService5.getUser(args[1]);
                                if (u == null) {
                                    System.out.println("unknown user");
                                    return true;
                                }
                                mgtService5.chown(u, args[2]);
                                System.out.println("owner changed.");
                                this.getResources();
                                return true;
                            }
                            Resource res2 = this.current.getResource(args[3]);
                            if (res2 != null) {
                                UserManagementService mgtService6 = (UserManagementService)this.current.getService("UserManagementService", "1.0");
                                User u = mgtService6.getUser(args[1]);
                                if (u == null) {
                                    System.out.println("unknown user");
                                    return true;
                                }
                                mgtService6.chown(res2, u, args[2]);
                                this.getResources();
                                return true;
                            }
                            System.err.println("Resource " + args[3] + " not found.");
                        } else if (args[0].equalsIgnoreCase("lock") || args[0].equalsIgnoreCase("unlock")) {
                            if (args.length < 2) {
                                this.messageln("Usage: lock resource");
                                return true;
                            }
                            res = this.current.getResource(args[1]);
                            if (res != null) {
                                UserManagementService mgtService7 = (UserManagementService)this.current.getService("UserManagementService", "1.0");
                                User user = mgtService7.getUser(this.properties.getProperty("user", "guest"));
                                if (args[0].equalsIgnoreCase("lock")) {
                                    mgtService7.lockResource(res, user);
                                } else {
                                    mgtService7.unlockResource(res);
                                }
                            }
                        } else {
                            StringTokenizer tok;
                            IndexQueryService service;
                            if (args[0].equalsIgnoreCase("elements")) {
                                System.out.println("Element occurrences in collection " + this.current.getName());
                                System.out.println("-------------------------------------------------------");
                                service = (IndexQueryService)this.current.getService("IndexQueryService", "1.0");
                                Occurrences[] elements = service.getIndexedElements(true);
                                for (i4 = 0; i4 < elements.length; ++i4) {
                                    System.out.println(InteractiveClient.formatString(elements[i4].getTerm().toString(), Integer.toString(elements[i4].getOccurrences()), 50));
                                }
                                return true;
                            }
                            if (args[0].equalsIgnoreCase("terms")) {
                                if (args.length < 3) {
                                    System.out.println("Usage: terms sequence-start sequence-end");
                                    return true;
                                }
                                service = (IndexQueryService)this.current.getService("IndexQueryService", "1.0");
                                Occurrences[] terms = service.scanIndexTerms(args[1], args[2], true);
                                System.out.println("Element occurrences in collection " + this.current.getName());
                                System.out.println("-------------------------------------------------------");
                                for (i4 = 0; i4 < terms.length; ++i4) {
                                    System.out.println(InteractiveClient.formatString(terms[i4].getTerm().toString(), Integer.toString(terms[i4].getOccurrences()), 50));
                                }
                            } else if (args[0].equalsIgnoreCase("xupdate")) {
                                if (this.startGUI) {
                                    this.messageln("command not supported in GUI mode.");
                                    return true;
                                }
                                String command = "";
                                try {
                                    String lastLine;
                                    while ((lastLine = Readline.readline((String)"| ")) != null && lastLine.length() != 0) {
                                        command = command + lastLine;
                                    }
                                }
                                catch (EOFException e) {
                                }
                                catch (IOException e) {
                                    // empty catch block
                                }
                                String xupdate = "<xu:modifications version=\"1.0\" xmlns:xu=\"http://www.xmldb.org/xupdate\">" + command + "</xu:modifications>";
                                XUpdateQueryService service2 = (XUpdateQueryService)this.current.getService("XUpdateQueryService", "1.0");
                                long mods = service2.update(xupdate);
                                System.out.println(mods + " modifications processed.");
                            } else if (args[0].equalsIgnoreCase("map")) {
                                String prefix;
                                tok = new StringTokenizer(args[1], "= ");
                                if (args[1].startsWith("=")) {
                                    prefix = "";
                                } else {
                                    if (tok.countTokens() < 2) {
                                        this.messageln("please specify a namespace/prefix mapping as: prefix=namespaceURI");
                                        return true;
                                    }
                                    prefix = tok.nextToken();
                                }
                                String uri = tok.nextToken();
                                this.namespaceMappings.put(prefix, uri);
                            } else if (args[0].equalsIgnoreCase("set")) {
                                if (args.length == 1) {
                                    this.properties.list(System.out);
                                } else {
                                    try {
                                        tok = new StringTokenizer(args[1], "= ");
                                        if (tok.countTokens() < 2) {
                                            System.err.println("please specify a key=value pair");
                                            return true;
                                        }
                                        String key = tok.nextToken();
                                        String val = tok.nextToken();
                                        System.out.println(key + " = " + val);
                                        this.properties.setProperty(key, val);
                                        this.current.setProperty(key, val);
                                        this.getResources();
                                    }
                                    catch (Exception e) {
                                        System.err.println("Exception: " + e.getMessage());
                                    }
                                }
                            } else {
                                if (args[0].equalsIgnoreCase("shutdown")) {
                                    DatabaseInstanceManager mgr = (DatabaseInstanceManager)this.current.getService("DatabaseInstanceManager", "1.0");
                                    if (mgr == null) {
                                        this.messageln("Service is not available");
                                        return true;
                                    }
                                    mgr.shutdown();
                                    return true;
                                }
                                if (args[0].equalsIgnoreCase("help") || args[0].equals("?")) {
                                    this.displayHelp();
                                } else {
                                    if (args[0].equalsIgnoreCase("quit")) {
                                        return false;
                                    }
                                    if (args[0].equalsIgnoreCase("validate")) {
                                        if (args.length < 2) {
                                            this.messageln("missing document name.");
                                        } else {
                                            SchemaService schemaService = (SchemaService)this.current.getService("SchemaService", "1.0");
                                            if (schemaService.validateResource(args[1])) {
                                                this.messageln("validated ok.");
                                            } else {
                                                this.messageln("there were errors.");
                                            }
                                        }
                                    } else {
                                        if (args[0].equalsIgnoreCase("putschema")) {
                                            if (args.length < 2) {
                                                this.messageln("missing schema file name.");
                                            } else {
                                                this.importSchema(args[1]);
                                                this.getResources();
                                            }
                                            return true;
                                        }
                                        this.messageln("unknown command");
                                        return true;
                                    }
                                }
                            }
                        }
                    }
                }
            }
            this.path = newPath;
            return true;
        }
        catch (Throwable e) {
            if (this.startGUI) {
                ClientFrame.showErrorMessage(InteractiveClient.getExceptionMessage(e), e);
            } else {
                this.messageln(InteractiveClient.getExceptionMessage(e));
                e.printStackTrace();
            }
            return true;
        }
    }

    private void editResource(String name) {
        block8: {
            try {
                Resource res = this.retrieve(name, this.properties.getProperty("indent", "yes"));
                DocumentView view = new DocumentView(this.getCollection(), res, this.properties);
                view.setSize(new Dimension(640, 400));
                if (res.getResourceType().equals("XMLResource")) {
                    view.setText((String)res.getContent());
                } else {
                    view.setText(new String((byte[])res.getContent()));
                }
                UserManagementService service = (UserManagementService)this.current.getService("UserManagementService", "1.0");
                User user = service.getUser(this.properties.getProperty("user"));
                String lockOwner = service.hasUserLock(res);
                if (lockOwner == null || JOptionPane.showConfirmDialog(this.frame, "Resource is already locked by user " + lockOwner + ". Should I try to relock it?", "Resource locked", 0) != 0) {
                    try {
                        service.lockResource(res, user);
                    }
                    catch (XMLDBException ex) {
                        System.out.println(ex.getMessage());
                        JOptionPane.showMessageDialog(this.frame, "Resource cannot be locked. Opening read-only.");
                        view.setReadOnly();
                    }
                    view.setVisible(true);
                    break block8;
                }
                view.dispose();
                this.frame.setCursor(Cursor.getDefaultCursor());
            }
            catch (IllegalArgumentException ex) {
                this.messageln("Illegal argument: " + ex.getMessage());
            }
            catch (XMLDBException ex) {
                this.messageln("XMLDB error: " + ex.getMessage());
            }
        }
    }

    private void importSchema(String filename) throws XMLDBException {
        SchemaService schemaService = (SchemaService)this.current.getService("SchemaService", "1.0");
        if (schemaService != null) {
            String schemaContents = null;
            try {
                DOMParser parser = new DOMParser();
                parser.parse(filename);
                Document document = parser.getDocument();
                StringWriter sw = new StringWriter();
                XMLSerializer serializer = new XMLSerializer((Writer)sw, new OutputFormat(document, "UTF-8", true));
                serializer.serialize(document);
                schemaContents = sw.toString();
                schemaService.putSchema(schemaContents);
                this.messageln("imported schema in file \"" + filename + "\".");
            }
            catch (SAXException saxEx) {
                this.messageln("Unable to parse schema in " + filename + ": " + saxEx.getMessage());
            }
            catch (IOException ioEx) {
                this.messageln("Uable to parse schema in " + filename + ": " + ioEx.getMessage());
            }
        }
    }

    private final ResourceSet find(String xpath) throws XMLDBException {
        if (xpath.charAt(xpath.length() - 1) == '\n') {
            xpath = xpath.substring(0, xpath.length() - 1);
        }
        if (this.traceWriter != null) {
            try {
                this.traceWriter.write("<query>");
                this.traceWriter.write(xpath);
                this.traceWriter.write("</query>\r\n");
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        String sortBy = null;
        int p = xpath.indexOf(" sort by ");
        if (p > -1) {
            String xp = xpath.substring(0, p);
            sortBy = xpath.substring(p + " sort by ".length());
            xpath = xp;
            System.out.println("XPath =   " + xpath);
            System.out.println("Sort-by = " + sortBy);
        }
        XPathQueryServiceImpl service = (XPathQueryServiceImpl)this.current.getService("XPathQueryService", "1.0");
        service.setProperty("indent", this.properties.getProperty("indent"));
        service.setProperty("encoding", this.properties.getProperty("encoding"));
        Iterator i = this.namespaceMappings.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry mapping = i.next();
            service.setNamespace((String)mapping.getKey(), (String)mapping.getValue());
        }
        return sortBy == null ? service.query(xpath) : service.query(xpath, sortBy);
    }

    private final void testQuery(String queryFile) {
        try {
            String line;
            File f = new File(queryFile);
            if (!f.canRead()) {
                System.err.println("can't read query file: " + queryFile);
                return;
            }
            BufferedReader reader = new BufferedReader(new FileReader(f));
            ArrayList<String> queries = new ArrayList<String>(10);
            Thread thread = null;
            while ((line = reader.readLine()) != null) {
                queries.add(line);
            }
            for (int i = 0; i < PARALLEL_THREADS; ++i) {
                thread = new QueryThread(queries);
                thread.setName("QueryThread" + i);
                thread.start();
            }
            try {
                thread.join();
            }
            catch (InterruptedException e) {}
        }
        catch (FileNotFoundException e) {
            System.err.println("ERROR: " + e);
        }
        catch (IOException e) {
            System.err.println("ERROR: " + e);
        }
    }

    protected final Resource retrieve(String resource) throws XMLDBException {
        return this.retrieve(resource, this.properties.getProperty("indent"));
    }

    protected final Resource retrieve(String resource, String indent) throws XMLDBException {
        Resource res = this.current.getResource(resource);
        if (res == null) {
            this.messageln("document not found.");
            return null;
        }
        return res;
    }

    private final void remove(String pattern) throws XMLDBException {
        Collection collection = this.current;
        if (pattern.startsWith("/")) {
            System.err.println("path pattern should be relative to current collection");
            return;
        }
        Resource res = collection.getResource(pattern);
        Resource[] resources = res == null ? CollectionScanner.scan(collection, "", pattern) : new Resource[]{res};
        for (int i = 0; i < resources.length; ++i) {
            this.message("removing document " + resources[i].getId() + " ...");
            Collection parent = resources[i].getParentCollection();
            parent.removeResource(resources[i]);
            this.messageln("done.");
        }
    }

    private final void xupdate(String resource, String filename) throws XMLDBException, IOException {
        File file = new File(filename);
        if (!file.exists() || !file.canRead()) {
            this.messageln("cannot read file " + filename);
            return;
        }
        String commands = XMLUtil.readFile(file, "UTF-8");
        XUpdateQueryService service = (XUpdateQueryService)this.current.getService("XUpdateQueryService", "1.0");
        long modifications = 0L;
        modifications = resource == null ? service.update(commands) : service.updateResource(resource, commands);
        this.messageln(modifications + " modifications processed " + "successfully.");
    }

    private final void rmcol(String collection) throws XMLDBException {
        CollectionManagementService mgtService = (CollectionManagementService)this.current.getService("CollectionManagementService", "1.0");
        this.message("removing collection " + collection + " ...");
        mgtService.removeCollection(collection);
        this.messageln("done.");
    }

    private final void copy(String source, String destination) throws XMLDBException {
        Resource srcDoc;
        CollectionManagementServiceImpl mgtService = (CollectionManagementServiceImpl)this.current.getService("CollectionManagementService", "1.0");
        String destName = null;
        Collection destCol = this.resolveCollection(destination);
        if (destCol == null) {
            int p = destination.lastIndexOf(47);
            if (p < 0) {
                destName = destination;
                destination = this.current.getName();
            } else {
                destName = destination.substring(p + 1);
                destination = destination.substring(0, p);
            }
        }
        if ((srcDoc = this.resolveResource(source)) != null) {
            String resourcePath = srcDoc.getParentCollection().getName() + '/' + srcDoc.getId();
            this.messageln("Copying resource " + resourcePath + " to " + destination);
            mgtService.copyResource(resourcePath, destination, destName);
        } else {
            this.messageln("Copying collection " + source + " to " + destination);
        }
        mgtService.copy(source, destination, destName);
    }

    private final void reindex() throws XMLDBException {
        IndexQueryService service = (IndexQueryService)this.current.getService("IndexQueryService", "1.0");
        this.message("reindexing collection " + this.current.getName());
        service.reindexCollection();
        this.messageln("done.");
    }

    private final void storeBinary(String fileName) throws XMLDBException {
        File file = new File(fileName);
        if (file.canRead()) {
            BinaryResource resource = (BinaryResource)this.current.createResource(file.getName(), "BinaryResource");
            resource.setContent((Object)file);
            this.current.storeResource((Resource)resource);
        }
    }

    private final File[] findFiles(String pattern) {
        String pathSep = System.getProperty("file.separator", "/");
        String baseDir = ".";
        String globExpr = pattern;
        int p = pattern.lastIndexOf(pathSep);
        if (-1 < p) {
            baseDir = pattern.substring(0, p);
            globExpr = pattern.substring(p + 1);
        }
        this.messageln("base = " + baseDir + "; glob = " + globExpr);
        File dir = new File(baseDir);
        if (!dir.isDirectory() || !dir.canRead()) {
            return null;
        }
        return dir.listFiles((FileFilter)new GlobFilenameFilter(globExpr));
    }

    private synchronized boolean findRecursive(Collection collection, File dir, String base) {
        File[] temp = dir.listFiles();
        for (int i = 0; i < temp.length; ++i) {
            String next = base + '/' + temp[i].getName();
            try {
                if (temp[i].isDirectory()) {
                    this.messageln("entering directory " + temp[i].getAbsolutePath());
                    Collection c = collection.getChildCollection(temp[i].getName());
                    if (c == null) {
                        CollectionManagementService mgtService = (CollectionManagementService)collection.getService("CollectionManagementService", "1.0");
                        c = mgtService.createCollection(temp[i].getName());
                    }
                    if (c instanceof Observable && this.verbose) {
                        ProgressObserver observer = new ProgressObserver();
                        ((Observable)c).addObserver(observer);
                    }
                    this.findRecursive(c, temp[i], next);
                    continue;
                }
                long start1 = System.currentTimeMillis();
                String resourceType = this.getResourceType(temp[i].getName());
                if (resourceType == null) {
                    this.messageln("File " + temp[i].getName() + " has an unknown " + "suffix. Cannot determine file type.");
                    continue;
                }
                this.message("storing document " + temp[i].getName() + " (" + i + " of " + temp.length + ") " + "...");
                Resource document = collection.createResource(temp[i].getName(), resourceType);
                document.setContent((Object)temp[i]);
                collection.storeResource(document);
                ++this.filesCount;
                this.messageln(" " + temp[i].length() + " bytes in " + (System.currentTimeMillis() - start1) + "ms.");
                continue;
            }
            catch (XMLDBException e) {
                this.messageln("could not parse file " + temp[i].getAbsolutePath());
            }
        }
        return true;
    }

    protected synchronized boolean parse(String fileName) throws XMLDBException {
        File[] files;
        fileName = fileName.replace('/', File.separatorChar).replace('\\', File.separatorChar);
        File file = new File(fileName);
        if (this.current instanceof Observable && this.verbose) {
            ProgressObserver observer = new ProgressObserver();
            ((Observable)this.current).addObserver(observer);
        }
        if (file.canRead()) {
            if (file.isDirectory()) {
                if (this.recurseDirs) {
                    this.filesCount = 0;
                    long start = System.currentTimeMillis();
                    boolean result = this.findRecursive(this.current, file, this.path);
                    this.messageln("storing " + this.filesCount + " files took " + (System.currentTimeMillis() - start) / 1000L + "sec.");
                    return result;
                }
                files = file.listFiles(new XMLFilenameFilter());
            } else {
                files = new File[]{file};
            }
        } else {
            files = DirectoryScanner.scanDir(fileName);
        }
        long start0 = System.currentTimeMillis();
        long bytes = 0L;
        for (int i = 0; i < files.length; ++i) {
            long start = System.currentTimeMillis();
            String resourceType = this.getResourceType(files[i].getName());
            if (resourceType == null) {
                this.messageln("File " + files[i].getName() + " has an unknown " + "suffix. Cannot determine file type.");
                continue;
            }
            Resource document = this.current.createResource(files[i].getName(), resourceType);
            this.message("storing document " + files[i].getName() + " (" + (i + 1) + " of " + files.length + ") ...");
            document.setContent((Object)files[i]);
            this.current.storeResource(document);
            this.messageln("done.");
            this.messageln("parsing " + files[i].length() + " bytes took " + (System.currentTimeMillis() - start) + "ms.\n");
            bytes += files[i].length();
        }
        this.messageln("parsed " + bytes + " bytes in " + (System.currentTimeMillis() - start0) + "ms.");
        return true;
    }

    protected synchronized boolean parse(File[] files, UploadDialog upload) throws XMLDBException {
        if (!upload.isVisible()) {
            upload.setVisible(true);
        }
        if (this.current instanceof Observable) {
            ((Observable)this.current).addObserver(upload.getObserver());
        }
        upload.setTotalSize(this.calculateFileSizes(files));
        long totalSize = 0L;
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].canRead()) continue;
            if (files[i].isDirectory()) {
                totalSize = this.findRecursive(this.current, files[i], this.path, upload, totalSize);
                continue;
            }
            upload.reset();
            upload.setCurrentDir(files[i].getParentFile().getAbsolutePath());
            upload.setCurrent(files[i].getName());
            upload.setCurrentSize(files[i].length());
            try {
                String resourceType = this.getResourceType(files[i].getName());
                if (resourceType == null) {
                    upload.showMessage("File " + files[i].getName() + " has an unknown " + "suffix. Cannot determine file type.");
                } else {
                    Resource document = this.current.createResource(files[i].getName(), resourceType);
                    document.setContent((Object)files[i]);
                    this.current.storeResource(document);
                }
                upload.setStoredSize(totalSize += files[i].length());
                continue;
            }
            catch (XMLDBException e) {
                upload.showMessage("could not parse file " + files[i].getAbsolutePath() + ": " + e.getMessage());
            }
        }
        if (this.current instanceof Observable) {
            ((Observable)this.current).deleteObservers();
        }
        upload.setVisible(false);
        return true;
    }

    private long calculateFileSizes(File[] files) throws XMLDBException {
        long size = 0L;
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].canRead()) continue;
            if (files[i].isDirectory()) {
                size += this.calculateFileSizes(files[i].listFiles());
                continue;
            }
            size += files[i].length();
        }
        return size;
    }

    private long findRecursive(Collection collection, File dir, String base, UploadDialog upload, long totalSize) {
        upload.setCurrentDir(dir.getAbsolutePath());
        File[] temp = dir.listFiles();
        for (int i = 0; i < temp.length; ++i) {
            String next = base + '/' + temp[i].getName();
            try {
                if (temp[i].isDirectory()) {
                    upload.setCurrentDir(temp[i].getAbsolutePath());
                    Collection c = collection.getChildCollection(temp[i].getName());
                    if (c == null) {
                        CollectionManagementService mgtService = (CollectionManagementService)collection.getService("CollectionManagementService", "1.0");
                        c = mgtService.createCollection(temp[i].getName());
                    }
                    if (c instanceof Observable) {
                        ((Observable)c).addObserver(upload.getObserver());
                    }
                    totalSize = this.findRecursive(c, temp[i], next, upload, totalSize);
                    continue;
                }
                upload.reset();
                upload.setCurrent(temp[i].getName());
                upload.setCurrentSize(temp[i].length());
                String resourceType = this.getResourceType(temp[i].getName());
                if (resourceType == null) {
                    upload.showMessage("File " + temp[i].getName() + " has an unknown " + "suffix. Cannot determine file type.");
                } else {
                    Resource document = collection.createResource(temp[i].getName(), resourceType);
                    document.setContent((Object)temp[i]);
                    collection.storeResource(document);
                }
                ++this.filesCount;
                upload.setStoredSize(totalSize += temp[i].length());
                continue;
            }
            catch (XMLDBException e) {
                upload.showMessage("could not parse file " + temp[i].getAbsolutePath() + ": " + e.getMessage());
            }
        }
        return totalSize;
    }

    private String getResourceType(String name) {
        int p = name.lastIndexOf(46);
        if (p < 0 || p + 1 == name.length()) {
            return null;
        }
        String suffix = name.substring(p + 1);
        String resourceType = null;
        if (suffix != null) {
            if (Arrays.binarySearch(this.xmlSuffixes, suffix) < 0) {
                if (Arrays.binarySearch(this.binarySuffixes, suffix) > -1) {
                    resourceType = "BinaryResource";
                }
            } else {
                resourceType = "XMLResource";
            }
        }
        return resourceType;
    }

    private void mkcol(String collPath) throws XMLDBException {
        System.out.println("creating " + collPath);
        if (collPath.startsWith("/db")) {
            collPath = collPath.substring("/db".length());
        }
        String p = "/db";
        StringTokenizer tok = new StringTokenizer(collPath, "/");
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            p = p + '/' + token;
            Collection c = DatabaseManager.getCollection((String)(this.properties.getProperty("uri") + p), (String)this.properties.getProperty("user"), (String)this.properties.getProperty("password"));
            if (c == null) {
                CollectionManagementService mgtService = (CollectionManagementService)this.current.getService("CollectionManagementService", "1.0");
                this.current = mgtService.createCollection(token);
                continue;
            }
            this.current = c;
        }
        this.path = p;
    }

    protected Collection getCollection(String path) throws XMLDBException {
        return DatabaseManager.getCollection((String)(this.properties.getProperty("uri") + path), (String)this.properties.getProperty("user"), (String)this.properties.getProperty("password"));
    }

    /*
     * WARNING - void declaration
     */
    private char[] readPassword(InputStream in) throws IOException {
        char[] lineBuffer;
        char[] buf = lineBuffer = new char[128];
        int room = buf.length;
        int offset = 0;
        block4: while (true) {
            int c = in.read();
            switch (c) {
                case -1: 
                case 10: {
                    break block4;
                }
                case 13: {
                    int c2 = in.read();
                    if (c2 == 10 || c2 == -1) break block4;
                    if (!(in instanceof PushbackInputStream)) {
                        in = new PushbackInputStream(in);
                    }
                    ((PushbackInputStream)in).unread(c2);
                }
                default: {
                    void var7_6;
                    if (--room < 0) {
                        buf = new char[offset + 128];
                        room = buf.length - offset - 1;
                        System.arraycopy(lineBuffer, 0, buf, 0, offset);
                        Arrays.fill(lineBuffer, ' ');
                        lineBuffer = buf;
                    }
                    buf[offset++] = (char)var7_6;
                    continue block4;
                }
            }
            break;
        }
        if (offset == 0) {
            return null;
        }
        char[] ret = new char[offset];
        System.arraycopy(buf, 0, ret, 0, offset);
        Arrays.fill(buf, ' ');
        return ret;
    }

    public void run(String[] args) throws Exception {
        String home;
        boolean openQueryGui;
        boolean interactive;
        block128: {
            this.properties = new Properties(defaultProps);
            try {
                String home2 = System.getProperty("exist.home");
                File propFile = home2 == null ? new File("client.properties") : new File(home2 + System.getProperty("file.separator", "/") + "client.properties");
                InputStream pin = propFile.canRead() ? new FileInputStream(propFile) : InteractiveClient.class.getResourceAsStream("client.properties");
                if (pin != null) {
                    this.properties.load(pin);
                }
            }
            catch (IOException ioe) {
                // empty catch block
            }
            this.xmlSuffixes = this.splitProperty("suffixes.xml");
            this.binarySuffixes = this.splitProperty("suffixes.binary");
            CLArgsParser optParser = new CLArgsParser(args, OPTIONS);
            if (optParser.getErrorString() != null) {
                System.err.println("ERROR: " + optParser.getErrorString());
                return;
            }
            Vector opt = optParser.getArguments();
            int size = opt.size();
            boolean needPasswd = false;
            boolean passwdSpecified = false;
            interactive = true;
            boolean foundCollection = false;
            openQueryGui = false;
            boolean doParse = false;
            boolean doReindex = false;
            String optionRemove = null;
            String optionGet = null;
            String optionMkcol = null;
            String optionRmcol = null;
            String optionXpath = null;
            String optionQueryFile = null;
            String optionXUpdate = null;
            String optionResource = null;
            String optionOutputFile = null;
            ArrayList<String> optionalArgs = new ArrayList<String>();
            block68: for (int i = 0; i < size; ++i) {
                CLOption option = (CLOption)opt.get(i);
                switch (option.getId()) {
                    case 104: {
                        this.printUsage();
                        return;
                    }
                    case 115: {
                        this.startGUI = false;
                        continue block68;
                    }
                    case 113: {
                        this.quiet = true;
                        continue block68;
                    }
                    case 118: {
                        this.verbose = true;
                        continue block68;
                    }
                    case 108: {
                        this.properties.setProperty("uri", "xmldb:exist://");
                        continue block68;
                    }
                    case 117: {
                        this.properties.setProperty("user", option.getArgument());
                        if (passwdSpecified) continue block68;
                        needPasswd = true;
                        continue block68;
                    }
                    case 80: {
                        this.properties.setProperty("password", option.getArgument());
                        needPasswd = false;
                        passwdSpecified = true;
                        continue block68;
                    }
                    case 67: {
                        this.properties.setProperty("configuration", option.getArgument());
                        continue block68;
                    }
                    case 99: {
                        this.path = option.getArgument();
                        foundCollection = true;
                        continue block68;
                    }
                    case 102: {
                        optionResource = option.getArgument();
                        continue block68;
                    }
                    case 79: {
                        optionOutputFile = option.getArgument();
                        continue block68;
                    }
                    case 112: {
                        doParse = true;
                        if (option.getArgumentCount() == 1) {
                            optionalArgs.add(option.getArgument());
                        }
                        interactive = false;
                        continue block68;
                    }
                    case 100: {
                        this.recurseDirs = true;
                        continue block68;
                    }
                    case 114: {
                        optionRemove = option.getArgument();
                        interactive = false;
                        continue block68;
                    }
                    case 103: {
                        optionGet = option.getArgument();
                        interactive = false;
                        continue block68;
                    }
                    case 109: {
                        optionMkcol = option.getArgument();
                        foundCollection = true;
                        continue block68;
                    }
                    case 82: {
                        optionRmcol = option.getArgument();
                        foundCollection = true;
                        interactive = false;
                        continue block68;
                    }
                    case 120: {
                        optionXpath = option.getArgumentCount() == 1 ? option.getArgument() : "stdin";
                        interactive = false;
                        continue block68;
                    }
                    case 110: {
                        try {
                            this.maxResults = Integer.parseInt(option.getArgument());
                            continue block68;
                        }
                        catch (NumberFormatException e) {
                            System.err.println("parameter -n needs a valid number");
                            return;
                        }
                    }
                    case 111: {
                        this.properties.setProperty(option.getArgument(0), option.getArgument(1));
                        continue block68;
                    }
                    case 70: {
                        optionQueryFile = option.getArgument();
                        interactive = false;
                        continue block68;
                    }
                    case 116: {
                        try {
                            PARALLEL_THREADS = Integer.parseInt(option.getArgument());
                        }
                        catch (NumberFormatException e) {
                            System.err.println("parameter -t needs a valid number");
                        }
                        continue block68;
                    }
                    case 88: {
                        optionXUpdate = option.getArgument();
                        interactive = false;
                        continue block68;
                    }
                    case 84: {
                        String traceFile = option.getArgument();
                        File f = new File(traceFile);
                        try {
                            this.traceWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(f, false), "UTF-8");
                            this.traceWriter.write("<?xml version=\"1.0\"?>\r\n");
                            this.traceWriter.write("<query-log>\r\n");
                        }
                        catch (UnsupportedEncodingException e1) {
                        }
                        catch (FileNotFoundException e1) {
                            this.messageln("Cannot open file " + traceFile);
                        }
                        catch (IOException e) {}
                        continue block68;
                    }
                    case 105: {
                        doReindex = true;
                        interactive = false;
                        continue block68;
                    }
                    case 81: {
                        openQueryGui = true;
                        continue block68;
                    }
                    case 0: {
                        optionalArgs.add(option.getArgument());
                    }
                }
            }
            this.properties.setProperty("uri", URLDecoder.decode(this.properties.getProperty("uri")));
            if (!this.quiet) {
                this.printNotice();
            }
            if (interactive && this.startGUI) {
                String[] loginData = ClientFrame.getLoginData(this.properties.getProperty("user"), this.properties.getProperty("uri"));
                if (loginData == null) {
                    System.exit(0);
                }
                this.properties.setProperty("user", loginData[0]);
                this.properties.setProperty("password", loginData[1]);
                this.properties.setProperty("uri", loginData[2]);
            } else if (needPasswd) {
                try {
                    this.properties.setProperty("password", Readline.readline((String)"password: "));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            String pathSep = System.getProperty("file.separator", "/");
            home = System.getProperty("exist.home");
            if (home == null) {
                home = System.getProperty("user.dir");
            }
            this.historyFile = new File(home + File.separatorChar + ".exist_history");
            this.queryHistoryFile = new File(home + File.separatorChar + ".exist_query_history");
            if (this.queryHistoryFile.canRead()) {
                this.readQueryHistory();
            }
            if (interactive) {
                block127: {
                    try {
                        Readline.load((ReadlineLibrary)ReadlineLibrary.GnuReadline);
                        System.out.println("GNU Readline found. IMPORTANT: Don't use GNU Readline");
                        System.out.println("to work with other character encodings than ISO-8859-1.");
                    }
                    catch (UnsatisfiedLinkError ule) {
                        if (this.quiet) break block127;
                        System.out.println("GNU Readline not found. Using System.in.");
                        System.out.println("If GNU Readline is available on your system,");
                        System.out.println("add directory ./lib to your LD_LIBRARY_PATH");
                    }
                }
                Readline.setEncoding((String)"UTF-8");
                Readline.initReadline((String)"exist");
                Readline.setCompleter((ReadlineCompleter)new CollectionCompleter());
                if (this.historyFile.canRead()) {
                    try {
                        Readline.readHistoryFile((String)this.historyFile.getAbsolutePath());
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            try {
                this.connect();
            }
            catch (Exception cnf) {
                if (this.startGUI && this.frame != null) {
                    this.frame.setStatus("Connection to database failed; message: " + cnf.getMessage());
                } else {
                    System.err.println("Connection to database failed; message: " + cnf.getMessage());
                }
                cnf.printStackTrace();
                System.exit(0);
            }
            if (this.current == null) {
                if (this.startGUI && this.frame != null) {
                    this.frame.setStatus("Could not retrieve collection " + this.path);
                } else {
                    System.err.println("Could not retrieve collection " + this.path);
                }
                this.shutdown(false);
                return;
            }
            if (doReindex) {
                if (!foundCollection) {
                    System.err.println("Please specify target collection with --collection");
                    this.shutdown(false);
                    return;
                }
                try {
                    this.reindex();
                }
                catch (XMLDBException e) {
                    System.err.println("XMLDBException while removing collection: " + InteractiveClient.getExceptionMessage(e));
                    e.printStackTrace();
                }
            }
            if (optionRmcol != null) {
                if (!foundCollection) {
                    System.err.println("Please specify target collection with --collection");
                    this.shutdown(false);
                    return;
                }
                try {
                    this.rmcol(optionRmcol);
                }
                catch (XMLDBException e) {
                    System.err.println("XMLDBException while removing collection: " + InteractiveClient.getExceptionMessage(e));
                    e.printStackTrace();
                }
            }
            if (optionMkcol != null) {
                try {
                    this.mkcol(optionMkcol);
                }
                catch (XMLDBException e) {
                    System.err.println("XMLDBException during mkcol: " + InteractiveClient.getExceptionMessage(e));
                    e.printStackTrace();
                }
            }
            if (optionGet != null) {
                try {
                    Resource res = this.retrieve(optionGet);
                    if (res == null) break block128;
                    if (res.getResourceType().equals("XMLResource")) {
                        if (optionOutputFile != null) {
                            this.writeOutputFile(optionOutputFile, res.getContent());
                        } else {
                            System.out.println(res.getContent().toString());
                        }
                        break block128;
                    }
                    if (optionOutputFile != null) {
                        this.writeOutputFile(optionOutputFile, res.getContent());
                        break block128;
                    }
                    System.out.println(new String((byte[])res.getContent()));
                }
                catch (XMLDBException e) {
                    System.err.println("XMLDBException while trying to retrieve document: " + InteractiveClient.getExceptionMessage(e));
                    e.printStackTrace();
                }
            } else if (optionRemove != null) {
                if (!foundCollection) {
                    System.err.println("Please specify target collection with --collection");
                } else {
                    try {
                        this.remove(optionRemove);
                    }
                    catch (XMLDBException e) {
                        System.out.println("XMLDBException during parse: " + InteractiveClient.getExceptionMessage(e));
                        e.printStackTrace();
                    }
                }
            } else if (doParse) {
                if (!foundCollection) {
                    System.err.println("Please specify target collection with --collection");
                } else {
                    Iterator i = optionalArgs.iterator();
                    while (i.hasNext()) {
                        try {
                            this.parse((String)i.next());
                        }
                        catch (XMLDBException e) {
                            System.out.println("XMLDBException during parse: " + InteractiveClient.getExceptionMessage(e));
                            e.printStackTrace();
                        }
                    }
                }
            } else if (optionXpath != null || optionQueryFile != null) {
                String line;
                StringBuffer buf;
                if (optionQueryFile != null) {
                    BufferedReader reader = new BufferedReader(new FileReader(optionQueryFile));
                    buf = new StringBuffer();
                    while ((line = reader.readLine()) != null) {
                        buf.append(line);
                        buf.append('\n');
                    }
                    optionXpath = buf.toString();
                }
                if (optionXpath.equals("stdin")) {
                    try {
                        BufferedReader stdin = new BufferedReader(new InputStreamReader(System.in));
                        buf = new StringBuffer();
                        while ((line = stdin.readLine()) != null) {
                            buf.append(line + '\n');
                        }
                        optionXpath = buf.toString();
                    }
                    catch (IOException e) {
                        System.err.println("failed to read query from stdin");
                        optionXpath = null;
                    }
                }
                if (optionXpath != null) {
                    try {
                        ResourceSet result = this.find(optionXpath);
                        if (this.maxResults <= 0) {
                            this.maxResults = (int)result.getSize();
                        }
                        if (optionOutputFile == null) {
                            for (int i = 0; i < this.maxResults && (long)i < result.getSize(); ++i) {
                                System.out.println(result.getResource((long)i).getContent());
                            }
                            break block128;
                        }
                        FileWriter writer = new FileWriter(optionOutputFile, false);
                        for (int i = 0; i < this.maxResults && (long)i < result.getSize(); ++i) {
                            writer.write(result.getResource((long)i).getContent().toString());
                        }
                        writer.close();
                    }
                    catch (XMLDBException e) {
                        System.err.println("XMLDBException during query: " + InteractiveClient.getExceptionMessage(e));
                        e.printStackTrace();
                    }
                }
            } else if (optionXUpdate != null) {
                try {
                    this.xupdate(optionResource, optionXUpdate);
                }
                catch (XMLDBException e) {
                    System.err.println("XMLDBException during xupdate: " + InteractiveClient.getExceptionMessage(e));
                }
                catch (IOException e) {
                    System.err.println("IOException during xupdate: " + InteractiveClient.getExceptionMessage(e));
                }
            }
        }
        if (interactive) {
            if (this.startGUI) {
                this.frame = new ClientFrame(this, this.path, this.properties);
                this.frame.setLocation(100, 100);
                this.frame.setSize(500, 450);
                this.frame.setVisible(true);
            }
            try {
                this.getResources();
            }
            catch (XMLDBException e) {
                if (!this.startGUI || this.frame == null) {
                    System.out.println("XMLDBException while retrieving collection contents: " + InteractiveClient.getExceptionMessage(e));
                    e.getCause().printStackTrace();
                } else {
                    ClientFrame.showErrorMessage("XMLDBException occurred while retrieving collection: " + InteractiveClient.getExceptionMessage(e), e);
                    this.frame.dispose();
                }
                System.exit(1);
            }
            this.messageln("\ntype help or ? for help.");
            if (openQueryGui) {
                QueryDialog qd = new QueryDialog(this, this.current, this.properties);
                qd.setLocation(100, 100);
                qd.setVisible(true);
            } else if (!this.startGUI) {
                this.readlineInputLoop(home);
            } else {
                this.frame.displayPrompt();
            }
        } else {
            this.shutdown(false);
        }
    }

    public static final String getExceptionMessage(Throwable e) {
        Throwable cause;
        while ((cause = e.getCause()) != null) {
            e = cause;
        }
        return e.getMessage();
    }

    protected void readQueryHistory() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(this.queryHistoryFile);
            NodeList nodes = doc.getElementsByTagName("query");
            for (int i = 0; i < nodes.getLength(); ++i) {
                Element query = (Element)nodes.item(i);
                StringBuffer value = new StringBuffer();
                for (Node next = query.getFirstChild(); next != null; next = next.getNextSibling()) {
                    value.append(next.getNodeValue());
                }
                this.queryHistory.addLast(value.toString());
            }
        }
        catch (Exception e) {
            if (this.startGUI) {
                ClientFrame.showErrorMessage("Error while reading query history: " + e.getMessage(), e);
            }
            this.messageln("Error while reading query history: " + e.getMessage());
        }
    }

    protected void addToHistory(String query) {
        this.queryHistory.add(query);
    }

    protected void writeQueryHistory() {
        try {
            Readline.writeHistoryFile((String)this.historyFile.getAbsolutePath());
        }
        catch (Exception e) {
            // empty catch block
        }
        Readline.cleanup();
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(this.queryHistoryFile));
            SAXSerializer serializer = SAXSerializerPool.getInstance().borrowSAXSerializer();
            serializer.setWriter(writer);
            serializer.setOutputProperties(null);
            int p = 0;
            if (this.queryHistory.size() > 20) {
                p = this.queryHistory.size() - 20;
            }
            AttributesImpl attrs = new AttributesImpl();
            serializer.startDocument();
            serializer.startElement("", "history", "history", attrs);
            ListIterator i = this.queryHistory.listIterator(p);
            while (i.hasNext()) {
                serializer.startElement("", "query", "query", attrs);
                String next = (String)i.next();
                serializer.characters(next.toCharArray(), 0, next.length());
                serializer.endElement("", "query", "query");
            }
            serializer.endElement("", "history", "history");
            serializer.endDocument();
            writer.close();
            SAXSerializerPool.getInstance().returnSAXSerializer(serializer);
        }
        catch (IOException e) {
            System.err.println("IO error while writing query history.");
        }
        catch (SAXException e) {
            System.err.println("SAX exception while writing query history.");
        }
    }

    public void readlineInputLoop(String home) {
        boolean cont = true;
        while (cont) {
            try {
                String line = this.properties.getProperty("colors").equals("true") ? Readline.readline((String)("\u001b[0;36mexist:" + this.path + ">" + ANSI_WHITE)) : Readline.readline((String)("exist:" + this.path + ">"));
                if (line == null) continue;
                cont = this.process(line);
            }
            catch (EOFException e) {
                break;
            }
            catch (IOException ioe) {
                System.err.println(ioe);
            }
            catch (Exception e) {
                System.err.println(e);
            }
        }
        try {
            Readline.writeHistoryFile((String)this.historyFile.getAbsolutePath());
        }
        catch (Exception e) {
            System.err.println("Could not write history File to " + this.historyFile.getAbsolutePath());
        }
        Readline.cleanup();
        this.shutdown(false);
        this.messageln("quit.");
    }

    protected final void shutdown(boolean force) {
        if (this.traceWriter != null) {
            try {
                this.traceWriter.write("</query-log>");
                this.traceWriter.close();
            }
            catch (IOException e1) {
                // empty catch block
            }
        }
        try {
            DatabaseInstanceManager mgr = (DatabaseInstanceManager)this.current.getService("DatabaseInstanceManager", "1.0");
            if (mgr == null) {
                System.err.println("service is not available");
            } else if (mgr.isLocalInstance() || force) {
                System.out.println("shutting down database...");
                mgr.shutdown();
            }
        }
        catch (XMLDBException e) {
            System.err.println("database shutdown failed: ");
            e.printStackTrace();
        }
    }

    private final void printUsage() {
        System.out.println("Usage: java " + InteractiveClient.class.getName() + " [options]");
        System.out.println(CLUtil.describeOptions((CLOptionDescriptor[])OPTIONS).toString());
    }

    public void printNotice() {
        this.messageln("eXist version 1.0, Copyright (C) 2004 Wolfgang Meier");
        this.messageln("eXist comes with ABSOLUTELY NO WARRANTY.");
        this.messageln("This is free software, and you are welcome to redistribute it\nunder certain conditions; for details read the license file.\n");
    }

    private final void message(String msg) {
        if (!this.quiet) {
            if (this.startGUI && this.frame != null) {
                this.frame.display(msg);
            } else {
                System.out.print(msg);
            }
        }
    }

    private final void messageln(String msg) {
        if (!this.quiet) {
            if (this.startGUI && this.frame != null) {
                this.frame.display(msg + '\n');
            } else {
                System.out.println(msg);
            }
        }
    }

    private Collection resolveCollection(String path) throws XMLDBException {
        return DatabaseManager.getCollection((String)(this.properties.getProperty("uri") + path), (String)this.properties.getProperty("user"), (String)this.properties.getProperty("password"));
    }

    private Resource resolveResource(String path) throws XMLDBException {
        String collectionPath;
        String resourceName = path;
        int p = path.lastIndexOf(47);
        if (p < 0) {
            collectionPath = this.current.getName();
        } else {
            collectionPath = path.substring(0, p);
            resourceName = path.substring(p + 1);
        }
        Collection collection = this.resolveCollection(collectionPath);
        if (collection == null) {
            this.messageln("Collection " + collectionPath + " not found.");
            return null;
        }
        this.messageln("Locating resource " + resourceName + " in collection " + collection.getName());
        return collection.getResource(resourceName);
    }

    private String[] splitProperty(String key) {
        String value = this.properties.getProperty(key);
        if (value == null) {
            return new String[0];
        }
        StringTokenizer tok = new StringTokenizer(value, ", ");
        Object[] values = new String[tok.countTokens()];
        int i = 0;
        while (tok.hasMoreTokens()) {
            values[i] = tok.nextToken();
            ++i;
        }
        Arrays.sort(values);
        return values;
    }

    private void writeOutputFile(String fileName, Object data) throws Exception {
        File file = new File(fileName);
        FileOutputStream os = new FileOutputStream(file);
        if (data instanceof byte[]) {
            os.write((byte[])data);
            os.close();
        } else {
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)os, Charset.forName(this.properties.getProperty("encoding")));
            writer.write(data.toString());
            writer.close();
        }
    }

    private static String formatString(String s1, String s2, int width) {
        StringBuffer buf = new StringBuffer(width);
        if (s1.length() > width) {
            s1 = s1.substring(0, width - 1);
        }
        buf.append(s1);
        int fill = width - (s1.length() + s2.length());
        for (int i = 0; i < fill; ++i) {
            buf.append(' ');
        }
        buf.append(s2);
        return buf.toString();
    }

    private static String formatString(String[] args, int[] sizes) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < args.length; ++i) {
            int j;
            if (sizes[i] < 0) {
                buf.append(args[i]);
            } else {
                for (j = 0; j < sizes[i] && j < args[i].length(); ++j) {
                    buf.append(args[i].charAt(j));
                }
            }
            for (j = 0; j < sizes[i] - args[i].length(); ++j) {
                buf.append(' ');
            }
        }
        return buf.toString();
    }

    public static class CollectionName {
        String name_;

        public CollectionName(String name) {
            this.name_ = name;
        }

        public String toString() {
            return this.name_;
        }
    }

    public static class ProgressObserver
    implements Observer {
        ProgressBar elementsProgress = new ProgressBar("storing elements");
        Observable lastObservable = null;
        ProgressBar parseProgress = new ProgressBar("storing nodes   ");
        ProgressBar wordsProgress = new ProgressBar("storing words   ");

        public void update(Observable o, Object obj) {
            ProgressIndicator ind = (ProgressIndicator)obj;
            if (this.lastObservable == null || o != this.lastObservable) {
                System.out.println();
            }
            if (o instanceof ElementIndex) {
                this.elementsProgress.set(ind.getValue(), ind.getMax());
            } else if (o instanceof TextSearchEngine) {
                this.wordsProgress.set(ind.getValue(), ind.getMax());
            } else {
                this.parseProgress.set(ind.getValue(), ind.getMax());
            }
            this.lastObservable = o;
        }
    }

    private class CollectionCompleter
    implements ReadlineCompleter {
        Iterator possibleValues;

        private CollectionCompleter() {
        }

        public String completer(String text, int state) {
            String nextKey;
            if (state == 0) {
                this.possibleValues = InteractiveClient.this.completitions.tailSet(text).iterator();
            }
            if (this.possibleValues.hasNext() && (nextKey = (String)this.possibleValues.next()).startsWith(text)) {
                return nextKey;
            }
            return null;
        }
    }

    private class QueryThread
    extends Thread {
        ArrayList queries;

        public QueryThread(ArrayList queries) {
            this.queries = queries;
        }

        public void run() {
            try {
                Collection collection = DatabaseManager.getCollection((String)(InteractiveClient.this.properties.getProperty("uri") + InteractiveClient.this.path), (String)InteractiveClient.this.properties.getProperty("user"), (String)InteractiveClient.this.properties.getProperty("password"));
                XPathQueryService service = (XPathQueryService)InteractiveClient.this.current.getService("XPathQueryService", "1.0");
                service.setProperty("indent", "yes");
                service.setProperty("encoding", InteractiveClient.this.properties.getProperty("encoding"));
                Random r = new Random(System.currentTimeMillis());
                for (int i = 0; i < 10; ++i) {
                    String query = (String)this.queries.get(r.nextInt(this.queries.size()));
                    System.out.println(this.getName() + " query: " + query);
                    ResourceSet result = service.query(query);
                    System.out.println(this.getName() + " found: " + result.getSize());
                }
            }
            catch (XMLDBException e) {
                System.err.println("ERROR: " + e.getMessage());
            }
            System.out.println(this.getName() + " finished.");
        }
    }
}

