/*
 * Decompiled with CFR 0.152.
 */
package org.exist.backup;

import java.awt.Dimension;
import java.awt.Frame;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Properties;
import javax.swing.JFrame;
import org.exist.backup.BackupDialog;
import org.exist.security.Permission;
import org.exist.util.serializer.SAXSerializer;
import org.exist.util.serializer.SAXSerializerPool;
import org.exist.xmldb.CollectionImpl;
import org.exist.xmldb.EXistResource;
import org.exist.xmldb.UserManagementService;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Database;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.XMLResource;

public class Backup {
    private String backupDir;
    private String rootCollection;
    private String user;
    private String pass;
    public static final String NS = "http://exist.sourceforge.net/NS/exist";
    public static final Properties defaultOutputProperties = new Properties();

    public Backup(String user, String pass, String backupDir, String rootCollection) {
        this.user = user;
        this.pass = pass;
        this.backupDir = backupDir;
        this.rootCollection = rootCollection;
    }

    public Backup(String user, String pass, String backupDir) {
        this(user, pass, backupDir, "xmldb:exist:///db");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void backup(boolean guiMode, JFrame parent) throws XMLDBException, IOException, SAXException {
        Collection current = DatabaseManager.getCollection((String)this.rootCollection, (String)this.user, (String)this.pass);
        if (guiMode) {
            BackupDialog dialog = new BackupDialog((Frame)parent, false);
            dialog.setSize(new Dimension(350, 150));
            dialog.setVisible(true);
            BackupThread thread = new BackupThread(current, dialog);
            thread.start();
            if (parent == null) {
                while (thread.isAlive()) {
                    Backup backup = this;
                    synchronized (backup) {
                        try {
                            this.wait(20L);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                    }
                }
            }
        } else {
            this.backup(current, null);
        }
    }

    private void backup(Collection current, BackupDialog dialog) throws XMLDBException, IOException, SAXException {
        File file;
        if (current == null) {
            return;
        }
        current.setProperty("encoding", "UTF-8");
        current.setProperty("indent", "no");
        current.setProperty("expand-xincludes", "no");
        current.setProperty("process-xsl-pi", "no");
        String[] resources = current.listResources();
        String cname = current.getName();
        if (cname.charAt(0) != '/') {
            cname = '/' + cname;
        }
        String path = this.backupDir + cname;
        UserManagementService mgtService = (UserManagementService)current.getService("UserManagementService", "1.0");
        Permission[] perms = mgtService.listResourcePermissions();
        Permission currentPerms = mgtService.getPermissions(current);
        if (dialog != null) {
            dialog.setCollection(current.getName());
            dialog.setResourceCount(resources.length);
        }
        if ((file = new File(path)).exists()) {
            System.out.println("removing " + path);
            file.delete();
        }
        file.mkdirs();
        BufferedWriter contents = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(path + '/' + "__contents__.xml"), "UTF-8"));
        SAXSerializer serializer = SAXSerializerPool.getInstance().borrowSAXSerializer();
        serializer.setWriter(contents);
        serializer.setOutputProperties(defaultOutputProperties);
        serializer.startDocument();
        serializer.startPrefixMapping("", NS);
        CollectionImpl cur = (CollectionImpl)current;
        AttributesImpl attr = new AttributesImpl();
        attr.addAttribute(NS, "name", "name", "CDATA", current.getName());
        attr.addAttribute(NS, "owner", "owner", "CDATA", currentPerms.getOwner());
        attr.addAttribute(NS, "group", "group", "CDATA", currentPerms.getOwnerGroup());
        attr.addAttribute(NS, "mode", "mode", "CDATA", Integer.toOctalString(currentPerms.getPermissions()));
        attr.addAttribute(NS, "created", "created", "CDATA", cur.getCreationTime().toString());
        serializer.startElement(NS, "collection", "collection", attr);
        for (int i = 0; i < resources.length; ++i) {
            Resource resource = current.getResource(resources[i]);
            file = new File(path);
            if (!file.exists()) {
                file.mkdirs();
            }
            if (dialog == null) {
                System.out.println("writing " + path + '/' + resources[i]);
            } else {
                dialog.setResource(resources[i]);
                dialog.setProgress(i);
            }
            FileOutputStream os = new FileOutputStream(path + '/' + resources[i]);
            if (resource.getResourceType().equals("BinaryResource")) {
                byte[] bdata = (byte[])resource.getContent();
                os.write(bdata);
                os.close();
            } else {
                try {
                    BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)os, "UTF-8"));
                    SAXSerializer contentSerializer = SAXSerializerPool.getInstance().borrowSAXSerializer();
                    contentSerializer.setWriter(writer);
                    contentSerializer.setOutputProperties(defaultOutputProperties);
                    ((EXistResource)resource).setLexicalHandler(contentSerializer);
                    ((XMLResource)resource).getContentAsSAX((ContentHandler)contentSerializer);
                    SAXSerializerPool.getInstance().returnSAXSerializer(contentSerializer);
                    writer.close();
                }
                catch (Exception e) {
                    System.err.println("An exception occurred while writing the resource: " + e.getMessage());
                    e.printStackTrace();
                    continue;
                }
            }
            EXistResource ris = (EXistResource)resource;
            attr.clear();
            attr.addAttribute(NS, "type", "type", "CDATA", resource.getResourceType());
            attr.addAttribute(NS, "name", "name", "CDATA", resources[i]);
            attr.addAttribute(NS, "owner", "owner", "CDATA", perms[i].getOwner());
            attr.addAttribute(NS, "group", "group", "CDATA", perms[i].getOwnerGroup());
            attr.addAttribute(NS, "mode", "mode", "CDATA", Integer.toOctalString(perms[i].getPermissions()));
            attr.addAttribute(NS, "created", "created", "CDATA", ris.getCreationTime().toString());
            attr.addAttribute(NS, "modified", "modified", "CDATA", ris.getLastModificationTime().toString());
            serializer.startElement(NS, "resource", "resource", attr);
            serializer.endElement(NS, "resource", "resource");
        }
        String[] collections = current.listChildCollections();
        for (int i = 0; i < collections.length; ++i) {
            if (current.getName().equals("db") && collections[i].equals("system")) continue;
            attr.clear();
            attr.addAttribute(NS, "name", "name", "CDATA", collections[i]);
            serializer.startElement(NS, "subcollection", "subcollection", attr);
            serializer.endElement(NS, "subcollection", "subcollection");
        }
        serializer.endElement(NS, "collection", "collection");
        serializer.endPrefixMapping("");
        serializer.endDocument();
        contents.close();
        SAXSerializerPool.getInstance().returnSAXSerializer(serializer);
        for (int i = 0; i < collections.length; ++i) {
            Collection child = current.getChildCollection(collections[i]);
            this.backup(child, dialog);
        }
    }

    public static void main(String[] args) {
        try {
            Class<?> cl = Class.forName("org.exist.xmldb.DatabaseImpl");
            Database database = (Database)cl.newInstance();
            database.setProperty("create-database", "true");
            DatabaseManager.registerDatabase((Database)database);
            Backup backup = new Backup("admin", null, "backup", args[0]);
            backup.backup(false, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        defaultOutputProperties.setProperty("indent", "yes");
        defaultOutputProperties.setProperty("encoding", "UTF-8");
        defaultOutputProperties.setProperty("omit-xml-declaration", "no");
    }

    class BackupThread
    extends Thread {
        Collection collection_;
        BackupDialog dialog_;

        public BackupThread(Collection collection, BackupDialog dialog) {
            this.collection_ = collection;
            this.dialog_ = dialog;
        }

        public void run() {
            try {
                Backup.this.backup(this.collection_, this.dialog_);
                this.dialog_.setVisible(false);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

