/*
 * Decompiled with CFR 0.152.
 */
package org.exist;

import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Logger;
import org.exist.EXistException;
import org.exist.dom.AttrImpl;
import org.exist.dom.CommentImpl;
import org.exist.dom.DocumentImpl;
import org.exist.dom.DocumentTypeImpl;
import org.exist.dom.ElementImpl;
import org.exist.dom.NodeObjectPool;
import org.exist.dom.ProcessingInstructionImpl;
import org.exist.dom.QName;
import org.exist.dom.TextImpl;
import org.exist.storage.DBBroker;
import org.exist.storage.NodePath;
import org.exist.util.Configuration;
import org.exist.util.FastStringBuffer;
import org.exist.util.ProgressIndicator;
import org.exist.util.XMLString;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.LexicalHandler;

public class Indexer
extends Observable
implements ContentHandler,
LexicalHandler,
ErrorHandler {
    private static final Logger LOG = Logger.getLogger((Class)Indexer.class);
    protected DBBroker broker = null;
    protected XMLString charBuf = new XMLString();
    protected int currentLine = 0;
    protected NodePath currentPath = new NodePath();
    protected DocumentImpl document = null;
    protected boolean insideDTD = false;
    protected boolean validate = false;
    protected int level = 0;
    protected Locator locator = null;
    protected int normalize = 3;
    protected Map nsMappings = new HashMap();
    protected Element rootNode;
    protected Stack stack = new Stack();
    protected boolean privileged = false;
    protected String ignorePrefix = null;
    protected ProgressIndicator progress;
    protected boolean suppressWSmixed = false;
    private TextImpl text = new TextImpl();
    private Stack usedElements = new Stack();
    private FastStringBuffer temp = new FastStringBuffer();
    static /* synthetic */ Class class$org$exist$dom$AttrImpl;

    public Indexer(DBBroker broker) throws EXistException {
        this(broker, false);
    }

    public Indexer(DBBroker broker, boolean priv) throws EXistException {
        Boolean temp;
        this.broker = broker;
        this.privileged = priv;
        Configuration config = broker.getConfiguration();
        String suppressWS = (String)config.getProperty("indexer.suppress-whitespace");
        if (suppressWS != null) {
            if (suppressWS.equals("leading")) {
                this.normalize = 1;
            } else if (suppressWS.equals("trailing")) {
                this.normalize = 2;
            } else if (suppressWS.equals("none")) {
                this.normalize = 0;
            }
        }
        if ((temp = (Boolean)config.getProperty("indexer.preserve-whitespace-mixed-content")) != null) {
            this.suppressWSmixed = temp;
        }
    }

    public void setBroker(DBBroker broker) {
        this.broker = broker;
    }

    public void setValidating(boolean validate) {
        this.validate = validate;
    }

    public void setDocument(DocumentImpl doc) {
        this.document = doc;
        this.level = 0;
        this.currentPath.reset();
        this.stack = new Stack();
        this.nsMappings.clear();
        this.rootNode = null;
    }

    public void setDocumentObject(DocumentImpl doc) {
        this.document = doc;
    }

    public DocumentImpl getDocument() {
        return this.document;
    }

    public void characters(char[] ch, int start, int length) {
        if (length <= 0) {
            return;
        }
        if (this.charBuf != null) {
            this.charBuf.append(ch, start, length);
        } else {
            this.charBuf = new XMLString(ch, start, length);
        }
    }

    public void comment(char[] ch, int start, int length) {
        if (this.insideDTD) {
            return;
        }
        CommentImpl comment = new CommentImpl(ch, start, length);
        comment.setOwnerDocument(this.document);
        if (this.stack.empty()) {
            if (!this.validate) {
                this.broker.store(comment, this.currentPath);
            }
            this.document.appendChild(comment);
        } else {
            ElementImpl last = (ElementImpl)this.stack.peek();
            if (this.charBuf != null && this.charBuf.length() > 0) {
                XMLString normalized = this.charBuf.normalize(this.normalize);
                if (normalized.length() > 0) {
                    this.text.setData(normalized);
                    this.text.setOwnerDocument(this.document);
                    last.appendChildInternal(this.text);
                    if (!this.validate) {
                        this.broker.store(this.text, this.currentPath);
                    }
                }
                this.charBuf.reset();
            }
            last.appendChildInternal(comment);
            if (!this.validate) {
                this.broker.store(comment, this.currentPath);
            }
        }
    }

    public void endCDATA() {
    }

    public void endDTD() {
        this.insideDTD = false;
    }

    public void endDocument() {
        if (!this.validate) {
            this.progress.finish();
            this.setChanged();
            this.notifyObservers(this.progress);
        }
    }

    public void endElement(String namespace, String name, String qname) {
        ElementImpl last = (ElementImpl)this.stack.peek();
        if (last.getNodeName().equals(qname)) {
            if (this.charBuf != null && this.charBuf.length() > 0) {
                XMLString normalized;
                XMLString xMLString = last.getChildCount() == 0 ? this.charBuf.normalize(this.normalize) : (normalized = this.charBuf.isWhitespaceOnly() ? null : this.charBuf);
                if (normalized != null && normalized.length() > 0) {
                    this.text.setData(normalized);
                    this.text.setOwnerDocument(this.document);
                    last.appendChildInternal(this.text);
                    if (!this.validate) {
                        this.broker.store(this.text, this.currentPath);
                    }
                    this.text.clear();
                }
                this.charBuf.reset();
            }
            this.stack.pop();
            this.currentPath.removeLastComponent();
            if (this.validate) {
                if (this.document.getTreeLevelOrder(this.level) < last.getChildCount()) {
                    this.document.setTreeLevelOrder(this.level, last.getChildCount());
                }
            } else {
                this.document.setOwnerDocument(this.document);
                if (last.getChildCount() > 0) {
                    this.broker.update(last);
                }
            }
            --this.level;
            if (last != this.rootNode) {
                last.clear();
                this.usedElements.push(last);
            }
        }
    }

    public void endEntity(String name) {
    }

    public void endPrefixMapping(String prefix) {
        if (this.ignorePrefix != null && prefix.equals(this.ignorePrefix)) {
            this.ignorePrefix = null;
        } else {
            this.nsMappings.remove(prefix);
        }
    }

    public void error(SAXParseException e) throws SAXException {
        LOG.debug((Object)("error at line " + e.getLineNumber()), (Throwable)e);
        throw new SAXException("error at line " + e.getLineNumber() + ": " + e.getMessage(), e);
    }

    public void fatalError(SAXParseException e) throws SAXException {
        LOG.debug((Object)("fatal error at line " + e.getLineNumber()), (Throwable)e);
        throw new SAXException("fatal error at line " + e.getLineNumber() + ": " + e.getMessage(), e);
    }

    public void ignorableWhitespace(char[] ch, int start, int length) {
    }

    public void processingInstruction(String target, String data) {
        ProcessingInstructionImpl pi = new ProcessingInstructionImpl(0L, target, data);
        pi.setOwnerDocument(this.document);
        if (this.stack.isEmpty()) {
            if (!this.validate) {
                this.broker.store(pi, this.currentPath);
            }
            this.document.appendChild(pi);
        } else {
            ElementImpl last = (ElementImpl)this.stack.peek();
            if (this.charBuf != null && this.charBuf.length() > 0) {
                XMLString normalized = this.charBuf.normalize(this.normalize);
                if (normalized.length() > 0) {
                    this.text.setData(normalized);
                    this.text.setOwnerDocument(this.document);
                    last.appendChildInternal(this.text);
                    if (!this.validate) {
                        this.broker.store(this.text, this.currentPath);
                    }
                    this.text.clear();
                }
                this.charBuf.reset();
            }
            last.appendChildInternal(pi);
            if (!this.validate) {
                this.broker.store(pi, this.currentPath);
            }
        }
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    private void setFeature(SAXParserFactory factory, String feature, boolean value) {
        try {
            factory.setFeature(feature, value);
        }
        catch (SAXNotRecognizedException e) {
            LOG.warn((Object)e);
        }
        catch (SAXNotSupportedException snse) {
            LOG.warn((Object)snse);
        }
        catch (ParserConfigurationException pce) {
            LOG.warn((Object)pce);
        }
    }

    public void skippedEntity(String name) {
    }

    public void startCDATA() {
    }

    public void startDTD(String name, String publicId, String systemId) {
        DocumentTypeImpl docType = new DocumentTypeImpl(name, publicId, systemId);
        this.document.setDocumentType(docType);
        this.insideDTD = true;
    }

    public void startDocument() {
        if (!this.validate) {
            this.progress = new ProgressIndicator(this.currentLine, 100);
            if (this.document.getDoctype() == null) {
                DocumentTypeImpl dt = new DocumentTypeImpl(this.rootNode.getTagName(), null, this.document.getFileName());
                this.document.setDocumentType(dt);
            }
            this.document.setChildCount(0);
        }
    }

    public void startElement(String namespace, String name, String qname, Attributes attributes) {
        String attrQName;
        String attrNS;
        int attrLength = attributes.getLength();
        for (int i = 0; i < attributes.getLength(); ++i) {
            attrNS = attributes.getURI(i);
            attrQName = attributes.getQName(i);
            if (!attrQName.startsWith("xmlns") && !attrNS.equals("http://exist.sourceforge.net/NS/exist")) continue;
            --attrLength;
        }
        ElementImpl last = null;
        ElementImpl node = null;
        int p = qname.indexOf(58);
        String prefix = p > -1 ? qname.substring(0, p) : "";
        QName qn = this.broker.getSymbols().getQName(namespace, name, prefix);
        if (!this.stack.empty()) {
            last = (ElementImpl)this.stack.peek();
            if (this.charBuf != null) {
                if (this.charBuf.isWhitespaceOnly()) {
                    if (this.suppressWSmixed && this.charBuf.length() > 0 && last.getChildCount() > 0) {
                        this.text.setData(this.charBuf);
                        this.text.setOwnerDocument(this.document);
                        last.appendChildInternal(this.text);
                        if (!this.validate) {
                            this.broker.store(this.text, this.currentPath);
                        }
                        this.text.clear();
                    }
                } else if (this.charBuf.length() > 0) {
                    this.text.setData(this.charBuf);
                    this.text.setOwnerDocument(this.document);
                    last.appendChildInternal(this.text);
                    if (!this.validate) {
                        this.broker.store(this.text, this.currentPath);
                    }
                    this.text.clear();
                }
                this.charBuf.reset();
            }
            if (!this.usedElements.isEmpty()) {
                node = (ElementImpl)this.usedElements.pop();
                node.setNodeName(qn);
            } else {
                node = new ElementImpl(qn);
            }
            last.appendChildInternal(node);
            node.setOwnerDocument(this.document);
            node.setAttributes((short)attrLength);
            if (this.nsMappings != null && this.nsMappings.size() > 0) {
                node.setNamespaceMappings(this.nsMappings);
                this.nsMappings.clear();
            }
            this.stack.push(node);
            this.currentPath.addComponent(qname);
            if (!this.validate) {
                this.broker.store(node, this.currentPath);
            }
        } else {
            node = this.validate ? new ElementImpl(0L, qn) : new ElementImpl(1L, qn);
            this.rootNode = node;
            node.setOwnerDocument(this.document);
            node.setAttributes((short)attrLength);
            if (this.nsMappings != null && this.nsMappings.size() > 0) {
                node.setNamespaceMappings(this.nsMappings);
                this.nsMappings.clear();
            }
            this.stack.push(node);
            this.currentPath.addComponent(qname);
            if (!this.validate) {
                this.broker.store(node, this.currentPath);
            }
            this.document.appendChild(node);
        }
        ++this.level;
        if (this.document.getMaxDepth() < this.level) {
            this.document.setMaxDepth(this.level);
        }
        for (int i = 0; i < attributes.getLength(); ++i) {
            attrNS = attributes.getURI(i);
            String attrLocalName = attributes.getLocalName(i);
            attrQName = attributes.getQName(i);
            if (attrQName.startsWith("xmlns") || attrNS.equals("http://exist.sourceforge.net/NS/exist")) {
                --attrLength;
                continue;
            }
            p = attrQName.indexOf(58);
            String attrPrefix = p > -1 ? attrQName.substring(0, p) : null;
            AttrImpl attr = (AttrImpl)NodeObjectPool.getInstance().borrowNode(class$org$exist$dom$AttrImpl == null ? Indexer.class$("org.exist.dom.AttrImpl") : class$org$exist$dom$AttrImpl);
            attr.setNodeName(this.document.getSymbols().getQName(attrNS, attrLocalName, attrPrefix));
            attr.setValue(attributes.getValue(i));
            attr.setOwnerDocument(this.document);
            if (attributes.getType(i).equals("ID")) {
                attr.setType(1);
            }
            node.appendChildInternal(attr);
            if (!this.validate) {
                this.broker.store(attr, this.currentPath);
            }
            attr.release();
        }
        if (attrLength > 0) {
            node.setAttributes((short)attrLength);
        }
        if (this.locator != null) {
            this.currentLine = this.locator.getLineNumber();
            if (!this.validate) {
                this.progress.setValue(this.currentLine);
                if (this.progress.changed()) {
                    this.setChanged();
                    this.notifyObservers(this.progress);
                }
            }
        }
    }

    public void startEntity(String name) {
    }

    public void startPrefixMapping(String prefix, String uri) {
        if (uri.equals("http://exist.sourceforge.net/NS/exist")) {
            this.ignorePrefix = prefix;
            return;
        }
        this.nsMappings.put(prefix, uri);
    }

    public void prepareForStore() {
    }

    public void warning(SAXParseException e) throws SAXException {
        LOG.debug((Object)("warning at line " + e.getLineNumber()), (Throwable)e);
        throw new SAXException("warning at line " + e.getLineNumber() + ": " + e.getMessage(), e);
    }

    private static StringBuffer removeLastPathComponent(StringBuffer path) {
        int i = -1;
        for (i = path.length() - 1; i > -1 && path.charAt(i) != '/'; --i) {
        }
        if (i < 0) {
            return path;
        }
        return path.delete(i, path.length());
    }
}

