/*
 * Decompiled with CFR 0.152.
 */
package org.dbxml.core.filer;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;
import org.apache.log4j.Logger;
import org.dbxml.core.DBException;
import org.dbxml.core.data.Value;
import org.exist.util.ByteConversion;

public abstract class Paged {
    protected static final Logger LOG = Logger.getLogger((Class)Paged.class);
    protected static final byte DELETED = 127;
    protected static final byte OVERFLOW = 126;
    protected static final byte UNUSED = 0;
    protected static int PAGE_SIZE = 4096;
    private RandomAccessFile raf;
    private File file;
    private FileHeader fileHeader = this.createFileHeader();
    private boolean readOnly = false;
    private boolean fileIsNew = false;
    private byte[] tempPageData = new byte[FileHeader.access$000(this.fileHeader)];
    private byte[] tempHeaderData = new byte[FileHeader.access$100(this.fileHeader)];
    private static String[] hex = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};

    public Paged() {
    }

    public Paged(File file) {
        this();
        this.setFile(file);
    }

    public short getFileVersion() {
        return 0;
    }

    public static final void setPageSize(int pageSize) {
        PAGE_SIZE = pageSize;
    }

    public static final int getPageSize() {
        return PAGE_SIZE;
    }

    public static int[] deleteArrayInt(int[] vals, int idx) {
        int[] newVals = new int[vals.length - 1];
        if (idx > 0) {
            System.arraycopy(vals, 0, newVals, 0, idx);
        }
        if (idx < newVals.length) {
            System.arraycopy(vals, idx + 1, newVals, idx, newVals.length - idx);
        }
        return newVals;
    }

    public static long[] deleteArrayLong(long[] vals, int idx) {
        long[] newVals = new long[vals.length - 1];
        if (idx > 0) {
            System.arraycopy(vals, 0, newVals, 0, idx);
        }
        if (idx < newVals.length) {
            System.arraycopy(vals, idx + 1, newVals, idx, newVals.length - idx);
        }
        return newVals;
    }

    public static short[] deleteArrayShort(short[] vals, int idx) {
        short[] newVals = new short[vals.length - 1];
        if (idx > 0) {
            System.arraycopy(vals, 0, newVals, 0, idx);
        }
        if (idx < newVals.length) {
            System.arraycopy(vals, idx + 1, newVals, idx, newVals.length - idx);
        }
        return newVals;
    }

    public static Value[] deleteArrayValue(Value[] vals, int idx) {
        Value[] newVals = new Value[vals.length - 1];
        if (idx > 0) {
            System.arraycopy(vals, 0, newVals, 0, idx);
        }
        if (idx < newVals.length) {
            System.arraycopy(vals, idx + 1, newVals, idx, newVals.length - idx);
        }
        return newVals;
    }

    public static int[] insertArrayInt(int[] vals, int val, int idx) {
        int[] newVals = new int[vals.length + 1];
        if (idx > 0) {
            System.arraycopy(vals, 0, newVals, 0, idx);
        }
        newVals[idx] = val;
        if (idx < vals.length) {
            System.arraycopy(vals, idx, newVals, idx + 1, vals.length - idx);
        }
        return newVals;
    }

    public static long[] insertArrayLong(long[] vals, long val, int idx) {
        long[] newVals = new long[vals.length + 1];
        if (idx > 0) {
            System.arraycopy(vals, 0, newVals, 0, idx);
        }
        newVals[idx] = val;
        if (idx < vals.length) {
            System.arraycopy(vals, idx, newVals, idx + 1, vals.length - idx);
        }
        return newVals;
    }

    public static short[] insertArrayShort(short[] vals, short val, int idx) {
        short[] newVals = new short[vals.length + 1];
        if (idx > 0) {
            System.arraycopy(vals, 0, newVals, 0, idx);
        }
        newVals[idx] = val;
        if (idx < vals.length) {
            System.arraycopy(vals, idx, newVals, idx + 1, vals.length - idx);
        }
        return newVals;
    }

    public static Value[] insertArrayValue(Value[] vals, Value val, int idx) {
        Value[] newVals = new Value[vals.length + 1];
        if (idx > 0) {
            System.arraycopy(vals, 0, newVals, 0, idx);
        }
        newVals[idx] = val;
        if (idx < vals.length) {
            System.arraycopy(vals, idx, newVals, idx + 1, vals.length - idx);
        }
        return newVals;
    }

    public final boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean close() throws DBException {
        try {
            this.raf.close();
        }
        catch (IOException e) {
            throw new DBException("an error occurred while closing database file: " + e.getMessage());
        }
        return true;
    }

    public boolean create() throws DBException {
        try {
            this.fileHeader.write();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DBException(0, "Error creating " + this.file.getName());
        }
    }

    public abstract FileHeader createFileHeader();

    public abstract FileHeader createFileHeader(boolean var1) throws IOException;

    public abstract FileHeader createFileHeader(long var1);

    public abstract FileHeader createFileHeader(long var1, int var3);

    public abstract PageHeader createPageHeader();

    public boolean drop() throws DBException {
        return true;
    }

    public boolean exists() {
        return !this.fileIsNew;
    }

    public boolean flush() throws DBException {
        try {
            if (!this.readOnly) {
                this.fileHeader.write();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    protected final File getFile() {
        return this.file;
    }

    public FileHeader getFileHeader() {
        return this.fileHeader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Page getFreePage() throws IOException {
        Page p = null;
        FileHeader fileHeader = this.fileHeader;
        synchronized (fileHeader) {
            long pageNum = this.fileHeader.firstFreePage;
            if (pageNum != -1L) {
                p = new Page(pageNum);
                p.read();
                this.fileHeader.firstFreePage = p.header.nextPage;
                if (this.fileHeader.firstFreePage == -1L) {
                    this.fileHeader.setLastFreePage(-1L);
                }
            } else {
                pageNum = this.fileHeader.totalCount;
                if (pageNum == Integer.MAX_VALUE) {
                    throw new IOException("page limit reached: " + pageNum);
                }
                this.fileHeader.setTotalCount(pageNum + 1L);
                p = new Page(pageNum);
                p.read();
            }
        }
        p.header.setNextPage(-1L);
        p.header.setStatus((byte)0);
        this.fileHeader.setDirty(true);
        return p;
    }

    protected final Page getPage(long pageNum) throws IOException {
        return new Page(pageNum);
    }

    public boolean isOpened() {
        return true;
    }

    public boolean open(short expectedVersion) throws DBException {
        try {
            if (this.exists()) {
                this.fileHeader.read();
                if (this.fileHeader.getVersion() != expectedVersion) {
                    throw new DBException("Database file " + this.getFile().getName() + " has a storage format incompatible with this " + "version of eXist. Please do a backup/restore of your data first.");
                }
                return true;
            }
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DBException(0, "Error opening " + this.file.getName());
        }
    }

    private void printFreeSpaceList() throws IOException {
        long pageNum = this.fileHeader.firstFreePage;
        System.out.println("first free page: " + pageNum);
        System.out.println("free pages for " + this.getFile().getName());
        while (pageNum != -1L) {
            Page next = this.getPage(pageNum);
            next.read();
            System.out.print(pageNum + ";");
            pageNum = next.header.nextPage;
        }
        System.out.println();
    }

    private boolean isRemovedPage(long pageNum) throws IOException {
        long nextNum = this.fileHeader.firstFreePage;
        while (nextNum != -1L) {
            if (nextNum == pageNum) {
                LOG.error((Object)("Page " + pageNum + " has already been removed"));
                Thread.dumpStack();
                return true;
            }
            Page next = this.getPage(nextNum);
            next.read();
            nextNum = next.header.nextPage;
        }
        return false;
    }

    protected final void setFile(File file) {
        this.file = file;
        this.fileIsNew = !file.exists();
        try {
            if (!file.exists() || file.canWrite()) {
                this.raf = new RandomAccessFile(file, "rw");
            } else {
                this.readOnly = true;
                this.raf = new RandomAccessFile(file, "r");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unlinkPages(Page page) throws IOException {
        if (page != null) {
            page.header.setStatus((byte)0);
            FileHeader fileHeader = this.fileHeader;
            synchronized (fileHeader) {
                if (this.fileHeader.firstFreePage == -1L) {
                    this.fileHeader.setFirstFreePage(page.pageNum);
                    page.header.setNextPage(-1L);
                } else {
                    Page p = this.getPage(this.fileHeader.firstFreePage);
                    this.fileHeader.setFirstFreePage(page.pageNum);
                    page.header.setNextPage(p.getPageNum());
                }
                page.remove();
                this.fileHeader.setDirty(true);
            }
        }
    }

    protected final void unlinkPages(long pageNum) throws IOException {
        this.unlinkPages(this.getPage(pageNum));
    }

    protected final void writeValue(Page page, Value value) throws IOException {
        byte[] data = value.getData();
        this.writeValue(page, data);
    }

    protected final void writeValue(Page page, byte[] data) throws IOException {
        PageHeader hdr = page.getPageHeader();
        hdr.dataLen = this.fileHeader.workSize;
        if (data.length < hdr.dataLen) {
            hdr.dataLen = data.length;
        }
        page.write(data);
    }

    protected final void writeValue(long page, Value value) throws IOException {
        this.writeValue(this.getPage(page), value);
    }

    public static String hexDump(byte[] data) {
        StringBuffer buf = new StringBuffer();
        buf.append("\r\n");
        int columns = 0;
        int i = 0;
        while (i < data.length) {
            Paged.byteToHex(buf, data[i]);
            if (columns == 16) {
                buf.append("\r\n");
                columns = 0;
            } else {
                buf.append(' ');
            }
            ++i;
            ++columns;
        }
        return buf.toString();
    }

    private static void byteToHex(StringBuffer buf, byte b) {
        int n = b;
        if (n < 0) {
            n = 256 + n;
        }
        int d1 = n / 16;
        int d2 = n % 16;
        buf.append(hex[d1]);
        buf.append(hex[d2]);
    }

    public static abstract class PageHeader {
        private int dataLen = 0;
        private boolean dirty = false;
        private long nextPage = -1L;
        private byte status = 0;

        public PageHeader() {
        }

        public PageHeader(byte[] data, int offset) throws IOException {
            this.read(data, offset);
        }

        public final int getDataLen() {
            return this.dataLen;
        }

        public final long getNextPage() {
            return this.nextPage;
        }

        public final byte getStatus() {
            return this.status;
        }

        public final boolean isDirty() {
            return this.dirty;
        }

        public int read(byte[] data, int offset) throws IOException {
            this.status = data[offset++];
            this.dataLen = ByteConversion.byteToInt(data, offset);
            this.nextPage = ByteConversion.byteToLong(data, offset += 4);
            return offset += 8;
        }

        public int write(byte[] data, int offset) throws IOException {
            data[offset++] = this.status;
            ByteConversion.intToByte(this.dataLen, data, offset);
            ByteConversion.longToByte(this.nextPage, data, offset += 4);
            this.dirty = false;
            return offset += 8;
        }

        public final void setDataLen(int dataLen) {
            this.dataLen = dataLen;
            this.dirty = true;
        }

        public final void setDirty(boolean dirty) {
            this.dirty = dirty;
        }

        public final void setNextPage(long nextPage) {
            this.nextPage = nextPage;
            this.dirty = true;
        }

        public final void setStatus(byte status) {
            this.status = status;
            this.dirty = true;
        }
    }

    public final class Page
    implements Comparable {
        private PageHeader header;
        private long offset;
        private long pageNum;
        private int refCount = 0;

        public Page() {
            this.header = Paged.this.createPageHeader();
        }

        public Page(long pageNum) throws IOException {
            this();
            if (pageNum < 0L) {
                throw new IOException("Illegal page num: " + pageNum);
            }
            this.setPageNum(pageNum);
        }

        public void decRefCount() {
            --this.refCount;
        }

        public long getOffset() {
            return this.offset;
        }

        public PageHeader getPageHeader() {
            return this.header;
        }

        public String getPageInfo() {
            return "page: " + this.pageNum + "; file = " + Paged.this.getFile().getName() + "; address = " + Long.toHexString(this.offset) + "; page header = " + Paged.this.fileHeader.getPageHeaderSize() + "; data start = " + Long.toHexString(this.offset + (long)Paged.this.fileHeader.getPageHeaderSize());
        }

        public long getPageNum() {
            return this.pageNum;
        }

        public int getRefCount() {
            return this.refCount;
        }

        public int getDataPos() {
            return Paged.this.fileHeader.pageHeaderSize;
        }

        public void incRefCount() {
            ++this.refCount;
        }

        public byte[] read() throws IOException {
            try {
                if (Paged.this.raf.getFilePointer() != this.offset) {
                    Paged.this.raf.seek(this.offset);
                }
                Arrays.fill(Paged.this.tempHeaderData, (byte)0);
                Paged.this.raf.read(Paged.this.tempHeaderData);
                this.header.read(Paged.this.tempHeaderData, 0);
                byte[] workData = new byte[this.header.dataLen];
                Paged.this.raf.read(workData);
                return workData;
            }
            catch (Exception e) {
                LOG.debug((Object)("error while reading page: " + this.getPageInfo()), (Throwable)e);
                throw new IOException(e.getMessage());
            }
        }

        public void setPageNum(long pageNum) {
            this.pageNum = pageNum;
            this.offset = (long)Paged.this.fileHeader.headerSize + pageNum * (long)Paged.this.fileHeader.pageSize;
        }

        public void remove() throws IOException {
            this.write(null);
        }

        private final void write(byte[] data) throws IOException {
            if (data == null) {
                Arrays.fill(Paged.this.tempPageData, (byte)0);
            }
            this.header.write(Paged.this.tempPageData, 0);
            this.header.dirty = false;
            if (data != null) {
                if (data.length > Paged.this.fileHeader.workSize) {
                    throw new IOException("page: " + this.getPageInfo() + ": data length too large: " + data.length);
                }
                System.arraycopy(data, 0, Paged.this.tempPageData, Paged.this.fileHeader.pageHeaderSize, data.length);
            }
            if (Paged.this.raf.getFilePointer() != this.offset) {
                Paged.this.raf.seek(this.offset);
            }
            Paged.this.raf.write(Paged.this.tempPageData);
        }

        public boolean equals(Object obj) {
            return ((Page)obj).pageNum == this.pageNum;
        }

        public int compareTo(Object o) {
            Page other = (Page)o;
            if (this.pageNum == other.pageNum) {
                return 0;
            }
            if (this.pageNum > other.pageNum) {
                return 1;
            }
            return -1;
        }

        public void dumpPage() throws IOException {
            if (Paged.this.raf.getFilePointer() != this.offset) {
                Paged.this.raf.seek(this.offset);
            }
            byte[] data = new byte[Paged.this.fileHeader.pageSize];
            Paged.this.raf.read(data);
            LOG.debug((Object)("Contents of page " + this.pageNum + ": " + Paged.hexDump(data)));
        }
    }

    public abstract class FileHeader {
        private short versionId;
        private boolean dirty = false;
        private long firstFreePage = -1L;
        private short headerSize;
        private long lastFreePage = -1L;
        private short maxKeySize = (short)256;
        private long pageCount;
        private byte pageHeaderSize = (byte)64;
        private int pageSize;
        private long recordCount;
        private long totalCount;
        private int workSize;

        public FileHeader() {
            this(1024L, PAGE_SIZE);
        }

        public FileHeader(long pageCount) {
            this(pageCount, 4096);
        }

        public FileHeader(long pageCount, int pageSize) {
            this(pageCount, pageSize, 4);
        }

        public FileHeader(long pageCount, int pageSize, byte blockSize) {
            this.pageSize = pageSize;
            this.pageCount = pageCount;
            this.totalCount = pageCount;
            this.headerSize = (short)pageSize;
            this.versionId = Paged.this.getFileVersion();
            this.calculateWorkSize();
        }

        public FileHeader(boolean read) throws IOException {
            if (read) {
                this.read();
            }
        }

        private void calculateWorkSize() {
            this.workSize = this.pageSize - this.pageHeaderSize;
        }

        public final synchronized void decRecordCount() {
            --this.recordCount;
            this.dirty = true;
        }

        public final long getFirstFreePage() {
            return this.firstFreePage;
        }

        public final short getHeaderSize() {
            return this.headerSize;
        }

        public final long getLastFreePage() {
            return this.lastFreePage;
        }

        public final short getMaxKeySize() {
            return this.maxKeySize;
        }

        public final long getPageCount() {
            return this.pageCount;
        }

        public final byte getPageHeaderSize() {
            return this.pageHeaderSize;
        }

        public final int getPageSize() {
            return this.pageSize;
        }

        public final long getRecordCount() {
            return this.recordCount;
        }

        public final long getTotalCount() {
            return this.totalCount;
        }

        public final int getWorkSize() {
            return this.workSize;
        }

        public final short getVersion() {
            return this.versionId;
        }

        public final synchronized void incRecordCount() {
            ++this.recordCount;
            this.dirty = true;
        }

        public final boolean isDirty() {
            return this.dirty;
        }

        public final synchronized void read() throws IOException {
            Paged.this.raf.seek(0L);
            this.read(Paged.this.raf);
            this.calculateWorkSize();
            this.dirty = false;
        }

        public void read(RandomAccessFile raf) throws IOException {
            this.versionId = raf.readShort();
            this.headerSize = raf.readShort();
            this.pageSize = raf.readInt();
            this.pageCount = raf.readLong();
            this.totalCount = raf.readLong();
            this.firstFreePage = raf.readLong();
            this.lastFreePage = raf.readLong();
            this.pageHeaderSize = raf.readByte();
            this.maxKeySize = raf.readShort();
            this.recordCount = raf.readLong();
        }

        public final void setDirty(boolean dirty) {
            this.dirty = dirty;
        }

        public final void setFirstFreePage(long firstFreePage) {
            this.firstFreePage = firstFreePage;
            this.dirty = true;
        }

        public final void setHeaderSize(short headerSize) {
            this.headerSize = headerSize;
            this.dirty = true;
        }

        public final void setLastFreePage(long lastFreePage) {
            this.lastFreePage = lastFreePage;
            this.dirty = true;
        }

        public final void setMaxKeySize(short maxKeySize) {
            this.maxKeySize = maxKeySize;
            this.dirty = true;
        }

        public final void setPageCount(long pageCount) {
            this.pageCount = pageCount;
            this.dirty = true;
        }

        public final void setPageHeaderSize(byte pageHeaderSize) {
            this.pageHeaderSize = pageHeaderSize;
            this.calculateWorkSize();
            this.dirty = true;
        }

        public final void setPageSize(int pageSize) {
            this.pageSize = pageSize;
            this.calculateWorkSize();
            this.dirty = true;
        }

        public final void setRecordCount(long recordCount) {
            this.recordCount = recordCount;
            this.dirty = true;
        }

        public final void setTotalCount(long totalCount) {
            this.totalCount = totalCount;
            this.dirty = true;
        }

        public final synchronized void write() throws IOException {
            Paged.this.raf.seek(0L);
            this.write(Paged.this.raf);
            this.dirty = false;
        }

        public void write(RandomAccessFile raf) throws IOException {
            raf.writeShort(this.versionId);
            raf.writeShort(this.headerSize);
            raf.writeInt(this.pageSize);
            raf.writeLong(this.pageCount);
            raf.writeLong(this.totalCount);
            raf.writeLong(this.firstFreePage);
            raf.writeLong(this.lastFreePage);
            raf.writeByte(this.pageHeaderSize);
            raf.writeShort(this.maxKeySize);
            raf.writeLong(this.recordCount);
        }
    }
}

