/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator.grammarAccess;

import com.google.inject.Guice;
import com.google.inject.Module;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.EnumLiteralDeclaration;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.XtextRuntimeModule;
import org.eclipse.xtext.generator.grammarAccess.UnicodeCharacterDatabaseNames;
import org.eclipse.xtext.parsetree.reconstr.SerializerUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrammarAccessUtil {
    private static SerializerUtil xtextSerializer = (SerializerUtil)Guice.createInjector((Module[])new Module[]{new XtextRuntimeModule()}).getInstance(SerializerUtil.class);

    public static String getClassName(EObject obj) {
        return obj.eClass().getName();
    }

    private static List<String> getElementDescription(AbstractElement element) {
        ArrayList<String> result = new ArrayList<String>();
        AbstractElement container = element;
        while (container != null) {
            result.addAll(0, GrammarAccessUtil.getSingleElementDescription(container));
            AbstractElement abstractElement = container = container.eContainer() instanceof AbstractElement ? (AbstractElement)container.eContainer() : null;
        }
        return result;
    }

    private static List<String> getSingleElementDescription(AbstractElement ele) {
        if (ele instanceof Keyword) {
            return Collections.singletonList(((Keyword)ele).getValue());
        }
        if (ele instanceof Assignment) {
            return Collections.singletonList(((Assignment)ele).getFeature());
        }
        if (ele instanceof RuleCall) {
            return Collections.singletonList(((RuleCall)ele).getRule().getName());
        }
        if (ele instanceof Action) {
            Action a = (Action)ele;
            ArrayList<String> r = new ArrayList<String>();
            if (a.getType() != null && a.getType().getClassifier() != null) {
                r.add(a.getType().getClassifier().getName());
            }
            if (a.getFeature() != null && !"".equals(a.getFeature())) {
                r.add(a.getFeature());
            }
            return r;
        }
        if (ele instanceof CrossReference) {
            CrossReference cr = (CrossReference)ele;
            if (cr.getType() != null && cr.getType().getClassifier() != null) {
                return Collections.singletonList(cr.getType().getClassifier().getName());
            }
        } else if (ele instanceof EnumLiteralDeclaration) {
            EnumLiteralDeclaration decl = (EnumLiteralDeclaration)ele;
            return Collections.singletonList(decl.getEnumLiteral().getName());
        }
        return Collections.emptyList();
    }

    public static String serialize(EObject obj, String prefix) {
        String s;
        try {
            s = xtextSerializer.serialize(obj, true);
        }
        catch (Exception e) {
            s = e.toString();
        }
        s = String.valueOf(prefix) + s.trim().replaceAll("[\\r\\n]", "\n" + prefix).replaceAll("/\\*", "/ *").replaceAll("\\*/", "* /");
        return s;
    }

    private static String getElementPath(AbstractElement ele) {
        AbstractElement obj = ele;
        StringBuffer buf = new StringBuffer();
        while (!(obj.eContainer() instanceof AbstractRule) && obj.eContainer() != null) {
            EObject tmp = obj.eContainer();
            buf.insert(0, tmp.eContents().indexOf((Object)obj));
            buf.insert(0, "_");
            obj = tmp;
        }
        return buf.toString();
    }

    private static String getElementTypeDescription(AbstractElement ele) {
        if (ele instanceof RuleCall) {
            AbstractRule r = ((RuleCall)ele).getRule();
            return String.valueOf(r.eClass().getName()) + "Call";
        }
        return ele.eClass().getName();
    }

    public static String getGrammarAccessFQName(Grammar grammar) {
        return String.valueOf(GrammarUtil.getNamespace((Grammar)grammar)) + ".services." + GrammarAccessUtil.getGrammarAccessSimpleName(grammar);
    }

    public static String getGrammarAccessSimpleName(Grammar grammar) {
        return String.valueOf(GrammarUtil.getName((Grammar)grammar)) + "GrammarAccess";
    }

    public static String getUniqueElementName(AbstractElement ele) {
        block3: {
            try {
                if (ele != null) break block3;
                return "null";
            }
            catch (Throwable t) {
                t.printStackTrace();
                return "failure";
            }
        }
        ArrayList<String> r = new ArrayList<String>();
        r.addAll(GrammarAccessUtil.getElementDescription(ele));
        r.add(GrammarAccessUtil.getElementTypeDescription(ele));
        r.add(GrammarAccessUtil.getElementPath(ele));
        return GrammarAccessUtil.toJavaIdentifier(r, true);
    }

    private static String toJavaIdentifier(List<String> text, boolean uppercaseFirst) {
        Iterator<String> i = text.iterator();
        StringBuffer b = new StringBuffer(GrammarAccessUtil.toJavaIdentifierSegment(i.next(), true, uppercaseFirst));
        while (i.hasNext()) {
            b.append(GrammarAccessUtil.toJavaIdentifierSegment(i.next(), false, true));
        }
        return b.toString();
    }

    private static String toJavaIdentifierSegmentInt(String text, boolean isFirst, boolean uppercaseFirst) {
        boolean start = isFirst;
        boolean up = true;
        StringBuffer r = new StringBuffer();
        char[] cArray = text.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            boolean valid;
            char c = cArray[n2];
            boolean bl = c != '$' && (start ? Character.isJavaIdentifierStart(c) : Character.isJavaIdentifierPart(c)) ? true : (valid = false);
            if (valid) {
                if (start) {
                    r.append(uppercaseFirst ? Character.toUpperCase(c) : Character.toLowerCase(c));
                } else {
                    r.append(up ? Character.toUpperCase(c) : c);
                }
                up = false;
                start = false;
            } else {
                up = true;
            }
            ++n2;
        }
        return r.toString();
    }

    private static String toJavaIdentifierSegment(String text, boolean isFirst, boolean uppercaseFirst) {
        String r = GrammarAccessUtil.toJavaIdentifierSegmentInt(text, isFirst, uppercaseFirst);
        if (r.length() > 0) {
            return r;
        }
        StringBuffer b = new StringBuffer();
        char[] cArray = text.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            String n3 = UnicodeCharacterDatabaseNames.getCharacterName(c);
            if (n3 != null) {
                b.append(String.valueOf(n3) + " ");
            }
            ++n2;
        }
        return GrammarAccessUtil.toJavaIdentifierSegmentInt(b.toString().toLowerCase().trim(), isFirst, true);
    }

    public static String toJavaIdentifier(String text, Boolean uppercaseFirst) {
        try {
            return GrammarAccessUtil.toJavaIdentifierSegment(text, true, uppercaseFirst);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return "%_FAILURE_(" + text + ")%";
        }
    }
}

