/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator.ecore;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.codegen.ecore.genmodel.GenJDKLevel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelPackage;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.mwe.core.ConfigurationException;
import org.eclipse.xpand2.XpandExecutionContext;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.GeneratedMetamodel;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.generator.ecore.AbstractEcoreGeneratorFragment;
import org.eclipse.xtext.resource.XtextResourceSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EcoreGeneratorFragment
extends AbstractEcoreGeneratorFragment {
    private static final Logger log = Logger.getLogger(EcoreGeneratorFragment.class);
    private static final String MODEL_PLUGIN_ID = "modelPluginID";
    private String urisString;
    private String javaModelDirectory = null;
    private String modelPluginID = null;
    private String editDirectory = null;
    private String editorDirectory = null;
    private String editPluginID = null;
    private String editorPluginID = null;

    @Override
    public void generate(Grammar grammar, XpandExecutionContext ctx) {
        super.generate(grammar, ctx);
        List list = EcoreUtil2.typeSelect((List)grammar.getMetamodelDeclarations(), GeneratedMetamodel.class);
        List packs = EcoreUtil2.collect((Collection)list, (int)0, EPackage.class);
        if (!packs.isEmpty()) {
            XtextResourceSet rs = new XtextResourceSet();
            EcoreUtil.Copier copier = new EcoreUtil.Copier();
            this.copyGeneratedMetamodelsTo((List<Grammar>)grammar.getUsedGrammars(), (ResourceSet)rs, copier);
            ArrayList<EPackage> copies = new ArrayList<EPackage>(packs.size());
            for (EPackage pack : packs) {
                copies.add((EPackage)copier.copy((EObject)pack));
            }
            copier.copyReferences();
            String javaPath = this.javaModelDirectory == null || "".equals(this.javaModelDirectory) ? ctx.getOutput().getOutlet("SRC_GEN").getPath() : this.javaModelDirectory;
            String xmiPath = this.getXmiModelDirectory() == null || "".equals(this.getXmiModelDirectory()) ? String.valueOf(javaPath) + "/" + grammar.getName().substring(0, grammar.getName().lastIndexOf(46)).replace('.', '/') : this.getXmiModelDirectory();
            if ((this.modelPluginID == null || "".equals(this.modelPluginID)) && ctx.getVariable(MODEL_PLUGIN_ID) != null) {
                this.modelPluginID = (String)ctx.getVariable(MODEL_PLUGIN_ID).getValue();
            }
            if (this.editDirectory == null || "".equals(this.editDirectory)) {
                this.editDirectory = String.valueOf(ctx.getOutput().getOutlet("PLUGIN").getPath()) + ".edit/src";
            }
            if ((this.editPluginID == null || "".equals(this.editPluginID)) && this.modelPluginID != null) {
                this.editPluginID = String.valueOf(this.modelPluginID) + ".edit";
            }
            if (this.editorDirectory == null || "".equals(this.editorDirectory)) {
                this.editorDirectory = String.valueOf(ctx.getOutput().getOutlet("PLUGIN").getPath()) + ".editor/src";
            }
            if ((this.editorPluginID == null || "".equals(this.editorPluginID)) && this.modelPluginID != null) {
                this.editorPluginID = String.valueOf(this.modelPluginID) + ".editor";
            }
            this.generateEcoreJavaClasses((ResourceSet)rs, copies, this.getBasePackage(grammar), javaPath, xmiPath, grammar);
        }
    }

    public void setGenModels(String uris) {
        if ("".equals(uris)) {
            return;
        }
        this.urisString = uris;
    }

    private Collection<? extends GenPackage> getUsedGenPackages(ResourceSet rs) {
        LinkedHashSet<GenPackage> result = new LinkedHashSet<GenPackage>();
        if (this.urisString != null) {
            String[] stringArray = this.urisString.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String uri = stringArray[n2];
                try {
                    Resource resource = rs.getResource(URI.createURI((String)uri.trim()), true);
                    GenModel genmodel = (GenModel)resource.getContents().get(0);
                    EList genPackages = genmodel.getGenPackages();
                    for (GenPackage genPackage : genPackages) {
                        genPackage.getEcorePackage().getEClassifiers();
                        result.add(genPackage);
                    }
                }
                catch (Exception e) {
                    log.error((Object)("Couldn't find genmodel for uri '" + uri + "'"));
                    throw new RuntimeException(e);
                }
                ++n2;
            }
        }
        return result;
    }

    public void generateEcoreJavaClasses(ResourceSet rs, Collection<? extends EPackage> packs, String basePackage, String javaPath, String xmiPath, Grammar grammar) throws ConfigurationException {
        Resource res;
        Resource res2;
        String modelName = grammar.getName().substring(grammar.getName().lastIndexOf(46) + 1);
        try {
            String prefix = String.valueOf(new File(xmiPath).getCanonicalPath()) + "/" + modelName;
            res2 = rs.createResource(URI.createFileURI((String)(String.valueOf(prefix) + ".ecore")), "");
            res = rs.createResource(URI.createFileURI((String)(String.valueOf(prefix) + ".genmodel")), "");
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Couldn't compute canonical path for " + new File(xmiPath).getAbsolutePath());
        }
        GenModel genModel = GenModelPackage.eINSTANCE.getGenModelFactory().createGenModel();
        genModel.initialize(packs);
        genModel.setModelDirectory(this.toGenModelProjectPath(javaPath));
        genModel.setModelName(modelName);
        genModel.setModelPluginID(this.modelPluginID);
        genModel.setEditDirectory(this.toGenModelProjectPath(this.editDirectory));
        genModel.setEditorDirectory(this.toGenModelProjectPath(this.editorDirectory));
        genModel.setEditPluginID(this.editPluginID);
        genModel.setEditorPluginID(this.editorPluginID);
        genModel.setValidateModel(false);
        genModel.setForceOverwrite(true);
        genModel.setCanGenerate(true);
        genModel.setFacadeHelperClass(null);
        genModel.setBundleManifest(true);
        genModel.setUpdateClasspath(false);
        genModel.setComplianceLevel(GenJDKLevel.JDK50_LITERAL);
        genModel.setRootExtendsClass("org.eclipse.emf.ecore.impl.MinimalEObjectImpl$Container");
        for (GenPackage genPackage : genModel.getGenPackages()) {
            genPackage.setBasePackage(basePackage);
        }
        Collection<? extends GenPackage> usedGenPackages = this.getUsedGenPackages(rs);
        genModel.getUsedGenPackages().addAll(usedGenPackages);
        res.getContents().add((Object)genModel);
        res2.getContents().addAll(packs);
        try {
            res2.save(null);
            res.save(null);
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        genModel.reconcile();
        this.doGenerate(genModel);
    }

    private String toGenModelProjectPath(String path) {
        return path == null || "".equals(path) || path.startsWith("/") ? path : path.substring(path.indexOf("/"));
    }

    public void setJavaModelDirectory(String dir) {
        this.javaModelDirectory = dir;
    }

    public void setModelPluginID(String modelPluginId) {
        this.modelPluginID = modelPluginId;
    }

    public void setEditDirectory(String editDirectory) {
        this.editDirectory = editDirectory;
    }

    public void setEditorDirectory(String editorDirectory) {
        this.editorDirectory = editorDirectory;
    }

    public void setEditPluginID(String editPluginId) {
        this.editPluginID = editPluginId;
    }

    public void setEditorPluginID(String editorPluginId) {
        this.editorPluginID = editorPluginId;
    }
}

