/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.xtext.generator.BindKey;
import org.eclipse.xtext.generator.BindValue;
import org.eclipse.xtext.generator.Binding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindFactory {
    private String contributedBy;
    private final Set<Binding> bindings = new LinkedHashSet<Binding>();

    public BindFactory() {
        this.contributedBy = new Exception().getStackTrace()[1].getClassName();
    }

    public BindFactory(String contributedBy) {
        this.contributedBy = contributedBy;
    }

    public String getContributedBy() {
        return this.contributedBy;
    }

    public BindFactory addTypeToInstance(String s1, String s2) {
        this.bindings.add(this.binding(BindKey.type(s1), BindValue.expr(s2)));
        return this;
    }

    private Binding binding(BindKey type, BindValue expr) {
        return this.binding(type, expr, false);
    }

    private Binding binding(BindKey type, BindValue expr, boolean isFinal) {
        return new Binding(type, expr, isFinal, this.getContributedBy());
    }

    public BindFactory addTypeToType(String s1, String s2) {
        this.add(this.binding(BindKey.type(s1), BindValue.type(s2)));
        return this;
    }

    private void add(Binding binding) {
        if (this.bindings.contains(binding)) {
            throw new IllegalArgumentException("Duplicate binding for " + binding.getKey() + " in " + this.getContributedBy());
        }
        this.bindings.add(binding);
    }

    public BindFactory addTypeToTypeSingleton(String s1, String s2) {
        this.add(this.binding(BindKey.singleton(s1), BindValue.type(s2)));
        return this;
    }

    public BindFactory addTypeToTypeEagerSingleton(String s1, String s2) {
        this.add(this.binding(BindKey.eagerSingleton(s1), BindValue.type(s2)));
        return this;
    }

    public BindFactory addfinalTypeToType(String s1, String s2) {
        this.add(this.binding(BindKey.type(s1), BindValue.type(s2), true));
        return this;
    }

    public BindFactory addfinalTypeToTypeSingleton(String s1, String s2) {
        this.add(this.binding(BindKey.singleton(s1), BindValue.type(s2), true));
        return this;
    }

    public BindFactory addfinalTypeToTypeEagerSingleton(String s1, String s2) {
        this.add(this.binding(BindKey.eagerSingleton(s1), BindValue.type(s2), true));
        return this;
    }

    public Set<Binding> getBindings() {
        return this.bindings;
    }
}

