/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.acs.objectexplorer.engine.BACI.converters;

import si.ijs.acs.objectexplorer.engine.BACI.BACIConverterSupport;

public class BACIDoubleLinearConverter
extends BACIConverterSupport {
    protected double c;
    protected double n;

    public BACIDoubleLinearConverter(double d, double d2) {
        this.c = d;
        this.n = d2;
    }

    @Override
    public Object convertPropertyValue(Object object) {
        return new Double(this.c * (Double)object + this.n);
    }

    @Override
    public Object inverseConvertPropertyValue(Object object) {
        return new Double(((Double)object - this.n) / this.c);
    }

    @Override
    public String getConvertedPropertyValueUnits(String string) {
        StringBuffer stringBuffer = new StringBuffer(64);
        if (this.c != 0.0) {
            stringBuffer.append(String.valueOf(this.c));
            stringBuffer.append('*');
        }
        stringBuffer.append(string);
        if (this.n != 0.0) {
            stringBuffer.append('+');
            stringBuffer.append(String.valueOf(this.n));
        }
        return stringBuffer.toString();
    }

    @Override
    public String getDescription() {
        return "Double BACI property linear converter.";
    }

    @Override
    public Class getInverseConvertPropertyParameterType() {
        return Double.TYPE;
    }
}

