/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.acs.objectexplorer.engine.BACI;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import si.ijs.acs.objectexplorer.engine.BACI.BACIRemoteAccess;
import si.ijs.acs.objectexplorer.engine.BACI.CorbalocDialog;

public class BACIMenu
extends JMenu {
    private JMenuItem corbalocItem = null;
    private JCheckBoxMenuItem cacheItem = null;
    private JCheckBoxMenuItem nonStickyItem = null;
    private BACIRemoteAccess ra = null;
    private Properties props = null;
    private String managerLoc = null;
    private String IRloc = null;
    private boolean connectNonSticky;

    public BACIMenu(BACIRemoteAccess bACIRemoteAccess) {
        if (bACIRemoteAccess == null) {
            throw new NullPointerException("ra");
        }
        this.ra = bACIRemoteAccess;
        this.setText("BACI Engine");
        this.corbalocItem = new JMenuItem("Manager & IR corbaloc");
        this.cacheItem = new JCheckBoxMenuItem("Cache IR descriptions");
        this.nonStickyItem = new JCheckBoxMenuItem("Connect as non-sticky");
        this.add(this.corbalocItem);
        this.add(this.cacheItem);
        this.add(this.nonStickyItem);
        this.props = System.getProperties();
        this.managerLoc = this.props.getProperty("ACS.manager");
        this.IRloc = this.props.getProperty("ACS.repository");
        String string = this.props.getProperty("objexp.connect_non_sticky");
        this.connectNonSticky = string == null ? true : Boolean.parseBoolean(string);
        this.ra.setConnectNonSticky(this.connectNonSticky);
        this.cacheItem.setSelected(this.ra.getCaching());
        this.nonStickyItem.setSelected(this.connectNonSticky);
        this.corbalocItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CorbalocDialog corbalocDialog = new CorbalocDialog();
                corbalocDialog.setLocationRelativeTo(BACIMenu.this);
                if (BACIMenu.this.managerLoc != null) {
                    corbalocDialog.setManagerFieldText(BACIMenu.this.managerLoc);
                }
                if (BACIMenu.this.IRloc != null) {
                    corbalocDialog.setRepositoryFieldText(BACIMenu.this.IRloc);
                }
                corbalocDialog.show();
                if (corbalocDialog.isOKed()) {
                    BACIMenu.this.managerLoc = corbalocDialog.getManagerFieldText();
                    BACIMenu.this.IRloc = corbalocDialog.getRepositoryFieldText();
                    BACIMenu.this.props.setProperty("ACS.manager", BACIMenu.this.managerLoc);
                    BACIMenu.this.props.setProperty("ACS.repository", BACIMenu.this.IRloc);
                }
            }
        });
        this.cacheItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (BACIMenu.this.cacheItem.isSelected()) {
                    BACIMenu.this.ra.setCaching(true);
                } else {
                    BACIMenu.this.ra.setCaching(false);
                }
            }
        });
        this.nonStickyItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BACIMenu.this.ra.setConnectNonSticky(BACIMenu.this.nonStickyItem.isSelected());
            }
        });
    }

    public void setNonSticky(boolean bl) {
        this.nonStickyItem.setSelected(bl);
        for (ActionListener actionListener : (ActionListener[])this.nonStickyItem.getListeners(ActionListener.class)) {
            actionListener.actionPerformed(new ActionEvent(this, 0, null));
        }
    }
}

