/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.acs.objectexplorer;

import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import si.ijs.acs.objectexplorer.AccessDestroyWindow;
import si.ijs.acs.objectexplorer.FirstTimeExpandedEvent;
import si.ijs.acs.objectexplorer.ListsHandlerBean;
import si.ijs.acs.objectexplorer.NodeRequestListener;
import si.ijs.acs.objectexplorer.NotificationBean;
import si.ijs.acs.objectexplorer.OETree;
import si.ijs.acs.objectexplorer.OETreeNode;
import si.ijs.acs.objectexplorer.ObjectDetailsHandler;
import si.ijs.acs.objectexplorer.ObjectExplorer;
import si.ijs.acs.objectexplorer.ReporterBean;
import si.ijs.acs.objectexplorer.engine.BACI.BACIInvocation;
import si.ijs.acs.objectexplorer.engine.BACI.BACIRemoteAccess;
import si.ijs.acs.objectexplorer.engine.BACI.BACIRemoteNode;
import si.ijs.acs.objectexplorer.engine.BACI.BACITreeDataNode;
import si.ijs.acs.objectexplorer.engine.BACI.DelegateInvocation;
import si.ijs.acs.objectexplorer.engine.BACI.DelegateRemoteNode;
import si.ijs.acs.objectexplorer.engine.BACI.InvocationCouple;
import si.ijs.acs.objectexplorer.engine.BACI.RemoteNodeCouple;
import si.ijs.acs.objectexplorer.engine.Introspectable;
import si.ijs.acs.objectexplorer.engine.Invocation;
import si.ijs.acs.objectexplorer.engine.NonStickyConnectFailedRemoteException;
import si.ijs.acs.objectexplorer.engine.RemoteAccess;
import si.ijs.acs.objectexplorer.engine.SimpleIntrospectable;

public class TreeHandlerBean
implements NodeRequestListener {
    private String accessType = null;
    private transient Introspectable clicked = null;
    private transient OETree tree = null;
    private transient RemoteAccess remoteAccess = null;
    private transient NotificationBean notifier = null;
    private transient ObjectExplorer parent = null;
    private transient TreeNode selectedNode = null;
    private ObjectDetailsHandler handler = null;
    private Hashtable devices = null;
    private Hashtable invList = new Hashtable();
    private OETree treeByName = null;

    public Hashtable getInvList() {
        return this.invList;
    }

    public RemoteAccess getRemoteAccess() {
        return this.remoteAccess;
    }

    public TreeHandlerBean(Hashtable hashtable, OETree oETree, OETree oETree2) {
        this.devices = hashtable;
        this.tree = oETree;
        this.treeByName = oETree2;
    }

    @Override
    public void addNode(TreeNode treeNode, TreeNode treeNode2) {
        this.addNodes(new TreeNode[]{treeNode}, treeNode2);
        if (treeNode instanceof BACIInvocation) {
            BACIInvocation bACIInvocation = (BACIInvocation)treeNode;
            InvocationCouple invocationCouple = new InvocationCouple(bACIInvocation, null);
            invocationCouple.invocationByName = new DelegateInvocation(bACIInvocation, this.treeByName, (BACIRemoteAccess)this.remoteAccess);
            String string = (String)((OETreeNode)treeNode2.getParent()).getUserObject() + ":" + treeNode2.toString();
            RemoteNodeCouple remoteNodeCouple = (RemoteNodeCouple)this.devices.get(string);
            if (remoteNodeCouple == null) {
                this.notifier.reportError("TreeHandlerBean::addNode - Unexpected null pointer (rnc).");
                return;
            }
            this.getInvList().put(bACIInvocation, invocationCouple);
            this.setNodesTreeByName(new TreeNode[]{invocationCouple.invocationByName}, (TreeNode)remoteNodeCouple.deviceByName);
        }
    }

    public InvocationCouple getInvocationCouple(Invocation invocation) {
        return (InvocationCouple)this.invList.get(invocation);
    }

    @Override
    public void addNodes(TreeNode[] treeNodeArray, TreeNode treeNode) {
        this.setNodes(treeNodeArray, treeNode);
    }

    public void connect() {
        try {
            this.clicked.connect();
        }
        catch (NonStickyConnectFailedRemoteException nonStickyConnectFailedRemoteException) {
            return;
        }
        ((DefaultTreeModel)this.tree.getModel()).reload((TreeNode)((Object)this.clicked));
        if (this.tree.getSelectionPath() != null && this.tree.getSelectionPath().getLastPathComponent() == this.clicked) {
            this.selectedNode = null;
            this.handler.setObject(this.clicked);
        }
        if (this.clicked instanceof BACIRemoteNode) {
            RemoteNodeCouple remoteNodeCouple;
            BACIRemoteNode bACIRemoteNode = (BACIRemoteNode)this.clicked;
            if (bACIRemoteNode.getUserObject() instanceof String) {
                String string = (String)bACIRemoteNode.getUserObject();
                remoteNodeCouple = (RemoteNodeCouple)this.devices.get(string);
            } else {
                RemoteNodeCouple remoteNodeCouple2;
                bACIRemoteNode.getParent();
                String string = (String)((OETreeNode)bACIRemoteNode.getParent()).getUserObject() + ":" + bACIRemoteNode.toString();
                remoteNodeCouple = remoteNodeCouple2 = (RemoteNodeCouple)this.devices.get(string);
            }
            if (remoteNodeCouple == null) {
                this.clicked = null;
                return;
            }
            ((DefaultTreeModel)this.treeByName.getModel()).reload(remoteNodeCouple.deviceByName);
        }
        this.clicked = null;
        this.tree.repaint();
        this.treeByName.repaint();
    }

    public void destroy() {
        this.destroyRA();
    }

    private void destroyRA() {
        if (this.remoteAccess != null) {
            AccessDestroyWindow accessDestroyWindow = new AccessDestroyWindow(this.parent);
            new accessDestroyer(this.remoteAccess, accessDestroyWindow).start();
            accessDestroyWindow.show();
        }
    }

    public void disconnect() {
        this.notifier.reportDebug("TreeHandlerBean::disconnect", "Requesting engine to disconnect the introspectable..:");
        if (this.clicked instanceof BACIRemoteNode) {
            TreePath treePath;
            BACIRemoteNode bACIRemoteNode;
            BACIRemoteNode bACIRemoteNode2 = (BACIRemoteNode)this.clicked;
            String string = bACIRemoteNode2.getUserObject() instanceof String ? (String)bACIRemoteNode2.getUserObject() : (String)((OETreeNode)bACIRemoteNode2.getParent()).getUserObject() + ":" + bACIRemoteNode2.toString();
            RemoteNodeCouple remoteNodeCouple = (RemoteNodeCouple)this.devices.get(string);
            if (remoteNodeCouple == null) {
                this.clicked = null;
                this.notifier.reportError("TreeHandlerBean::disconnect - Unexpected null pointer (rnc).");
                return;
            }
            if (remoteNodeCouple.deviceByType.isConnected()) {
                bACIRemoteNode = remoteNodeCouple.deviceByType;
                bACIRemoteNode.setChildrenDefined(true);
                remoteNodeCouple.deviceByType.disconnect();
                treePath = new TreePath(bACIRemoteNode.getPath());
                if (treePath.isDescendant(this.tree.getSelectionPath()) || treePath.equals(this.tree.getSelectionPath())) {
                    this.selectedNode = bACIRemoteNode;
                    this.tree.setSelectionPath(treePath);
                    this.handler.setObject(null);
                }
                this.tree.collapsePath(treePath);
                bACIRemoteNode.removeAllChildren();
                ((DefaultTreeModel)this.tree.getModel()).reload(bACIRemoteNode);
                bACIRemoteNode.setChildrenDefined(false);
            }
            bACIRemoteNode = remoteNodeCouple.deviceByName;
            bACIRemoteNode.setChildrenDefined(true);
            remoteNodeCouple.deviceByName.disconnect();
            treePath = new TreePath(bACIRemoteNode.getPath());
            if (treePath.isDescendant(this.treeByName.getSelectionPath()) || treePath.equals(this.treeByName.getSelectionPath())) {
                this.selectedNode = bACIRemoteNode;
                this.treeByName.setSelectionPath(treePath);
                this.handler.setObject(null);
            }
            this.treeByName.collapsePath(treePath);
            this.purgeChildren(bACIRemoteNode);
            bACIRemoteNode.removeAllChildren();
            ((DefaultTreeModel)this.treeByName.getModel()).reload(bACIRemoteNode);
            bACIRemoteNode.setChildrenDefined(false);
        } else {
            this.notifier.reportError("TreeHandlerBean::disconnect - clicked not instanceof BACIRemoteNode.");
            if (this.clicked instanceof OETreeNode && this.clicked.isConnected()) {
                OETreeNode oETreeNode = (OETreeNode)((Object)this.clicked);
                oETreeNode.setChildrenDefined(true);
                this.clicked.disconnect();
                TreePath treePath = new TreePath(oETreeNode.getPath());
                if (treePath.isDescendant(this.tree.getSelectionPath()) || treePath.equals(this.tree.getSelectionPath())) {
                    this.selectedNode = oETreeNode;
                    this.tree.setSelectionPath(treePath);
                    this.handler.setObject(null);
                }
                this.tree.collapsePath(treePath);
                this.purgeChildren(oETreeNode);
                oETreeNode.removeAllChildren();
                ((DefaultTreeModel)this.tree.getModel()).reload(oETreeNode);
                oETreeNode.setChildrenDefined(false);
            }
        }
        this.clicked = null;
    }

    public void purgeChildren(OETreeNode oETreeNode) {
        if (oETreeNode == null || oETreeNode.childrenHolder == null) {
            return;
        }
        for (int i = 0; i < oETreeNode.childrenHolder.size(); ++i) {
            this.purgeAll((OETreeNode)oETreeNode.childrenHolder.get(i));
        }
    }

    private void purgeAll(OETreeNode oETreeNode) {
        String string;
        if (oETreeNode == null || oETreeNode.childrenHolder == null) {
            return;
        }
        for (int i = 0; i < oETreeNode.childrenHolder.size(); ++i) {
            this.purgeAll((OETreeNode)oETreeNode.childrenHolder.get(i));
        }
        if (oETreeNode.getUserObject() instanceof String) {
            string = (String)oETreeNode.getUserObject();
        } else {
            oETreeNode.getParent();
            string = (String)((OETreeNode)oETreeNode.getParent()).getUserObject() + ":" + oETreeNode.toString();
        }
        this.devices.remove(string);
    }

    public synchronized void getDevices(FirstTimeExpandedEvent firstTimeExpandedEvent) {
        OETreeNode oETreeNode = firstTimeExpandedEvent.getTreeNode();
        if (firstTimeExpandedEvent.getSource() == this.treeByName && oETreeNode instanceof BACIRemoteNode) {
            RemoteNodeCouple remoteNodeCouple;
            BACIRemoteNode bACIRemoteNode = (BACIRemoteNode)oETreeNode;
            if (bACIRemoteNode.getUserObject() instanceof String) {
                String string = (String)bACIRemoteNode.getUserObject();
                remoteNodeCouple = (RemoteNodeCouple)this.devices.get(string);
            } else {
                RemoteNodeCouple remoteNodeCouple2;
                bACIRemoteNode.getParent();
                String string = (String)((OETreeNode)bACIRemoteNode.getParent()).getUserObject() + ":" + bACIRemoteNode.toString();
                remoteNodeCouple = remoteNodeCouple2 = (RemoteNodeCouple)this.devices.get(string);
            }
            if (remoteNodeCouple == null) {
                this.notifier.reportError("TreeHandlerBean::getDevices - Unexpected null pointer (rnc).");
                return;
            }
            remoteNodeCouple.deviceByType.getChildCount();
            return;
        }
        this.notifier.reportDebug("TreeHandlerBean::getDevices", "node: " + oETreeNode + " " + oETreeNode.getUserObject());
        try {
            if (oETreeNode == null) {
                return;
            }
            if (oETreeNode.getUserObject() instanceof String && oETreeNode.getUserObject().equals("root")) {
                if (oETreeNode.getParentTree() == this.treeByName) {
                    return;
                }
                this.notifier.reportMessage("Initializing " + this.accessType + " engine. Please wait...");
                this.notifier.reportDebug("TreeHandlerBean::setAccess", "Selected engine: " + this.accessType);
                this.treeByName.clearTree();
                this.invList.clear();
                this.devices.clear();
                this.setAccess(oETreeNode);
            } else {
                new SubNodesSearching(this, oETreeNode).start();
            }
            return;
        }
        catch (Exception exception) {
            this.notifier.reportError("Error while searching for devices of " + oETreeNode, exception);
            return;
        }
    }

    private NotificationBean getNotifier() {
        return this.notifier;
    }

    private ObjectExplorer getParent() {
        return this.parent;
    }

    public OETree getTree() {
        return this.tree;
    }

    private void initializeDetailsHandler() {
        this.handler = new ListsHandlerBean();
        this.handler.setNotifier(this.notifier);
        this.handler.setReporter(this.parent.getReporter());
        this.handler.setNodeRequestListener(this);
        this.parent.setDetailsPanel(this.handler.getEditorPanel());
    }

    @Override
    public void removeNode(TreeNode treeNode) {
        if (treeNode.getParent() == null) {
            return;
        }
        InvocationCouple invocationCouple = this.getInvocationCouple((Invocation)treeNode);
        if (invocationCouple == null) {
            this.notifier.reportError("TreeHandlerBean::removeNode - Unexpected null pointer (ic).");
            return;
        }
        if (this.tree.getSelectionPath() != null) {
            if (this.tree.getSelectionPath().getLastPathComponent() == treeNode) {
                this.tree.setSelectionPath(new TreePath(((DefaultMutableTreeNode)treeNode.getParent()).getPath()));
            }
        } else if (this.treeByName.getSelectionPath() == null && this.treeByName.getSelectionPath().getLastPathComponent() == invocationCouple.invocationByName) {
            this.treeByName.setSelectionPath(new TreePath(((DefaultMutableTreeNode)invocationCouple.invocationByName.getParent()).getPath()));
        }
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.tree.getModel();
        defaultTreeModel.removeNodeFromParent(invocationCouple.invocationByType);
        defaultTreeModel = (DefaultTreeModel)this.treeByName.getModel();
        defaultTreeModel.removeNodeFromParent(invocationCouple.invocationByName);
    }

    @Override
    public void removeNodes(TreeNode[] treeNodeArray) {
        for (int i = 0; i < treeNodeArray.length; ++i) {
            this.removeNode(treeNodeArray[i]);
        }
    }

    public void selectionChanged(OETree oETree) {
        if (oETree.getSelectionPath() == null) {
            this.selectedNode = null;
            this.handler.setObject(null);
            return;
        }
        if (this.selectedNode != (TreeNode)oETree.getSelectionPath().getLastPathComponent()) {
            this.selectedNode = (TreeNode)oETree.getSelectionPath().getLastPathComponent();
            if (this.selectedNode instanceof Introspectable) {
                try {
                    ((Introspectable)((Object)this.selectedNode)).connect();
                }
                catch (NonStickyConnectFailedRemoteException nonStickyConnectFailedRemoteException) {
                    return;
                }
            }
            if (this.selectedNode instanceof SimpleIntrospectable && (!(this.selectedNode instanceof Invocation) || ((Invocation)this.selectedNode).isControllable())) {
                this.handler.setObject((SimpleIntrospectable)((Object)this.selectedNode));
                return;
            }
            this.handler.setObject(null);
        }
    }

    public void setAccess(String string) {
        this.accessType = string;
    }

    private void setAccess(OETreeNode oETreeNode) {
        try {
            if (this.remoteAccess != null) {
                this.parent.getReporter().clearResponseWindows();
                this.handler.setObject(null);
            }
            new accessSetter(this.accessType, this.notifier, oETreeNode, this, this.devices).start();
        }
        catch (Exception exception) {
            this.notifier.reportError("Remote Access " + this.accessType + " could not be found (or initialized)", exception);
            return;
        }
    }

    public OETree getTreeByName() {
        return this.treeByName;
    }

    public void setClicked(Introspectable introspectable) {
        this.clicked = introspectable;
    }

    public Introspectable getClicked() {
        return this.clicked;
    }

    private void setNodes(TreeNode[] treeNodeArray, TreeNode treeNode) {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.tree.getModel();
        if (treeNodeArray != null && treeNode != null) {
            int[] nArray = new int[treeNodeArray.length];
            for (int i = 0; i < treeNodeArray.length; ++i) {
                ((OETreeNode)treeNode).add((DefaultMutableTreeNode)treeNodeArray[i]);
                nArray[i] = treeNode.getChildCount() - 1;
            }
            defaultTreeModel.nodesWereInserted(treeNode, nArray);
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TreeHandlerBean.this.tree.revalidate();
                    TreeHandlerBean.this.tree.repaint();
                }
            });
        }
        this.getParent().setEnabled(true);
    }

    private void setNodesTreeByName(Vector vector, TreeNode treeNode) {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.treeByName.getModel();
        if (vector != null && treeNode != null && vector.size() > 0) {
            int[] nArray = new int[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                ((OETreeNode)treeNode).add((DefaultMutableTreeNode)vector.get(i));
                nArray[i] = treeNode.getChildCount() - 1;
            }
            defaultTreeModel.nodesWereInserted(treeNode, nArray);
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TreeHandlerBean.this.treeByName.revalidate();
                    TreeHandlerBean.this.treeByName.repaint();
                }
            });
        }
        this.getParent().setEnabled(true);
    }

    private void setNodesTreeByName(TreeNode[] treeNodeArray, TreeNode treeNode) {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.treeByName.getModel();
        if (treeNodeArray != null && treeNode != null) {
            int[] nArray = new int[treeNodeArray.length];
            for (int i = 0; i < treeNodeArray.length; ++i) {
                ((OETreeNode)treeNode).add((DefaultMutableTreeNode)treeNodeArray[i]);
                nArray[i] = treeNode.getChildCount() - 1;
            }
            defaultTreeModel.nodesWereInserted(treeNode, nArray);
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TreeHandlerBean.this.treeByName.revalidate();
                    TreeHandlerBean.this.treeByName.repaint();
                }
            });
        }
        this.getParent().setEnabled(true);
    }

    public void setNotifier(NotificationBean notificationBean) {
        this.notifier = notificationBean;
        if (this.tree != null) {
            this.tree.setNotifier(notificationBean);
        }
    }

    public void setParent(ObjectExplorer objectExplorer) {
        this.parent = objectExplorer;
    }

    public void setTree(OETree oETree) {
        this.tree = oETree;
        if (this.notifier != null) {
            this.tree.setNotifier(this.notifier);
        }
    }

    private class accessDestroyer
    extends Thread {
        private RemoteAccess ra = null;
        private AccessDestroyWindow adw = null;

        public accessDestroyer(RemoteAccess remoteAccess, AccessDestroyWindow accessDestroyWindow) {
            this.ra = remoteAccess;
            this.adw = accessDestroyWindow;
        }

        @Override
        public void run() {
            TreeHandlerBean.this.notifier.reportDebug("accessDestroyer.run", "starting destroy");
            try {
                TreeHandlerBean.this.notifier.setShowError(false);
                TreeHandlerBean.this.notifier.setAccessDestroyWindow(this.adw);
                this.ra.destroy();
            }
            catch (Exception exception) {
                TreeHandlerBean.this.notifier.reportError("Error while destroying RemoteAccess", exception, false);
            }
            TreeHandlerBean.this.notifier.setShowError(true);
            TreeHandlerBean.this.notifier.setAccessDestroyWindow(null);
            this.adw.terminate(true);
            TreeHandlerBean.this.notifier.reportDebug("accessDestroyer.run", "end of destroy");
        }
    }

    private class accessSetter
    extends Thread {
        private String type = null;
        private TreeHandlerBean parent = null;
        private NotificationBean notifier = null;
        private OETreeNode node = null;

        public accessSetter(String string, NotificationBean notificationBean, OETreeNode oETreeNode, TreeHandlerBean treeHandlerBean2, Hashtable hashtable) {
            this.type = string;
            this.notifier = notificationBean;
            this.node = oETreeNode;
            this.parent = treeHandlerBean2;
        }

        @Override
        public void run() {
            this.notifier.reportDebug("accessSetter.run", "starting set");
            try {
                ++ReporterBean.raID;
                this.parent.destroyRA();
                this.parent.getParent().removeEngineMenu();
            }
            catch (Throwable throwable) {
                this.notifier.reportError("Remote Access " + TreeHandlerBean.this.remoteAccess + " could not be properly destroyed", throwable);
            }
            this.parent.remoteAccess = null;
            try {
                RemoteAccess remoteAccess = this.constructRemoteAccess(this.type);
                remoteAccess.initialize();
                this.parent.remoteAccess = remoteAccess;
                JMenu jMenu = remoteAccess.getEngineMenu();
                if (jMenu != null) {
                    this.parent.getParent().addEngineMenu(jMenu);
                } else {
                    this.notifier.reportMessage(this.type + " engine menu is missing");
                }
                new SubNodesSearching(this.parent, this.node).start();
                this.parent.parent.getReporter().killResponseWindows();
            }
            catch (Throwable throwable) {
                this.notifier.reportError("Remote Access " + this.type + " could not be found (or initialized)", throwable);
                this.parent.getParent().setEnabled(true);
                return;
            }
            TreeHandlerBean.this.initializeDetailsHandler();
            this.notifier.reportDebug("accessSetter.run", "finishing set");
        }

        private RemoteAccess constructRemoteAccess(String string) throws ClassNotFoundException, InvocationTargetException, InstantiationException, IllegalAccessException {
            String string2 = string;
            Object[] objectArray = new Object[]{this.parent, this.notifier, TreeHandlerBean.this.devices};
            if (string.indexOf(".") == -1) {
                string2 = "si.ijs.acs.objectexplorer.engine." + string + "." + string + "RemoteAccess";
            }
            RemoteAccess remoteAccess = (RemoteAccess)Class.forName(string2).getConstructors()[0].newInstance(objectArray);
            return remoteAccess;
        }
    }

    public class SubNodesSearching
    extends Thread {
        private OETreeNode rootNode = null;
        private TreeHandlerBean parent = null;

        public SubNodesSearching(TreeHandlerBean treeHandlerBean2, OETreeNode oETreeNode) {
            this.parent = treeHandlerBean2;
            this.rootNode = oETreeNode;
        }

        @Override
        public void run() {
            try {
                this.parent.getParent().setReady(false);
                OETreeNode oETreeNode = this.rootNode;
                RemoteNodeCouple remoteNodeCouple = (RemoteNodeCouple)TreeHandlerBean.this.devices.get(oETreeNode.getUserObject().toString());
                if (oETreeNode.getLevel() == 0 && "Objects".equals(oETreeNode.getName()) && "root".equals(oETreeNode.getUserObject().toString())) {
                    oETreeNode = null;
                } else if (oETreeNode instanceof DelegateRemoteNode) {
                    oETreeNode = remoteNodeCouple.deviceByType;
                } else if (oETreeNode instanceof BACITreeDataNode && oETreeNode.getNodeType() == 6) {
                    TreeNode[] treeNodeArray = ((BACIRemoteAccess)this.parent.remoteAccess).explodeDummyNode((BACITreeDataNode)oETreeNode);
                    this.parent.setNodesTreeByName(treeNodeArray, this.rootNode);
                    this.parent.getParent().setReady(true);
                    return;
                }
                TreeNode[] treeNodeArray = this.parent.remoteAccess.explodeTreeNode(oETreeNode);
                this.parent.setNodes(treeNodeArray, this.rootNode);
                if (oETreeNode == null) {
                    TreeNode[] treeNodeArray2 = ((BACIRemoteAccess)this.parent.remoteAccess).explodeRootNodeByName();
                    this.parent.setNodesTreeByName(treeNodeArray2, (OETreeNode)this.parent.treeByName.getModel().getRoot());
                } else {
                    if (oETreeNode.getNodeType() == 1 || oETreeNode.getNodeType() == 0) {
                        this.parent.getParent().setReady(true);
                        return;
                    }
                    if (remoteNodeCouple != null) {
                        Vector<DelegateRemoteNode> vector = new Vector<DelegateRemoteNode>();
                        for (int i = 0; i < treeNodeArray.length; ++i) {
                            RemoteNodeCouple remoteNodeCouple2;
                            String string;
                            if (!(treeNodeArray[i] instanceof BACIRemoteNode)) continue;
                            if (((DefaultMutableTreeNode)treeNodeArray[i]).getUserObject() instanceof String) {
                                string = (String)((DefaultMutableTreeNode)treeNodeArray[i]).getUserObject();
                                remoteNodeCouple2 = (RemoteNodeCouple)TreeHandlerBean.this.devices.get(string);
                            } else {
                                string = (String)remoteNodeCouple.deviceByType.getUserObject() + ":" + ((OETreeNode)treeNodeArray[i]).toString();
                                RemoteNodeCouple remoteNodeCouple3 = (RemoteNodeCouple)TreeHandlerBean.this.devices.get(string);
                                if (remoteNodeCouple3 == null) {
                                    remoteNodeCouple3 = new RemoteNodeCouple((BACIRemoteNode)treeNodeArray[i], null);
                                    remoteNodeCouple3.deviceByName = new DelegateRemoteNode(((OETreeNode)treeNodeArray[i]).toString(), this.parent, (BACIRemoteNode)treeNodeArray[i]);
                                    TreeHandlerBean.this.devices.put(string, remoteNodeCouple3);
                                }
                                remoteNodeCouple2 = remoteNodeCouple3;
                            }
                            if (remoteNodeCouple2 == null) {
                                TreeHandlerBean.this.notifier.reportError("SubNodesSearching::run - Unexpected null pointer (rnc).");
                                continue;
                            }
                            vector.add(remoteNodeCouple2.deviceByName);
                        }
                        this.parent.setNodesTreeByName(vector, remoteNodeCouple.deviceByName);
                    }
                }
            }
            catch (Throwable throwable) {
                this.parent.getParent().setEnabled(true);
                this.parent.getNotifier().reportError("Error while searching for subnodes of " + this.rootNode, throwable);
                this.parent.getParent().setReady(true);
            }
            this.parent.getParent().setReady(true);
        }
    }
}

