/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.acs.objectexplorer;

import alma.acs.util.IsoDateFormat;
import com.cosylab.gui.components.r2.DataFormatter;
import com.cosylab.gui.components.r2.SmartTextPane;
import java.awt.Color;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import si.ijs.acs.objectexplorer.NotificationBean;
import si.ijs.acs.objectexplorer.ObjectExplorer;
import si.ijs.acs.objectexplorer.RemoteResponseWindow;
import si.ijs.acs.objectexplorer.engine.Converter;
import si.ijs.acs.objectexplorer.engine.Invocation;
import si.ijs.acs.objectexplorer.engine.RemoteCall;
import si.ijs.acs.objectexplorer.engine.RemoteResponse;

public class ReporterBean {
    private SmartTextPane resultArea = null;
    private NotificationBean notifier = null;
    private boolean expand = false;
    private boolean window = true;
    private Hashtable responseWindows = new Hashtable(10);
    static int raID = 0;
    private Style redStyle = null;
    private Style blackStyle = null;

    public void clearResponseWindows() {
        this.notifier.reportDebug("ReporterBean::clearResponseWindows", "started");
        Enumeration enumeration = this.responseWindows.elements();
        while (enumeration.hasMoreElements()) {
            Object v = enumeration.nextElement();
            if (!(v instanceof RemoteResponseWindow)) continue;
            ((RemoteResponseWindow)v).setDisposeOnDestroy(true);
            this.notifier.reportDebug("ReporterBean::clearResponseWindows", "disposed " + v);
        }
        this.notifier.reportDebug("ReporterBean::clearResponseWindows", "finished");
    }

    public SmartTextPane getResultArea() {
        return this.resultArea;
    }

    public synchronized void invocationDestroyed(Invocation invocation) {
        Integer n = new Integer(invocation.getInvocationRequest().getSN());
        Object v = this.responseWindows.get(n);
        if (v instanceof RemoteResponseWindow) {
            ((RemoteResponseWindow)v).disable();
        } else {
            this.responseWindows.remove(n);
            this.resultArea.append("\n[" + n + "] INVOCATION " + invocation + " WAS DESTROYED \n");
            this.resultArea.setCaretPosition(this.resultArea.getText().length() - 1);
        }
    }

    public boolean isExpand() {
        return this.expand;
    }

    public void killResponseWindows() {
        this.notifier.reportDebug("ReporterBean::killResponseWindows", "started");
        Enumeration enumeration = this.responseWindows.elements();
        while (enumeration.hasMoreElements()) {
            Object v = enumeration.nextElement();
            if (!(v instanceof RemoteResponseWindow)) continue;
            ((RemoteResponseWindow)v).dispose();
        }
        this.notifier.reportDebug("ReporterBean::killResponseWindows", "finished");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void reportRemoteCall(RemoteCall remoteCall) {
        try {
            boolean bl = remoteCall.isErrorResponse();
            if (bl) {
                this.resultArea.setCaretPosition(this.resultArea.getText().length());
                this.resultArea.setLogicalStyle(this.redStyle);
            }
            this.resultArea.append(ReporterBean.toString(remoteCall, this.expand | bl));
            if (bl) {
                this.resultArea.append("\n");
            }
        }
        finally {
            this.resultArea.setLogicalStyle(this.blackStyle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void reportRemoteResponse(RemoteResponse remoteResponse) {
        Integer n = new Integer(remoteResponse.getInvocation().getInvocationRequest().getSN());
        Object v = this.responseWindows.get(n);
        if (this.window && (remoteResponse.getSequenceNumber() > 0 || remoteResponse.getName().equals("working")) && !(v instanceof String)) {
            RemoteResponseWindow remoteResponseWindow = null;
            if (v instanceof RemoteResponseWindow) {
                remoteResponseWindow = (RemoteResponseWindow)v;
            } else {
                remoteResponseWindow = new RemoteResponseWindow(remoteResponse, this.notifier, this);
                this.responseWindows.put(n, remoteResponseWindow);
                remoteResponseWindow.show();
            }
            if (!remoteResponseWindow.isDestroyed()) {
                remoteResponseWindow.reportRemoteResponse(remoteResponse);
            }
        } else {
            try {
                boolean bl = remoteResponse.isErrorResponse();
                if (bl) {
                    this.resultArea.setCaretPosition(this.resultArea.getText().length());
                    this.resultArea.setLogicalStyle(this.redStyle);
                }
                this.resultArea.append(ReporterBean.toString(remoteResponse, this.expand | bl) + "\n");
                this.resultArea.setCaretPosition(this.resultArea.getText().length() - 1);
                if (remoteResponse.getSequenceNumber() == 0) {
                    this.responseWindows.put(n, remoteResponse);
                }
                if (bl) {
                    this.resultArea.append("\n");
                }
            }
            finally {
                this.resultArea.setLogicalStyle(this.blackStyle);
            }
        }
    }

    public void setExpand() {
        this.expand = !this.expand;
    }

    public void setNotifier(NotificationBean notificationBean) {
        this.notifier = notificationBean;
    }

    public void setResultArea(SmartTextPane smartTextPane) {
        this.resultArea = smartTextPane;
        this.blackStyle = this.resultArea.getLogicalStyle();
        this.redStyle = this.resultArea.addStyle("Red", null);
        StyleConstants.setForeground(this.redStyle, Color.red);
    }

    public void setWindow() {
        this.window = !this.window;
    }

    public static String toString(RemoteCall remoteCall) {
        return ReporterBean.toString(remoteCall, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String toString(RemoteCall remoteCall, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(500);
        stringBuffer.append('[');
        stringBuffer.append(remoteCall.getSN());
        stringBuffer.append("] : ");
        stringBuffer.append(IsoDateFormat.formatCurrentDate());
        stringBuffer.append(" |--------------------------------------------------------\n");
        stringBuffer.append(remoteCall.getIntrospectable().getName());
        String string = null;
        if (remoteCall.getAttribute() == null) {
            if (remoteCall.getOperation() == null) throw new NullPointerException("RemoteCall -- both Operation and Attribute are null");
            string = remoteCall.getOperation().getName();
        } else {
            string = remoteCall.getAttribute().toString();
        }
        Converter converter = remoteCall.isAttributeAccess() ? ObjectExplorer.getConverter(remoteCall.getAttribute().getIntrospectable()) : ObjectExplorer.getConverter(remoteCall.getOperation().getIntrospectable());
        Object object = remoteCall.getSyncReturnValue();
        Object[] objectArray = remoteCall.getAuxReturnValues();
        if (converter != null && converter.acceptConvert(string)) {
            object = converter.convert(string, objectArray, object);
        }
        stringBuffer.append('.');
        stringBuffer.append(string);
        stringBuffer.append('\n');
        stringBuffer.append(" --> Return value: ");
        if (remoteCall.getOperation() != null && remoteCall.getOperation().getReturnType() == Void.TYPE) {
            stringBuffer.append("void");
        } else {
            stringBuffer.append(DataFormatter.unpackReturnValue((Object)object, (String)"      ", (int)0, (boolean)bl));
        }
        stringBuffer.append('\n');
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] == null) continue;
                stringBuffer.append(" --> Auxiliary return value '" + remoteCall.getOperation().getParameterNames()[i] + "' = " + DataFormatter.unpackReturnValue((Object)objectArray[i], (String)"      ", (int)0, (boolean)bl) + "\n");
            }
        }
        if (remoteCall.getThrowable() != null) {
            stringBuffer.append(" --> Exception: " + remoteCall.getThrowable() + "\n");
            stringBuffer.append(DataFormatter.unpackReturnValue((Object)remoteCall.getThrowable(), (String)"/      ", (int)0, (boolean)bl));
        }
        if (!remoteCall.isTimeout()) return stringBuffer.toString();
        stringBuffer.append(" --> Timeout raised by the engine while waiting for response.\n");
        return stringBuffer.toString();
    }

    public static String toString(RemoteResponse remoteResponse) {
        return ReporterBean.toString(remoteResponse, false);
    }

    public static String toString(RemoteResponse remoteResponse, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(500);
        stringBuffer.append("[");
        stringBuffer.append(remoteResponse.getInvocation().getInvocationRequest().getSN());
        stringBuffer.append(":");
        stringBuffer.append(remoteResponse.getSequenceNumber());
        stringBuffer.append("] : ");
        stringBuffer.append(IsoDateFormat.formatDate((Date)new Date(remoteResponse.getTimestamp())));
        stringBuffer.append(" |-----------------------------------------------------\n");
        stringBuffer.append(" --> Response for: ");
        stringBuffer.append(remoteResponse.getInvocation().getName());
        stringBuffer.append("\n --> Message: ");
        stringBuffer.append(remoteResponse.getName());
        stringBuffer.append("\n --> Parameters: ");
        Object[] objectArray = remoteResponse.getData();
        for (int i = 0; i < objectArray.length; ++i) {
            stringBuffer.append("\n    ");
            stringBuffer.append(remoteResponse.getDataNames()[i]);
            stringBuffer.append(": ");
            stringBuffer.append(DataFormatter.unpackReturnValue((Object)objectArray[i], (String)"      ", (int)0, (boolean)bl));
        }
        return stringBuffer.toString();
    }
}

