/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.acs.objectexplorer;

import alma.acs.logging.ClientLogManager;
import com.cosylab.gui.components.r2.SmartTextPane;
import java.awt.Frame;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import si.ijs.acs.objectexplorer.AccessDestroyWindow;
import si.ijs.acs.objectexplorer.ErrorDialog;
import si.ijs.acs.objectexplorer.engine.Introspectable;
import si.ijs.acs.objectexplorer.engine.NonStickyComponentReleased;

public class NotificationBean {
    SmartTextPane textArea = null;
    JFrame parent = null;
    boolean showError = true;
    AccessDestroyWindow accessDestroyWindow = null;
    ErrorDialog errorDialog = null;
    private static boolean debugToConsole = true;
    private Logger consoleLogger = ClientLogManager.getAcsLogManager().getLoggerForApplication("objexp-console", false);

    public JFrame getParent() {
        return this.parent;
    }

    public SmartTextPane getTextArea() {
        return this.textArea;
    }

    public boolean isDebugToConsole() {
        return debugToConsole;
    }

    public void reportDebug(String string, String string2) {
        if (debugToConsole) {
            this.consoleLogger.info(string2);
        }
    }

    public void reportError(String string) {
        this.reportError(string, null);
    }

    public void reportError(String string, Throwable throwable) {
        this.reportError(string, throwable, true);
    }

    public void reportError(String string, Throwable throwable, boolean bl) {
        this.reportError(string, throwable, bl, true);
    }

    public void reportError(String string, Throwable throwable, boolean bl, boolean bl2) {
        this.textArea.append("Error: " + string);
        if (bl2) {
            this.textArea.append(" (See console for exception stack trace.)");
        }
        this.textArea.append("\n");
        if (throwable != null) {
            if (!(throwable instanceof NonStickyComponentReleased)) {
                if (bl2) {
                    this.consoleLogger.log(Level.WARNING, string, throwable);
                } else {
                    this.consoleLogger.warning(string);
                }
            }
            string = string + "\n" + throwable;
        } else {
            this.consoleLogger.warning(string);
        }
        if (bl && this.showError) {
            if (this.errorDialog == null) {
                this.errorDialog = new ErrorDialog((Frame)this.parent, this.parent.getTitle() + " error", string);
                this.errorDialog = null;
            } else {
                this.errorDialog.addError(string);
            }
        } else if (this.accessDestroyWindow != null) {
            this.accessDestroyWindow.addError();
        }
    }

    public synchronized void reportMessage(String string) {
        this.textArea.append("Message: " + string + "\n");
    }

    public void reportStructuralAccess(short s, Introspectable introspectable, String string) {
        this.textArea.append("StructuralAccess: " + introspectable + " - " + string + " (type " + s + ")\n");
        this.textArea.setCaretPosition(this.textArea.getText().length());
    }

    public void setAccessDestroyWindow(AccessDestroyWindow accessDestroyWindow) {
        this.accessDestroyWindow = accessDestroyWindow;
    }

    public void setDebugToConsole() {
        debugToConsole = !debugToConsole;
    }

    public void setParent(JFrame jFrame) {
        this.parent = jFrame;
    }

    public void setShowError(boolean bl) {
        this.showError = bl;
    }

    public void setTextArea(SmartTextPane smartTextPane) {
        this.textArea = smartTextPane;
    }
}

