/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.gui.components.r2.chart.demo;

import com.cosylab.gui.components.r2.chart.BaseChart;
import com.cosylab.gui.components.r2.chart.ChartUpdateRequest;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ChartFrame
extends JFrame
implements Runnable {
    private JPanel ivjJFrameContentPane = null;
    private BaseChart ivjBaseChart = null;
    IvjEventHandler ivjEventHandler = new IvjEventHandler();
    private JLabel ivjJLabel1 = null;
    private JLabel ivjJLabel2 = null;
    private JPanel ivjJPanel1 = null;
    private JSlider ivjUpdaterSlider = null;
    private boolean alive = true;
    private int timer = 1000;

    public ChartFrame() {
        this.initialize();
    }

    public ChartFrame(String string) {
        super(string);
        this.initialize();
    }

    public synchronized void chartFrame_WindowActivated() {
        this.notify();
    }

    public void chartFrame_WindowClosed() {
        this.alive = false;
    }

    private void connEtoC1(WindowEvent windowEvent) {
        try {
            this.chartFrame_WindowActivated();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoC2(WindowEvent windowEvent) {
        try {
            this.chartFrame_WindowClosed();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoC3(ChangeEvent changeEvent) {
        try {
            this.updaterSlider_StateChanged();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoM1(ChangeEvent changeEvent) {
        try {
            this.getJLabel2().setText(String.valueOf(this.getUpdaterSlider().getValue()));
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    public BaseChart getBaseChart() {
        if (this.ivjBaseChart == null) {
            try {
                this.ivjBaseChart = new BaseChart();
                this.ivjBaseChart.setName("BaseChart");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjBaseChart;
    }

    private JPanel getJFrameContentPane() {
        if (this.ivjJFrameContentPane == null) {
            try {
                this.ivjJFrameContentPane = new JPanel();
                this.ivjJFrameContentPane.setName("JFrameContentPane");
                this.ivjJFrameContentPane.setLayout(new BorderLayout());
                this.getJFrameContentPane().add((Component)this.getJPanel1(), "South");
                this.getJFrameContentPane().add((Component)this.getBaseChart(), "Center");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJFrameContentPane;
    }

    private JLabel getJLabel1() {
        if (this.ivjJLabel1 == null) {
            try {
                this.ivjJLabel1 = new JLabel();
                this.ivjJLabel1.setName("JLabel1");
                this.ivjJLabel1.setText("updates per s");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJLabel1;
    }

    private JLabel getJLabel2() {
        if (this.ivjJLabel2 == null) {
            try {
                this.ivjJLabel2 = new JLabel();
                this.ivjJLabel2.setName("JLabel2");
                this.ivjJLabel2.setText("1");
                this.ivjJLabel2.setMaximumSize(new Dimension(21, 14));
                this.ivjJLabel2.setPreferredSize(new Dimension(21, 14));
                this.ivjJLabel2.setMinimumSize(new Dimension(21, 14));
                this.ivjJLabel2.setHorizontalAlignment(4);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJLabel2;
    }

    private JPanel getJPanel1() {
        if (this.ivjJPanel1 == null) {
            try {
                this.ivjJPanel1 = new JPanel();
                this.ivjJPanel1.setName("JPanel1");
                this.ivjJPanel1.setLayout(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.fill = 2;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.insets = new Insets(11, 11, 11, 11);
                this.getJPanel1().add((Component)this.getUpdaterSlider(), gridBagConstraints);
                GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
                gridBagConstraints2.gridx = 2;
                gridBagConstraints2.gridy = 0;
                gridBagConstraints2.insets = new Insets(11, 4, 11, 11);
                this.getJPanel1().add((Component)this.getJLabel1(), gridBagConstraints2);
                GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
                gridBagConstraints3.gridx = 1;
                gridBagConstraints3.gridy = 0;
                gridBagConstraints3.insets = new Insets(4, 4, 4, 4);
                this.getJPanel1().add((Component)this.getJLabel2(), gridBagConstraints3);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJPanel1;
    }

    private JSlider getUpdaterSlider() {
        if (this.ivjUpdaterSlider == null) {
            try {
                this.ivjUpdaterSlider = new JSlider();
                this.ivjUpdaterSlider.setName("UpdaterSlider");
                this.ivjUpdaterSlider.setPaintLabels(false);
                this.ivjUpdaterSlider.setPaintTicks(true);
                this.ivjUpdaterSlider.setValue(1);
                this.ivjUpdaterSlider.setMajorTickSpacing(10);
                this.ivjUpdaterSlider.setSnapToTicks(true);
                this.ivjUpdaterSlider.setMinimum(0);
                this.ivjUpdaterSlider.setMinorTickSpacing(1);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjUpdaterSlider;
    }

    private void handleException(Throwable throwable) {
        System.out.println("--------- UNCAUGHT EXCEPTION ---------");
        throwable.printStackTrace(System.out);
    }

    private void initConnections() throws Exception {
        this.getUpdaterSlider().addChangeListener(this.ivjEventHandler);
        this.addWindowListener(this.ivjEventHandler);
    }

    private void initialize() {
        try {
            this.setName("ChartFrame");
            this.setDefaultCloseOperation(2);
            this.setSize(430, 255);
            this.setTitle("Chart Frame");
            this.setContentPane(this.getJFrameContentPane());
            this.initConnections();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
        new Thread(this).start();
    }

    public static void main(String[] stringArray) {
        try {
            ChartFrame chartFrame = new ChartFrame();
            chartFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    System.exit(0);
                }
            });
            chartFrame.show();
            Insets insets = chartFrame.getInsets();
            chartFrame.setSize(chartFrame.getWidth() + insets.left + insets.right, chartFrame.getHeight() + insets.top + insets.bottom);
            chartFrame.setVisible(true);
        }
        catch (Throwable throwable) {
            System.err.println("Exception occurred in main() of javax.swing.JFrame");
            throwable.printStackTrace(System.out);
        }
    }

    public synchronized void run() {
        while (this.alive) {
            if (this.isVisible()) {
                this.getBaseChart().updateChart(ChartUpdateRequest.UPDATE_ALL);
            }
            try {
                this.wait(this.timer);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        new Thread(){

            public void run() {
                System.gc();
            }
        }.start();
    }

    public synchronized void updaterSlider_StateChanged() {
        this.timer = this.getUpdaterSlider().getValue() == 0 ? 0 : 1000 / this.getUpdaterSlider().getValue();
        this.notify();
    }

    class IvjEventHandler
    implements WindowListener,
    ChangeListener {
        IvjEventHandler() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (changeEvent.getSource() == ChartFrame.this.getUpdaterSlider()) {
                ChartFrame.this.connEtoM1(changeEvent);
            }
            if (changeEvent.getSource() == ChartFrame.this.getUpdaterSlider()) {
                ChartFrame.this.connEtoC3(changeEvent);
            }
        }

        public void windowActivated(WindowEvent windowEvent) {
            if (windowEvent.getSource() == ChartFrame.this) {
                ChartFrame.this.connEtoC1(windowEvent);
            }
        }

        public void windowClosed(WindowEvent windowEvent) {
            if (windowEvent.getSource() == ChartFrame.this) {
                ChartFrame.this.connEtoC2(windowEvent);
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
        }

        public void windowDeactivated(WindowEvent windowEvent) {
        }

        public void windowDeiconified(WindowEvent windowEvent) {
        }

        public void windowIconified(WindowEvent windowEvent) {
        }

        public void windowOpened(WindowEvent windowEvent) {
        }
    }
}

