/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.gui.components.r2.chart.demo;

import com.cosylab.gui.components.r2.chart.DefaultChartDecorator;
import com.cosylab.gui.components.r2.chart.FancyChartFlavor;
import com.cosylab.gui.components.r2.chart.FancyTimeTrendFlavor;
import com.cosylab.gui.components.r2.chart.Interval;
import com.cosylab.gui.components.r2.chart.PlainChartStyle;
import com.cosylab.gui.components.r2.chart.SimpleTrendFlavor;
import com.cosylab.gui.components.r2.chart.SinusFunction;
import com.cosylab.gui.components.r2.chart.demo.ChartFrame;
import com.cosylab.gui.components.r2.chart.demo.FunctionDataModel;
import com.cosylab.gui.components.r2.chart.demo.RandomTrendDataModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class ChartDemo
extends JPanel {
    private JLabel ivjJLabel1 = null;
    private JScrollPane ivjJScrollPane1 = null;
    private JTextArea ivjTextArea = null;
    private JButton ivjDefaultChartButton = null;
    IvjEventHandler ivjEventHandler = new IvjEventHandler();
    private JButton ivjSimpleTrendButton = null;
    private JButton ivjHistoryTrendButton = null;
    private JButton ivjFancyChartButton = null;

    public ChartDemo() {
        this.initialize();
    }

    public ChartDemo(LayoutManager layoutManager) {
        super(layoutManager);
    }

    public ChartDemo(LayoutManager layoutManager, boolean bl) {
        super(layoutManager, bl);
    }

    public ChartDemo(boolean bl) {
        super(bl);
    }

    private void connEtoC1(ActionEvent actionEvent) {
        try {
            this.startDefaultChart();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoC2(ActionEvent actionEvent) {
        try {
            this.startSimpleTrendChart();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoC3(ActionEvent actionEvent) {
        try {
            this.startHistoryTrendChart();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoC4(ActionEvent actionEvent) {
        try {
            this.startFancyChart();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoM1(MouseEvent mouseEvent) {
        try {
            this.getTextArea().setText(this.descDefaultChart());
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoM2(MouseEvent mouseEvent) {
        try {
            this.getTextArea().setText(this.descSimpleTrendChart());
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoM3(MouseEvent mouseEvent) {
        try {
            this.getTextArea().setText(this.dendTrendChart());
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoM4(MouseEvent mouseEvent) {
        try {
            this.getTextArea().setText(this.descFancyChart());
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    public String dendTrendChart() {
        return "Trend Chart\n\nFancy branch of charts with additional features.";
    }

    public String descDefaultChart() {
        return "Default Chart\n\nChart as comes by default.\nSinusoidal functions are recalculated each update for each point on X axis.";
    }

    public String descFancyChart() {
        return "Fancy Chart\n\nMore sophysticated chart with avaliable fancy features.";
    }

    public String descSimpleTrendChart() {
        return "Simple Trend Chart\n\nMinimalistic trend chart for heavy duty performance charting.";
    }

    private JButton getDefaultChartButton() {
        if (this.ivjDefaultChartButton == null) {
            try {
                this.ivjDefaultChartButton = new JButton();
                this.ivjDefaultChartButton.setName("DefaultChartButton");
                this.ivjDefaultChartButton.setPreferredSize(new Dimension(160, 25));
                this.ivjDefaultChartButton.setText("Default Chart...");
                this.ivjDefaultChartButton.setMinimumSize(new Dimension(160, 25));
                this.ivjDefaultChartButton.setMaximumSize(new Dimension(160, 25));
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjDefaultChartButton;
    }

    private JButton getFancyChartButton() {
        if (this.ivjFancyChartButton == null) {
            try {
                this.ivjFancyChartButton = new JButton();
                this.ivjFancyChartButton.setName("FancyChartButton");
                this.ivjFancyChartButton.setPreferredSize(new Dimension(160, 25));
                this.ivjFancyChartButton.setText("Fancy Chart...");
                this.ivjFancyChartButton.setMinimumSize(new Dimension(160, 25));
                this.ivjFancyChartButton.setMaximumSize(new Dimension(160, 25));
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjFancyChartButton;
    }

    private JButton getHistoryTrendButton() {
        if (this.ivjHistoryTrendButton == null) {
            try {
                this.ivjHistoryTrendButton = new JButton();
                this.ivjHistoryTrendButton.setName("HistoryTrendButton");
                this.ivjHistoryTrendButton.setPreferredSize(new Dimension(160, 25));
                this.ivjHistoryTrendButton.setText("Trend Chart...");
                this.ivjHistoryTrendButton.setMinimumSize(new Dimension(160, 25));
                this.ivjHistoryTrendButton.setMaximumSize(new Dimension(160, 25));
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjHistoryTrendButton;
    }

    private JLabel getJLabel1() {
        if (this.ivjJLabel1 == null) {
            try {
                this.ivjJLabel1 = new JLabel();
                this.ivjJLabel1.setName("JLabel1");
                this.ivjJLabel1.setFont(new Font("Times New Roman", 3, 48));
                this.ivjJLabel1.setText("Chart Demo");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJLabel1;
    }

    private JScrollPane getJScrollPane1() {
        if (this.ivjJScrollPane1 == null) {
            try {
                this.ivjJScrollPane1 = new JScrollPane();
                this.ivjJScrollPane1.setName("JScrollPane1");
                this.getJScrollPane1().setViewportView(this.getTextArea());
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJScrollPane1;
    }

    private JButton getSimpleTrendButton() {
        if (this.ivjSimpleTrendButton == null) {
            try {
                this.ivjSimpleTrendButton = new JButton();
                this.ivjSimpleTrendButton.setName("SimpleTrendButton");
                this.ivjSimpleTrendButton.setPreferredSize(new Dimension(160, 25));
                this.ivjSimpleTrendButton.setText("Simple Trend Chart...");
                this.ivjSimpleTrendButton.setMinimumSize(new Dimension(160, 25));
                this.ivjSimpleTrendButton.setMaximumSize(new Dimension(160, 25));
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjSimpleTrendButton;
    }

    private JTextArea getTextArea() {
        if (this.ivjTextArea == null) {
            try {
                this.ivjTextArea = new JTextArea();
                this.ivjTextArea.setName("TextArea");
                this.ivjTextArea.setLineWrap(true);
                this.ivjTextArea.setText("Interactive Help\n\nMove mouse over buttons for help.\n\nClick on button for new chart.");
                this.ivjTextArea.setBackground(new Color(222, 222, 255));
                this.ivjTextArea.setBounds(0, 0, 160, 120);
                this.ivjTextArea.setMargin(new Insets(11, 11, 11, 11));
                this.ivjTextArea.setEditable(false);
                this.ivjTextArea.setEnabled(true);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjTextArea;
    }

    private void handleException(Throwable throwable) {
        System.out.println("--------- UNCAUGHT EXCEPTION ---------");
        throwable.printStackTrace(System.out);
    }

    private void initConnections() throws Exception {
        this.getDefaultChartButton().addMouseListener(this.ivjEventHandler);
        this.getDefaultChartButton().addActionListener(this.ivjEventHandler);
        this.getSimpleTrendButton().addMouseListener(this.ivjEventHandler);
        this.getSimpleTrendButton().addActionListener(this.ivjEventHandler);
        this.getHistoryTrendButton().addMouseListener(this.ivjEventHandler);
        this.getHistoryTrendButton().addActionListener(this.ivjEventHandler);
        this.getFancyChartButton().addMouseListener(this.ivjEventHandler);
        this.getFancyChartButton().addActionListener(this.ivjEventHandler);
    }

    private void initialize() {
        try {
            this.setName("ChartDemo");
            this.setLayout(new GridBagLayout());
            this.setSize(301, 375);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(12, 4, 20, 4);
            this.add((Component)this.getJLabel1(), gridBagConstraints);
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.insets = new Insets(4, 4, 4, 4);
            this.add((Component)this.getDefaultChartButton(), gridBagConstraints2);
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.gridy = 3;
            gridBagConstraints3.insets = new Insets(4, 4, 4, 4);
            this.add((Component)this.getSimpleTrendButton(), gridBagConstraints3);
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.gridy = 4;
            gridBagConstraints4.insets = new Insets(4, 4, 4, 4);
            this.add((Component)this.getHistoryTrendButton(), gridBagConstraints4);
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.gridy = 5;
            gridBagConstraints5.fill = 1;
            gridBagConstraints5.weightx = 1.0;
            gridBagConstraints5.weighty = 1.0;
            gridBagConstraints5.insets = new Insets(15, 4, 4, 4);
            this.add((Component)this.getJScrollPane1(), gridBagConstraints5);
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 0;
            gridBagConstraints6.gridy = 2;
            gridBagConstraints6.insets = new Insets(4, 4, 4, 4);
            this.add((Component)this.getFancyChartButton(), gridBagConstraints6);
            this.initConnections();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    public static void main(String[] stringArray) {
        try {
            JFrame jFrame = new JFrame();
            ChartDemo chartDemo = new ChartDemo();
            jFrame.setTitle("Chart Demo");
            jFrame.setContentPane(chartDemo);
            jFrame.setSize(chartDemo.getSize());
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    System.exit(0);
                }
            });
            jFrame.show();
            Insets insets = jFrame.getInsets();
            jFrame.setSize(jFrame.getWidth() + insets.left + insets.right, jFrame.getHeight() + insets.top + insets.bottom);
            jFrame.setVisible(true);
        }
        catch (Throwable throwable) {
            System.err.println("Exception occurred in main() of javax.swing.JPanel");
            throwable.printStackTrace(System.out);
        }
    }

    public void startDefaultChart() {
        ChartFrame chartFrame = new ChartFrame("Default Chart Frame");
        int n = 1 + (int)(Math.random() * 9.0);
        for (int i = 0; i < n; ++i) {
            FunctionDataModel functionDataModel = new FunctionDataModel(new SinusFunction(Math.random() * 10.0, Math.random() * 3.0, 0.0, Math.random() * 3.14), Math.random() * 0.5, Math.random() * 10.0);
            functionDataModel.setChartStyle(new PlainChartStyle(1, new Color((int)(255.0 * Math.random()), (int)(255.0 * Math.random()), (int)(255.0 * Math.random())), 0, 0, Color.black));
            chartFrame.getBaseChart().getChartArea().addDataModel(functionDataModel);
        }
        chartFrame.show();
    }

    public void startFancyChart() {
        ChartFrame chartFrame = new ChartFrame("Fancy Chart Frame");
        DefaultChartDecorator defaultChartDecorator = new DefaultChartDecorator();
        defaultChartDecorator.applyFlavor(chartFrame.getBaseChart(), new FancyChartFlavor());
        int n = 1 + (int)(Math.random() * 9.0);
        for (int i = 0; i < n; ++i) {
            FunctionDataModel functionDataModel = new FunctionDataModel(new SinusFunction(Math.random() * 10.0, Math.random() * 3.0, 0.0, Math.random() * 3.14), Math.random() * 0.5, Math.random() * 10.0);
            functionDataModel.setChartStyle(new PlainChartStyle(1, new Color((int)(255.0 * Math.random()), (int)(255.0 * Math.random()), (int)(255.0 * Math.random())), 0, 0, Color.black));
            chartFrame.getBaseChart().getChartArea().addDataModel(functionDataModel);
        }
        chartFrame.show();
    }

    public void startHistoryTrendChart() {
        ChartFrame chartFrame = new ChartFrame("Trend Chart Frame");
        DefaultChartDecorator defaultChartDecorator = new DefaultChartDecorator();
        defaultChartDecorator.applyFlavor(chartFrame.getBaseChart(), new FancyTimeTrendFlavor());
        chartFrame.getBaseChart().getViewManager().setXScale(new Interval(0.0, 100.0));
        chartFrame.getBaseChart().getViewManager().setYScale(new Interval(0.0, 10.0));
        int n = 1 + (int)(Math.random() * 9.0);
        for (int i = 0; i < n; ++i) {
            RandomTrendDataModel randomTrendDataModel;
            randomTrendDataModel.setValueRange((randomTrendDataModel = new RandomTrendDataModel(0.001 + 3.0 * Math.random(), 1 + (int)(2.0 * Math.random()), 0.0, 10.0 * (Math.random() - 0.5), 1.0 + 8.0 * Math.random(), 0.0)).getStartValue() > 5.0 ? 10.0 - randomTrendDataModel.getStartValue() : randomTrendDataModel.getStartValue());
            randomTrendDataModel.setPositionAdvance(3.0 / (double)randomTrendDataModel.getPointsPerUpdate());
            chartFrame.getBaseChart().getChartArea().addDataModel(randomTrendDataModel);
        }
        chartFrame.show();
    }

    public void startSimpleTrendChart() {
        ChartFrame chartFrame = new ChartFrame("Simple Trend Chart Frame");
        DefaultChartDecorator defaultChartDecorator = new DefaultChartDecorator();
        defaultChartDecorator.applyFlavor(chartFrame.getBaseChart(), new SimpleTrendFlavor());
        chartFrame.getBaseChart().getViewManager().setXScale(new Interval(0.0, 100.0));
        chartFrame.getBaseChart().getViewManager().setYScale(new Interval(0.0, 10.0));
        int n = 1 + (int)(Math.random() * 9.0);
        for (int i = 0; i < n; ++i) {
            RandomTrendDataModel randomTrendDataModel;
            randomTrendDataModel.setValueRange((randomTrendDataModel = new RandomTrendDataModel(0.001 + 3.0 * Math.random(), 1 + (int)(2.0 * Math.random()), 0.0, 10.0 * (Math.random() - 0.5), 1.0 + 8.0 * Math.random(), 0.0)).getStartValue() > 5.0 ? 10.0 - randomTrendDataModel.getStartValue() : randomTrendDataModel.getStartValue());
            randomTrendDataModel.setPositionAdvance(3.0 / (double)randomTrendDataModel.getPointsPerUpdate());
            chartFrame.getBaseChart().getChartArea().addDataModel(randomTrendDataModel);
        }
        chartFrame.show();
    }

    class IvjEventHandler
    implements ActionListener,
    MouseListener {
        IvjEventHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == ChartDemo.this.getDefaultChartButton()) {
                ChartDemo.this.connEtoC1(actionEvent);
            }
            if (actionEvent.getSource() == ChartDemo.this.getSimpleTrendButton()) {
                ChartDemo.this.connEtoC2(actionEvent);
            }
            if (actionEvent.getSource() == ChartDemo.this.getHistoryTrendButton()) {
                ChartDemo.this.connEtoC3(actionEvent);
            }
            if (actionEvent.getSource() == ChartDemo.this.getFancyChartButton()) {
                ChartDemo.this.connEtoC4(actionEvent);
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            if (mouseEvent.getSource() == ChartDemo.this.getDefaultChartButton()) {
                ChartDemo.this.connEtoM1(mouseEvent);
            }
            if (mouseEvent.getSource() == ChartDemo.this.getSimpleTrendButton()) {
                ChartDemo.this.connEtoM2(mouseEvent);
            }
            if (mouseEvent.getSource() == ChartDemo.this.getHistoryTrendButton()) {
                ChartDemo.this.connEtoM3(mouseEvent);
            }
            if (mouseEvent.getSource() == ChartDemo.this.getFancyChartButton()) {
                ChartDemo.this.connEtoM4(mouseEvent);
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }
    }
}

