/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.gui.components.r2.chart;

import com.cosylab.gui.components.r2.chart.ChartDataModel;
import com.cosylab.gui.components.r2.chart.ChartDataService;
import com.cosylab.gui.components.r2.chart.ChartProperties;
import com.cosylab.gui.components.r2.chart.ChartService;
import com.cosylab.gui.components.r2.chart.ChartUpdateRequest;
import com.cosylab.gui.components.r2.chart.Chartics;
import com.cosylab.gui.components.r2.chart.DefaultChartArea;
import com.cosylab.gui.components.r2.chart.DefaultDataService;
import com.cosylab.gui.components.r2.chart.TrendPointTransformer;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.Iterator;

public class TrendChartArea
extends DefaultChartArea {
    protected Chartics im = new Chartics();
    protected double lastTimestamp;

    public TrendChartArea() {
    }

    public TrendChartArea(ChartService chartService) {
        super(chartService);
    }

    public void addDataModel(ChartDataModel chartDataModel) {
        TrendPointTransformer trendPointTransformer = null;
        trendPointTransformer = new TrendPointTransformer();
        DefaultDataService defaultDataService = new DefaultDataService(chartDataModel, this.chartService, trendPointTransformer);
        this.models.add(defaultDataService);
        this.model2service.put(chartDataModel, defaultDataService);
        trendPointTransformer.setChartRectangle(this.chartRectangle);
    }

    public void drawData(Chartics chartics, ChartUpdateRequest chartUpdateRequest) {
        if (this.models.size() == 0) {
            return;
        }
        Iterator iterator = this.models.iterator();
        if (this.im.getImage() == null) {
            this.im.setImage(new BufferedImage(this.size.width, this.size.height, 1));
            this.im.setBackground(chartics.getBackground());
            this.im.getGraphics().setColor(this.im.getBackground());
            this.im.getGraphics().fillRect(0, 0, this.size.width, this.size.height);
            this.im.getGraphics().setColor(chartics.getGraphics().getColor());
            this.im.getGraphics().translate(this.chartRectangle.x, this.chartRectangle.y);
            if (ChartProperties.getChartProperties().isDebugGraphics()) {
                this.im.getGraphics().drawString("New Image", (int)((double)this.size.width / 2.0) - 20, (int)((double)this.size.height / 2.0));
            }
        }
        iterator = this.models.iterator();
        ChartDataService chartDataService = null;
        int n = 0;
        int n2 = 0;
        while (iterator.hasNext()) {
            chartDataService = (ChartDataService)iterator.next();
            chartDataService.prepare();
            if (0 != chartDataService.transform()) continue;
            n2 = chartDataService.getPointTransformer().getLastIntPoint().x + 1 - this.chartRectangle.width - n;
            if (n2 > 0) {
                this.im.shift(n2 - this.chartRectangle.x, -this.chartRectangle.y, this.size.width - this.chartRectangle.x - n2, this.size.height + this.chartRectangle.y, -n2, 0);
                this.im.getGraphics().translate(-n2, 0);
                n += n2;
            }
            this.im.drawGraph(chartDataService.getPointTransformer().pointIterator(), chartDataService.getDataModel().getChartStyle());
        }
        if (n > 0) {
            this.im.getGraphics().translate(n, 0);
        }
        chartics.getGraphics().drawImage(this.im.getImage(), 0, 0, null);
    }

    public void setSize(Dimension dimension) {
        this.im.setImage(null);
        this.size = dimension;
        this.setRectangle(new Rectangle(0, 5, this.size.width - 5, this.size.height - 10));
    }
}

