/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.gui.components.r2.chart;

import com.cosylab.gui.components.r2.chart.Point;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;

public class PointCollector {
    private ReferenceQueue queue = new ReferenceQueue();
    private Point first = null;
    private Point last = null;
    private int recycled = 0;
    private int created = 0;
    private int size = 0;
    private int capacity = 10;

    public PointCollector() {
    }

    public PointCollector(int n) {
        this.capacity = n;
    }

    public void finalize() {
        System.out.println(this + " r:" + this.recycled + " c:" + this.created);
    }

    public Point newPoint() {
        Reference reference;
        while ((reference = this.queue.poll()) != null) {
            if (reference.get() == null) continue;
            ++this.recycled;
            return (Point)reference.get();
        }
        if (this.first != null) {
            Point point = this.first;
            this.first = this.first.next;
            point.next = null;
            --this.size;
            ++this.recycled;
            return point;
        }
        ++this.created;
        Point point = new Point();
        new SoftReference<Point>(point, this.queue);
        return point;
    }

    public Point newPoint(double d, double d2) {
        Point point = this.newPoint();
        point.x = d;
        point.y = d2;
        return point;
    }

    public void recyclePoint(Point point) {
        if (point == null) {
            return;
        }
        point.next = null;
        if (this.size >= this.capacity) {
            return;
        }
        if (this.first == null) {
            this.first = this.last = point;
        } else {
            this.last.next = point;
            this.last = point;
        }
        ++this.size;
    }

    public void setCapacity(int n) {
        this.capacity = n;
    }
}

