/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.gui.components.r2.chart;

import com.cosylab.gui.components.r2.chart.ChartStyle;
import com.cosylab.gui.components.r2.chart.IntPoint;
import com.cosylab.gui.components.r2.chart.IntPointIterator;
import java.awt.Color;
import java.awt.Graphics;

public class PlainChartStyle
implements ChartStyle {
    private int symbolStyle = 1;
    private int lineStyle = 1;
    private Color symbolColor = Color.black;
    private Color lineColor = Color.black;
    private int symbolSize = 7;
    public static final int SYMBOL_NONE = 0;
    public static final int SYMBOL_DOT = 1;
    public static final int LINE_NONE = 0;
    public static final int LINE_PLAIN = 1;
    protected boolean editable = true;

    public PlainChartStyle() {
    }

    public PlainChartStyle(int n, Color color, int n2, int n3, Color color2) {
        this.lineStyle = n;
        this.lineColor = color;
        this.symbolStyle = n2;
        this.symbolSize = n3;
        this.symbolColor = color2;
    }

    protected void drawDots(IntPointIterator intPointIterator, Graphics graphics) {
        graphics.setColor(this.symbolColor);
        int n = (int)((double)this.symbolSize / 2.0);
        while (intPointIterator.hasNext()) {
            IntPoint intPoint = intPointIterator.next();
            graphics.fillOval(intPoint.x - n, intPoint.y - n, this.symbolSize, this.symbolSize);
        }
    }

    public void drawGraph(IntPointIterator intPointIterator, Graphics graphics) {
        if (this.lineStyle == 1 && this.symbolStyle == 0) {
            this.drawLine(intPointIterator, graphics);
        } else if (this.lineStyle == 0 && this.symbolStyle == 1) {
            this.drawDots(intPointIterator, graphics);
        } else if (this.lineStyle == 1 && this.symbolStyle == 1) {
            this.drawLineDots(intPointIterator, graphics);
        }
    }

    protected void drawLine(IntPointIterator intPointIterator, Graphics graphics) {
        graphics.setColor(this.lineColor);
        IntPoint intPoint = null;
        if (intPointIterator.hasNext()) {
            intPoint = intPointIterator.next();
        }
        while (intPointIterator.hasNext()) {
            IntPoint intPoint2 = intPointIterator.next();
            graphics.drawLine(intPoint.x, intPoint.y, intPoint2.x, intPoint2.y);
            intPoint = intPoint2;
        }
    }

    protected void drawLineDots(IntPointIterator intPointIterator, Graphics graphics) {
        int n = (int)((double)this.symbolSize / 2.0);
        IntPoint intPoint = null;
        if (intPointIterator.hasNext()) {
            intPoint = intPointIterator.next();
        }
        while (intPointIterator.hasNext()) {
            IntPoint intPoint2 = intPointIterator.next();
            graphics.setColor(this.lineColor);
            graphics.drawLine(intPoint.x, intPoint.y, intPoint2.x, intPoint2.y);
            graphics.setColor(this.symbolColor);
            graphics.fillOval(intPoint.x - n, intPoint.y - n, this.symbolSize, this.symbolSize);
            intPoint = intPoint2;
        }
        if (intPoint != null) {
            graphics.setColor(this.symbolColor);
            graphics.fillOval(intPoint.x - n, intPoint.y - n, this.symbolSize, this.symbolSize);
        }
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public int getLineStyle() {
        return this.lineStyle;
    }

    public Color getSymbolColor() {
        return this.symbolColor;
    }

    public int getSymbolSize() {
        return this.symbolSize;
    }

    public int getSymbolStyle() {
        return this.symbolStyle;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setLineColor(Color color) {
        this.lineColor = color;
    }

    public void setLineStyle(int n) {
        this.lineStyle = n;
    }

    public void setSymbolColor(Color color) {
        this.symbolColor = color;
    }

    public void setSymbolSize(int n) {
        this.symbolSize = n;
    }

    public void setSymbolStyle(int n) {
        this.symbolStyle = n;
    }
}

