/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.gui.components.r2.chart;

import com.cosylab.gui.components.r2.chart.IntervalListener;
import java.util.ArrayList;

public class Interval {
    private double min = 0.0;
    private double max = 1.0;
    private ArrayList list;
    private boolean logaritmic = false;

    public Interval() {
    }

    public Interval(double d, double d2) {
        this.min = d;
        this.max = d2;
    }

    public synchronized void addIntervalListener(IntervalListener intervalListener) {
        if (intervalListener == null) {
            return;
        }
        if (this.list == null) {
            this.list = new ArrayList(10);
        }
        this.list.add(intervalListener);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        return object instanceof Interval && ((Interval)object).max == this.max && ((Interval)object).min == this.min;
    }

    private void fireIntervalChange() {
        if (this.list == null) {
            return;
        }
        for (int i = 0; i < this.list.size(); ++i) {
            try {
                ((IntervalListener)this.list.get(i)).intervalChange(this);
                continue;
            }
            catch (Throwable throwable) {
                System.out.println("Error IntervalChange event dispatching:");
                throwable.printStackTrace();
            }
        }
    }

    public double getLength() {
        return this.max - this.min;
    }

    public boolean isLogaritmic() {
        return this.logaritmic;
    }

    public double length() {
        return this.max - this.min;
    }

    public double max() {
        return this.max;
    }

    public double min() {
        return this.min;
    }

    public synchronized void removeIntervalListener(IntervalListener intervalListener) {
        if (this.list != null) {
            this.list.remove(intervalListener);
        }
    }

    public void set(double d, double d2) {
        this.min = d;
        this.max = d2;
        this.fireIntervalChange();
    }

    public void set(Interval interval) {
        if (interval == null) {
            return;
        }
        this.min = interval.min();
        this.max = interval.max();
        this.fireIntervalChange();
    }

    public void setLogaritmic(boolean bl) {
        this.logaritmic = bl;
        this.fireIntervalChange();
    }

    public void setMax(double d) {
        this.max = d;
        this.fireIntervalChange();
    }

    public void setMin(double d) {
        this.min = d;
        this.fireIntervalChange();
    }

    public void shift(double d) {
        this.set(this.min + d, this.max + d);
        this.fireIntervalChange();
    }

    public String toString() {
        return "Interval[" + this.min + "," + this.max + "]";
    }

    public void unionWith(Interval interval) {
        if (interval == null) {
            return;
        }
        boolean bl = false;
        if (interval.min() < this.min) {
            this.min = interval.min();
            bl = true;
        }
        if (interval.max() > this.max) {
            this.max = interval.max();
            bl = true;
        }
        if (bl) {
            this.fireIntervalChange();
        }
    }
}

