/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.gui.components.r2.chart;

import com.cosylab.gui.components.r2.chart.IntPoint;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;

public class IntPointCollector {
    private ReferenceQueue queue = new ReferenceQueue();
    private IntPoint first = null;
    private IntPoint last = null;
    private int recycled = 0;
    private int created = 0;
    private int size = 0;
    private int capacity = 10;

    public IntPointCollector() {
    }

    public IntPointCollector(int n) {
        this.capacity = n;
    }

    public void finalize() {
        System.out.println(this + " r:" + this.recycled + " c:" + this.created);
    }

    public IntPoint newPoint() {
        Reference reference;
        while ((reference = this.queue.poll()) != null) {
            if (reference.get() == null) continue;
            ++this.recycled;
            return (IntPoint)reference.get();
        }
        if (this.first != null) {
            IntPoint intPoint = this.first;
            this.first = this.first.next;
            intPoint.next = null;
            --this.size;
            ++this.recycled;
            return intPoint;
        }
        ++this.created;
        IntPoint intPoint = new IntPoint();
        new SoftReference<IntPoint>(intPoint, this.queue);
        return intPoint;
    }

    public IntPoint newPoint(int n, int n2) {
        IntPoint intPoint = this.newPoint();
        intPoint.x = n;
        intPoint.y = n2;
        return intPoint;
    }

    public void recyclePoint(IntPoint intPoint) {
        if (intPoint == null) {
            return;
        }
        intPoint.next = null;
        if (this.size >= this.capacity) {
            return;
        }
        if (this.first == null) {
            this.first = this.last = intPoint;
        } else {
            this.last.next = intPoint;
            this.last = intPoint;
        }
        ++this.size;
    }

    public void setCapacity(int n) {
        this.capacity = n;
    }
}

