/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.gui.components.r2.chart;

import com.cosylab.gui.components.r2.chart.ChartDataModel;
import com.cosylab.gui.components.r2.chart.ChartProperties;
import com.cosylab.gui.components.r2.chart.ChartService;
import com.cosylab.gui.components.r2.chart.DefaultDataService;
import com.cosylab.gui.components.r2.chart.Point;
import com.cosylab.gui.components.r2.chart.PointCollector;
import com.cosylab.gui.components.r2.chart.PointIterator;
import com.cosylab.gui.components.r2.chart.PointTransformerModel;
import com.cosylab.gui.components.r2.chart.TrendPointTransformer;
import java.util.Iterator;
import java.util.LinkedList;

public class HistoryTrendPointService
extends DefaultDataService {
    public LinkedList history = new LinkedList();
    public PointCollector pointCollector = new PointCollector();
    public PointInterceptor interceptor = new PointInterceptor();
    public HistoryIterator historyInterator = new HistoryIterator();
    private boolean resetToHistory = false;

    public HistoryTrendPointService(ChartDataModel chartDataModel, ChartService chartService, PointTransformerModel pointTransformerModel) {
        super(chartDataModel, chartService, pointTransformerModel);
    }

    public Point addPoint(Point point) {
        Point point2 = this.pointCollector.newPoint();
        point2.x = point.x;
        point2.y = point.y;
        this.history.addLast(point2);
        return point;
    }

    public LinkedList getHistory() {
        return this.history;
    }

    public PointCollector getPointCollector() {
        return this.pointCollector;
    }

    public boolean isResetToHistory() {
        return this.resetToHistory;
    }

    public void packHistory(double d) {
        double d2 = ((Point)this.history.getLast()).x - d;
        while (d2 > ((Point)this.history.getFirst()).x) {
            this.history.removeFirst();
        }
    }

    public void resetToHistory() {
        this.resetToHistory = true;
    }

    public int transform() {
        if (this.resetToHistory) {
            if (ChartProperties.getChartProperties().isDebugData()) {
                System.out.println("ResetToHistory");
            }
            this.resetToHistory = false;
            if (this.history.size() == 0) {
                return 1;
            }
            this.historyInterator.init(this.history);
            ((TrendPointTransformer)this.pointTransformer).clearLast();
            this.pointTransformer.transform(this.historyInterator);
        } else {
            if (this.dataModel.getPointCount() == 0) {
                return 1;
            }
            this.interceptor.intercept(this.dataModel.getPointIterator());
            this.pointTransformer.transform(this.interceptor);
            this.packHistory(this.pointTransformer.getXScale().getLength());
        }
        return 0;
    }

    class HistoryIterator
    implements PointIterator {
        public Iterator it;

        HistoryIterator() {
        }

        public void init(LinkedList linkedList) {
            this.it = linkedList.iterator();
        }

        public Point next() {
            return (Point)this.it.next();
        }

        public boolean hasNext() {
            return this.it.hasNext();
        }
    }

    class PointInterceptor
    implements PointIterator {
        PointIterator it;
        Point last;

        PointInterceptor() {
        }

        public void intercept(PointIterator pointIterator) {
            this.it = pointIterator;
        }

        public Point next() {
            return HistoryTrendPointService.this.addPoint(this.it.next());
        }

        public boolean hasNext() {
            return this.it.hasNext();
        }
    }
}

