/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.gui.components.r2.chart;

import com.cosylab.gui.components.r2.chart.ChartDataModel;
import com.cosylab.gui.components.r2.chart.ChartService;
import com.cosylab.gui.components.r2.chart.HistoryTrendPointService;
import com.cosylab.gui.components.r2.chart.Interval;
import com.cosylab.gui.components.r2.chart.IntervalListener;
import com.cosylab.gui.components.r2.chart.TrendChartArea;
import com.cosylab.gui.components.r2.chart.TrendPointTransformer;
import java.awt.Dimension;
import java.util.Iterator;

public class HistoryTrendChartArea
extends TrendChartArea {
    private IntervalListener intervalXListener = new XListener();
    private IntervalListener intervalYListener = new YListener();

    public HistoryTrendChartArea() {
    }

    public HistoryTrendChartArea(ChartService chartService) {
        super(chartService);
    }

    public void addDataModel(ChartDataModel chartDataModel) {
        TrendPointTransformer trendPointTransformer = null;
        trendPointTransformer = new TrendPointTransformer();
        HistoryTrendPointService historyTrendPointService = new HistoryTrendPointService(chartDataModel, this.chartService, trendPointTransformer);
        this.models.add(historyTrendPointService);
        this.model2service.put(chartDataModel, historyTrendPointService);
        trendPointTransformer.setChartRectangle(this.chartRectangle);
    }

    public void setChartService(ChartService chartService) {
        Iterator iterator;
        if (this.chartService != null) {
            iterator = this.chartService.getViewManager().extractedXScaleIterator();
            while (iterator.hasNext()) {
                ((Interval)iterator.next()).removeIntervalListener(this.intervalXListener);
            }
            iterator = this.chartService.getViewManager().extractedYScaleIterator();
            while (iterator.hasNext()) {
                ((Interval)iterator.next()).removeIntervalListener(this.intervalYListener);
            }
        }
        super.setChartService(chartService);
        iterator = this.chartService.getViewManager().extractedXScaleIterator();
        while (iterator.hasNext()) {
            ((Interval)iterator.next()).addIntervalListener(this.intervalXListener);
        }
        iterator = this.chartService.getViewManager().extractedYScaleIterator();
        while (iterator.hasNext()) {
            ((Interval)iterator.next()).addIntervalListener(this.intervalYListener);
        }
    }

    public void setSize(Dimension dimension) {
        super.setSize(dimension);
        Iterator iterator = this.models.iterator();
        while (iterator.hasNext()) {
            ((HistoryTrendPointService)iterator.next()).resetToHistory();
        }
    }

    class YListener
    implements IntervalListener {
        private double length = 0.0;

        YListener() {
        }

        public void intervalChange(Interval interval) {
            if (Math.abs(this.length - interval.length()) > 1.0E-10) {
                this.length = interval.length();
                Iterator iterator = HistoryTrendChartArea.this.models.iterator();
                while (iterator.hasNext()) {
                    ((HistoryTrendPointService)iterator.next()).resetToHistory();
                }
            }
        }
    }

    class XListener
    implements IntervalListener {
        private double length = 0.0;

        XListener() {
        }

        public void intervalChange(Interval interval) {
            if (Math.abs(this.length - interval.length()) > 1.0E-10) {
                this.length = interval.length();
                Iterator iterator = HistoryTrendChartArea.this.models.iterator();
                while (iterator.hasNext()) {
                    ((HistoryTrendPointService)iterator.next()).resetToHistory();
                }
            }
        }
    }
}

