/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.gui.components.r2.chart;

import com.cosylab.gui.components.r2.chart.IntPoint;
import com.cosylab.gui.components.r2.chart.IntPointCollector;
import com.cosylab.gui.components.r2.chart.IntPointIterator;
import com.cosylab.gui.components.r2.chart.Interval;
import com.cosylab.gui.components.r2.chart.IntervalListener;
import com.cosylab.gui.components.r2.chart.Point;
import com.cosylab.gui.components.r2.chart.PointIterator;
import com.cosylab.gui.components.r2.chart.PointTransformerModel;
import java.awt.Rectangle;

public class DefaultPointTransformer
implements PointTransformerModel {
    protected double x0 = 0.0;
    protected double x1 = 0.0;
    protected double y0 = 0.0;
    protected double y1 = 0.0;
    protected Rectangle chartRectangle = new Rectangle(0, 0, 10, 10);
    protected Interval xScale = new Interval(0.0, 1.0);
    protected Interval yScale = new Interval(0.0, 1.0);
    protected Point maxValue = new Point();
    protected Point minValue = new Point();
    protected IntPointCollector points = new IntPointCollector(300);
    protected IntPoint first;
    protected IntPoint last;
    protected int count = 0;
    protected Point lastPoint;
    protected IntervalListener listener = new IntervalListener(){

        public void intervalChange(Interval interval) {
            DefaultPointTransformer.this.updateTransformation();
        }
    };

    public DefaultPointTransformer() {
        this.updateTransformation();
    }

    protected IntPoint add(IntPoint intPoint) {
        if (this.last != null) {
            this.last.next = intPoint;
        }
        this.last = intPoint;
        if (this.first == null) {
            this.first = intPoint;
        }
        ++this.count;
        return intPoint;
    }

    public void clear() {
        IntPointIterator intPointIterator = this.pointIterator();
        while (intPointIterator.hasNext()) {
            intPointIterator.next();
        }
    }

    public Rectangle getChartRectangle() {
        return this.chartRectangle;
    }

    public int getCount() {
        return this.count;
    }

    public IntPoint getFirstIntPoint() {
        return this.first;
    }

    public IntPoint getLastIntPoint() {
        return this.last;
    }

    public Point getLastPoint() {
        return this.lastPoint;
    }

    public Point getMaxValue() {
        return this.maxValue;
    }

    public Point getMinValue() {
        return this.minValue;
    }

    public Interval getXScale() {
        return this.xScale;
    }

    public Interval getYScale() {
        return this.yScale;
    }

    public IntPointIterator pointIterator() {
        return new IntPointIterator(){
            IntPoint p;
            {
                this.p = DefaultPointTransformer.this.first;
            }

            public boolean hasNext() {
                return this.p != null;
            }

            public IntPoint next() {
                if (this.p == null) {
                    return null;
                }
                this.p = this.p.next;
                return DefaultPointTransformer.this.removeFirst();
            }
        };
    }

    protected IntPoint removeFirst() {
        if (this.first != null) {
            IntPoint intPoint = this.first;
            this.first = this.first.next;
            if (this.first == null) {
                this.last = null;
            }
            --this.count;
            this.points.recyclePoint(intPoint);
            return intPoint;
        }
        return null;
    }

    public void setChartRectangle(Rectangle rectangle) {
        this.chartRectangle = rectangle;
        this.updateTransformation();
    }

    public void setXScale(Interval interval) {
        if (this.xScale != null) {
            this.xScale.removeIntervalListener(this.listener);
        }
        this.xScale = interval;
        if (this.xScale != null) {
            this.xScale.addIntervalListener(this.listener);
        }
        this.updateTransformation();
    }

    public void setYScale(Interval interval) {
        if (this.yScale != null) {
            this.yScale.removeIntervalListener(this.listener);
        }
        this.yScale = interval;
        if (this.yScale != null) {
            this.yScale.addIntervalListener(this.listener);
        }
        this.updateTransformation();
    }

    public void transform(PointIterator pointIterator) {
        if (!pointIterator.hasNext()) {
            return;
        }
        this.updateTransformation();
        int n = this.chartRectangle.x;
        int n2 = this.chartRectangle.y;
        this.maxValue.y = Double.MIN_VALUE;
        this.maxValue.x = 0.0;
        this.minValue.y = Double.MAX_VALUE;
        this.minValue.x = 0.0;
        Point point = null;
        while (pointIterator.hasNext()) {
            point = pointIterator.next();
            int n3 = n + (int)Math.rint((point.x - this.x0) * this.x1);
            int n4 = n2 + this.chartRectangle.height - 1 - (int)Math.rint((point.y - this.y0) * this.y1);
            if (Double.isInfinite(n4)) {
                n4 = this.chartRectangle.height + 1;
                System.out.println("Autocorrect: (" + n3 + ",Infinite) -> (" + n3 + "," + n4 + ")");
            }
            if (Double.isNaN(n4)) {
                n4 = 0;
                System.out.println("Autocorrect: (" + n3 + ",NaN) -> (" + n3 + "," + n4 + ")");
            }
            this.add(this.points.newPoint(n3, n4));
            if (Double.isInfinite(point.y) || Double.isNaN(point.y)) continue;
            if (point.y > this.maxValue.y) {
                this.maxValue.y = point.y;
                this.maxValue.x = point.x;
                continue;
            }
            if (!(point.y < this.minValue.y)) continue;
            this.minValue.y = point.y;
            this.minValue.x = point.x;
        }
        if (this.lastPoint == null) {
            this.lastPoint = (Point)point.clone();
        } else {
            this.lastPoint.x = point.x;
            this.lastPoint.y = point.y;
        }
    }

    protected void updateTransformation() {
        this.x0 = this.xScale.min();
        this.x1 = (double)(this.chartRectangle.width - 1) / (this.xScale.max() - this.xScale.min());
        this.y0 = this.yScale.min();
        this.y1 = (double)(this.chartRectangle.height - 1) / (this.yScale.max() - this.yScale.min());
    }
}

