/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.gui.components.r2.chart;

import com.cosylab.gui.components.r2.chart.AbstractChartAxis;
import com.cosylab.gui.components.r2.chart.ChartYAxis;
import java.awt.FontMetrics;
import java.awt.Graphics;

public class DefaultChartYAxis
extends AbstractChartAxis
implements ChartYAxis {
    public void drawAxis(Graphics graphics) {
        if (this.chartSize == null) {
            return;
        }
        if (this.yScale.isLogaritmic()) {
            this.drawLogAxis(graphics);
        } else {
            this.drawLinAxis(graphics);
        }
    }

    private void drawLinAxis(Graphics graphics) {
        graphics.setColor(this.lineColor);
        graphics.drawLine(0, -this.majorTickLength, 0, this.chartSize.height - 1 + this.majorTickLength);
        graphics.drawLine(1 - this.majorTickLength, 0, 0, 0);
        if (this.chartSize.width < 20) {
            return;
        }
        for (int i = 0; i < 9; ++i) {
            graphics.drawLine(1 - this.minorTickLength, (int)((double)(i + 1) * (double)this.chartSize.height / 10.0), 0, (int)((double)(i + 1) * (double)this.chartSize.height / 10.0));
        }
        graphics.setColor(this.fontColor);
        graphics.setFont(this.font);
        String string = this.format(this.yScale.min());
        FontMetrics fontMetrics = graphics.getFontMetrics(this.font);
        int n = fontMetrics.stringWidth(string);
        graphics.drawString(string, -n - this.majorTickLength - this.textMargin.right, this.chartSize.height - 2 + (int)((double)fontMetrics.getHeight() / 3.0));
        string = this.format(this.yScale.max());
        int n2 = fontMetrics.stringWidth(string);
        graphics.drawString(string, -n2 - this.majorTickLength - this.textMargin.right, (int)((double)fontMetrics.getHeight() / 3.0) - 1);
        this.preferedHeight = fontMetrics.getHeight() + this.textMargin.bottom + this.textMargin.top + this.majorTickLength;
        this.preferedWidth = (n > n2 ? n : n2) + this.textMargin.left + this.textMargin.right + this.majorTickLength;
    }

    private void drawLogAxis(Graphics graphics) {
        graphics.drawLine(0, -this.majorTickLength, 0, this.chartSize.height - 1 + this.majorTickLength);
        graphics.drawLine(1 - this.majorTickLength, 0, 0, 0);
        String string = this.format(this.yScale.min());
        FontMetrics fontMetrics = graphics.getFontMetrics(this.font);
        int n = fontMetrics.stringWidth(string);
        graphics.drawString(string, -n - this.majorTickLength - this.textMargin.right, this.chartSize.height - 2 + (int)((double)fontMetrics.getHeight() / 2.0));
        string = this.format(this.yScale.max());
        int n2 = fontMetrics.stringWidth(string);
        graphics.drawString(string, -n2 - this.majorTickLength - this.textMargin.right, (int)((double)fontMetrics.getHeight() / 2.0) - 1);
        this.preferedHeight = fontMetrics.getHeight() + this.textMargin.bottom + this.textMargin.top + this.majorTickLength;
        this.preferedWidth = (n > n2 ? n : n2) + this.textMargin.left + this.textMargin.right + this.majorTickLength;
        if (this.chartSize.width < 20) {
            return;
        }
        for (int i = 1; i < 10; ++i) {
            graphics.drawLine(1 - this.minorTickLength, (int)(Math.log(i) * (double)this.chartSize.height), 0, (int)(Math.log(i) * (double)this.chartSize.height));
        }
    }
}

