/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.gui.components.r2.chart;

import com.cosylab.gui.components.r2.chart.ChartViewManager;
import com.cosylab.gui.components.r2.chart.Interval;
import com.cosylab.gui.components.r2.chart.IntervalListener;
import java.util.ArrayList;
import java.util.Iterator;

public class DefaultChartViewManager
implements ChartViewManager {
    protected boolean preferedYScaleUsed = true;
    protected boolean preferedXScaleUsed = true;
    protected Interval yScale = new Interval(0.0, 1.0);
    protected Interval xScale = new Interval(0.0, 1.0);
    protected ArrayList xScales = new ArrayList(10);
    protected ArrayList yScales = new ArrayList(10);
    protected Interval extXScale = new Interval(0.0, 1.0);
    protected Interval extYScale = new Interval(0.0, 1.0);
    protected IntervalListener xScaleListener = new IntervalListener(){

        public void intervalChange(Interval interval) {
            if (!DefaultChartViewManager.this.preferedXScaleUsed) {
                DefaultChartViewManager.this.extXScale.set(DefaultChartViewManager.this.xScale);
            }
        }
    };
    protected IntervalListener yScaleListener = new IntervalListener(){

        public void intervalChange(Interval interval) {
            if (!DefaultChartViewManager.this.preferedYScaleUsed) {
                DefaultChartViewManager.this.extYScale.set(DefaultChartViewManager.this.yScale);
            }
        }
    };
    protected IntervalListener yUserScaleListener = new IntervalListener(){

        public void intervalChange(Interval interval) {
            if (DefaultChartViewManager.this.preferedYScaleUsed) {
                DefaultChartViewManager.this.setToPreferedYScale();
            }
        }
    };
    protected IntervalListener xUserScaleListener = new IntervalListener(){

        public void intervalChange(Interval interval) {
            if (DefaultChartViewManager.this.preferedXScaleUsed) {
                DefaultChartViewManager.this.setToPreferedXScale();
            }
        }
    };

    public Interval addUserXScale(Interval interval) {
        if (interval == null) {
            return this.extXScale;
        }
        this.xScales.add(interval);
        interval.addIntervalListener(this.xUserScaleListener);
        if (this.preferedXScaleUsed) {
            this.setToPreferedXScale();
        }
        return this.extXScale;
    }

    public Interval addUserYScale(Interval interval) {
        if (interval == null) {
            return this.extYScale;
        }
        this.yScales.add(interval);
        interval.addIntervalListener(this.yUserScaleListener);
        if (this.preferedYScaleUsed) {
            this.setToPreferedYScale();
        }
        return this.extYScale;
    }

    public Iterator extractedXScaleIterator() {
        return new Iterator(){
            Interval i;
            {
                this.i = DefaultChartViewManager.this.extXScale;
            }

            public boolean hasNext() {
                return this.i != null;
            }

            public Object next() {
                Interval interval = this.i;
                this.i = null;
                return interval;
            }

            public void remove() {
            }
        };
    }

    public Iterator extractedYScaleIterator() {
        return new Iterator(){
            Interval i;
            {
                this.i = DefaultChartViewManager.this.extYScale;
            }

            public boolean hasNext() {
                return this.i != null;
            }

            public Object next() {
                Interval interval = this.i;
                this.i = null;
                return interval;
            }

            public void remove() {
            }
        };
    }

    public int getExctractedXScaleCount() {
        return 1;
    }

    public int getExctractedYScaleCount() {
        return 1;
    }

    public Interval getExtractedXScale(Interval interval) {
        return this.extXScale;
    }

    public Interval getExtractedYScale(Interval interval) {
        return this.extYScale;
    }

    public Interval getXScale() {
        return this.xScale;
    }

    public Interval getYScale() {
        return this.yScale;
    }

    public boolean isUserXScaleUsed() {
        return this.preferedXScaleUsed;
    }

    public boolean isUserYScaleUsed() {
        return this.preferedYScaleUsed;
    }

    public void removeUserXScale(Interval interval) {
        this.xScales.remove(interval);
        interval.removeIntervalListener(this.xUserScaleListener);
    }

    public void removeUserYScale(Interval interval) {
        this.yScales.remove(interval);
        interval.removeIntervalListener(this.yUserScaleListener);
    }

    public void revalidate() {
        if (this.preferedXScaleUsed) {
            this.setToPreferedXScale();
        } else {
            this.extXScale.set(this.xScale);
        }
        if (this.preferedYScaleUsed) {
            this.setToPreferedYScale();
        } else {
            this.extYScale.set(this.yScale);
        }
    }

    protected void setToPreferedXScale() {
        boolean bl = true;
        Iterator iterator = this.xScales.iterator();
        while (iterator.hasNext()) {
            Interval interval = (Interval)iterator.next();
            if (bl) {
                this.extXScale.set(interval);
                bl = false;
                continue;
            }
            this.extXScale.unionWith(interval);
        }
    }

    protected void setToPreferedYScale() {
        boolean bl = true;
        Iterator iterator = this.yScales.iterator();
        while (iterator.hasNext()) {
            Interval interval = (Interval)iterator.next();
            if (bl) {
                this.extYScale.set(interval);
                bl = false;
                continue;
            }
            this.extYScale.unionWith(interval);
        }
    }

    public void setUserXScaleUsed(boolean bl) {
        this.preferedXScaleUsed = bl;
        if (this.preferedXScaleUsed) {
            this.setToPreferedXScale();
        } else {
            this.extXScale.set(this.xScale);
        }
    }

    public void setUserYScaleUsed(boolean bl) {
        this.preferedYScaleUsed = bl;
        if (this.preferedYScaleUsed) {
            this.setToPreferedYScale();
        } else {
            this.extYScale.set(this.yScale);
        }
    }

    public void setXScale(Interval interval) {
        if (interval == null) {
            throw new NullPointerException("New scale is null");
        }
        if (this.xScale != null) {
            this.xScale.removeIntervalListener(this.xScaleListener);
        }
        this.xScale = interval;
        this.xScale.addIntervalListener(this.xScaleListener);
        this.preferedXScaleUsed = false;
        this.extXScale.set(this.xScale);
    }

    public void setYScale(Interval interval) {
        if (interval == null) {
            throw new NullPointerException("New scale is null");
        }
        if (this.yScale != null) {
            this.yScale.removeIntervalListener(this.yScaleListener);
        }
        this.yScale = interval;
        this.yScale.addIntervalListener(this.yScaleListener);
        this.preferedYScaleUsed = false;
        this.extYScale.set(this.yScale);
    }

    public Iterator xScaleIterator() {
        return this.xScales.iterator();
    }

    public Iterator yScaleIterator() {
        return this.yScales.iterator();
    }
}

