/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.gui.components.r2.chart;

import com.cosylab.gui.components.r2.chart.ChartArea;
import com.cosylab.gui.components.r2.chart.ChartDataModel;
import com.cosylab.gui.components.r2.chart.ChartDataService;
import com.cosylab.gui.components.r2.chart.ChartService;
import com.cosylab.gui.components.r2.chart.ChartUpdateRequest;
import com.cosylab.gui.components.r2.chart.Chartics;
import com.cosylab.gui.components.r2.chart.DefaultDataService;
import com.cosylab.gui.components.r2.chart.DefaultPointTransformer;
import com.cosylab.gui.components.r2.chart.Point;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class DefaultChartArea
implements ChartArea {
    protected ArrayList models = new ArrayList(1);
    protected ChartService chartService;
    HashMap model2service = new HashMap();
    protected Rectangle chartRectangle = new Rectangle();
    protected Dimension size = new Dimension(10, 10);

    public DefaultChartArea() {
    }

    public DefaultChartArea(ChartService chartService) {
        this();
        this.setChartService(chartService);
    }

    public void addDataModel(ChartDataModel chartDataModel) {
        DefaultPointTransformer defaultPointTransformer = null;
        defaultPointTransformer = new DefaultPointTransformer();
        DefaultDataService defaultDataService = new DefaultDataService(chartDataModel, this.chartService, defaultPointTransformer);
        this.models.add(defaultDataService);
        this.model2service.put(chartDataModel, defaultDataService);
        defaultPointTransformer.setChartRectangle(this.chartRectangle);
    }

    public void drawData(Chartics chartics, ChartUpdateRequest chartUpdateRequest) {
        if (this.models.size() == 0) {
            return;
        }
        Iterator iterator = this.models.iterator();
        while (iterator.hasNext()) {
            ChartDataService chartDataService = (ChartDataService)iterator.next();
            chartDataService.prepare();
            if (0 != chartDataService.transform()) continue;
            chartics.drawGraph(chartDataService.getPointTransformer().pointIterator(), chartDataService.getDataModel().getChartStyle());
        }
    }

    public Rectangle getChartRectangle() {
        return this.chartRectangle;
    }

    public ChartService getChartService() {
        return this.chartService;
    }

    public ChartDataModel getDataModel(int n) {
        return ((ChartDataService)this.models.get(n)).getDataModel();
    }

    public int getDataModelCount() {
        return this.models.size();
    }

    public ChartDataModel[] getDataModels() {
        ChartDataModel[] chartDataModelArray = new ChartDataModel[this.models.size()];
        this.models.toArray(chartDataModelArray);
        return chartDataModelArray;
    }

    public Point getMaxValue() {
        Point point = new Point(0.0, Double.MIN_VALUE);
        Iterator iterator = this.models.iterator();
        while (iterator.hasNext()) {
            Point point2;
            Point point3 = ((ChartDataService)iterator.next()).getPointTransformer().getMaxValue();
            if (!(point2.y > point.y)) continue;
            point = point3;
        }
        return point;
    }

    public Point getMinValue() {
        Point point = new Point(0.0, Double.MAX_VALUE);
        Iterator iterator = this.models.iterator();
        while (iterator.hasNext()) {
            Point point2;
            Point point3 = ((ChartDataService)iterator.next()).getPointTransformer().getMinValue();
            if (!(point2.y < point.y)) continue;
            point = point3;
        }
        return point;
    }

    public Dimension getSize() {
        return this.size;
    }

    public void removeDataModel(ChartDataModel chartDataModel) {
        this.models.remove(this.model2service.get(chartDataModel));
        this.model2service.remove(chartDataModel);
        this.chartService.getChartStyleManager().returnStyle(chartDataModel);
        this.chartService.getViewManager().removeUserXScale(chartDataModel.getPreferedXScale());
        this.chartService.getViewManager().removeUserYScale(chartDataModel.getPreferedYScale());
    }

    public void setChartService(ChartService chartService) {
        this.chartService = chartService;
        Iterator iterator = this.models.iterator();
        while (iterator.hasNext()) {
            ChartDataService chartDataService = (ChartDataService)iterator.next();
            chartDataService.setChartService(this.chartService);
        }
    }

    protected void setRectangle(Rectangle rectangle) {
        this.chartRectangle = rectangle;
        Iterator iterator = this.models.iterator();
        while (iterator.hasNext()) {
            ((ChartDataService)iterator.next()).getPointTransformer().setChartRectangle(this.chartRectangle);
        }
    }

    public void setSize(Dimension dimension) {
        this.chartRectangle = new Rectangle(dimension);
        this.size = dimension;
        this.setRectangle(new Rectangle(5, 5, this.size.width - 10, this.size.height - 10));
    }
}

