/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.gui.components.r2.chart;

import com.cosylab.gui.components.r2.chart.ChartDataListener;
import com.cosylab.gui.components.r2.chart.ChartDataModel;
import com.cosylab.gui.components.r2.chart.ChartDataService;
import com.cosylab.gui.components.r2.chart.ChartService;
import com.cosylab.gui.components.r2.chart.ChartStyleManager;
import com.cosylab.gui.components.r2.chart.ChartUpdateRequest;
import com.cosylab.gui.components.r2.chart.ChartViewManager;
import com.cosylab.gui.components.r2.chart.DataChange;
import com.cosylab.gui.components.r2.chart.DataManageable;
import com.cosylab.gui.components.r2.chart.Interval;
import com.cosylab.gui.components.r2.chart.Point;
import com.cosylab.gui.components.r2.chart.PointCollector;
import com.cosylab.gui.components.r2.chart.PointIterator;
import com.cosylab.gui.components.r2.chart.PointTransformerModel;

class AutoscaleDataService
implements ChartService,
ChartDataService {
    public ChartDataModel dataModel;
    public ChartService chartService;
    public PointTransformerModel pointTransformer;
    public Interval xScale;
    public Interval yScale;
    protected PointCollector points = new PointCollector();
    protected Point point;
    protected int count = 0;

    public AutoscaleDataService(ChartDataModel chartDataModel, ChartService chartService, PointTransformerModel pointTransformerModel) {
        this.chartService = chartService;
        this.dataModel = chartDataModel;
        this.pointTransformer = pointTransformerModel;
        this.dataModel.setChartService(this);
        this.chartService.getChartStyleManager().getStyleForSerie(this.dataModel);
        this.xScale = chartDataModel.getPreferedXScale();
        this.yScale = new Interval();
        if (chartDataModel.getPreferedYScale() != null) {
            this.yScale.set(chartDataModel.getPreferedYScale().min(), chartDataModel.getPreferedYScale().max());
        }
        this.pointTransformer.setXScale(this.chartService.getViewManager().addUserXScale(this.xScale));
        this.pointTransformer.setYScale(this.chartService.getViewManager().addUserYScale(this.yScale));
        if (this.dataModel instanceof DataManageable) {
            ((DataManageable)((Object)this.dataModel)).getDataManager().addDataChartListener(new ChartDataListener(){

                public void dataChanged(DataChange dataChange) {
                    AutoscaleDataService.this.updateChart(dataChange);
                }
            });
        }
    }

    public int getChartDisplayablePointCount() {
        return this.chartService.getChartDisplayablePointCount();
    }

    public ChartService getChartService() {
        return this.chartService;
    }

    public ChartStyleManager getChartStyleManager() {
        return this.chartService.getChartStyleManager();
    }

    public ChartDataModel getDataModel() {
        return this.dataModel;
    }

    public PointTransformerModel getPointTransformer() {
        return this.pointTransformer;
    }

    public ChartViewManager getViewManager() {
        return this.chartService.getViewManager();
    }

    public void prepare() {
        Point point;
        if (this.dataModel.getPointCount() == 0) {
            this.count = 0;
            return;
        }
        double d = 0.0;
        double d2 = 0.0;
        this.count = 0;
        Point point2 = this.point;
        PointIterator pointIterator = this.dataModel.getPointIterator();
        if (pointIterator.hasNext()) {
            point = pointIterator.next();
            d = d2 = point.y;
            if (point2 != null) {
                point2.x = point.x;
                point2.y = point.y;
            } else {
                this.point = point2 = this.points.newPoint(point.x, point.y);
            }
            ++this.count;
        } else {
            return;
        }
        while (pointIterator.hasNext()) {
            point = pointIterator.next();
            if (point.y > d) {
                d = point.y;
            } else if (point.y < d2) {
                d2 = point.y;
            }
            if (point2.next != null) {
                point2 = point2.next;
                point2.x = point.x;
                point2.y = point.y;
            } else {
                point2 = point2.next = this.points.newPoint(point.x, point.y);
            }
            ++this.count;
        }
        double d3 = d - d2;
        if (d3 < Math.pow(10.0, -7.0)) {
            d3 = Math.pow(10.0, -7.0);
        }
        if (Math.abs(this.yScale.max() - d - d3 * 0.1) > d3 * 0.1 || Math.abs(this.yScale.min() - d2 + d3 * 0.1) > d3 * 0.1) {
            this.yScale.set(d2 - d3 * 0.1, d + d3 * 0.1);
        }
        point = point2.next;
        point2.next = null;
        point2 = point;
        while (point2 != null) {
            point = point2.next;
            this.points.recyclePoint(point2);
            point2 = point;
        }
    }

    public void setChartService(ChartService chartService) {
        this.chartService.getViewManager().removeUserXScale(this.xScale);
        this.chartService.getViewManager().removeUserYScale(this.yScale);
        this.chartService = chartService;
        this.dataModel.setChartService(this);
        this.chartService.getChartStyleManager().getStyleForSerie(this.dataModel);
        this.pointTransformer.setXScale(this.chartService.getViewManager().addUserXScale(this.xScale));
        this.pointTransformer.setYScale(this.chartService.getViewManager().addUserYScale(this.yScale));
    }

    public int transform() {
        if (this.count == 0) {
            return 1;
        }
        this.pointTransformer.transform(new PointIterator(){
            Point p;
            {
                this.p = AutoscaleDataService.this.point;
            }

            public boolean hasNext() {
                return this.p != null;
            }

            public Point next() {
                Point point = this.p;
                this.p = this.p.next;
                return point;
            }
        });
        return 0;
    }

    public void updateChart(ChartUpdateRequest chartUpdateRequest) {
        this.chartService.updateChart(chartUpdateRequest);
    }

    public void updateChart(DataChange dataChange) {
        switch (dataChange.getCode()) {
            case 0: {
                this.chartService.updateChart(ChartUpdateRequest.RELOAD_ALL);
                break;
            }
            case 1: {
                this.chartService.updateChart(ChartUpdateRequest.UPDATE_ALL);
                break;
            }
            default: {
                this.chartService.updateChart(ChartUpdateRequest.UPDATE_SERIE);
            }
        }
    }
}

