/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.gui.components.r2;

import com.cosylab.gui.components.r2.JIntegerTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class TimeChooser
extends JPanel {
    protected JIntegerTextField hourChooser;
    protected JIntegerTextField minuteChooser;
    protected JIntegerTextField secondChooser;
    private JLabel separator1;
    private JLabel separator2;
    private JLabel hourLabel;
    private JLabel minuteLabel;
    private JLabel secondsLabel;
    private Calendar calendar = new GregorianCalendar();

    public TimeChooser() {
        super(new GridBagLayout());
        this.createComponents();
        this.updateDisplay();
    }

    protected void createComponents() {
        NumberChangeListener numberChangeListener = new NumberChangeListener();
        this.hourLabel = new JLabel("Hours");
        this.add((Component)this.hourLabel, this.createConstraints(0, 0, 0.0, 4, 0));
        this.hourChooser = new JIntegerTextField();
        this.hourChooser.addPropertyChangeListener(numberChangeListener);
        this.add((Component)this.hourChooser, this.createConstraints(0, 1, 1.0, 0, 4));
        this.hourChooser.setMinimum(0);
        this.hourChooser.setMaximum(23);
        this.separator1 = new JLabel(":");
        this.add((Component)this.separator1, this.createConstraints(1, 1, 0.0, 4, 4));
        this.minuteLabel = new JLabel("Minutes");
        this.add((Component)this.minuteLabel, this.createConstraints(2, 0, 0.0, 4, 0));
        this.minuteChooser = new JIntegerTextField();
        this.minuteChooser.addPropertyChangeListener(numberChangeListener);
        this.add((Component)this.minuteChooser, this.createConstraints(2, 1, 1.0, 0, 4));
        this.minuteChooser.setMinimum(0);
        this.minuteChooser.setMaximum(59);
        this.separator2 = new JLabel(":");
        this.add((Component)this.separator2, this.createConstraints(3, 1, 0.0, 4, 4));
        this.secondsLabel = new JLabel("Seconds");
        this.add((Component)this.secondsLabel, this.createConstraints(4, 0, 0.0, 4, 0));
        this.secondChooser = new JIntegerTextField();
        this.secondChooser.addPropertyChangeListener(numberChangeListener);
        this.add((Component)this.secondChooser, this.createConstraints(4, 1, 1.0, 0, 4));
        this.secondChooser.setMinimum(0);
        this.secondChooser.setMaximum(59);
    }

    protected GridBagConstraints createConstraints(int n, int n2, double d, int n3, int n4) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.weightx = d;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(n3, 4, n4, 4);
        gridBagConstraints.anchor = 17;
        return gridBagConstraints;
    }

    public int getHour() {
        return this.calendar.get(11);
    }

    public int getMinute() {
        return this.calendar.get(12);
    }

    public int getSeconds() {
        return this.calendar.get(13);
    }

    public Date getTime() {
        System.out.println("TimeChooser.getTime()" + this.calendar.getTime().toString());
        return this.calendar.getTime();
    }

    public static void main(String[] stringArray) {
        JDialog jDialog = new JDialog();
        jDialog.setModal(true);
        jDialog.setSize(200, 100);
        jDialog.getContentPane().setLayout(new GridBagLayout());
        TimeChooser timeChooser = new TimeChooser();
        GridBagConstraints gridBagConstraints = timeChooser.createConstraints(0, 0, 1.0, 0, 0);
        gridBagConstraints.fill = 1;
        jDialog.getContentPane().add((Component)timeChooser, gridBagConstraints);
        jDialog.show();
        System.exit(0);
    }

    public void setEnabled(boolean bl) {
        this.hourChooser.setEnabled(bl);
        this.minuteChooser.setEnabled(bl);
        this.secondChooser.setEnabled(bl);
    }

    public void setHour(int n) {
        if (n != this.getHour()) {
            if (n < 0) {
                n = 0;
            }
            if (n > 23) {
                n = 23;
            }
            this.calendar.set(11, n);
            this.hourChooser.setIntegerValue(n);
        }
    }

    public void setMinute(int n) {
        if (n != this.getMinute()) {
            if (n < 0) {
                n = 0;
            }
            if (n > 59) {
                n = 59;
            }
            this.calendar.set(12, n);
            this.minuteChooser.setIntegerValue(n);
        }
    }

    public void setSeconds(int n) {
        if (n != this.getSeconds()) {
            if (n < 0) {
                n = 0;
            }
            if (n > 59) {
                n = 59;
            }
            this.calendar.set(13, n);
            this.secondChooser.setIntegerValue(n);
        }
    }

    public void setTime() {
    }

    public void setTime(Date date) {
        this.calendar.setTime(date);
        this.updateDisplay();
    }

    protected void updateDisplay() {
        this.hourChooser.setIntegerValue(this.getHour());
        this.minuteChooser.setIntegerValue(this.getMinute());
        this.secondChooser.setIntegerValue(this.getSeconds());
    }

    private class NumberChangeListener
    implements PropertyChangeListener {
        private NumberChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            TimeChooser timeChooser = TimeChooser.this;
            if (propertyChangeEvent.getPropertyName().equals("integerValue")) {
                int n = (Integer)propertyChangeEvent.getNewValue();
                if (propertyChangeEvent.getSource() == timeChooser.hourChooser) {
                    timeChooser.setHour(n);
                }
                if (propertyChangeEvent.getSource() == timeChooser.minuteChooser) {
                    timeChooser.setMinute(n);
                }
                if (propertyChangeEvent.getSource() == timeChooser.secondChooser) {
                    timeChooser.setSeconds(n);
                }
            }
        }
    }
}

