/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.gui.components.r2;

import com.cosylab.gui.components.r2.AbstractProgressTask;
import com.cosylab.gui.components.r2.ProgressEvent;
import com.cosylab.gui.components.r2.ProgressListener;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.Timer;

public class ProgressDialog
extends JDialog {
    private JLabel statusLabel;
    private JProgressBar progressBar;
    private AbstractProgressTask task;
    private Timer timer;

    public ProgressDialog(AbstractProgressTask abstractProgressTask) {
        this.task = abstractProgressTask;
        this.initialize();
    }

    private GridBagConstraints createConstraints(int n, int n2) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        return gridBagConstraints;
    }

    private void initialize() {
        this.setSize(350, 100);
        this.getContentPane().setLayout(new GridBagLayout());
        this.statusLabel = new JLabel();
        this.getContentPane().add((Component)this.statusLabel, this.createConstraints(0, 0));
        this.progressBar = new JProgressBar();
        this.getContentPane().add((Component)this.progressBar, this.createConstraints(0, 1));
    }

    public static void main(String[] stringArray) {
    }

    public void performTask() {
        TimerListener timerListener = new TimerListener();
        StateListener stateListener = new StateListener();
        this.timer = new Timer(500, timerListener);
        this.task.addProgressListener(stateListener);
        this.task.start();
        this.timer.start();
    }

    protected void setProgress(int n) {
        this.progressBar.setValue(n);
    }

    protected void setProgressBounds(int n, int n2) {
        if (n >= n2) {
            return;
        }
        this.progressBar.setMinimum(n);
        this.progressBar.setMaximum(n2);
        this.progressBar.setValue(n);
    }

    protected void setStatus(String string) {
        this.statusLabel.setText(string);
    }

    protected void updateState() {
        ProgressDialog progressDialog = this;
        int n = this.task.getCurrent();
        int n2 = this.task.getTotal();
        progressDialog.progressBar.setVisible(n2 > -1);
        progressDialog.setProgressBounds(0, n2);
        progressDialog.setProgress(n);
        this.setStatus(progressDialog.task.getStatus());
    }

    protected class StateListener
    implements ProgressListener {
        protected StateListener() {
        }

        public void progress(ProgressEvent progressEvent) {
            ProgressDialog.this.updateState();
        }

        public void taskComplete(ProgressEvent progressEvent) {
            ProgressDialog.this.updateState();
            ProgressDialog.this.setVisible(false);
        }

        public void taskInterruped(ProgressEvent progressEvent) {
            ProgressDialog.this.setStatus(progressEvent.getStatus());
            ProgressDialog.this.hide();
        }

        public void taskStarted(ProgressEvent progressEvent) {
            ProgressDialog.this.show();
        }
    }

    protected class TimerListener
    implements ActionListener {
        protected TimerListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ProgressDialog.this.updateState();
        }
    }
}

