/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.gui.components.r2;

import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class JIntegerTextField
extends JTextField {
    private int integerValue = 0;
    private int minValue = 0;
    private int maxValue = 100;
    private boolean minimumSet = false;
    private boolean maximumSet = false;

    public JIntegerTextField() {
        this.setText(String.valueOf(this.integerValue));
    }

    protected Document createDefaultModel() {
        return new IntegerDocument();
    }

    public int getIntegerValue() {
        return this.integerValue;
    }

    protected void internalSet(int n) {
        if (n == this.integerValue) {
            return;
        }
        int n2 = this.integerValue;
        this.integerValue = n;
        this.firePropertyChange("integerValue", n2, n);
    }

    public boolean isMaximumSet() {
        return this.maximumSet;
    }

    public boolean isMinimumSet() {
        return this.minimumSet;
    }

    public void setIntegerValue(int n) {
        if (n != this.integerValue) {
            this.setText(String.valueOf(n));
        }
    }

    public void setMaximum(int n) {
        this.maximumSet = true;
        this.maxValue = n;
    }

    public void setMaximumSet(boolean bl) {
        this.maximumSet = bl;
    }

    public void setMinimum(int n) {
        this.minimumSet = true;
        this.minValue = n;
    }

    public void setMinimumSet(boolean bl) {
        this.minimumSet = bl;
    }

    protected class IntegerDocument
    extends PlainDocument {
        protected IntegerDocument() {
        }

        public void remove(int n, int n2) throws BadLocationException {
            JIntegerTextField jIntegerTextField = JIntegerTextField.this;
            super.remove(n, n2);
            String string = this.getText(0, this.getLength());
            int n3 = 0;
            try {
                n3 = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            jIntegerTextField.internalSet(n3);
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            int n2;
            JIntegerTextField jIntegerTextField = JIntegerTextField.this;
            char[] cArray = string.toCharArray();
            char[] cArray2 = new char[cArray.length];
            int n3 = 0;
            int n4 = cArray2.length;
            for (n2 = 0; n2 < n4; ++n2) {
                if (!Character.isDigit(cArray[n2])) continue;
                cArray2[n3++] = cArray[n2];
            }
            super.insertString(n, new String(cArray2, 0, n3), attributeSet);
            n2 = 0;
            if (n3 > 0) {
                String string2 = this.getText(0, this.getLength());
                try {
                    n2 = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (jIntegerTextField.maximumSet && n2 > jIntegerTextField.maxValue) {
                jIntegerTextField.setIntegerValue(jIntegerTextField.maxValue);
                jIntegerTextField.setText(String.valueOf(jIntegerTextField.maxValue));
                return;
            }
            if (jIntegerTextField.minimumSet && n2 < jIntegerTextField.minValue) {
                jIntegerTextField.setIntegerValue(jIntegerTextField.minValue);
                jIntegerTextField.setText(String.valueOf(jIntegerTextField.minValue));
                return;
            }
            jIntegerTextField.internalSet(n2);
        }
    }
}

