/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.gui.components.r2;

import com.cosylab.gui.components.r2.FloatingPointParser;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class JDoubleTextField
extends JTextField {
    private double doubleValue = 0.0;
    private FloatingPointParser fpParser = new FloatingPointParser();

    public JDoubleTextField() {
    }

    public JDoubleTextField(double d) {
        this();
        this.setDoubleValue(d);
    }

    public JDoubleTextField(String string) {
        super(string);
    }

    protected Document createDefaultModel() {
        return new DoubleDocument();
    }

    public double getDoubleValue() {
        return this.doubleValue;
    }

    protected void internalSet(double d) {
        if (this.doubleValue != d) {
            double d2 = this.doubleValue;
            this.doubleValue = d;
            this.firePropertyChange("doubleValue", d2, d);
        }
    }

    public void setDoubleValue(double d) {
        this.internalSet(d);
    }

    protected class DoubleDocument
    extends PlainDocument {
        protected DoubleDocument() {
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            JDoubleTextField jDoubleTextField = JDoubleTextField.this;
            String string2 = this.getText(0, this.getLength());
            String string3 = string2.substring(0, n);
            String string4 = string2.substring(n, string2.length());
            String string5 = string3 + string + string4;
            double d = Double.NaN;
            try {
                d = jDoubleTextField.fpParser.parseDouble(string5);
                super.insertString(n, string, attributeSet);
                jDoubleTextField.internalSet(d);
            }
            catch (RuntimeException runtimeException) {
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        public void remove(int n, int n2) {
            JDoubleTextField jDoubleTextField = JDoubleTextField.this;
            try {
                String string = this.getText(0, this.getLength());
                String string2 = string.substring(0, n);
                String string3 = string.substring(n + n2, string.length());
                String string4 = string2 + string3;
                double d = 0.0;
                d = jDoubleTextField.fpParser.parseDouble(string4);
                super.remove(n, n2);
                jDoubleTextField.internalSet(d);
            }
            catch (RuntimeException runtimeException) {
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }
}

