/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.gui.components.r2;

import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JComponent;

public final class InterceptorPane
extends JComponent {
    protected Window window;

    public InterceptorPane(Window window) {
        this.initialize(window);
    }

    private void initialize(Window window) {
        this.window = window;
        if (this.window == null) {
            System.out.println("InterceptorPane error: cannot create interceptor pane for window==null");
            return;
        }
        this.addMouseListener(new ClickListener());
        this.window.addWindowListener(new FocusMonitor());
    }

    private final class FocusMonitor
    extends WindowAdapter {
        private FocusMonitor() {
        }

        public final void windowDeactivated(WindowEvent windowEvent) {
            if (InterceptorPane.this.window == null) {
                return;
            }
            InterceptorPane interceptorPane = InterceptorPane.this;
            interceptorPane.setSize(interceptorPane.window.getSize());
            interceptorPane.setVisible(true);
        }
    }

    protected final class ClickListener
    extends MouseAdapter {
        protected ClickListener() {
        }

        private final InterceptorPane getOwner() {
            return InterceptorPane.this;
        }

        private final void shouldIgnoreEvent(MouseEvent mouseEvent) {
            mouseEvent.consume();
            this.getOwner().setVisible(false);
        }

        public final void mouseClicked(MouseEvent mouseEvent) {
            this.shouldIgnoreEvent(mouseEvent);
        }

        public final void mousePressed(MouseEvent mouseEvent) {
            this.shouldIgnoreEvent(mouseEvent);
        }

        public final void mouseReleased(MouseEvent mouseEvent) {
            this.shouldIgnoreEvent(mouseEvent);
        }
    }
}

