/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.gui.components.r2;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DateChooser
extends JPanel {
    protected int startingYear = 2000;
    private int numberOfYears = 20;
    protected JComboBox daySelector = null;
    protected JComboBox monthSelector = null;
    protected JComboBox yearSelector = null;
    private JLabel dayLabel = null;
    private JLabel monthLabel = null;
    private JLabel yearLabel = null;
    private Calendar calendar = new GregorianCalendar();

    public DateChooser() {
        super(new GridBagLayout());
        this.createComponents();
        this.updateComponents();
        DateChangeListener dateChangeListener = new DateChangeListener();
        this.daySelector.addItemListener(dateChangeListener);
        this.monthSelector.addItemListener(dateChangeListener);
        this.yearSelector.addItemListener(dateChangeListener);
    }

    protected void createComponents() {
        this.dayLabel = new JLabel("Day");
        this.add((Component)this.dayLabel, this.createConstraints(0, 0, 0.1, 4, 0));
        this.monthLabel = new JLabel("Month");
        this.add((Component)this.monthLabel, this.createConstraints(1, 0, 1.0, 4, 0));
        this.yearLabel = new JLabel("Year");
        this.add((Component)this.yearLabel, this.createConstraints(2, 0, 0.1, 4, 0));
        this.daySelector = new JComboBox();
        this.add((Component)this.daySelector, this.createConstraints(0, 1, 0.1, 0, 4));
        String[] stringArray = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
        this.monthSelector = new JComboBox<String>(stringArray);
        this.add((Component)this.monthSelector, this.createConstraints(1, 1, 1.0, 0, 4));
        String[] stringArray2 = new String[this.numberOfYears];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = String.valueOf(this.startingYear + i);
        }
        this.yearSelector = new JComboBox<String>(stringArray2);
        this.add((Component)this.yearSelector, this.createConstraints(2, 1, 0.1, 0, 4));
    }

    protected GridBagConstraints createConstraints(int n, int n2, double d, int n3, int n4) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.weightx = d;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(n3, 4, n4, 4);
        gridBagConstraints.anchor = 17;
        return gridBagConstraints;
    }

    protected void displayDays() {
        int n = this.calendar.getActualMinimum(5);
        int n2 = this.calendar.getActualMaximum(5);
        int n3 = n2 - n + 1;
        String[] stringArray = new String[n3];
        for (int i = 0; i < n3; ++i) {
            stringArray[i] = String.valueOf(i + n);
        }
        this.daySelector.setModel(new DefaultComboBoxModel<String>(stringArray));
    }

    public Date getDate() {
        return this.calendar.getTime();
    }

    public int getDay() {
        return this.calendar.get(5);
    }

    public int getMonth() {
        return this.calendar.get(2);
    }

    public int getNumberOfYears() {
        return this.numberOfYears;
    }

    public int getStartingYear() {
        return this.startingYear;
    }

    public int getYear() {
        return this.calendar.get(1);
    }

    public static void main(String[] stringArray) {
        JDialog jDialog = new JDialog();
        jDialog.setModal(true);
        jDialog.setSize(200, 100);
        jDialog.getContentPane().setLayout(new GridBagLayout());
        DateChooser dateChooser = new DateChooser();
        GridBagConstraints gridBagConstraints = dateChooser.createConstraints(0, 0, 1.0, 0, 0);
        gridBagConstraints.fill = 1;
        jDialog.getContentPane().add((Component)dateChooser, gridBagConstraints);
        jDialog.show();
        System.exit(0);
    }

    public void setDate(Date date) {
        this.calendar.setTime(date);
        this.updateComponents();
    }

    public void setDay(int n) {
        if (n != this.getDay()) {
            int n2 = this.calendar.getActualMinimum(5);
            int n3 = this.calendar.getActualMaximum(5);
            if (n < n2) {
                n = n2;
            }
            if (n > n3) {
                n = n3;
            }
            this.calendar.set(5, n);
            this.daySelector.setSelectedIndex(this.getDay() - 1);
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.daySelector.setEnabled(bl);
        this.monthSelector.setEnabled(bl);
        this.yearSelector.setEnabled(bl);
    }

    protected void setMonth(int n) {
        if (n != this.getMonth()) {
            if (n < 1) {
                n = 1;
            }
            if (n > 12) {
                n = 12;
            }
            this.calendar.set(2, n);
            this.displayDays();
        }
    }

    public void setNumberOfYears(int n) {
        this.numberOfYears = n;
    }

    public void setStartingYear(int n) {
        this.startingYear = n;
    }

    public void setYear(int n) {
        if (n != this.getYear()) {
            if (n < this.startingYear) {
                n = this.startingYear;
            }
            if (n > this.startingYear + this.numberOfYears) {
                n = this.startingYear + this.numberOfYears;
            }
            this.calendar.set(1, n);
            this.displayDays();
        }
    }

    private void updateComponents() {
        this.displayDays();
        this.daySelector.setSelectedIndex(this.getDay() - 1);
        this.monthSelector.setSelectedIndex(this.getMonth());
        this.yearSelector.setSelectedIndex(this.getYear() - this.startingYear);
    }

    private class DateChangeListener
    implements ItemListener {
        private DateChangeListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                DateChooser dateChooser = DateChooser.this;
                if (itemEvent.getSource() == dateChooser.daySelector) {
                    dateChooser.setDay(dateChooser.daySelector.getSelectedIndex() + 1);
                }
                if (itemEvent.getSource() == dateChooser.monthSelector) {
                    dateChooser.setMonth(dateChooser.monthSelector.getSelectedIndex());
                }
                if (itemEvent.getSource() == dateChooser.yearSelector) {
                    dateChooser.setYear(dateChooser.yearSelector.getSelectedIndex() + dateChooser.startingYear);
                }
            }
        }
    }
}

