/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.gui.components.r2;

import com.cosylab.gui.components.r2.ProgressEvent;
import com.cosylab.gui.components.r2.ProgressListener;
import com.cosylab.gui.components.r2.ProgressMonitor;
import java.util.ArrayList;

public abstract class AbstractProgressTask
extends Thread
implements ProgressMonitor {
    private final ArrayList listeners = new ArrayList();

    public void addProgressListener(ProgressListener progressListener) {
        this.listeners.add(progressListener);
    }

    protected void fireProgressEvent(String string, int n, int n2) {
        AbstractProgressTask.yield();
        ProgressEvent progressEvent = new ProgressEvent(this, string, n, n2);
        for (int i = 0; i < this.listeners.size(); ++i) {
            Object e = this.listeners.get(i);
            if (!(e instanceof ProgressListener)) continue;
            ((ProgressListener)e).progress(progressEvent);
        }
        AbstractProgressTask.yield();
    }

    public void fireTaskComplete() {
        AbstractProgressTask.yield();
        ProgressEvent progressEvent = new ProgressEvent(this, this.getStatus(), this.getCurrent(), this.getTotal());
        for (int i = 0; i < this.listeners.size(); ++i) {
            Object e = this.listeners.get(i);
            if (!(e instanceof ProgressListener)) continue;
            ((ProgressListener)e).taskComplete(progressEvent);
        }
        AbstractProgressTask.yield();
    }

    public void fireTaskInterrupted(String string) {
        AbstractProgressTask.yield();
        ProgressEvent progressEvent = new ProgressEvent(this, string, 0, -1);
        for (int i = 0; i < this.listeners.size(); ++i) {
            Object e = this.listeners.get(i);
            if (!(e instanceof ProgressListener)) continue;
            ((ProgressListener)e).taskInterruped(progressEvent);
        }
        AbstractProgressTask.yield();
    }

    protected void fireTaskStarted() {
        AbstractProgressTask.yield();
        ProgressEvent progressEvent = new ProgressEvent(this, this.getStatus(), this.getCurrent(), this.getTotal());
        for (int i = 0; i < this.listeners.size(); ++i) {
            Object e = this.listeners.get(i);
            if (!(e instanceof ProgressListener)) continue;
            ((ProgressListener)e).taskStarted(progressEvent);
        }
        AbstractProgressTask.yield();
    }

    protected void immediateUpdate() {
        this.fireProgressEvent(this.getStatus(), this.getCurrent(), this.getTotal());
    }

    public void removeProgressListener(ProgressListener progressListener) {
        this.listeners.remove(progressListener);
    }
}

