/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.List;
import org.apache.commons.dbcp.AbandonedTrace;
import org.apache.commons.dbcp.DelegatingConnection;
import org.apache.commons.dbcp.DelegatingPreparedStatement;
import org.apache.commons.dbcp.DelegatingResultSet;

public class DelegatingStatement
extends AbandonedTrace
implements Statement {
    protected Statement _stmt = null;
    protected DelegatingConnection _conn = null;
    protected boolean _closed = false;

    public DelegatingStatement(DelegatingConnection c, Statement s) {
        super(c);
        this._stmt = s;
        this._conn = c;
    }

    public Statement getDelegate() {
        return this._stmt;
    }

    public boolean equals(Object obj) {
        Statement delegate = this.getInnermostDelegate();
        if (delegate == null) {
            return false;
        }
        if (obj instanceof DelegatingStatement) {
            DelegatingStatement s = (DelegatingStatement)obj;
            return delegate.equals(s.getInnermostDelegate());
        }
        return delegate.equals(obj);
    }

    public int hashCode() {
        Statement obj = this.getInnermostDelegate();
        if (obj == null) {
            return 0;
        }
        return obj.hashCode();
    }

    public Statement getInnermostDelegate() {
        Statement s = this._stmt;
        while (s != null && s instanceof DelegatingStatement) {
            if (this != (s = ((DelegatingStatement)s).getDelegate())) continue;
            return null;
        }
        return s;
    }

    public void setDelegate(Statement s) {
        this._stmt = s;
    }

    public void close() throws SQLException {
        this.passivate();
        this._stmt.close();
    }

    public Connection getConnection() throws SQLException {
        this.checkOpen();
        return this._conn;
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        this.checkOpen();
        return DelegatingResultSet.wrapResultSet(this, this._stmt.executeQuery(sql));
    }

    public ResultSet getResultSet() throws SQLException {
        this.checkOpen();
        return DelegatingResultSet.wrapResultSet(this, this._stmt.getResultSet());
    }

    public int executeUpdate(String sql) throws SQLException {
        this.checkOpen();
        return this._stmt.executeUpdate(sql);
    }

    public int getMaxFieldSize() throws SQLException {
        this.checkOpen();
        return this._stmt.getMaxFieldSize();
    }

    public void setMaxFieldSize(int max) throws SQLException {
        this.checkOpen();
        this._stmt.setMaxFieldSize(max);
    }

    public int getMaxRows() throws SQLException {
        this.checkOpen();
        return this._stmt.getMaxRows();
    }

    public void setMaxRows(int max) throws SQLException {
        this.checkOpen();
        this._stmt.setMaxRows(max);
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.checkOpen();
        this._stmt.setEscapeProcessing(enable);
    }

    public int getQueryTimeout() throws SQLException {
        this.checkOpen();
        return this._stmt.getQueryTimeout();
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        this.checkOpen();
        this._stmt.setQueryTimeout(seconds);
    }

    public void cancel() throws SQLException {
        this.checkOpen();
        this._stmt.cancel();
    }

    public SQLWarning getWarnings() throws SQLException {
        this.checkOpen();
        return this._stmt.getWarnings();
    }

    public void clearWarnings() throws SQLException {
        this.checkOpen();
        this._stmt.clearWarnings();
    }

    public void setCursorName(String name) throws SQLException {
        this.checkOpen();
        this._stmt.setCursorName(name);
    }

    public boolean execute(String sql) throws SQLException {
        this.checkOpen();
        return this._stmt.execute(sql);
    }

    public int getUpdateCount() throws SQLException {
        this.checkOpen();
        return this._stmt.getUpdateCount();
    }

    public boolean getMoreResults() throws SQLException {
        this.checkOpen();
        return this._stmt.getMoreResults();
    }

    public void setFetchDirection(int direction) throws SQLException {
        this.checkOpen();
        this._stmt.setFetchDirection(direction);
    }

    public int getFetchDirection() throws SQLException {
        this.checkOpen();
        return this._stmt.getFetchDirection();
    }

    public void setFetchSize(int rows) throws SQLException {
        this.checkOpen();
        this._stmt.setFetchSize(rows);
    }

    public int getFetchSize() throws SQLException {
        this.checkOpen();
        return this._stmt.getFetchSize();
    }

    public int getResultSetConcurrency() throws SQLException {
        this.checkOpen();
        return this._stmt.getResultSetConcurrency();
    }

    public int getResultSetType() throws SQLException {
        this.checkOpen();
        return this._stmt.getResultSetType();
    }

    public void addBatch(String sql) throws SQLException {
        this.checkOpen();
        this._stmt.addBatch(sql);
    }

    public void clearBatch() throws SQLException {
        this.checkOpen();
        this._stmt.clearBatch();
    }

    public int[] executeBatch() throws SQLException {
        this.checkOpen();
        return this._stmt.executeBatch();
    }

    protected void checkOpen() throws SQLException {
        if (this._closed) {
            throw new SQLException("Connection is closed.");
        }
    }

    protected void activate() {
        this._closed = false;
        if (this._stmt instanceof DelegatingPreparedStatement) {
            ((DelegatingPreparedStatement)this._stmt).activate();
        }
    }

    protected void passivate() throws SQLException {
        List resultSets;
        this._closed = true;
        if (this._conn != null) {
            this._conn.removeTrace(this);
            this._conn = null;
        }
        if ((resultSets = this.getTrace()) != null) {
            ResultSet[] set = new ResultSet[resultSets.size()];
            resultSets.toArray(set);
            int i = 0;
            while (i < set.length) {
                set[i].close();
                ++i;
            }
            this.clearTrace();
        }
        if (this._stmt instanceof DelegatingPreparedStatement) {
            ((DelegatingPreparedStatement)this._stmt).passivate();
        }
    }

    public boolean getMoreResults(int current) throws SQLException {
        this.checkOpen();
        return this._stmt.getMoreResults(current);
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        this.checkOpen();
        return this._stmt.getGeneratedKeys();
    }

    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkOpen();
        return this._stmt.executeUpdate(sql, autoGeneratedKeys);
    }

    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.checkOpen();
        return this._stmt.executeUpdate(sql, columnIndexes);
    }

    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        this.checkOpen();
        return this._stmt.executeUpdate(sql, columnNames);
    }

    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkOpen();
        return this._stmt.execute(sql, autoGeneratedKeys);
    }

    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        this.checkOpen();
        return this._stmt.execute(sql, columnIndexes);
    }

    public boolean execute(String sql, String[] columnNames) throws SQLException {
        this.checkOpen();
        return this._stmt.execute(sql, columnNames);
    }

    public int getResultSetHoldability() throws SQLException {
        this.checkOpen();
        return this._stmt.getResultSetHoldability();
    }
}

